/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: issue_state.proto

package issue_state

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TargetAndMethods struct {
	TargetName           string   `protobuf:"bytes,1,opt,name=target_name,json=targetName,proto3" json:"target_name,omitempty"`
	MethodNames          []string `protobuf:"bytes,2,rep,name=method_names,json=methodNames,proto3" json:"method_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TargetAndMethods) Reset()         { *m = TargetAndMethods{} }
func (m *TargetAndMethods) String() string { return proto.CompactTextString(m) }
func (*TargetAndMethods) ProtoMessage()    {}
func (*TargetAndMethods) Descriptor() ([]byte, []int) {
	return fileDescriptor_0231a95aac646693, []int{0}
}

func (m *TargetAndMethods) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetAndMethods.Unmarshal(m, b)
}
func (m *TargetAndMethods) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetAndMethods.Marshal(b, m, deterministic)
}
func (m *TargetAndMethods) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetAndMethods.Merge(m, src)
}
func (m *TargetAndMethods) XXX_Size() int {
	return xxx_messageInfo_TargetAndMethods.Size(m)
}
func (m *TargetAndMethods) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetAndMethods.DiscardUnknown(m)
}

var xxx_messageInfo_TargetAndMethods proto.InternalMessageInfo

func (m *TargetAndMethods) GetTargetName() string {
	if m != nil {
		return m.TargetName
	}
	return ""
}

func (m *TargetAndMethods) GetMethodNames() []string {
	if m != nil {
		return m.MethodNames
	}
	return nil
}

type IssueInfo struct {
	IssueId      string   `protobuf:"bytes,1,opt,name=issue_id,json=issueId,proto3" json:"issue_id,omitempty"`
	Title        string   `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	IsAutobug    bool     `protobuf:"varint,3,opt,name=is_autobug,json=isAutobug,proto3" json:"is_autobug,omitempty"`
	LastModified float64  `protobuf:"fixed64,4,opt,name=last_modified,json=lastModified,proto3" json:"last_modified,omitempty"`
	RowIds       []string `protobuf:"bytes,5,rep,name=row_ids,json=rowIds,proto3" json:"row_ids,omitempty"`
	// Run IDs used to associate this issue with a particular target (in case of repeats, or across
	// runs on different dashboards).
	RunIds []string `protobuf:"bytes,6,rep,name=run_ids,json=runIds,proto3" json:"run_ids,omitempty"`
	// Targets + methods associated with this issue.
	// Only set if test group's `link_bugs_by_test_methods` is True, else all targets + methods will
	// be linked to this issue.
	TargetsAndMethods    []*TargetAndMethods `protobuf:"bytes,7,rep,name=targets_and_methods,json=targetsAndMethods,proto3" json:"targets_and_methods,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *IssueInfo) Reset()         { *m = IssueInfo{} }
func (m *IssueInfo) String() string { return proto.CompactTextString(m) }
func (*IssueInfo) ProtoMessage()    {}
func (*IssueInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0231a95aac646693, []int{1}
}

func (m *IssueInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssueInfo.Unmarshal(m, b)
}
func (m *IssueInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssueInfo.Marshal(b, m, deterministic)
}
func (m *IssueInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueInfo.Merge(m, src)
}
func (m *IssueInfo) XXX_Size() int {
	return xxx_messageInfo_IssueInfo.Size(m)
}
func (m *IssueInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueInfo.DiscardUnknown(m)
}

var xxx_messageInfo_IssueInfo proto.InternalMessageInfo

func (m *IssueInfo) GetIssueId() string {
	if m != nil {
		return m.IssueId
	}
	return ""
}

func (m *IssueInfo) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *IssueInfo) GetIsAutobug() bool {
	if m != nil {
		return m.IsAutobug
	}
	return false
}

func (m *IssueInfo) GetLastModified() float64 {
	if m != nil {
		return m.LastModified
	}
	return 0
}

func (m *IssueInfo) GetRowIds() []string {
	if m != nil {
		return m.RowIds
	}
	return nil
}

func (m *IssueInfo) GetRunIds() []string {
	if m != nil {
		return m.RunIds
	}
	return nil
}

func (m *IssueInfo) GetTargetsAndMethods() []*TargetAndMethods {
	if m != nil {
		return m.TargetsAndMethods
	}
	return nil
}

type IssueState struct {
	// List of collected info for bugs.
	IssueInfo            []*IssueInfo `protobuf:"bytes,1,rep,name=issue_info,json=issueInfo,proto3" json:"issue_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *IssueState) Reset()         { *m = IssueState{} }
func (m *IssueState) String() string { return proto.CompactTextString(m) }
func (*IssueState) ProtoMessage()    {}
func (*IssueState) Descriptor() ([]byte, []int) {
	return fileDescriptor_0231a95aac646693, []int{2}
}

func (m *IssueState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssueState.Unmarshal(m, b)
}
func (m *IssueState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssueState.Marshal(b, m, deterministic)
}
func (m *IssueState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueState.Merge(m, src)
}
func (m *IssueState) XXX_Size() int {
	return xxx_messageInfo_IssueState.Size(m)
}
func (m *IssueState) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueState.DiscardUnknown(m)
}

var xxx_messageInfo_IssueState proto.InternalMessageInfo

func (m *IssueState) GetIssueInfo() []*IssueInfo {
	if m != nil {
		return m.IssueInfo
	}
	return nil
}

func init() {
	proto.RegisterType((*TargetAndMethods)(nil), "TargetAndMethods")
	proto.RegisterType((*IssueInfo)(nil), "IssueInfo")
	proto.RegisterType((*IssueState)(nil), "IssueState")
}

func init() { proto.RegisterFile("issue_state.proto", fileDescriptor_0231a95aac646693) }

var fileDescriptor_0231a95aac646693 = []byte{
	// 289 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x5c, 0x91, 0x3f, 0x4f, 0xc3, 0x30,
	0x10, 0xc5, 0xe5, 0x96, 0xfe, 0xc9, 0xb5, 0x48, 0xd4, 0x20, 0x61, 0x06, 0x44, 0x28, 0x4b, 0x58,
	0x32, 0xc0, 0xc0, 0x9c, 0x31, 0x43, 0x19, 0x02, 0x62, 0xb5, 0x5c, 0xd9, 0x29, 0x96, 0x1a, 0x1b,
	0xe5, 0x1c, 0xf5, 0x93, 0xb3, 0x23, 0x9f, 0x23, 0x90, 0xd8, 0x72, 0xbf, 0xf7, 0x74, 0x97, 0xf7,
	0x0c, 0x1b, 0x8b, 0x38, 0x18, 0x89, 0x41, 0x05, 0x53, 0x7e, 0xf5, 0x3e, 0xf8, 0xed, 0x07, 0x5c,
	0xbc, 0xab, 0xfe, 0x60, 0x42, 0xe5, 0xf4, 0xce, 0x84, 0x4f, 0xaf, 0x91, 0xdf, 0xc1, 0x2a, 0x10,
	0x93, 0x4e, 0x75, 0x46, 0xb0, 0x9c, 0x15, 0x59, 0x03, 0x09, 0xbd, 0xaa, 0xce, 0xf0, 0x7b, 0x58,
	0x77, 0xe4, 0x25, 0x03, 0x8a, 0x49, 0x3e, 0x2d, 0xb2, 0x66, 0x95, 0x58, 0x74, 0xe0, 0xf6, 0x9b,
	0x41, 0x56, 0xc7, 0x6b, 0xb5, 0x6b, 0x3d, 0xbf, 0x81, 0x65, 0x3a, 0x6d, 0xf5, 0xb8, 0x6e, 0x41,
	0x73, 0xad, 0xf9, 0x15, 0xcc, 0x82, 0x0d, 0x47, 0x23, 0x26, 0xc4, 0xd3, 0xc0, 0x6f, 0x01, 0x2c,
	0x4a, 0x35, 0x04, 0xbf, 0x1f, 0x0e, 0x62, 0x9a, 0xb3, 0x62, 0xd9, 0x64, 0x16, 0xab, 0x04, 0xf8,
	0x03, 0x9c, 0x1f, 0x15, 0x06, 0xd9, 0x79, 0x6d, 0x5b, 0x6b, 0xb4, 0x38, 0xcb, 0x59, 0xc1, 0x9a,
	0x75, 0x84, 0xbb, 0x91, 0xf1, 0x6b, 0x58, 0xf4, 0xfe, 0x24, 0xad, 0x46, 0x31, 0xa3, 0x1f, 0x9c,
	0xf7, 0xfe, 0x54, 0x6b, 0x24, 0x61, 0x70, 0x24, 0xcc, 0x47, 0x61, 0x70, 0x51, 0xa8, 0xe0, 0x32,
	0xa5, 0x44, 0xa9, 0x9c, 0x96, 0x29, 0x0f, 0x8a, 0x45, 0x3e, 0x2d, 0x56, 0x4f, 0x9b, 0xf2, 0x7f,
	0x51, 0xcd, 0x66, 0x74, 0xff, 0xa1, 0xed, 0x0b, 0x00, 0xc5, 0x7e, 0x8b, 0x1d, 0xf3, 0xc7, 0x18,
	0x83, 0x72, 0xbb, 0xd6, 0x0b, 0x46, 0x7b, 0xa0, 0xfc, 0xed, 0x25, 0x46, 0x1a, 0x3f, 0xf7, 0x73,
	0x7a, 0x8f, 0xe7, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbb, 0xc0, 0x3f, 0x24, 0xa4, 0x01, 0x00,
	0x00,
}
