/*
Copyright 2020 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package releasefakes

import (
	"sync"

	"k8s.io/release/pkg/release"
)

type FakeJobCacheClient struct {
	GetJobCacheStub        func(string, bool) (*release.JobCache, error)
	getJobCacheMutex       sync.RWMutex
	getJobCacheArgsForCall []struct {
		arg1 string
		arg2 bool
	}
	getJobCacheReturns struct {
		result1 *release.JobCache
		result2 error
	}
	getJobCacheReturnsOnCall map[int]struct {
		result1 *release.JobCache
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeJobCacheClient) GetJobCache(arg1 string, arg2 bool) (*release.JobCache, error) {
	fake.getJobCacheMutex.Lock()
	ret, specificReturn := fake.getJobCacheReturnsOnCall[len(fake.getJobCacheArgsForCall)]
	fake.getJobCacheArgsForCall = append(fake.getJobCacheArgsForCall, struct {
		arg1 string
		arg2 bool
	}{arg1, arg2})
	fake.recordInvocation("GetJobCache", []interface{}{arg1, arg2})
	fake.getJobCacheMutex.Unlock()
	if fake.GetJobCacheStub != nil {
		return fake.GetJobCacheStub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	fakeReturns := fake.getJobCacheReturns
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeJobCacheClient) GetJobCacheCallCount() int {
	fake.getJobCacheMutex.RLock()
	defer fake.getJobCacheMutex.RUnlock()
	return len(fake.getJobCacheArgsForCall)
}

func (fake *FakeJobCacheClient) GetJobCacheCalls(stub func(string, bool) (*release.JobCache, error)) {
	fake.getJobCacheMutex.Lock()
	defer fake.getJobCacheMutex.Unlock()
	fake.GetJobCacheStub = stub
}

func (fake *FakeJobCacheClient) GetJobCacheArgsForCall(i int) (string, bool) {
	fake.getJobCacheMutex.RLock()
	defer fake.getJobCacheMutex.RUnlock()
	argsForCall := fake.getJobCacheArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeJobCacheClient) GetJobCacheReturns(result1 *release.JobCache, result2 error) {
	fake.getJobCacheMutex.Lock()
	defer fake.getJobCacheMutex.Unlock()
	fake.GetJobCacheStub = nil
	fake.getJobCacheReturns = struct {
		result1 *release.JobCache
		result2 error
	}{result1, result2}
}

func (fake *FakeJobCacheClient) GetJobCacheReturnsOnCall(i int, result1 *release.JobCache, result2 error) {
	fake.getJobCacheMutex.Lock()
	defer fake.getJobCacheMutex.Unlock()
	fake.GetJobCacheStub = nil
	if fake.getJobCacheReturnsOnCall == nil {
		fake.getJobCacheReturnsOnCall = make(map[int]struct {
			result1 *release.JobCache
			result2 error
		})
	}
	fake.getJobCacheReturnsOnCall[i] = struct {
		result1 *release.JobCache
		result2 error
	}{result1, result2}
}

func (fake *FakeJobCacheClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.getJobCacheMutex.RLock()
	defer fake.getJobCacheMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeJobCacheClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
