package metric

import "strings"

//Exploitability is metric type for Temporal Metrics
type Exploitability int

//Constant of Exploitability result
const (
	ExploitabilityNotDefined Exploitability = iota
	ExploitabilityUnproven
	ExploitabilityProofOfConcept
	ExploitabilityFunctional
	ExploitabilityHigh
)

var exploitabilityMap = map[Exploitability]string{
	ExploitabilityNotDefined:     "X",
	ExploitabilityUnproven:       "U",
	ExploitabilityProofOfConcept: "P",
	ExploitabilityFunctional:     "F",
	ExploitabilityHigh:           "H",
}

var exploitabilityValueMap = map[Exploitability]float64{
	ExploitabilityNotDefined:     1,
	ExploitabilityUnproven:       0.91,
	ExploitabilityProofOfConcept: 0.94,
	ExploitabilityFunctional:     0.97,
	ExploitabilityHigh:           1,
}

//GetExploitability returns result of Exploitability metric
func GetExploitability(s string) Exploitability {
	s = strings.ToUpper(s)
	for k, v := range exploitabilityMap {
		if s == v {
			return k
		}
	}
	return ExploitabilityNotDefined
}

func (ex Exploitability) String() string {
	if s, ok := exploitabilityMap[ex]; ok {
		return s
	}
	return ""
}

//Value returns value of Exploitability metric
func (ex Exploitability) Value() float64 {
	if v, ok := exploitabilityValueMap[ex]; ok {
		return v
	}
	return 1
}

//IsDefined returns false if undefined result value of metric
func (ex Exploitability) IsDefined() bool {
	_, ok := exploitabilityValueMap[ex]
	return ok
}

/* Copyright by Florent Viel, 2020 */
/* Contributed by Spiegel, 2020 */
