// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/image/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ImageTagLister helps list ImageTags.
type ImageTagLister interface {
	// List lists all ImageTags in the indexer.
	List(selector labels.Selector) (ret []*v1.ImageTag, err error)
	// ImageTags returns an object that can list and get ImageTags.
	ImageTags(namespace string) ImageTagNamespaceLister
	ImageTagListerExpansion
}

// imageTagLister implements the ImageTagLister interface.
type imageTagLister struct {
	indexer cache.Indexer
}

// NewImageTagLister returns a new ImageTagLister.
func NewImageTagLister(indexer cache.Indexer) ImageTagLister {
	return &imageTagLister{indexer: indexer}
}

// List lists all ImageTags in the indexer.
func (s *imageTagLister) List(selector labels.Selector) (ret []*v1.ImageTag, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ImageTag))
	})
	return ret, err
}

// ImageTags returns an object that can list and get ImageTags.
func (s *imageTagLister) ImageTags(namespace string) ImageTagNamespaceLister {
	return imageTagNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ImageTagNamespaceLister helps list and get ImageTags.
type ImageTagNamespaceLister interface {
	// List lists all ImageTags in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.ImageTag, err error)
	// Get retrieves the ImageTag from the indexer for a given namespace and name.
	Get(name string) (*v1.ImageTag, error)
	ImageTagNamespaceListerExpansion
}

// imageTagNamespaceLister implements the ImageTagNamespaceLister
// interface.
type imageTagNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ImageTags in the indexer for a given namespace.
func (s imageTagNamespaceLister) List(selector labels.Selector) (ret []*v1.ImageTag, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ImageTag))
	})
	return ret, err
}

// Get retrieves the ImageTag from the indexer for a given namespace and name.
func (s imageTagNamespaceLister) Get(name string) (*v1.ImageTag, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("imagetag"), name)
	}
	return obj.(*v1.ImageTag), nil
}
