// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTags API operation for Amazon Machine Learning.
//
// Adds one or more tags to an object, up to a limit of 10. Each tag consists
// of a key and an optional value. If you add a tag using a key that is already
// associated with the ML object, AddTags updates the tag's value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//
//   * ErrCodeTagLimitExceededException "TagLimitExceededException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBatchPrediction = "CreateBatchPrediction"

// CreateBatchPredictionRequest generates a "aws/request.Request" representing the
// client's request for the CreateBatchPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBatchPrediction for more information on using the CreateBatchPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBatchPredictionRequest method.
//    req, resp := client.CreateBatchPredictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateBatchPredictionRequest(input *CreateBatchPredictionInput) (req *request.Request, output *CreateBatchPredictionOutput) {
	op := &request.Operation{
		Name:       opCreateBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchPredictionInput{}
	}

	output = &CreateBatchPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBatchPrediction API operation for Amazon Machine Learning.
//
// Generates predictions for a group of observations. The observations to process
// exist in one or more data files referenced by a DataSource. This operation
// creates a new BatchPrediction, and uses an MLModel and the data files referenced
// by the DataSource as information sources.
//
// CreateBatchPrediction is an asynchronous operation. In response to CreateBatchPrediction,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the BatchPrediction
// status to PENDING. After the BatchPrediction completes, Amazon ML sets the
// status to COMPLETED.
//
// You can poll for status updates by using the GetBatchPrediction operation
// and checking the Status parameter of the result. After the COMPLETED status
// appears, the results are available in the location specified by the OutputUri
// parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateBatchPrediction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A second request to use or change an object was not allowed. This can result
//   from retrying a request using a parameter that was not present in the original
//   request.
//
func (c *MachineLearning) CreateBatchPrediction(input *CreateBatchPredictionInput) (*CreateBatchPredictionOutput, error) {
	req, out := c.CreateBatchPredictionRequest(input)
	return out, req.Send()
}

// CreateBatchPredictionWithContext is the same as CreateBatchPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBatchPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateBatchPredictionWithContext(ctx aws.Context, input *CreateBatchPredictionInput, opts ...request.Option) (*CreateBatchPredictionOutput, error) {
	req, out := c.CreateBatchPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSourceFromRDS = "CreateDataSourceFromRDS"

// CreateDataSourceFromRDSRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSourceFromRDS operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSourceFromRDS for more information on using the CreateDataSourceFromRDS
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceFromRDSRequest method.
//    req, resp := client.CreateDataSourceFromRDSRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateDataSourceFromRDSRequest(input *CreateDataSourceFromRDSInput) (req *request.Request, output *CreateDataSourceFromRDSOutput) {
	op := &request.Operation{
		Name:       opCreateDataSourceFromRDS,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceFromRDSInput{}
	}

	output = &CreateDataSourceFromRDSOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSourceFromRDS API operation for Amazon Machine Learning.
//
// Creates a DataSource object from an  Amazon Relational Database Service (http://aws.amazon.com/rds/)
// (Amazon RDS). A DataSource references data that can be used to perform CreateMLModel,
// CreateEvaluation, or CreateBatchPrediction operations.
//
// CreateDataSourceFromRDS is an asynchronous operation. In response to CreateDataSourceFromRDS,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the DataSource
// status to PENDING. After the DataSource is created and ready for use, Amazon
// ML sets the Status parameter to COMPLETED. DataSource in the COMPLETED or
// PENDING state can be used only to perform >CreateMLModel>, CreateEvaluation,
// or CreateBatchPrediction operations.
//
// If Amazon ML cannot accept the input source, it sets the Status parameter
// to FAILED and includes an error message in the Message attribute of the GetDataSource
// operation response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateDataSourceFromRDS for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A second request to use or change an object was not allowed. This can result
//   from retrying a request using a parameter that was not present in the original
//   request.
//
func (c *MachineLearning) CreateDataSourceFromRDS(input *CreateDataSourceFromRDSInput) (*CreateDataSourceFromRDSOutput, error) {
	req, out := c.CreateDataSourceFromRDSRequest(input)
	return out, req.Send()
}

// CreateDataSourceFromRDSWithContext is the same as CreateDataSourceFromRDS with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSourceFromRDS for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateDataSourceFromRDSWithContext(ctx aws.Context, input *CreateDataSourceFromRDSInput, opts ...request.Option) (*CreateDataSourceFromRDSOutput, error) {
	req, out := c.CreateDataSourceFromRDSRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSourceFromRedshift = "CreateDataSourceFromRedshift"

// CreateDataSourceFromRedshiftRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSourceFromRedshift operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSourceFromRedshift for more information on using the CreateDataSourceFromRedshift
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceFromRedshiftRequest method.
//    req, resp := client.CreateDataSourceFromRedshiftRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateDataSourceFromRedshiftRequest(input *CreateDataSourceFromRedshiftInput) (req *request.Request, output *CreateDataSourceFromRedshiftOutput) {
	op := &request.Operation{
		Name:       opCreateDataSourceFromRedshift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceFromRedshiftInput{}
	}

	output = &CreateDataSourceFromRedshiftOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSourceFromRedshift API operation for Amazon Machine Learning.
//
// Creates a DataSource from a database hosted on an Amazon Redshift cluster.
// A DataSource references data that can be used to perform either CreateMLModel,
// CreateEvaluation, or CreateBatchPrediction operations.
//
// CreateDataSourceFromRedshift is an asynchronous operation. In response to
// CreateDataSourceFromRedshift, Amazon Machine Learning (Amazon ML) immediately
// returns and sets the DataSource status to PENDING. After the DataSource is
// created and ready for use, Amazon ML sets the Status parameter to COMPLETED.
// DataSource in COMPLETED or PENDING states can be used to perform only CreateMLModel,
// CreateEvaluation, or CreateBatchPrediction operations.
//
// If Amazon ML can't accept the input source, it sets the Status parameter
// to FAILED and includes an error message in the Message attribute of the GetDataSource
// operation response.
//
// The observations should be contained in the database hosted on an Amazon
// Redshift cluster and should be specified by a SelectSqlQuery query. Amazon
// ML executes an Unload command in Amazon Redshift to transfer the result set
// of the SelectSqlQuery query to S3StagingLocation.
//
// After the DataSource has been created, it's ready for use in evaluations
// and batch predictions. If you plan to use the DataSource to train an MLModel,
// the DataSource also requires a recipe. A recipe describes how each input
// variable will be used in training an MLModel. Will the variable be included
// or excluded from training? Will the variable be manipulated; for example,
// will it be combined with another variable or will it be split apart into
// word combinations? The recipe provides answers to these questions.
//
// You can't change an existing datasource, but you can copy and modify the
// settings from an existing Amazon Redshift datasource to create a new datasource.
// To do so, call GetDataSource for an existing datasource and copy the values
// to a CreateDataSource call. Change the settings that you want to change and
// make sure that all required fields have the appropriate values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateDataSourceFromRedshift for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A second request to use or change an object was not allowed. This can result
//   from retrying a request using a parameter that was not present in the original
//   request.
//
func (c *MachineLearning) CreateDataSourceFromRedshift(input *CreateDataSourceFromRedshiftInput) (*CreateDataSourceFromRedshiftOutput, error) {
	req, out := c.CreateDataSourceFromRedshiftRequest(input)
	return out, req.Send()
}

// CreateDataSourceFromRedshiftWithContext is the same as CreateDataSourceFromRedshift with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSourceFromRedshift for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateDataSourceFromRedshiftWithContext(ctx aws.Context, input *CreateDataSourceFromRedshiftInput, opts ...request.Option) (*CreateDataSourceFromRedshiftOutput, error) {
	req, out := c.CreateDataSourceFromRedshiftRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSourceFromS3 = "CreateDataSourceFromS3"

// CreateDataSourceFromS3Request generates a "aws/request.Request" representing the
// client's request for the CreateDataSourceFromS3 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSourceFromS3 for more information on using the CreateDataSourceFromS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceFromS3Request method.
//    req, resp := client.CreateDataSourceFromS3Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateDataSourceFromS3Request(input *CreateDataSourceFromS3Input) (req *request.Request, output *CreateDataSourceFromS3Output) {
	op := &request.Operation{
		Name:       opCreateDataSourceFromS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceFromS3Input{}
	}

	output = &CreateDataSourceFromS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSourceFromS3 API operation for Amazon Machine Learning.
//
// Creates a DataSource object. A DataSource references data that can be used
// to perform CreateMLModel, CreateEvaluation, or CreateBatchPrediction operations.
//
// CreateDataSourceFromS3 is an asynchronous operation. In response to CreateDataSourceFromS3,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the DataSource
// status to PENDING. After the DataSource has been created and is ready for
// use, Amazon ML sets the Status parameter to COMPLETED. DataSource in the
// COMPLETED or PENDING state can be used to perform only CreateMLModel, CreateEvaluation
// or CreateBatchPrediction operations.
//
// If Amazon ML can't accept the input source, it sets the Status parameter
// to FAILED and includes an error message in the Message attribute of the GetDataSource
// operation response.
//
// The observation data used in a DataSource should be ready to use; that is,
// it should have a consistent structure, and missing data values should be
// kept to a minimum. The observation data must reside in one or more .csv files
// in an Amazon Simple Storage Service (Amazon S3) location, along with a schema
// that describes the data items by name and type. The same schema must be used
// for all of the data files referenced by the DataSource.
//
// After the DataSource has been created, it's ready to use in evaluations and
// batch predictions. If you plan to use the DataSource to train an MLModel,
// the DataSource also needs a recipe. A recipe describes how each input variable
// will be used in training an MLModel. Will the variable be included or excluded
// from training? Will the variable be manipulated; for example, will it be
// combined with another variable or will it be split apart into word combinations?
// The recipe provides answers to these questions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateDataSourceFromS3 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A second request to use or change an object was not allowed. This can result
//   from retrying a request using a parameter that was not present in the original
//   request.
//
func (c *MachineLearning) CreateDataSourceFromS3(input *CreateDataSourceFromS3Input) (*CreateDataSourceFromS3Output, error) {
	req, out := c.CreateDataSourceFromS3Request(input)
	return out, req.Send()
}

// CreateDataSourceFromS3WithContext is the same as CreateDataSourceFromS3 with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSourceFromS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateDataSourceFromS3WithContext(ctx aws.Context, input *CreateDataSourceFromS3Input, opts ...request.Option) (*CreateDataSourceFromS3Output, error) {
	req, out := c.CreateDataSourceFromS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEvaluation = "CreateEvaluation"

// CreateEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the CreateEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEvaluation for more information on using the CreateEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEvaluationRequest method.
//    req, resp := client.CreateEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateEvaluationRequest(input *CreateEvaluationInput) (req *request.Request, output *CreateEvaluationOutput) {
	op := &request.Operation{
		Name:       opCreateEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEvaluationInput{}
	}

	output = &CreateEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEvaluation API operation for Amazon Machine Learning.
//
// Creates a new Evaluation of an MLModel. An MLModel is evaluated on a set
// of observations associated to a DataSource. Like a DataSource for an MLModel,
// the DataSource for an Evaluation contains values for the Target Variable.
// The Evaluation compares the predicted result for each observation to the
// actual outcome and provides a summary so that you know how effective the
// MLModel functions on the test data. Evaluation generates a relevant performance
// metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on
// the corresponding MLModelType: BINARY, REGRESSION or MULTICLASS.
//
// CreateEvaluation is an asynchronous operation. In response to CreateEvaluation,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation
// status to PENDING. After the Evaluation is created and ready for use, Amazon
// ML sets the status to COMPLETED.
//
// You can use the GetEvaluation operation to check progress of the evaluation
// during the creation operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateEvaluation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A second request to use or change an object was not allowed. This can result
//   from retrying a request using a parameter that was not present in the original
//   request.
//
func (c *MachineLearning) CreateEvaluation(input *CreateEvaluationInput) (*CreateEvaluationOutput, error) {
	req, out := c.CreateEvaluationRequest(input)
	return out, req.Send()
}

// CreateEvaluationWithContext is the same as CreateEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateEvaluationWithContext(ctx aws.Context, input *CreateEvaluationInput, opts ...request.Option) (*CreateEvaluationOutput, error) {
	req, out := c.CreateEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMLModel = "CreateMLModel"

// CreateMLModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateMLModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMLModel for more information on using the CreateMLModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMLModelRequest method.
//    req, resp := client.CreateMLModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateMLModelRequest(input *CreateMLModelInput) (req *request.Request, output *CreateMLModelOutput) {
	op := &request.Operation{
		Name:       opCreateMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMLModelInput{}
	}

	output = &CreateMLModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMLModel API operation for Amazon Machine Learning.
//
// Creates a new MLModel using the DataSource and the recipe as information
// sources.
//
// An MLModel is nearly immutable. Users can update only the MLModelName and
// the ScoreThreshold in an MLModel without creating a new MLModel.
//
// CreateMLModel is an asynchronous operation. In response to CreateMLModel,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the MLModel
// status to PENDING. After the MLModel has been created and ready is for use,
// Amazon ML sets the status to COMPLETED.
//
// You can use the GetMLModel operation to check the progress of the MLModel
// during the creation operation.
//
// CreateMLModel requires a DataSource with computed statistics, which can be
// created by setting ComputeStatistics to true in CreateDataSourceFromRDS,
// CreateDataSourceFromS3, or CreateDataSourceFromRedshift operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateMLModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A second request to use or change an object was not allowed. This can result
//   from retrying a request using a parameter that was not present in the original
//   request.
//
func (c *MachineLearning) CreateMLModel(input *CreateMLModelInput) (*CreateMLModelOutput, error) {
	req, out := c.CreateMLModelRequest(input)
	return out, req.Send()
}

// CreateMLModelWithContext is the same as CreateMLModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMLModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateMLModelWithContext(ctx aws.Context, input *CreateMLModelInput, opts ...request.Option) (*CreateMLModelOutput, error) {
	req, out := c.CreateMLModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRealtimeEndpoint = "CreateRealtimeEndpoint"

// CreateRealtimeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateRealtimeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRealtimeEndpoint for more information on using the CreateRealtimeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRealtimeEndpointRequest method.
//    req, resp := client.CreateRealtimeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) CreateRealtimeEndpointRequest(input *CreateRealtimeEndpointInput) (req *request.Request, output *CreateRealtimeEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateRealtimeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRealtimeEndpointInput{}
	}

	output = &CreateRealtimeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRealtimeEndpoint API operation for Amazon Machine Learning.
//
// Creates a real-time endpoint for the MLModel. The endpoint contains the URI
// of the MLModel; that is, the location to send real-time prediction requests
// for the specified MLModel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation CreateRealtimeEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) CreateRealtimeEndpoint(input *CreateRealtimeEndpointInput) (*CreateRealtimeEndpointOutput, error) {
	req, out := c.CreateRealtimeEndpointRequest(input)
	return out, req.Send()
}

// CreateRealtimeEndpointWithContext is the same as CreateRealtimeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRealtimeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) CreateRealtimeEndpointWithContext(ctx aws.Context, input *CreateRealtimeEndpointInput, opts ...request.Option) (*CreateRealtimeEndpointOutput, error) {
	req, out := c.CreateRealtimeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBatchPrediction = "DeleteBatchPrediction"

// DeleteBatchPredictionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBatchPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBatchPrediction for more information on using the DeleteBatchPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBatchPredictionRequest method.
//    req, resp := client.DeleteBatchPredictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DeleteBatchPredictionRequest(input *DeleteBatchPredictionInput) (req *request.Request, output *DeleteBatchPredictionOutput) {
	op := &request.Operation{
		Name:       opDeleteBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBatchPredictionInput{}
	}

	output = &DeleteBatchPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBatchPrediction API operation for Amazon Machine Learning.
//
// Assigns the DELETED status to a BatchPrediction, rendering it unusable.
//
// After using the DeleteBatchPrediction operation, you can use the GetBatchPrediction
// operation to verify that the status of the BatchPrediction changed to DELETED.
//
// Caution: The result of the DeleteBatchPrediction operation is irreversible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DeleteBatchPrediction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DeleteBatchPrediction(input *DeleteBatchPredictionInput) (*DeleteBatchPredictionOutput, error) {
	req, out := c.DeleteBatchPredictionRequest(input)
	return out, req.Send()
}

// DeleteBatchPredictionWithContext is the same as DeleteBatchPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBatchPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DeleteBatchPredictionWithContext(ctx aws.Context, input *DeleteBatchPredictionInput, opts ...request.Option) (*DeleteBatchPredictionOutput, error) {
	req, out := c.DeleteBatchPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSourceRequest method.
//    req, resp := client.DeleteDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon Machine Learning.
//
// Assigns the DELETED status to a DataSource, rendering it unusable.
//
// After using the DeleteDataSource operation, you can use the GetDataSource
// operation to verify that the status of the DataSource changed to DELETED.
//
// Caution: The results of the DeleteDataSource operation are irreversible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvaluation = "DeleteEvaluation"

// DeleteEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvaluation for more information on using the DeleteEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEvaluationRequest method.
//    req, resp := client.DeleteEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DeleteEvaluationRequest(input *DeleteEvaluationInput) (req *request.Request, output *DeleteEvaluationOutput) {
	op := &request.Operation{
		Name:       opDeleteEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationInput{}
	}

	output = &DeleteEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEvaluation API operation for Amazon Machine Learning.
//
// Assigns the DELETED status to an Evaluation, rendering it unusable.
//
// After invoking the DeleteEvaluation operation, you can use the GetEvaluation
// operation to verify that the status of the Evaluation changed to DELETED.
//
// CautionThe results of the DeleteEvaluation operation are irreversible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DeleteEvaluation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DeleteEvaluation(input *DeleteEvaluationInput) (*DeleteEvaluationOutput, error) {
	req, out := c.DeleteEvaluationRequest(input)
	return out, req.Send()
}

// DeleteEvaluationWithContext is the same as DeleteEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DeleteEvaluationWithContext(ctx aws.Context, input *DeleteEvaluationInput, opts ...request.Option) (*DeleteEvaluationOutput, error) {
	req, out := c.DeleteEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMLModel = "DeleteMLModel"

// DeleteMLModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMLModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMLModel for more information on using the DeleteMLModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMLModelRequest method.
//    req, resp := client.DeleteMLModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DeleteMLModelRequest(input *DeleteMLModelInput) (req *request.Request, output *DeleteMLModelOutput) {
	op := &request.Operation{
		Name:       opDeleteMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMLModelInput{}
	}

	output = &DeleteMLModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMLModel API operation for Amazon Machine Learning.
//
// Assigns the DELETED status to an MLModel, rendering it unusable.
//
// After using the DeleteMLModel operation, you can use the GetMLModel operation
// to verify that the status of the MLModel changed to DELETED.
//
// Caution: The result of the DeleteMLModel operation is irreversible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DeleteMLModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DeleteMLModel(input *DeleteMLModelInput) (*DeleteMLModelOutput, error) {
	req, out := c.DeleteMLModelRequest(input)
	return out, req.Send()
}

// DeleteMLModelWithContext is the same as DeleteMLModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMLModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DeleteMLModelWithContext(ctx aws.Context, input *DeleteMLModelInput, opts ...request.Option) (*DeleteMLModelOutput, error) {
	req, out := c.DeleteMLModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRealtimeEndpoint = "DeleteRealtimeEndpoint"

// DeleteRealtimeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRealtimeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRealtimeEndpoint for more information on using the DeleteRealtimeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRealtimeEndpointRequest method.
//    req, resp := client.DeleteRealtimeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DeleteRealtimeEndpointRequest(input *DeleteRealtimeEndpointInput) (req *request.Request, output *DeleteRealtimeEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteRealtimeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRealtimeEndpointInput{}
	}

	output = &DeleteRealtimeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRealtimeEndpoint API operation for Amazon Machine Learning.
//
// Deletes a real time endpoint of an MLModel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DeleteRealtimeEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DeleteRealtimeEndpoint(input *DeleteRealtimeEndpointInput) (*DeleteRealtimeEndpointOutput, error) {
	req, out := c.DeleteRealtimeEndpointRequest(input)
	return out, req.Send()
}

// DeleteRealtimeEndpointWithContext is the same as DeleteRealtimeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRealtimeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DeleteRealtimeEndpointWithContext(ctx aws.Context, input *DeleteRealtimeEndpointInput, opts ...request.Option) (*DeleteRealtimeEndpointOutput, error) {
	req, out := c.DeleteRealtimeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTags API operation for Amazon Machine Learning.
//
// Deletes the specified tags associated with an ML object. After this operation
// is complete, you can't recover deleted tags.
//
// If you specify a tag that doesn't exist, Amazon ML ignores it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBatchPredictions = "DescribeBatchPredictions"

// DescribeBatchPredictionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBatchPredictions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBatchPredictions for more information on using the DescribeBatchPredictions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBatchPredictionsRequest method.
//    req, resp := client.DescribeBatchPredictionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DescribeBatchPredictionsRequest(input *DescribeBatchPredictionsInput) (req *request.Request, output *DescribeBatchPredictionsOutput) {
	op := &request.Operation{
		Name:       opDescribeBatchPredictions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBatchPredictionsInput{}
	}

	output = &DescribeBatchPredictionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBatchPredictions API operation for Amazon Machine Learning.
//
// Returns a list of BatchPrediction operations that match the search criteria
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DescribeBatchPredictions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DescribeBatchPredictions(input *DescribeBatchPredictionsInput) (*DescribeBatchPredictionsOutput, error) {
	req, out := c.DescribeBatchPredictionsRequest(input)
	return out, req.Send()
}

// DescribeBatchPredictionsWithContext is the same as DescribeBatchPredictions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBatchPredictions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeBatchPredictionsWithContext(ctx aws.Context, input *DescribeBatchPredictionsInput, opts ...request.Option) (*DescribeBatchPredictionsOutput, error) {
	req, out := c.DescribeBatchPredictionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeBatchPredictionsPages iterates over the pages of a DescribeBatchPredictions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeBatchPredictions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeBatchPredictions operation.
//    pageNum := 0
//    err := client.DescribeBatchPredictionsPages(params,
//        func(page *DescribeBatchPredictionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MachineLearning) DescribeBatchPredictionsPages(input *DescribeBatchPredictionsInput, fn func(*DescribeBatchPredictionsOutput, bool) bool) error {
	return c.DescribeBatchPredictionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeBatchPredictionsPagesWithContext same as DescribeBatchPredictionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeBatchPredictionsPagesWithContext(ctx aws.Context, input *DescribeBatchPredictionsInput, fn func(*DescribeBatchPredictionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeBatchPredictionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeBatchPredictionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeBatchPredictionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDataSources = "DescribeDataSources"

// DescribeDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSources for more information on using the DescribeDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourcesRequest method.
//    req, resp := client.DescribeDataSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DescribeDataSourcesRequest(input *DescribeDataSourcesInput) (req *request.Request, output *DescribeDataSourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDataSourcesInput{}
	}

	output = &DescribeDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSources API operation for Amazon Machine Learning.
//
// Returns a list of DataSource that match the search criteria in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DescribeDataSources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DescribeDataSources(input *DescribeDataSourcesInput) (*DescribeDataSourcesOutput, error) {
	req, out := c.DescribeDataSourcesRequest(input)
	return out, req.Send()
}

// DescribeDataSourcesWithContext is the same as DescribeDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeDataSourcesWithContext(ctx aws.Context, input *DescribeDataSourcesInput, opts ...request.Option) (*DescribeDataSourcesOutput, error) {
	req, out := c.DescribeDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDataSourcesPages iterates over the pages of a DescribeDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDataSources operation.
//    pageNum := 0
//    err := client.DescribeDataSourcesPages(params,
//        func(page *DescribeDataSourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MachineLearning) DescribeDataSourcesPages(input *DescribeDataSourcesInput, fn func(*DescribeDataSourcesOutput, bool) bool) error {
	return c.DescribeDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDataSourcesPagesWithContext same as DescribeDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeDataSourcesPagesWithContext(ctx aws.Context, input *DescribeDataSourcesInput, fn func(*DescribeDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDataSourcesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEvaluations = "DescribeEvaluations"

// DescribeEvaluationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvaluations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvaluations for more information on using the DescribeEvaluations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEvaluationsRequest method.
//    req, resp := client.DescribeEvaluationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DescribeEvaluationsRequest(input *DescribeEvaluationsInput) (req *request.Request, output *DescribeEvaluationsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvaluations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEvaluationsInput{}
	}

	output = &DescribeEvaluationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvaluations API operation for Amazon Machine Learning.
//
// Returns a list of DescribeEvaluations that match the search criteria in the
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DescribeEvaluations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DescribeEvaluations(input *DescribeEvaluationsInput) (*DescribeEvaluationsOutput, error) {
	req, out := c.DescribeEvaluationsRequest(input)
	return out, req.Send()
}

// DescribeEvaluationsWithContext is the same as DescribeEvaluations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvaluations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeEvaluationsWithContext(ctx aws.Context, input *DescribeEvaluationsInput, opts ...request.Option) (*DescribeEvaluationsOutput, error) {
	req, out := c.DescribeEvaluationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEvaluationsPages iterates over the pages of a DescribeEvaluations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvaluations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvaluations operation.
//    pageNum := 0
//    err := client.DescribeEvaluationsPages(params,
//        func(page *DescribeEvaluationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MachineLearning) DescribeEvaluationsPages(input *DescribeEvaluationsInput, fn func(*DescribeEvaluationsOutput, bool) bool) error {
	return c.DescribeEvaluationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEvaluationsPagesWithContext same as DescribeEvaluationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeEvaluationsPagesWithContext(ctx aws.Context, input *DescribeEvaluationsInput, fn func(*DescribeEvaluationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEvaluationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEvaluationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEvaluationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeMLModels = "DescribeMLModels"

// DescribeMLModelsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMLModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMLModels for more information on using the DescribeMLModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMLModelsRequest method.
//    req, resp := client.DescribeMLModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DescribeMLModelsRequest(input *DescribeMLModelsInput) (req *request.Request, output *DescribeMLModelsOutput) {
	op := &request.Operation{
		Name:       opDescribeMLModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMLModelsInput{}
	}

	output = &DescribeMLModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMLModels API operation for Amazon Machine Learning.
//
// Returns a list of MLModel that match the search criteria in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DescribeMLModels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DescribeMLModels(input *DescribeMLModelsInput) (*DescribeMLModelsOutput, error) {
	req, out := c.DescribeMLModelsRequest(input)
	return out, req.Send()
}

// DescribeMLModelsWithContext is the same as DescribeMLModels with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMLModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeMLModelsWithContext(ctx aws.Context, input *DescribeMLModelsInput, opts ...request.Option) (*DescribeMLModelsOutput, error) {
	req, out := c.DescribeMLModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMLModelsPages iterates over the pages of a DescribeMLModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMLModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeMLModels operation.
//    pageNum := 0
//    err := client.DescribeMLModelsPages(params,
//        func(page *DescribeMLModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MachineLearning) DescribeMLModelsPages(input *DescribeMLModelsInput, fn func(*DescribeMLModelsOutput, bool) bool) error {
	return c.DescribeMLModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMLModelsPagesWithContext same as DescribeMLModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeMLModelsPagesWithContext(ctx aws.Context, input *DescribeMLModelsInput, fn func(*DescribeMLModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMLModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMLModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeMLModelsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon Machine Learning.
//
// Describes one or more of the tags for your Amazon ML object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBatchPrediction = "GetBatchPrediction"

// GetBatchPredictionRequest generates a "aws/request.Request" representing the
// client's request for the GetBatchPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBatchPrediction for more information on using the GetBatchPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBatchPredictionRequest method.
//    req, resp := client.GetBatchPredictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) GetBatchPredictionRequest(input *GetBatchPredictionInput) (req *request.Request, output *GetBatchPredictionOutput) {
	op := &request.Operation{
		Name:       opGetBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBatchPredictionInput{}
	}

	output = &GetBatchPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBatchPrediction API operation for Amazon Machine Learning.
//
// Returns a BatchPrediction that includes detailed metadata, status, and data
// file information for a Batch Prediction request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation GetBatchPrediction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) GetBatchPrediction(input *GetBatchPredictionInput) (*GetBatchPredictionOutput, error) {
	req, out := c.GetBatchPredictionRequest(input)
	return out, req.Send()
}

// GetBatchPredictionWithContext is the same as GetBatchPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See GetBatchPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) GetBatchPredictionWithContext(ctx aws.Context, input *GetBatchPredictionInput, opts ...request.Option) (*GetBatchPredictionOutput, error) {
	req, out := c.GetBatchPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataSourceRequest method.
//    req, resp := client.GetDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for Amazon Machine Learning.
//
// Returns a DataSource that includes metadata and data file information, as
// well as the current status of the DataSource.
//
// GetDataSource provides results in normal or verbose format. The verbose format
// adds the schema description and the list of files pointed to by the DataSource
// to the normal format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation GetDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEvaluation = "GetEvaluation"

// GetEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the GetEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEvaluation for more information on using the GetEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEvaluationRequest method.
//    req, resp := client.GetEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) GetEvaluationRequest(input *GetEvaluationInput) (req *request.Request, output *GetEvaluationOutput) {
	op := &request.Operation{
		Name:       opGetEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEvaluationInput{}
	}

	output = &GetEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEvaluation API operation for Amazon Machine Learning.
//
// Returns an Evaluation that includes metadata as well as the current status
// of the Evaluation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation GetEvaluation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) GetEvaluation(input *GetEvaluationInput) (*GetEvaluationOutput, error) {
	req, out := c.GetEvaluationRequest(input)
	return out, req.Send()
}

// GetEvaluationWithContext is the same as GetEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See GetEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) GetEvaluationWithContext(ctx aws.Context, input *GetEvaluationInput, opts ...request.Option) (*GetEvaluationOutput, error) {
	req, out := c.GetEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMLModel = "GetMLModel"

// GetMLModelRequest generates a "aws/request.Request" representing the
// client's request for the GetMLModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMLModel for more information on using the GetMLModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMLModelRequest method.
//    req, resp := client.GetMLModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) GetMLModelRequest(input *GetMLModelInput) (req *request.Request, output *GetMLModelOutput) {
	op := &request.Operation{
		Name:       opGetMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMLModelInput{}
	}

	output = &GetMLModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMLModel API operation for Amazon Machine Learning.
//
// Returns an MLModel that includes detailed metadata, data source information,
// and the current status of the MLModel.
//
// GetMLModel provides results in normal or verbose format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation GetMLModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) GetMLModel(input *GetMLModelInput) (*GetMLModelOutput, error) {
	req, out := c.GetMLModelRequest(input)
	return out, req.Send()
}

// GetMLModelWithContext is the same as GetMLModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetMLModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) GetMLModelWithContext(ctx aws.Context, input *GetMLModelInput, opts ...request.Option) (*GetMLModelOutput, error) {
	req, out := c.GetMLModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPredict = "Predict"

// PredictRequest generates a "aws/request.Request" representing the
// client's request for the Predict operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Predict for more information on using the Predict
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PredictRequest method.
//    req, resp := client.PredictRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) PredictRequest(input *PredictInput) (req *request.Request, output *PredictOutput) {
	op := &request.Operation{
		Name:       opPredict,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PredictInput{}
	}

	output = &PredictOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Predict API operation for Amazon Machine Learning.
//
// Generates a prediction for the observation using the specified ML Model.
//
// NoteNot all response parameters will be populated. Whether a response parameter
// is populated depends on the type of model requested.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation Predict for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The subscriber exceeded the maximum number of operations. This exception
//   can occur when listing objects such as DataSource.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
//   * ErrCodePredictorNotMountedException "PredictorNotMountedException"
//   The exception is thrown when a predict request is made to an unmounted MLModel.
//
func (c *MachineLearning) Predict(input *PredictInput) (*PredictOutput, error) {
	req, out := c.PredictRequest(input)
	return out, req.Send()
}

// PredictWithContext is the same as Predict with the addition of
// the ability to pass a context and additional request options.
//
// See Predict for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) PredictWithContext(ctx aws.Context, input *PredictInput, opts ...request.Option) (*PredictOutput, error) {
	req, out := c.PredictRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBatchPrediction = "UpdateBatchPrediction"

// UpdateBatchPredictionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBatchPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBatchPrediction for more information on using the UpdateBatchPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBatchPredictionRequest method.
//    req, resp := client.UpdateBatchPredictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) UpdateBatchPredictionRequest(input *UpdateBatchPredictionInput) (req *request.Request, output *UpdateBatchPredictionOutput) {
	op := &request.Operation{
		Name:       opUpdateBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBatchPredictionInput{}
	}

	output = &UpdateBatchPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBatchPrediction API operation for Amazon Machine Learning.
//
// Updates the BatchPredictionName of a BatchPrediction.
//
// You can use the GetBatchPrediction operation to view the contents of the
// updated data element.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation UpdateBatchPrediction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) UpdateBatchPrediction(input *UpdateBatchPredictionInput) (*UpdateBatchPredictionOutput, error) {
	req, out := c.UpdateBatchPredictionRequest(input)
	return out, req.Send()
}

// UpdateBatchPredictionWithContext is the same as UpdateBatchPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBatchPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) UpdateBatchPredictionWithContext(ctx aws.Context, input *UpdateBatchPredictionInput, opts ...request.Option) (*UpdateBatchPredictionOutput, error) {
	req, out := c.UpdateBatchPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourceRequest method.
//    req, resp := client.UpdateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon Machine Learning.
//
// Updates the DataSourceName of a DataSource.
//
// You can use the GetDataSource operation to view the contents of the updated
// data element.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEvaluation = "UpdateEvaluation"

// UpdateEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEvaluation for more information on using the UpdateEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEvaluationRequest method.
//    req, resp := client.UpdateEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) UpdateEvaluationRequest(input *UpdateEvaluationInput) (req *request.Request, output *UpdateEvaluationOutput) {
	op := &request.Operation{
		Name:       opUpdateEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEvaluationInput{}
	}

	output = &UpdateEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEvaluation API operation for Amazon Machine Learning.
//
// Updates the EvaluationName of an Evaluation.
//
// You can use the GetEvaluation operation to view the contents of the updated
// data element.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation UpdateEvaluation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) UpdateEvaluation(input *UpdateEvaluationInput) (*UpdateEvaluationOutput, error) {
	req, out := c.UpdateEvaluationRequest(input)
	return out, req.Send()
}

// UpdateEvaluationWithContext is the same as UpdateEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) UpdateEvaluationWithContext(ctx aws.Context, input *UpdateEvaluationInput, opts ...request.Option) (*UpdateEvaluationOutput, error) {
	req, out := c.UpdateEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMLModel = "UpdateMLModel"

// UpdateMLModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMLModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMLModel for more information on using the UpdateMLModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMLModelRequest method.
//    req, resp := client.UpdateMLModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MachineLearning) UpdateMLModelRequest(input *UpdateMLModelInput) (req *request.Request, output *UpdateMLModelOutput) {
	op := &request.Operation{
		Name:       opUpdateMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMLModelInput{}
	}

	output = &UpdateMLModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMLModel API operation for Amazon Machine Learning.
//
// Updates the MLModelName and the ScoreThreshold of an MLModel.
//
// You can use the GetMLModel operation to view the contents of the updated
// data element.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Machine Learning's
// API operation UpdateMLModel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   An error on the client occurred. Typically, the cause is an invalid input
//   value.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource cannot be located.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An error on the server occurred when trying to process a request.
//
func (c *MachineLearning) UpdateMLModel(input *UpdateMLModelInput) (*UpdateMLModelOutput, error) {
	req, out := c.UpdateMLModelRequest(input)
	return out, req.Send()
}

// UpdateMLModelWithContext is the same as UpdateMLModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMLModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MachineLearning) UpdateMLModelWithContext(ctx aws.Context, input *UpdateMLModelInput, opts ...request.Option) (*UpdateMLModelOutput, error) {
	req, out := c.UpdateMLModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the ML object to tag. For example, exampleModelId.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the ML object to tag.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"TaggableResourceType"`

	// The key-value pairs to use to create tags. If you specify a key without specifying
	// a value, Amazon ML creates a tag with the specified key and a value of null.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsInput) SetResourceId(v string) *AddTagsInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AddTagsInput) SetResourceType(v string) *AddTagsInput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsInput) SetTags(v []*Tag) *AddTagsInput {
	s.Tags = v
	return s
}

// Amazon ML returns the following elements.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the ML object that was tagged.
	ResourceId *string `min:"1" type:"string"`

	// The type of the ML object that was tagged.
	ResourceType *string `type:"string" enum:"TaggableResourceType"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsOutput) SetResourceId(v string) *AddTagsOutput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AddTagsOutput) SetResourceType(v string) *AddTagsOutput {
	s.ResourceType = &v
	return s
}

// Represents the output of a GetBatchPrediction operation.
//
// The content consists of the detailed metadata, the status, and the data file
// information of a Batch Prediction.
type BatchPrediction struct {
	_ struct{} `type:"structure"`

	// The ID of the DataSource that points to the group of observations to predict.
	BatchPredictionDataSourceId *string `min:"1" type:"string"`

	// The ID assigned to the BatchPrediction at creation. This value should be
	// identical to the value of the BatchPredictionID in the request.
	BatchPredictionId *string `min:"1" type:"string"`

	// Long integer type that is a 64-bit signed number.
	ComputeTime *int64 `type:"long"`

	// The time that the BatchPrediction was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account that invoked the BatchPrediction. The account type can
	// be either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIamUser *string `type:"string"`

	// A timestamp represented in epoch time.
	FinishedAt *time.Time `type:"timestamp"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// Long integer type that is a 64-bit signed number.
	InvalidRecordCount *int64 `type:"long"`

	// The time of the most recent edit to the BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The ID of the MLModel that generated predictions for the BatchPrediction
	// request.
	MLModelId *string `min:"1" type:"string"`

	// A description of the most recent details about processing the batch prediction
	// request.
	Message *string `type:"string"`

	// A user-supplied name or description of the BatchPrediction.
	Name *string `type:"string"`

	// The location of an Amazon S3 bucket or directory to receive the operation
	// results. The following substrings are not allowed in the s3 key portion of
	// the outputURI field: ':', '//', '/./', '/../'.
	OutputUri *string `type:"string"`

	// A timestamp represented in epoch time.
	StartedAt *time.Time `type:"timestamp"`

	// The status of the BatchPrediction. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    generate predictions for a batch of observations.
	//    * INPROGRESS - The process is underway.
	//    * FAILED - The request to perform a batch prediction did not run to completion.
	//    It is not usable.
	//    * COMPLETED - The batch prediction process completed successfully.
	//    * DELETED - The BatchPrediction is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	// Long integer type that is a 64-bit signed number.
	TotalRecordCount *int64 `type:"long"`
}

// String returns the string representation
func (s BatchPrediction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPrediction) GoString() string {
	return s.String()
}

// SetBatchPredictionDataSourceId sets the BatchPredictionDataSourceId field's value.
func (s *BatchPrediction) SetBatchPredictionDataSourceId(v string) *BatchPrediction {
	s.BatchPredictionDataSourceId = &v
	return s
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *BatchPrediction) SetBatchPredictionId(v string) *BatchPrediction {
	s.BatchPredictionId = &v
	return s
}

// SetComputeTime sets the ComputeTime field's value.
func (s *BatchPrediction) SetComputeTime(v int64) *BatchPrediction {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *BatchPrediction) SetCreatedAt(v time.Time) *BatchPrediction {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *BatchPrediction) SetCreatedByIamUser(v string) *BatchPrediction {
	s.CreatedByIamUser = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *BatchPrediction) SetFinishedAt(v time.Time) *BatchPrediction {
	s.FinishedAt = &v
	return s
}

// SetInputDataLocationS3 sets the InputDataLocationS3 field's value.
func (s *BatchPrediction) SetInputDataLocationS3(v string) *BatchPrediction {
	s.InputDataLocationS3 = &v
	return s
}

// SetInvalidRecordCount sets the InvalidRecordCount field's value.
func (s *BatchPrediction) SetInvalidRecordCount(v int64) *BatchPrediction {
	s.InvalidRecordCount = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *BatchPrediction) SetLastUpdatedAt(v time.Time) *BatchPrediction {
	s.LastUpdatedAt = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *BatchPrediction) SetMLModelId(v string) *BatchPrediction {
	s.MLModelId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchPrediction) SetMessage(v string) *BatchPrediction {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchPrediction) SetName(v string) *BatchPrediction {
	s.Name = &v
	return s
}

// SetOutputUri sets the OutputUri field's value.
func (s *BatchPrediction) SetOutputUri(v string) *BatchPrediction {
	s.OutputUri = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *BatchPrediction) SetStartedAt(v time.Time) *BatchPrediction {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchPrediction) SetStatus(v string) *BatchPrediction {
	s.Status = &v
	return s
}

// SetTotalRecordCount sets the TotalRecordCount field's value.
func (s *BatchPrediction) SetTotalRecordCount(v int64) *BatchPrediction {
	s.TotalRecordCount = &v
	return s
}

type CreateBatchPredictionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DataSource that points to the group of observations to predict.
	//
	// BatchPredictionDataSourceId is a required field
	BatchPredictionDataSourceId *string `min:"1" type:"string" required:"true"`

	// A user-supplied ID that uniquely identifies the BatchPrediction.
	//
	// BatchPredictionId is a required field
	BatchPredictionId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the BatchPrediction. BatchPredictionName
	// can only use the UTF-8 character set.
	BatchPredictionName *string `type:"string"`

	// The ID of the MLModel that will generate predictions for the group of observations.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`

	// The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory
	// to store the batch prediction results. The following substrings are not allowed
	// in the s3 key portion of the outputURI field: ':', '//', '/./', '/../'.
	//
	// Amazon ML needs permissions to store and retrieve the logs on your behalf.
	// For information about how to set permissions, see the Amazon Machine Learning
	// Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	//
	// OutputUri is a required field
	OutputUri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBatchPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBatchPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBatchPredictionInput"}
	if s.BatchPredictionDataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchPredictionDataSourceId"))
	}
	if s.BatchPredictionDataSourceId != nil && len(*s.BatchPredictionDataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchPredictionDataSourceId", 1))
	}
	if s.BatchPredictionId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchPredictionId"))
	}
	if s.BatchPredictionId != nil && len(*s.BatchPredictionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchPredictionId", 1))
	}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}
	if s.OutputUri == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchPredictionDataSourceId sets the BatchPredictionDataSourceId field's value.
func (s *CreateBatchPredictionInput) SetBatchPredictionDataSourceId(v string) *CreateBatchPredictionInput {
	s.BatchPredictionDataSourceId = &v
	return s
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *CreateBatchPredictionInput) SetBatchPredictionId(v string) *CreateBatchPredictionInput {
	s.BatchPredictionId = &v
	return s
}

// SetBatchPredictionName sets the BatchPredictionName field's value.
func (s *CreateBatchPredictionInput) SetBatchPredictionName(v string) *CreateBatchPredictionInput {
	s.BatchPredictionName = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *CreateBatchPredictionInput) SetMLModelId(v string) *CreateBatchPredictionInput {
	s.MLModelId = &v
	return s
}

// SetOutputUri sets the OutputUri field's value.
func (s *CreateBatchPredictionInput) SetOutputUri(v string) *CreateBatchPredictionInput {
	s.OutputUri = &v
	return s
}

// Represents the output of a CreateBatchPrediction operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateBatchPrediction operation is asynchronous. You can poll for status
// updates by using the >GetBatchPrediction operation and checking the Status
// parameter of the result.
type CreateBatchPredictionOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the BatchPrediction. This value
	// is identical to the value of the BatchPredictionId in the request.
	BatchPredictionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBatchPredictionOutput) GoString() string {
	return s.String()
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *CreateBatchPredictionOutput) SetBatchPredictionId(v string) *CreateBatchPredictionOutput {
	s.BatchPredictionId = &v
	return s
}

type CreateDataSourceFromRDSInput struct {
	_ struct{} `type:"structure"`

	// The compute statistics for a DataSource. The statistics are generated from
	// the observation data referenced by a DataSource. Amazon ML uses the statistics
	// internally during MLModel training. This parameter must be set to true if
	// the DataSource needs to be used for MLModel training.
	ComputeStatistics *bool `type:"boolean"`

	// A user-supplied ID that uniquely identifies the DataSource. Typically, an
	// Amazon Resource Number (ARN) becomes the ID for a DataSource.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the DataSource.
	DataSourceName *string `type:"string"`

	// The data specification of an Amazon RDS DataSource:
	//
	// RDSData is a required field
	RDSData *RDSDataSpec `type:"structure" required:"true"`

	// The role that Amazon ML assumes on behalf of the user to create and activate
	// a data pipeline in the user's account and copy data using the SelectSqlQuery
	// query from Amazon RDS to Amazon S3.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDataSourceFromRDSInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRDSInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceFromRDSInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceFromRDSInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.RDSData == nil {
		invalidParams.Add(request.NewErrParamRequired("RDSData"))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.RDSData != nil {
		if err := s.RDSData.Validate(); err != nil {
			invalidParams.AddNested("RDSData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeStatistics sets the ComputeStatistics field's value.
func (s *CreateDataSourceFromRDSInput) SetComputeStatistics(v bool) *CreateDataSourceFromRDSInput {
	s.ComputeStatistics = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceFromRDSInput) SetDataSourceId(v string) *CreateDataSourceFromRDSInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *CreateDataSourceFromRDSInput) SetDataSourceName(v string) *CreateDataSourceFromRDSInput {
	s.DataSourceName = &v
	return s
}

// SetRDSData sets the RDSData field's value.
func (s *CreateDataSourceFromRDSInput) SetRDSData(v *RDSDataSpec) *CreateDataSourceFromRDSInput {
	s.RDSData = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateDataSourceFromRDSInput) SetRoleARN(v string) *CreateDataSourceFromRDSInput {
	s.RoleARN = &v
	return s
}

// Represents the output of a CreateDataSourceFromRDS operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateDataSourceFromRDS> operation is asynchronous. You can poll for
// updates by using the GetBatchPrediction operation and checking the Status
// parameter. You can inspect the Message when Status shows up as FAILED. You
// can also check the progress of the copy operation by going to the DataPipeline
// console and looking up the pipeline using the pipelineId  from the describe
// call.
type CreateDataSourceFromRDSOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the datasource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDataSourceFromRDSOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRDSOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceFromRDSOutput) SetDataSourceId(v string) *CreateDataSourceFromRDSOutput {
	s.DataSourceId = &v
	return s
}

type CreateDataSourceFromRedshiftInput struct {
	_ struct{} `type:"structure"`

	// The compute statistics for a DataSource. The statistics are generated from
	// the observation data referenced by a DataSource. Amazon ML uses the statistics
	// internally during MLModel training. This parameter must be set to true if
	// the DataSource needs to be used for MLModel training.
	ComputeStatistics *bool `type:"boolean"`

	// A user-supplied ID that uniquely identifies the DataSource.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the DataSource.
	DataSourceName *string `type:"string"`

	// The data specification of an Amazon Redshift DataSource:
	//
	//    * DatabaseInformation - DatabaseName - The name of the Amazon Redshift
	//    database.
	//  ClusterIdentifier - The unique ID for the Amazon Redshift cluster.
	//
	//    * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials
	//    that are used to connect to the Amazon Redshift database.
	//
	//    * SelectSqlQuery - The query that is used to retrieve the observation
	//    data for the Datasource.
	//
	//    * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location
	//    for staging Amazon Redshift data. The data retrieved from Amazon Redshift
	//    using the SelectSqlQuery query is stored in this location.
	//
	//    * DataSchemaUri - The Amazon S3 location of the DataSchema.
	//
	//    * DataSchema - A JSON string representing the schema. This is not required
	//    if DataSchemaUri is specified.
	//
	//    * DataRearrangement - A JSON string that represents the splitting and
	//    rearrangement requirements for the DataSource.
	//
	//  Sample -  "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
	//
	// DataSpec is a required field
	DataSpec *RedshiftDataSpec `type:"structure" required:"true"`

	// A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the
	// role on behalf of the user to create the following:
	//
	// A security group to allow Amazon ML to execute the SelectSqlQuery query on
	// an Amazon Redshift cluster
	//
	// An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the
	// S3StagingLocation
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDataSourceFromRedshiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRedshiftInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceFromRedshiftInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceFromRedshiftInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.DataSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSpec"))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.DataSpec != nil {
		if err := s.DataSpec.Validate(); err != nil {
			invalidParams.AddNested("DataSpec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeStatistics sets the ComputeStatistics field's value.
func (s *CreateDataSourceFromRedshiftInput) SetComputeStatistics(v bool) *CreateDataSourceFromRedshiftInput {
	s.ComputeStatistics = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceFromRedshiftInput) SetDataSourceId(v string) *CreateDataSourceFromRedshiftInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *CreateDataSourceFromRedshiftInput) SetDataSourceName(v string) *CreateDataSourceFromRedshiftInput {
	s.DataSourceName = &v
	return s
}

// SetDataSpec sets the DataSpec field's value.
func (s *CreateDataSourceFromRedshiftInput) SetDataSpec(v *RedshiftDataSpec) *CreateDataSourceFromRedshiftInput {
	s.DataSpec = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateDataSourceFromRedshiftInput) SetRoleARN(v string) *CreateDataSourceFromRedshiftInput {
	s.RoleARN = &v
	return s
}

// Represents the output of a CreateDataSourceFromRedshift operation, and is
// an acknowledgement that Amazon ML received the request.
//
// The CreateDataSourceFromRedshift operation is asynchronous. You can poll
// for updates by using the GetBatchPrediction operation and checking the Status
// parameter.
type CreateDataSourceFromRedshiftOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the datasource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDataSourceFromRedshiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRedshiftOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceFromRedshiftOutput) SetDataSourceId(v string) *CreateDataSourceFromRedshiftOutput {
	s.DataSourceId = &v
	return s
}

type CreateDataSourceFromS3Input struct {
	_ struct{} `type:"structure"`

	// The compute statistics for a DataSource. The statistics are generated from
	// the observation data referenced by a DataSource. Amazon ML uses the statistics
	// internally during MLModel training. This parameter must be set to true if
	// the DataSource needs to be used for MLModel training.
	ComputeStatistics *bool `type:"boolean"`

	// A user-supplied identifier that uniquely identifies the DataSource.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the DataSource.
	DataSourceName *string `type:"string"`

	// The data specification of a DataSource:
	//
	//    * DataLocationS3 - The Amazon S3 location of the observation data.
	//
	//    * DataSchemaLocationS3 - The Amazon S3 location of the DataSchema.
	//
	//    * DataSchema - A JSON string representing the schema. This is not required
	//    if DataSchemaUri is specified.
	//
	//    * DataRearrangement - A JSON string that represents the splitting and
	//    rearrangement requirements for the Datasource.
	//
	//  Sample -  "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
	//
	// DataSpec is a required field
	DataSpec *S3DataSpec `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDataSourceFromS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceFromS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceFromS3Input"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.DataSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSpec"))
	}
	if s.DataSpec != nil {
		if err := s.DataSpec.Validate(); err != nil {
			invalidParams.AddNested("DataSpec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeStatistics sets the ComputeStatistics field's value.
func (s *CreateDataSourceFromS3Input) SetComputeStatistics(v bool) *CreateDataSourceFromS3Input {
	s.ComputeStatistics = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceFromS3Input) SetDataSourceId(v string) *CreateDataSourceFromS3Input {
	s.DataSourceId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *CreateDataSourceFromS3Input) SetDataSourceName(v string) *CreateDataSourceFromS3Input {
	s.DataSourceName = &v
	return s
}

// SetDataSpec sets the DataSpec field's value.
func (s *CreateDataSourceFromS3Input) SetDataSpec(v *S3DataSpec) *CreateDataSourceFromS3Input {
	s.DataSpec = v
	return s
}

// Represents the output of a CreateDataSourceFromS3 operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateDataSourceFromS3 operation is asynchronous. You can poll for updates
// by using the GetBatchPrediction operation and checking the Status parameter.
type CreateDataSourceFromS3Output struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the DataSource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDataSourceFromS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromS3Output) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceFromS3Output) SetDataSourceId(v string) *CreateDataSourceFromS3Output {
	s.DataSourceId = &v
	return s
}

type CreateEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DataSource for the evaluation. The schema of the DataSource
	// must match the schema used to create the MLModel.
	//
	// EvaluationDataSourceId is a required field
	EvaluationDataSourceId *string `min:"1" type:"string" required:"true"`

	// A user-supplied ID that uniquely identifies the Evaluation.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the Evaluation.
	EvaluationName *string `type:"string"`

	// The ID of the MLModel to evaluate.
	//
	// The schema used in creating the MLModel must match the schema of the DataSource
	// used in the Evaluation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEvaluationInput"}
	if s.EvaluationDataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationDataSourceId"))
	}
	if s.EvaluationDataSourceId != nil && len(*s.EvaluationDataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluationDataSourceId", 1))
	}
	if s.EvaluationId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluationId", 1))
	}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluationDataSourceId sets the EvaluationDataSourceId field's value.
func (s *CreateEvaluationInput) SetEvaluationDataSourceId(v string) *CreateEvaluationInput {
	s.EvaluationDataSourceId = &v
	return s
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *CreateEvaluationInput) SetEvaluationId(v string) *CreateEvaluationInput {
	s.EvaluationId = &v
	return s
}

// SetEvaluationName sets the EvaluationName field's value.
func (s *CreateEvaluationInput) SetEvaluationName(v string) *CreateEvaluationInput {
	s.EvaluationName = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *CreateEvaluationInput) SetMLModelId(v string) *CreateEvaluationInput {
	s.MLModelId = &v
	return s
}

// Represents the output of a CreateEvaluation operation, and is an acknowledgement
// that Amazon ML received the request.
//
// CreateEvaluation operation is asynchronous. You can poll for status updates
// by using the GetEvcaluation operation and checking the Status parameter.
type CreateEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// The user-supplied ID that uniquely identifies the Evaluation. This value
	// should be identical to the value of the EvaluationId in the request.
	EvaluationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEvaluationOutput) GoString() string {
	return s.String()
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *CreateEvaluationOutput) SetEvaluationId(v string) *CreateEvaluationOutput {
	s.EvaluationId = &v
	return s
}

type CreateMLModelInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the MLModel.
	MLModelName *string `type:"string"`

	// The category of supervised learning that this MLModel will address. Choose
	// from the following types:
	//
	//    * Choose REGRESSION if the MLModel will be used to predict a numeric value.
	//
	//    * Choose BINARY if the MLModel result has two possible values.
	//    * Choose MULTICLASS if the MLModel result has a limited number of values.
	//
	// For more information, see the Amazon Machine Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	//
	// MLModelType is a required field
	MLModelType *string `type:"string" required:"true" enum:"MLModelType"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key-value pairs.
	//
	// The following is the current set of training parameters:
	//
	//    * sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending
	//    on the input data, the size of the model might affect its performance.
	//
	//  The value is an integer that ranges from 100000 to 2147483648. The default
	//    value is 33554432.
	//
	//    * sgd.maxPasses - The number of times that the training process traverses
	//    the observations to build the MLModel. The value is an integer that ranges
	//    from 1 to 10000. The default value is 10.
	//
	//    * sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling
	//    the data improves a model's ability to find the optimal solution for a
	//    variety of data types. The valid values are auto and none. The default
	//    value is none. We strongly recommend that you shuffle your data.
	//
	//    * sgd.l1RegularizationAmount - The coefficient regularization L1 norm.
	//    It controls overfitting the data by penalizing large coefficients. This
	//    tends to drive coefficients to zero, resulting in a sparse feature set.
	//    If you use this parameter, start by specifying a small value, such as
	//    1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is to
	//    not use L1 normalization. This parameter can't be used when L2 is specified.
	//    Use this parameter sparingly.
	//
	//    * sgd.l2RegularizationAmount - The coefficient regularization L2 norm.
	//    It controls overfitting the data by penalizing large coefficients. This
	//    tends to drive coefficients to small, nonzero values. If you use this
	//    parameter, start by specifying a small value, such as 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is to
	//    not use L2 normalization. This parameter can't be used when L1 is specified.
	//    Use this parameter sparingly.
	Parameters map[string]*string `type:"map"`

	// The data recipe for creating the MLModel. You must specify either the recipe
	// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a
	// default.
	Recipe *string `type:"string"`

	// The Amazon Simple Storage Service (Amazon S3) location and file name that
	// contains the MLModel recipe. You must specify either the recipe or its URI.
	// If you don't specify a recipe or its URI, Amazon ML creates a default.
	RecipeUri *string `type:"string"`

	// The DataSource that points to the training data.
	//
	// TrainingDataSourceId is a required field
	TrainingDataSourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMLModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMLModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMLModelInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}
	if s.MLModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelType"))
	}
	if s.TrainingDataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataSourceId"))
	}
	if s.TrainingDataSourceId != nil && len(*s.TrainingDataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingDataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *CreateMLModelInput) SetMLModelId(v string) *CreateMLModelInput {
	s.MLModelId = &v
	return s
}

// SetMLModelName sets the MLModelName field's value.
func (s *CreateMLModelInput) SetMLModelName(v string) *CreateMLModelInput {
	s.MLModelName = &v
	return s
}

// SetMLModelType sets the MLModelType field's value.
func (s *CreateMLModelInput) SetMLModelType(v string) *CreateMLModelInput {
	s.MLModelType = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateMLModelInput) SetParameters(v map[string]*string) *CreateMLModelInput {
	s.Parameters = v
	return s
}

// SetRecipe sets the Recipe field's value.
func (s *CreateMLModelInput) SetRecipe(v string) *CreateMLModelInput {
	s.Recipe = &v
	return s
}

// SetRecipeUri sets the RecipeUri field's value.
func (s *CreateMLModelInput) SetRecipeUri(v string) *CreateMLModelInput {
	s.RecipeUri = &v
	return s
}

// SetTrainingDataSourceId sets the TrainingDataSourceId field's value.
func (s *CreateMLModelInput) SetTrainingDataSourceId(v string) *CreateMLModelInput {
	s.TrainingDataSourceId = &v
	return s
}

// Represents the output of a CreateMLModel operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateMLModel operation is asynchronous. You can poll for status updates
// by using the GetMLModel operation and checking the Status parameter.
type CreateMLModelOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelId in the request.
	MLModelId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMLModelOutput) GoString() string {
	return s.String()
}

// SetMLModelId sets the MLModelId field's value.
func (s *CreateMLModelOutput) SetMLModelId(v string) *CreateMLModelOutput {
	s.MLModelId = &v
	return s
}

type CreateRealtimeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the MLModel during creation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRealtimeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRealtimeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRealtimeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRealtimeEndpointInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *CreateRealtimeEndpointInput) SetMLModelId(v string) *CreateRealtimeEndpointInput {
	s.MLModelId = &v
	return s
}

// Represents the output of an CreateRealtimeEndpoint operation.
//
// The result contains the MLModelId and the endpoint information for the MLModel.
//
// The endpoint information includes the URI of the MLModel; that is, the location
// to send online prediction requests for the specified MLModel.
type CreateRealtimeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelId in the request.
	MLModelId *string `min:"1" type:"string"`

	// The endpoint information of the MLModel
	RealtimeEndpointInfo *RealtimeEndpointInfo `type:"structure"`
}

// String returns the string representation
func (s CreateRealtimeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRealtimeEndpointOutput) GoString() string {
	return s.String()
}

// SetMLModelId sets the MLModelId field's value.
func (s *CreateRealtimeEndpointOutput) SetMLModelId(v string) *CreateRealtimeEndpointOutput {
	s.MLModelId = &v
	return s
}

// SetRealtimeEndpointInfo sets the RealtimeEndpointInfo field's value.
func (s *CreateRealtimeEndpointOutput) SetRealtimeEndpointInfo(v *RealtimeEndpointInfo) *CreateRealtimeEndpointOutput {
	s.RealtimeEndpointInfo = v
	return s
}

// Represents the output of the GetDataSource operation.
//
// The content consists of the detailed metadata and data file information and
// the current status of the DataSource.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The parameter is true if statistics need to be generated from the observation
	// data.
	ComputeStatistics *bool `type:"boolean"`

	// Long integer type that is a 64-bit signed number.
	ComputeTime *int64 `type:"long"`

	// The time that the DataSource was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account from which the DataSource was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIamUser *string `type:"string"`

	// The location and name of the data in Amazon Simple Storage Service (Amazon
	// S3) that is used by a DataSource.
	DataLocationS3 *string `type:"string"`

	// A JSON string that represents the splitting and rearrangement requirement
	// used when this DataSource was created.
	DataRearrangement *string `type:"string"`

	// The total number of observations contained in the data files that the DataSource
	// references.
	DataSizeInBytes *int64 `type:"long"`

	// The ID that is assigned to the DataSource during creation.
	DataSourceId *string `min:"1" type:"string"`

	// A timestamp represented in epoch time.
	FinishedAt *time.Time `type:"timestamp"`

	// The time of the most recent edit to the BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// A description of the most recent details about creating the DataSource.
	Message *string `type:"string"`

	// A user-supplied name or description of the DataSource.
	Name *string `type:"string"`

	// The number of data files referenced by the DataSource.
	NumberOfFiles *int64 `type:"long"`

	// The datasource details that are specific to Amazon RDS.
	RDSMetadata *RDSMetadata `type:"structure"`

	// Describes the DataSource details specific to Amazon Redshift.
	RedshiftMetadata *RedshiftMetadata `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS IAM Role (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts),
	// such as the following: arn:aws:iam::account:role/rolename.
	RoleARN *string `min:"1" type:"string"`

	// A timestamp represented in epoch time.
	StartedAt *time.Time `type:"timestamp"`

	// The current status of the DataSource. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    create a DataSource.
	//    * INPROGRESS - The creation process is underway.
	//    * FAILED - The request to create a DataSource did not run to completion.
	//    It is not usable.
	//    * COMPLETED - The creation process completed successfully.
	//    * DELETED - The DataSource is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// SetComputeStatistics sets the ComputeStatistics field's value.
func (s *DataSource) SetComputeStatistics(v bool) *DataSource {
	s.ComputeStatistics = &v
	return s
}

// SetComputeTime sets the ComputeTime field's value.
func (s *DataSource) SetComputeTime(v int64) *DataSource {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSource) SetCreatedAt(v time.Time) *DataSource {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *DataSource) SetCreatedByIamUser(v string) *DataSource {
	s.CreatedByIamUser = &v
	return s
}

// SetDataLocationS3 sets the DataLocationS3 field's value.
func (s *DataSource) SetDataLocationS3(v string) *DataSource {
	s.DataLocationS3 = &v
	return s
}

// SetDataRearrangement sets the DataRearrangement field's value.
func (s *DataSource) SetDataRearrangement(v string) *DataSource {
	s.DataRearrangement = &v
	return s
}

// SetDataSizeInBytes sets the DataSizeInBytes field's value.
func (s *DataSource) SetDataSizeInBytes(v int64) *DataSource {
	s.DataSizeInBytes = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSource) SetDataSourceId(v string) *DataSource {
	s.DataSourceId = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *DataSource) SetFinishedAt(v time.Time) *DataSource {
	s.FinishedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DataSource) SetLastUpdatedAt(v time.Time) *DataSource {
	s.LastUpdatedAt = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DataSource) SetMessage(v string) *DataSource {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetNumberOfFiles sets the NumberOfFiles field's value.
func (s *DataSource) SetNumberOfFiles(v int64) *DataSource {
	s.NumberOfFiles = &v
	return s
}

// SetRDSMetadata sets the RDSMetadata field's value.
func (s *DataSource) SetRDSMetadata(v *RDSMetadata) *DataSource {
	s.RDSMetadata = v
	return s
}

// SetRedshiftMetadata sets the RedshiftMetadata field's value.
func (s *DataSource) SetRedshiftMetadata(v *RedshiftMetadata) *DataSource {
	s.RedshiftMetadata = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *DataSource) SetRoleARN(v string) *DataSource {
	s.RoleARN = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *DataSource) SetStartedAt(v time.Time) *DataSource {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSource) SetStatus(v string) *DataSource {
	s.Status = &v
	return s
}

type DeleteBatchPredictionInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the BatchPrediction.
	//
	// BatchPredictionId is a required field
	BatchPredictionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBatchPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBatchPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBatchPredictionInput"}
	if s.BatchPredictionId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchPredictionId"))
	}
	if s.BatchPredictionId != nil && len(*s.BatchPredictionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchPredictionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *DeleteBatchPredictionInput) SetBatchPredictionId(v string) *DeleteBatchPredictionInput {
	s.BatchPredictionId = &v
	return s
}

// Represents the output of a DeleteBatchPrediction operation.
//
// You can use the GetBatchPrediction operation and check the value of the Status
// parameter to see whether a BatchPrediction is marked as DELETED.
type DeleteBatchPredictionOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the BatchPrediction. This value
	// should be identical to the value of the BatchPredictionID in the request.
	BatchPredictionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBatchPredictionOutput) GoString() string {
	return s.String()
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *DeleteBatchPredictionOutput) SetBatchPredictionId(v string) *DeleteBatchPredictionOutput {
	s.BatchPredictionId = &v
	return s
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the DataSource.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceInput) SetDataSourceId(v string) *DeleteDataSourceInput {
	s.DataSourceId = &v
	return s
}

// Represents the output of a DeleteDataSource operation.
type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the DataSource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceOutput) SetDataSourceId(v string) *DeleteDataSourceOutput {
	s.DataSourceId = &v
	return s
}

type DeleteEvaluationInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the Evaluation to delete.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEvaluationInput"}
	if s.EvaluationId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *DeleteEvaluationInput) SetEvaluationId(v string) *DeleteEvaluationInput {
	s.EvaluationId = &v
	return s
}

// Represents the output of a DeleteEvaluation operation. The output indicates
// that Amazon Machine Learning (Amazon ML) received the request.
//
// You can use the GetEvaluation operation and check the value of the Status
// parameter to see whether an Evaluation is marked as DELETED.
type DeleteEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the Evaluation. This value should
	// be identical to the value of the EvaluationId in the request.
	EvaluationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationOutput) GoString() string {
	return s.String()
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *DeleteEvaluationOutput) SetEvaluationId(v string) *DeleteEvaluationOutput {
	s.EvaluationId = &v
	return s
}

type DeleteMLModelInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMLModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMLModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMLModelInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *DeleteMLModelInput) SetMLModelId(v string) *DeleteMLModelInput {
	s.MLModelId = &v
	return s
}

// Represents the output of a DeleteMLModel operation.
//
// You can use the GetMLModel operation and check the value of the Status parameter
// to see whether an MLModel is marked as DELETED.
type DeleteMLModelOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelID in the request.
	MLModelId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMLModelOutput) GoString() string {
	return s.String()
}

// SetMLModelId sets the MLModelId field's value.
func (s *DeleteMLModelOutput) SetMLModelId(v string) *DeleteMLModelOutput {
	s.MLModelId = &v
	return s
}

type DeleteRealtimeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the MLModel during creation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRealtimeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRealtimeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRealtimeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRealtimeEndpointInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *DeleteRealtimeEndpointInput) SetMLModelId(v string) *DeleteRealtimeEndpointInput {
	s.MLModelId = &v
	return s
}

// Represents the output of an DeleteRealtimeEndpoint operation.
//
// The result contains the MLModelId and the endpoint information for the MLModel.
type DeleteRealtimeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelId in the request.
	MLModelId *string `min:"1" type:"string"`

	// The endpoint information of the MLModel
	RealtimeEndpointInfo *RealtimeEndpointInfo `type:"structure"`
}

// String returns the string representation
func (s DeleteRealtimeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRealtimeEndpointOutput) GoString() string {
	return s.String()
}

// SetMLModelId sets the MLModelId field's value.
func (s *DeleteRealtimeEndpointOutput) SetMLModelId(v string) *DeleteRealtimeEndpointOutput {
	s.MLModelId = &v
	return s
}

// SetRealtimeEndpointInfo sets the RealtimeEndpointInfo field's value.
func (s *DeleteRealtimeEndpointOutput) SetRealtimeEndpointInfo(v *RealtimeEndpointInfo) *DeleteRealtimeEndpointOutput {
	s.RealtimeEndpointInfo = v
	return s
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the tagged ML object. For example, exampleModelId.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the tagged ML object.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"TaggableResourceType"`

	// One or more tags to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsInput) SetResourceId(v string) *DeleteTagsInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DeleteTagsInput) SetResourceType(v string) *DeleteTagsInput {
	s.ResourceType = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

// Amazon ML returns the following elements.
type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the ML object from which tags were deleted.
	ResourceId *string `min:"1" type:"string"`

	// The type of the ML object from which tags were deleted.
	ResourceType *string `type:"string" enum:"TaggableResourceType"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsOutput) SetResourceId(v string) *DeleteTagsOutput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DeleteTagsOutput) SetResourceType(v string) *DeleteTagsOutput {
	s.ResourceType = &v
	return s
}

type DescribeBatchPredictionsInput struct {
	_ struct{} `type:"structure"`

	// The equal to operator. The BatchPrediction results will have FilterVariable
	// values that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variables to filter a list of BatchPrediction:
	//
	//    * CreatedAt - Sets the search criteria to the BatchPrediction creation
	//    date.
	//    * Status - Sets the search criteria to the BatchPrediction status.
	//    * Name - Sets the search criteria to the contents of the BatchPredictionName.
	//
	//    * IAMUser - Sets the search criteria to the user account that invoked
	//    the BatchPrediction creation.
	//    * MLModelId - Sets the search criteria to the MLModel used in the BatchPrediction.
	//
	//    * DataSourceId - Sets the search criteria to the DataSource used in the
	//    BatchPrediction.
	//    * DataURI - Sets the search criteria to the data file(s) used in the BatchPrediction.
	//    The URL can identify either a file or an Amazon Simple Storage Solution
	//    (Amazon S3) bucket or directory.
	FilterVariable *string `type:"string" enum:"BatchPredictionFilterVariable"`

	// The greater than or equal to operator. The BatchPrediction results will have
	// FilterVariable values that are greater than or equal to the value specified
	// with GE.
	GE *string `type:"string"`

	// The greater than operator. The BatchPrediction results will have FilterVariable
	// values that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The BatchPrediction results will have
	// FilterVariable values that are less than or equal to the value specified
	// with LE.
	LE *string `type:"string"`

	// The less than operator. The BatchPrediction results will have FilterVariable
	// values that are less than the value specified with LT.
	LT *string `type:"string"`

	// The number of pages of information to include in the result. The range of
	// acceptable values is 1 through 100. The default value is 100.
	Limit *int64 `min:"1" type:"integer"`

	// The not equal to operator. The BatchPrediction results will have FilterVariable
	// values not equal to the value specified with NE.
	NE *string `type:"string"`

	// An ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, a Batch Prediction operation could have the Name2014-09-09-HolidayGiftMailer.
	// To search for this BatchPrediction, select Name for the FilterVariable and
	// any of the following strings for the Prefix:
	//
	//    * 2014-09
	//
	//    * 2014-09-09
	//
	//    * 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of MLModels.
	//
	//    * asc - Arranges the list in ascending order (A-Z, 0-9).
	//    * dsc - Arranges the list in descending order (Z-A, 9-0).
	// Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s DescribeBatchPredictionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBatchPredictionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBatchPredictionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBatchPredictionsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEQ sets the EQ field's value.
func (s *DescribeBatchPredictionsInput) SetEQ(v string) *DescribeBatchPredictionsInput {
	s.EQ = &v
	return s
}

// SetFilterVariable sets the FilterVariable field's value.
func (s *DescribeBatchPredictionsInput) SetFilterVariable(v string) *DescribeBatchPredictionsInput {
	s.FilterVariable = &v
	return s
}

// SetGE sets the GE field's value.
func (s *DescribeBatchPredictionsInput) SetGE(v string) *DescribeBatchPredictionsInput {
	s.GE = &v
	return s
}

// SetGT sets the GT field's value.
func (s *DescribeBatchPredictionsInput) SetGT(v string) *DescribeBatchPredictionsInput {
	s.GT = &v
	return s
}

// SetLE sets the LE field's value.
func (s *DescribeBatchPredictionsInput) SetLE(v string) *DescribeBatchPredictionsInput {
	s.LE = &v
	return s
}

// SetLT sets the LT field's value.
func (s *DescribeBatchPredictionsInput) SetLT(v string) *DescribeBatchPredictionsInput {
	s.LT = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeBatchPredictionsInput) SetLimit(v int64) *DescribeBatchPredictionsInput {
	s.Limit = &v
	return s
}

// SetNE sets the NE field's value.
func (s *DescribeBatchPredictionsInput) SetNE(v string) *DescribeBatchPredictionsInput {
	s.NE = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBatchPredictionsInput) SetNextToken(v string) *DescribeBatchPredictionsInput {
	s.NextToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *DescribeBatchPredictionsInput) SetPrefix(v string) *DescribeBatchPredictionsInput {
	s.Prefix = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *DescribeBatchPredictionsInput) SetSortOrder(v string) *DescribeBatchPredictionsInput {
	s.SortOrder = &v
	return s
}

// Represents the output of a DescribeBatchPredictions operation. The content
// is essentially a list of BatchPredictions.
type DescribeBatchPredictionsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the next page in the paginated results that indicates at least
	// one more page follows.
	NextToken *string `type:"string"`

	// A list of BatchPrediction objects that meet the search criteria.
	Results []*BatchPrediction `type:"list"`
}

// String returns the string representation
func (s DescribeBatchPredictionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBatchPredictionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBatchPredictionsOutput) SetNextToken(v string) *DescribeBatchPredictionsOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *DescribeBatchPredictionsOutput) SetResults(v []*BatchPrediction) *DescribeBatchPredictionsOutput {
	s.Results = v
	return s
}

type DescribeDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The equal to operator. The DataSource results will have FilterVariable values
	// that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variables to filter a list of DataSource:
	//
	//    * CreatedAt - Sets the search criteria to DataSource creation dates.
	//    * Status - Sets the search criteria to DataSource statuses.
	//    * Name - Sets the search criteria to the contents of DataSourceName.
	//    * DataUri - Sets the search criteria to the URI of data files used to
	//    create the DataSource. The URI can identify either a file or an Amazon
	//    Simple Storage Service (Amazon S3) bucket or directory.
	//    * IAMUser - Sets the search criteria to the user account that invoked
	//    the DataSource creation.
	FilterVariable *string `type:"string" enum:"DataSourceFilterVariable"`

	// The greater than or equal to operator. The DataSource results will have FilterVariable
	// values that are greater than or equal to the value specified with GE.
	GE *string `type:"string"`

	// The greater than operator. The DataSource results will have FilterVariable
	// values that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The DataSource results will have FilterVariable
	// values that are less than or equal to the value specified with LE.
	LE *string `type:"string"`

	// The less than operator. The DataSource results will have FilterVariable values
	// that are less than the value specified with LT.
	LT *string `type:"string"`

	// The maximum number of DataSource to include in the result.
	Limit *int64 `min:"1" type:"integer"`

	// The not equal to operator. The DataSource results will have FilterVariable
	// values not equal to the value specified with NE.
	NE *string `type:"string"`

	// The ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, a DataSource could have the Name2014-09-09-HolidayGiftMailer.
	// To search for this DataSource, select Name for the FilterVariable and any
	// of the following strings for the Prefix:
	//
	//    * 2014-09
	//
	//    * 2014-09-09
	//
	//    * 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of DataSource.
	//
	//    * asc - Arranges the list in ascending order (A-Z, 0-9).
	//    * dsc - Arranges the list in descending order (Z-A, 9-0).
	// Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s DescribeDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourcesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEQ sets the EQ field's value.
func (s *DescribeDataSourcesInput) SetEQ(v string) *DescribeDataSourcesInput {
	s.EQ = &v
	return s
}

// SetFilterVariable sets the FilterVariable field's value.
func (s *DescribeDataSourcesInput) SetFilterVariable(v string) *DescribeDataSourcesInput {
	s.FilterVariable = &v
	return s
}

// SetGE sets the GE field's value.
func (s *DescribeDataSourcesInput) SetGE(v string) *DescribeDataSourcesInput {
	s.GE = &v
	return s
}

// SetGT sets the GT field's value.
func (s *DescribeDataSourcesInput) SetGT(v string) *DescribeDataSourcesInput {
	s.GT = &v
	return s
}

// SetLE sets the LE field's value.
func (s *DescribeDataSourcesInput) SetLE(v string) *DescribeDataSourcesInput {
	s.LE = &v
	return s
}

// SetLT sets the LT field's value.
func (s *DescribeDataSourcesInput) SetLT(v string) *DescribeDataSourcesInput {
	s.LT = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeDataSourcesInput) SetLimit(v int64) *DescribeDataSourcesInput {
	s.Limit = &v
	return s
}

// SetNE sets the NE field's value.
func (s *DescribeDataSourcesInput) SetNE(v string) *DescribeDataSourcesInput {
	s.NE = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDataSourcesInput) SetNextToken(v string) *DescribeDataSourcesInput {
	s.NextToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *DescribeDataSourcesInput) SetPrefix(v string) *DescribeDataSourcesInput {
	s.Prefix = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *DescribeDataSourcesInput) SetSortOrder(v string) *DescribeDataSourcesInput {
	s.SortOrder = &v
	return s
}

// Represents the query results from a DescribeDataSources operation. The content
// is essentially a list of DataSource.
type DescribeDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// An ID of the next page in the paginated results that indicates at least one
	// more page follows.
	NextToken *string `type:"string"`

	// A list of DataSource that meet the search criteria.
	Results []*DataSource `type:"list"`
}

// String returns the string representation
func (s DescribeDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDataSourcesOutput) SetNextToken(v string) *DescribeDataSourcesOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *DescribeDataSourcesOutput) SetResults(v []*DataSource) *DescribeDataSourcesOutput {
	s.Results = v
	return s
}

type DescribeEvaluationsInput struct {
	_ struct{} `type:"structure"`

	// The equal to operator. The Evaluation results will have FilterVariable values
	// that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variable to filter a list of Evaluation objects:
	//
	//    * CreatedAt - Sets the search criteria to the Evaluation creation date.
	//
	//    * Status - Sets the search criteria to the Evaluation status.
	//    * Name - Sets the search criteria to the contents of EvaluationName.
	//    * IAMUser - Sets the search criteria to the user account that invoked
	//    an Evaluation.
	//    * MLModelId - Sets the search criteria to the MLModel that was evaluated.
	//
	//    * DataSourceId - Sets the search criteria to the DataSource used in Evaluation.
	//
	//    * DataUri - Sets the search criteria to the data file(s) used in Evaluation.
	//    The URL can identify either a file or an Amazon Simple Storage Solution
	//    (Amazon S3) bucket or directory.
	FilterVariable *string `type:"string" enum:"EvaluationFilterVariable"`

	// The greater than or equal to operator. The Evaluation results will have FilterVariable
	// values that are greater than or equal to the value specified with GE.
	GE *string `type:"string"`

	// The greater than operator. The Evaluation results will have FilterVariable
	// values that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The Evaluation results will have FilterVariable
	// values that are less than or equal to the value specified with LE.
	LE *string `type:"string"`

	// The less than operator. The Evaluation results will have FilterVariable values
	// that are less than the value specified with LT.
	LT *string `type:"string"`

	// The maximum number of Evaluation to include in the result.
	Limit *int64 `min:"1" type:"integer"`

	// The not equal to operator. The Evaluation results will have FilterVariable
	// values not equal to the value specified with NE.
	NE *string `type:"string"`

	// The ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, an Evaluation could have the Name2014-09-09-HolidayGiftMailer.
	// To search for this Evaluation, select Name for the FilterVariable and any
	// of the following strings for the Prefix:
	//
	//    * 2014-09
	//
	//    * 2014-09-09
	//
	//    * 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of Evaluation.
	//
	//    * asc - Arranges the list in ascending order (A-Z, 0-9).
	//    * dsc - Arranges the list in descending order (Z-A, 9-0).
	// Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s DescribeEvaluationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEvaluationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEvaluationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEvaluationsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEQ sets the EQ field's value.
func (s *DescribeEvaluationsInput) SetEQ(v string) *DescribeEvaluationsInput {
	s.EQ = &v
	return s
}

// SetFilterVariable sets the FilterVariable field's value.
func (s *DescribeEvaluationsInput) SetFilterVariable(v string) *DescribeEvaluationsInput {
	s.FilterVariable = &v
	return s
}

// SetGE sets the GE field's value.
func (s *DescribeEvaluationsInput) SetGE(v string) *DescribeEvaluationsInput {
	s.GE = &v
	return s
}

// SetGT sets the GT field's value.
func (s *DescribeEvaluationsInput) SetGT(v string) *DescribeEvaluationsInput {
	s.GT = &v
	return s
}

// SetLE sets the LE field's value.
func (s *DescribeEvaluationsInput) SetLE(v string) *DescribeEvaluationsInput {
	s.LE = &v
	return s
}

// SetLT sets the LT field's value.
func (s *DescribeEvaluationsInput) SetLT(v string) *DescribeEvaluationsInput {
	s.LT = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeEvaluationsInput) SetLimit(v int64) *DescribeEvaluationsInput {
	s.Limit = &v
	return s
}

// SetNE sets the NE field's value.
func (s *DescribeEvaluationsInput) SetNE(v string) *DescribeEvaluationsInput {
	s.NE = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEvaluationsInput) SetNextToken(v string) *DescribeEvaluationsInput {
	s.NextToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *DescribeEvaluationsInput) SetPrefix(v string) *DescribeEvaluationsInput {
	s.Prefix = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *DescribeEvaluationsInput) SetSortOrder(v string) *DescribeEvaluationsInput {
	s.SortOrder = &v
	return s
}

// Represents the query results from a DescribeEvaluations operation. The content
// is essentially a list of Evaluation.
type DescribeEvaluationsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the next page in the paginated results that indicates at least
	// one more page follows.
	NextToken *string `type:"string"`

	// A list of Evaluation that meet the search criteria.
	Results []*Evaluation `type:"list"`
}

// String returns the string representation
func (s DescribeEvaluationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEvaluationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEvaluationsOutput) SetNextToken(v string) *DescribeEvaluationsOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *DescribeEvaluationsOutput) SetResults(v []*Evaluation) *DescribeEvaluationsOutput {
	s.Results = v
	return s
}

type DescribeMLModelsInput struct {
	_ struct{} `type:"structure"`

	// The equal to operator. The MLModel results will have FilterVariable values
	// that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variables to filter a list of MLModel:
	//
	//    * CreatedAt - Sets the search criteria to MLModel creation date.
	//    * Status - Sets the search criteria to MLModel status.
	//    * Name - Sets the search criteria to the contents of MLModelName.
	//    * IAMUser - Sets the search criteria to the user account that invoked
	//    the MLModel creation.
	//    * TrainingDataSourceId - Sets the search criteria to the DataSource used
	//    to train one or more MLModel.
	//    * RealtimeEndpointStatus - Sets the search criteria to the MLModel real-time
	//    endpoint status.
	//    * MLModelType - Sets the search criteria to MLModel type: binary, regression,
	//    or multi-class.
	//    * Algorithm - Sets the search criteria to the algorithm that the MLModel
	//    uses.
	//    * TrainingDataURI - Sets the search criteria to the data file(s) used
	//    in training a MLModel. The URL can identify either a file or an Amazon
	//    Simple Storage Service (Amazon S3) bucket or directory.
	FilterVariable *string `type:"string" enum:"MLModelFilterVariable"`

	// The greater than or equal to operator. The MLModel results will have FilterVariable
	// values that are greater than or equal to the value specified with GE.
	GE *string `type:"string"`

	// The greater than operator. The MLModel results will have FilterVariable values
	// that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The MLModel results will have FilterVariable
	// values that are less than or equal to the value specified with LE.
	LE *string `type:"string"`

	// The less than operator. The MLModel results will have FilterVariable values
	// that are less than the value specified with LT.
	LT *string `type:"string"`

	// The number of pages of information to include in the result. The range of
	// acceptable values is 1 through 100. The default value is 100.
	Limit *int64 `min:"1" type:"integer"`

	// The not equal to operator. The MLModel results will have FilterVariable values
	// not equal to the value specified with NE.
	NE *string `type:"string"`

	// The ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, an MLModel could have the Name2014-09-09-HolidayGiftMailer.
	// To search for this MLModel, select Name for the FilterVariable and any of
	// the following strings for the Prefix:
	//
	//    * 2014-09
	//
	//    * 2014-09-09
	//
	//    * 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of MLModel.
	//
	//    * asc - Arranges the list in ascending order (A-Z, 0-9).
	//    * dsc - Arranges the list in descending order (Z-A, 9-0).
	// Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s DescribeMLModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMLModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMLModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMLModelsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEQ sets the EQ field's value.
func (s *DescribeMLModelsInput) SetEQ(v string) *DescribeMLModelsInput {
	s.EQ = &v
	return s
}

// SetFilterVariable sets the FilterVariable field's value.
func (s *DescribeMLModelsInput) SetFilterVariable(v string) *DescribeMLModelsInput {
	s.FilterVariable = &v
	return s
}

// SetGE sets the GE field's value.
func (s *DescribeMLModelsInput) SetGE(v string) *DescribeMLModelsInput {
	s.GE = &v
	return s
}

// SetGT sets the GT field's value.
func (s *DescribeMLModelsInput) SetGT(v string) *DescribeMLModelsInput {
	s.GT = &v
	return s
}

// SetLE sets the LE field's value.
func (s *DescribeMLModelsInput) SetLE(v string) *DescribeMLModelsInput {
	s.LE = &v
	return s
}

// SetLT sets the LT field's value.
func (s *DescribeMLModelsInput) SetLT(v string) *DescribeMLModelsInput {
	s.LT = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeMLModelsInput) SetLimit(v int64) *DescribeMLModelsInput {
	s.Limit = &v
	return s
}

// SetNE sets the NE field's value.
func (s *DescribeMLModelsInput) SetNE(v string) *DescribeMLModelsInput {
	s.NE = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMLModelsInput) SetNextToken(v string) *DescribeMLModelsInput {
	s.NextToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *DescribeMLModelsInput) SetPrefix(v string) *DescribeMLModelsInput {
	s.Prefix = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *DescribeMLModelsInput) SetSortOrder(v string) *DescribeMLModelsInput {
	s.SortOrder = &v
	return s
}

// Represents the output of a DescribeMLModels operation. The content is essentially
// a list of MLModel.
type DescribeMLModelsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the next page in the paginated results that indicates at least
	// one more page follows.
	NextToken *string `type:"string"`

	// A list of MLModel that meet the search criteria.
	Results []*MLModel `type:"list"`
}

// String returns the string representation
func (s DescribeMLModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMLModelsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMLModelsOutput) SetNextToken(v string) *DescribeMLModelsOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *DescribeMLModelsOutput) SetResults(v []*MLModel) *DescribeMLModelsOutput {
	s.Results = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the ML object. For example, exampleModelId.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the ML object.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"TaggableResourceType"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsInput) SetResourceId(v string) *DescribeTagsInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeTagsInput) SetResourceType(v string) *DescribeTagsInput {
	s.ResourceType = &v
	return s
}

// Amazon ML returns the following elements.
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the tagged ML object.
	ResourceId *string `min:"1" type:"string"`

	// The type of the tagged ML object.
	ResourceType *string `type:"string" enum:"TaggableResourceType"`

	// A list of tags associated with the ML object.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsOutput) SetResourceId(v string) *DescribeTagsOutput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeTagsOutput) SetResourceType(v string) *DescribeTagsOutput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTagsOutput) SetTags(v []*Tag) *DescribeTagsOutput {
	s.Tags = v
	return s
}

// Represents the output of GetEvaluation operation.
//
// The content consists of the detailed metadata and data file information and
// the current status of the Evaluation.
type Evaluation struct {
	_ struct{} `type:"structure"`

	// Long integer type that is a 64-bit signed number.
	ComputeTime *int64 `type:"long"`

	// The time that the Evaluation was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account that invoked the evaluation. The account type can be
	// either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIamUser *string `type:"string"`

	// The ID of the DataSource that is used to evaluate the MLModel.
	EvaluationDataSourceId *string `min:"1" type:"string"`

	// The ID that is assigned to the Evaluation at creation.
	EvaluationId *string `min:"1" type:"string"`

	// A timestamp represented in epoch time.
	FinishedAt *time.Time `type:"timestamp"`

	// The location and name of the data in Amazon Simple Storage Server (Amazon
	// S3) that is used in the evaluation.
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the Evaluation. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The ID of the MLModel that is the focus of the evaluation.
	MLModelId *string `min:"1" type:"string"`

	// A description of the most recent details about evaluating the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the Evaluation.
	Name *string `type:"string"`

	// Measurements of how well the MLModel performed, using observations referenced
	// by the DataSource. One of the following metrics is returned, based on the
	// type of the MLModel:
	//
	//    * BinaryAUC: A binary MLModel uses the Area Under the Curve (AUC) technique
	//    to measure performance.
	//
	//    * RegressionRMSE: A regression MLModel uses the Root Mean Square Error
	//    (RMSE) technique to measure performance. RMSE measures the difference
	//    between predicted and actual values for a single variable.
	//
	//    * MulticlassAvgFScore: A multiclass MLModel uses the F1 score technique
	//    to measure performance.
	//
	// For more information about performance metrics, please see the Amazon Machine
	// Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	PerformanceMetrics *PerformanceMetrics `type:"structure"`

	// A timestamp represented in epoch time.
	StartedAt *time.Time `type:"timestamp"`

	// The status of the evaluation. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    evaluate an MLModel.
	//    * INPROGRESS - The evaluation is underway.
	//    * FAILED - The request to evaluate an MLModel did not run to completion.
	//    It is not usable.
	//    * COMPLETED - The evaluation process completed successfully.
	//    * DELETED - The Evaluation is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`
}

// String returns the string representation
func (s Evaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Evaluation) GoString() string {
	return s.String()
}

// SetComputeTime sets the ComputeTime field's value.
func (s *Evaluation) SetComputeTime(v int64) *Evaluation {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Evaluation) SetCreatedAt(v time.Time) *Evaluation {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *Evaluation) SetCreatedByIamUser(v string) *Evaluation {
	s.CreatedByIamUser = &v
	return s
}

// SetEvaluationDataSourceId sets the EvaluationDataSourceId field's value.
func (s *Evaluation) SetEvaluationDataSourceId(v string) *Evaluation {
	s.EvaluationDataSourceId = &v
	return s
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *Evaluation) SetEvaluationId(v string) *Evaluation {
	s.EvaluationId = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *Evaluation) SetFinishedAt(v time.Time) *Evaluation {
	s.FinishedAt = &v
	return s
}

// SetInputDataLocationS3 sets the InputDataLocationS3 field's value.
func (s *Evaluation) SetInputDataLocationS3(v string) *Evaluation {
	s.InputDataLocationS3 = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Evaluation) SetLastUpdatedAt(v time.Time) *Evaluation {
	s.LastUpdatedAt = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *Evaluation) SetMLModelId(v string) *Evaluation {
	s.MLModelId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Evaluation) SetMessage(v string) *Evaluation {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Evaluation) SetName(v string) *Evaluation {
	s.Name = &v
	return s
}

// SetPerformanceMetrics sets the PerformanceMetrics field's value.
func (s *Evaluation) SetPerformanceMetrics(v *PerformanceMetrics) *Evaluation {
	s.PerformanceMetrics = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *Evaluation) SetStartedAt(v time.Time) *Evaluation {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Evaluation) SetStatus(v string) *Evaluation {
	s.Status = &v
	return s
}

type GetBatchPredictionInput struct {
	_ struct{} `type:"structure"`

	// An ID assigned to the BatchPrediction at creation.
	//
	// BatchPredictionId is a required field
	BatchPredictionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBatchPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBatchPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBatchPredictionInput"}
	if s.BatchPredictionId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchPredictionId"))
	}
	if s.BatchPredictionId != nil && len(*s.BatchPredictionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchPredictionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *GetBatchPredictionInput) SetBatchPredictionId(v string) *GetBatchPredictionInput {
	s.BatchPredictionId = &v
	return s
}

// Represents the output of a GetBatchPrediction operation and describes a BatchPrediction.
type GetBatchPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the DataSource that was used to create the BatchPrediction.
	BatchPredictionDataSourceId *string `min:"1" type:"string"`

	// An ID assigned to the BatchPrediction at creation. This value should be identical
	// to the value of the BatchPredictionID in the request.
	BatchPredictionId *string `min:"1" type:"string"`

	// The approximate CPU time in milliseconds that Amazon Machine Learning spent
	// processing the BatchPrediction, normalized and scaled on computation resources.
	// ComputeTime is only available if the BatchPrediction is in the COMPLETED
	// state.
	ComputeTime *int64 `type:"long"`

	// The time when the BatchPrediction was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account that invoked the BatchPrediction. The account type can
	// be either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIamUser *string `type:"string"`

	// The epoch time when Amazon Machine Learning marked the BatchPrediction as
	// COMPLETED or FAILED. FinishedAt is only available when the BatchPrediction
	// is in the COMPLETED or FAILED state.
	FinishedAt *time.Time `type:"timestamp"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The number of invalid records that Amazon Machine Learning saw while processing
	// the BatchPrediction.
	InvalidRecordCount *int64 `type:"long"`

	// The time of the most recent edit to BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// A link to the file that contains logs of the CreateBatchPrediction operation.
	LogUri *string `type:"string"`

	// The ID of the MLModel that generated predictions for the BatchPrediction
	// request.
	MLModelId *string `min:"1" type:"string"`

	// A description of the most recent details about processing the batch prediction
	// request.
	Message *string `type:"string"`

	// A user-supplied name or description of the BatchPrediction.
	Name *string `type:"string"`

	// The location of an Amazon S3 bucket or directory to receive the operation
	// results.
	OutputUri *string `type:"string"`

	// The epoch time when Amazon Machine Learning marked the BatchPrediction as
	// INPROGRESS. StartedAt isn't available if the BatchPrediction is in the PENDING
	// state.
	StartedAt *time.Time `type:"timestamp"`

	// The status of the BatchPrediction, which can be one of the following values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    generate batch predictions.
	//    * INPROGRESS - The batch predictions are in progress.
	//    * FAILED - The request to perform a batch prediction did not run to completion.
	//    It is not usable.
	//    * COMPLETED - The batch prediction process completed successfully.
	//    * DELETED - The BatchPrediction is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	// The number of total records that Amazon Machine Learning saw while processing
	// the BatchPrediction.
	TotalRecordCount *int64 `type:"long"`
}

// String returns the string representation
func (s GetBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBatchPredictionOutput) GoString() string {
	return s.String()
}

// SetBatchPredictionDataSourceId sets the BatchPredictionDataSourceId field's value.
func (s *GetBatchPredictionOutput) SetBatchPredictionDataSourceId(v string) *GetBatchPredictionOutput {
	s.BatchPredictionDataSourceId = &v
	return s
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *GetBatchPredictionOutput) SetBatchPredictionId(v string) *GetBatchPredictionOutput {
	s.BatchPredictionId = &v
	return s
}

// SetComputeTime sets the ComputeTime field's value.
func (s *GetBatchPredictionOutput) SetComputeTime(v int64) *GetBatchPredictionOutput {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetBatchPredictionOutput) SetCreatedAt(v time.Time) *GetBatchPredictionOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *GetBatchPredictionOutput) SetCreatedByIamUser(v string) *GetBatchPredictionOutput {
	s.CreatedByIamUser = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *GetBatchPredictionOutput) SetFinishedAt(v time.Time) *GetBatchPredictionOutput {
	s.FinishedAt = &v
	return s
}

// SetInputDataLocationS3 sets the InputDataLocationS3 field's value.
func (s *GetBatchPredictionOutput) SetInputDataLocationS3(v string) *GetBatchPredictionOutput {
	s.InputDataLocationS3 = &v
	return s
}

// SetInvalidRecordCount sets the InvalidRecordCount field's value.
func (s *GetBatchPredictionOutput) SetInvalidRecordCount(v int64) *GetBatchPredictionOutput {
	s.InvalidRecordCount = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetBatchPredictionOutput) SetLastUpdatedAt(v time.Time) *GetBatchPredictionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *GetBatchPredictionOutput) SetLogUri(v string) *GetBatchPredictionOutput {
	s.LogUri = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *GetBatchPredictionOutput) SetMLModelId(v string) *GetBatchPredictionOutput {
	s.MLModelId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetBatchPredictionOutput) SetMessage(v string) *GetBatchPredictionOutput {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetBatchPredictionOutput) SetName(v string) *GetBatchPredictionOutput {
	s.Name = &v
	return s
}

// SetOutputUri sets the OutputUri field's value.
func (s *GetBatchPredictionOutput) SetOutputUri(v string) *GetBatchPredictionOutput {
	s.OutputUri = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetBatchPredictionOutput) SetStartedAt(v time.Time) *GetBatchPredictionOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBatchPredictionOutput) SetStatus(v string) *GetBatchPredictionOutput {
	s.Status = &v
	return s
}

// SetTotalRecordCount sets the TotalRecordCount field's value.
func (s *GetBatchPredictionOutput) SetTotalRecordCount(v int64) *GetBatchPredictionOutput {
	s.TotalRecordCount = &v
	return s
}

type GetDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the DataSource at creation.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// Specifies whether the GetDataSource operation should return DataSourceSchema.
	//
	// If true, DataSourceSchema is returned.
	//
	// If false, DataSourceSchema is not returned.
	Verbose *bool `type:"boolean"`
}

// String returns the string representation
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceInput) SetDataSourceId(v string) *GetDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetVerbose sets the Verbose field's value.
func (s *GetDataSourceInput) SetVerbose(v bool) *GetDataSourceInput {
	s.Verbose = &v
	return s
}

// Represents the output of a GetDataSource operation and describes a DataSource.
type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The parameter is true if statistics need to be generated from the observation
	// data.
	ComputeStatistics *bool `type:"boolean"`

	// The approximate CPU time in milliseconds that Amazon Machine Learning spent
	// processing the DataSource, normalized and scaled on computation resources.
	// ComputeTime is only available if the DataSource is in the COMPLETED state
	// and the ComputeStatistics is set to true.
	ComputeTime *int64 `type:"long"`

	// The time that the DataSource was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account from which the DataSource was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIamUser *string `type:"string"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	DataLocationS3 *string `type:"string"`

	// A JSON string that represents the splitting and rearrangement requirement
	// used when this DataSource was created.
	DataRearrangement *string `type:"string"`

	// The total size of observations in the data files.
	DataSizeInBytes *int64 `type:"long"`

	// The ID assigned to the DataSource at creation. This value should be identical
	// to the value of the DataSourceId in the request.
	DataSourceId *string `min:"1" type:"string"`

	// The schema used by all of the data files of this DataSource.
	//
	// NoteThis parameter is provided as part of the verbose format.
	DataSourceSchema *string `type:"string"`

	// The epoch time when Amazon Machine Learning marked the DataSource as COMPLETED
	// or FAILED. FinishedAt is only available when the DataSource is in the COMPLETED
	// or FAILED state.
	FinishedAt *time.Time `type:"timestamp"`

	// The time of the most recent edit to the DataSource. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// A link to the file containing logs of CreateDataSourceFrom* operations.
	LogUri *string `type:"string"`

	// The user-supplied description of the most recent details about creating the
	// DataSource.
	Message *string `type:"string"`

	// A user-supplied name or description of the DataSource.
	Name *string `type:"string"`

	// The number of data files referenced by the DataSource.
	NumberOfFiles *int64 `type:"long"`

	// The datasource details that are specific to Amazon RDS.
	RDSMetadata *RDSMetadata `type:"structure"`

	// Describes the DataSource details specific to Amazon Redshift.
	RedshiftMetadata *RedshiftMetadata `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS IAM Role (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts),
	// such as the following: arn:aws:iam::account:role/rolename.
	RoleARN *string `min:"1" type:"string"`

	// The epoch time when Amazon Machine Learning marked the DataSource as INPROGRESS.
	// StartedAt isn't available if the DataSource is in the PENDING state.
	StartedAt *time.Time `type:"timestamp"`

	// The current status of the DataSource. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon ML submitted a request to create a DataSource.
	//    * INPROGRESS - The creation process is underway.
	//    * FAILED - The request to create a DataSource did not run to completion.
	//    It is not usable.
	//    * COMPLETED - The creation process completed successfully.
	//    * DELETED - The DataSource is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`
}

// String returns the string representation
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetComputeStatistics sets the ComputeStatistics field's value.
func (s *GetDataSourceOutput) SetComputeStatistics(v bool) *GetDataSourceOutput {
	s.ComputeStatistics = &v
	return s
}

// SetComputeTime sets the ComputeTime field's value.
func (s *GetDataSourceOutput) SetComputeTime(v int64) *GetDataSourceOutput {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDataSourceOutput) SetCreatedAt(v time.Time) *GetDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *GetDataSourceOutput) SetCreatedByIamUser(v string) *GetDataSourceOutput {
	s.CreatedByIamUser = &v
	return s
}

// SetDataLocationS3 sets the DataLocationS3 field's value.
func (s *GetDataSourceOutput) SetDataLocationS3(v string) *GetDataSourceOutput {
	s.DataLocationS3 = &v
	return s
}

// SetDataRearrangement sets the DataRearrangement field's value.
func (s *GetDataSourceOutput) SetDataRearrangement(v string) *GetDataSourceOutput {
	s.DataRearrangement = &v
	return s
}

// SetDataSizeInBytes sets the DataSizeInBytes field's value.
func (s *GetDataSourceOutput) SetDataSizeInBytes(v int64) *GetDataSourceOutput {
	s.DataSizeInBytes = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceOutput) SetDataSourceId(v string) *GetDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceSchema sets the DataSourceSchema field's value.
func (s *GetDataSourceOutput) SetDataSourceSchema(v string) *GetDataSourceOutput {
	s.DataSourceSchema = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *GetDataSourceOutput) SetFinishedAt(v time.Time) *GetDataSourceOutput {
	s.FinishedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetDataSourceOutput) SetLastUpdatedAt(v time.Time) *GetDataSourceOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *GetDataSourceOutput) SetLogUri(v string) *GetDataSourceOutput {
	s.LogUri = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetDataSourceOutput) SetMessage(v string) *GetDataSourceOutput {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataSourceOutput) SetName(v string) *GetDataSourceOutput {
	s.Name = &v
	return s
}

// SetNumberOfFiles sets the NumberOfFiles field's value.
func (s *GetDataSourceOutput) SetNumberOfFiles(v int64) *GetDataSourceOutput {
	s.NumberOfFiles = &v
	return s
}

// SetRDSMetadata sets the RDSMetadata field's value.
func (s *GetDataSourceOutput) SetRDSMetadata(v *RDSMetadata) *GetDataSourceOutput {
	s.RDSMetadata = v
	return s
}

// SetRedshiftMetadata sets the RedshiftMetadata field's value.
func (s *GetDataSourceOutput) SetRedshiftMetadata(v *RedshiftMetadata) *GetDataSourceOutput {
	s.RedshiftMetadata = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *GetDataSourceOutput) SetRoleARN(v string) *GetDataSourceOutput {
	s.RoleARN = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetDataSourceOutput) SetStartedAt(v time.Time) *GetDataSourceOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDataSourceOutput) SetStatus(v string) *GetDataSourceOutput {
	s.Status = &v
	return s
}

type GetEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Evaluation to retrieve. The evaluation of each MLModel is recorded
	// and cataloged. The ID provides the means to access the information.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEvaluationInput"}
	if s.EvaluationId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *GetEvaluationInput) SetEvaluationId(v string) *GetEvaluationInput {
	s.EvaluationId = &v
	return s
}

// Represents the output of a GetEvaluation operation and describes an Evaluation.
type GetEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// The approximate CPU time in milliseconds that Amazon Machine Learning spent
	// processing the Evaluation, normalized and scaled on computation resources.
	// ComputeTime is only available if the Evaluation is in the COMPLETED state.
	ComputeTime *int64 `type:"long"`

	// The time that the Evaluation was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account that invoked the evaluation. The account type can be
	// either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIamUser *string `type:"string"`

	// The DataSource used for this evaluation.
	EvaluationDataSourceId *string `min:"1" type:"string"`

	// The evaluation ID which is same as the EvaluationId in the request.
	EvaluationId *string `min:"1" type:"string"`

	// The epoch time when Amazon Machine Learning marked the Evaluation as COMPLETED
	// or FAILED. FinishedAt is only available when the Evaluation is in the COMPLETED
	// or FAILED state.
	FinishedAt *time.Time `type:"timestamp"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the Evaluation. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// A link to the file that contains logs of the CreateEvaluation operation.
	LogUri *string `type:"string"`

	// The ID of the MLModel that was the focus of the evaluation.
	MLModelId *string `min:"1" type:"string"`

	// A description of the most recent details about evaluating the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the Evaluation.
	Name *string `type:"string"`

	// Measurements of how well the MLModel performed using observations referenced
	// by the DataSource. One of the following metric is returned based on the type
	// of the MLModel:
	//
	//    * BinaryAUC: A binary MLModel uses the Area Under the Curve (AUC) technique
	//    to measure performance.
	//
	//    * RegressionRMSE: A regression MLModel uses the Root Mean Square Error
	//    (RMSE) technique to measure performance. RMSE measures the difference
	//    between predicted and actual values for a single variable.
	//
	//    * MulticlassAvgFScore: A multiclass MLModel uses the F1 score technique
	//    to measure performance.
	//
	// For more information about performance metrics, please see the Amazon Machine
	// Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	PerformanceMetrics *PerformanceMetrics `type:"structure"`

	// The epoch time when Amazon Machine Learning marked the Evaluation as INPROGRESS.
	// StartedAt isn't available if the Evaluation is in the PENDING state.
	StartedAt *time.Time `type:"timestamp"`

	// The status of the evaluation. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Language (Amazon ML) submitted a request to
	//    evaluate an MLModel.
	//    * INPROGRESS - The evaluation is underway.
	//    * FAILED - The request to evaluate an MLModel did not run to completion.
	//    It is not usable.
	//    * COMPLETED - The evaluation process completed successfully.
	//    * DELETED - The Evaluation is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`
}

// String returns the string representation
func (s GetEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvaluationOutput) GoString() string {
	return s.String()
}

// SetComputeTime sets the ComputeTime field's value.
func (s *GetEvaluationOutput) SetComputeTime(v int64) *GetEvaluationOutput {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEvaluationOutput) SetCreatedAt(v time.Time) *GetEvaluationOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *GetEvaluationOutput) SetCreatedByIamUser(v string) *GetEvaluationOutput {
	s.CreatedByIamUser = &v
	return s
}

// SetEvaluationDataSourceId sets the EvaluationDataSourceId field's value.
func (s *GetEvaluationOutput) SetEvaluationDataSourceId(v string) *GetEvaluationOutput {
	s.EvaluationDataSourceId = &v
	return s
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *GetEvaluationOutput) SetEvaluationId(v string) *GetEvaluationOutput {
	s.EvaluationId = &v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *GetEvaluationOutput) SetFinishedAt(v time.Time) *GetEvaluationOutput {
	s.FinishedAt = &v
	return s
}

// SetInputDataLocationS3 sets the InputDataLocationS3 field's value.
func (s *GetEvaluationOutput) SetInputDataLocationS3(v string) *GetEvaluationOutput {
	s.InputDataLocationS3 = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetEvaluationOutput) SetLastUpdatedAt(v time.Time) *GetEvaluationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *GetEvaluationOutput) SetLogUri(v string) *GetEvaluationOutput {
	s.LogUri = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *GetEvaluationOutput) SetMLModelId(v string) *GetEvaluationOutput {
	s.MLModelId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetEvaluationOutput) SetMessage(v string) *GetEvaluationOutput {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEvaluationOutput) SetName(v string) *GetEvaluationOutput {
	s.Name = &v
	return s
}

// SetPerformanceMetrics sets the PerformanceMetrics field's value.
func (s *GetEvaluationOutput) SetPerformanceMetrics(v *PerformanceMetrics) *GetEvaluationOutput {
	s.PerformanceMetrics = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetEvaluationOutput) SetStartedAt(v time.Time) *GetEvaluationOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEvaluationOutput) SetStatus(v string) *GetEvaluationOutput {
	s.Status = &v
	return s
}

type GetMLModelInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the MLModel at creation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`

	// Specifies whether the GetMLModel operation should return Recipe.
	//
	// If true, Recipe is returned.
	//
	// If false, Recipe is not returned.
	Verbose *bool `type:"boolean"`
}

// String returns the string representation
func (s GetMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMLModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMLModelInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *GetMLModelInput) SetMLModelId(v string) *GetMLModelInput {
	s.MLModelId = &v
	return s
}

// SetVerbose sets the Verbose field's value.
func (s *GetMLModelInput) SetVerbose(v bool) *GetMLModelInput {
	s.Verbose = &v
	return s
}

// Represents the output of a GetMLModel operation, and provides detailed information
// about a MLModel.
type GetMLModelOutput struct {
	_ struct{} `type:"structure"`

	// The approximate CPU time in milliseconds that Amazon Machine Learning spent
	// processing the MLModel, normalized and scaled on computation resources. ComputeTime
	// is only available if the MLModel is in the COMPLETED state.
	ComputeTime *int64 `type:"long"`

	// The time that the MLModel was created. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account from which the MLModel was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIamUser *string `type:"string"`

	// The current endpoint of the MLModel
	EndpointInfo *RealtimeEndpointInfo `type:"structure"`

	// The epoch time when Amazon Machine Learning marked the MLModel as COMPLETED
	// or FAILED. FinishedAt is only available when the MLModel is in the COMPLETED
	// or FAILED state.
	FinishedAt *time.Time `type:"timestamp"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the MLModel. The time is expressed in
	// epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// A link to the file that contains logs of the CreateMLModel operation.
	LogUri *string `type:"string"`

	// The MLModel ID, which is same as the MLModelId in the request.
	MLModelId *string `min:"1" type:"string"`

	// Identifies the MLModel category. The following are the available types:
	//
	//    * REGRESSION -- Produces a numeric result. For example, "What price should
	//    a house be listed at?"
	//    * BINARY -- Produces one of two possible results. For example, "Is this
	//    an e-commerce website?"
	//    * MULTICLASS -- Produces one of several possible results. For example,
	//    "Is this a HIGH, LOW or MEDIUM risk trade?"
	MLModelType *string `type:"string" enum:"MLModelType"`

	// A description of the most recent details about accessing the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the MLModel.
	Name *string `type:"string"`

	// The recipe to use when training the MLModel. The Recipe provides detailed
	// information about the observation data to use during training, and manipulations
	// to perform on the observation data during training.
	//
	// NoteThis parameter is provided as part of the verbose format.
	Recipe *string `type:"string"`

	// The schema used by all of the data files referenced by the DataSource.
	//
	// NoteThis parameter is provided as part of the verbose format.
	Schema *string `type:"string"`

	// The scoring threshold is used in binary classification MLModelmodels. It
	// marks the boundary between a positive prediction and a negative prediction.
	//
	// Output values greater than or equal to the threshold receive a positive result
	// from the MLModel, such as true. Output values less than the threshold receive
	// a negative response from the MLModel, such as false.
	ScoreThreshold *float64 `type:"float"`

	// The time of the most recent edit to the ScoreThreshold. The time is expressed
	// in epoch time.
	ScoreThresholdLastUpdatedAt *time.Time `type:"timestamp"`

	// Long integer type that is a 64-bit signed number.
	SizeInBytes *int64 `type:"long"`

	// The epoch time when Amazon Machine Learning marked the MLModel as INPROGRESS.
	// StartedAt isn't available if the MLModel is in the PENDING state.
	StartedAt *time.Time `type:"timestamp"`

	// The current status of the MLModel. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    describe a MLModel.
	//    * INPROGRESS - The request is processing.
	//    * FAILED - The request did not run to completion. The ML model isn't usable.
	//
	//    * COMPLETED - The request completed successfully.
	//    * DELETED - The MLModel is marked as deleted. It isn't usable.
	Status *string `type:"string" enum:"EntityStatus"`

	// The ID of the training DataSource.
	TrainingDataSourceId *string `min:"1" type:"string"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key-value pairs.
	//
	// The following is the current set of training parameters:
	//
	//    * sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending
	//    on the input data, the size of the model might affect its performance.
	//
	//  The value is an integer that ranges from 100000 to 2147483648. The default
	//    value is 33554432.
	//
	//    * sgd.maxPasses - The number of times that the training process traverses
	//    the observations to build the MLModel. The value is an integer that ranges
	//    from 1 to 10000. The default value is 10.
	//
	//    * sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling
	//    data improves a model's ability to find the optimal solution for a variety
	//    of data types. The valid values are auto and none. The default value is
	//    none. We strongly recommend that you shuffle your data.
	//
	//    * sgd.l1RegularizationAmount - The coefficient regularization L1 norm.
	//    It controls overfitting the data by penalizing large coefficients. This
	//    tends to drive coefficients to zero, resulting in a sparse feature set.
	//    If you use this parameter, start by specifying a small value, such as
	//    1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is to
	//    not use L1 normalization. This parameter can't be used when L2 is specified.
	//    Use this parameter sparingly.
	//
	//    * sgd.l2RegularizationAmount - The coefficient regularization L2 norm.
	//    It controls overfitting the data by penalizing large coefficients. This
	//    tends to drive coefficients to small, nonzero values. If you use this
	//    parameter, start by specifying a small value, such as 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is to
	//    not use L2 normalization. This parameter can't be used when L1 is specified.
	//    Use this parameter sparingly.
	TrainingParameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMLModelOutput) GoString() string {
	return s.String()
}

// SetComputeTime sets the ComputeTime field's value.
func (s *GetMLModelOutput) SetComputeTime(v int64) *GetMLModelOutput {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMLModelOutput) SetCreatedAt(v time.Time) *GetMLModelOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *GetMLModelOutput) SetCreatedByIamUser(v string) *GetMLModelOutput {
	s.CreatedByIamUser = &v
	return s
}

// SetEndpointInfo sets the EndpointInfo field's value.
func (s *GetMLModelOutput) SetEndpointInfo(v *RealtimeEndpointInfo) *GetMLModelOutput {
	s.EndpointInfo = v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *GetMLModelOutput) SetFinishedAt(v time.Time) *GetMLModelOutput {
	s.FinishedAt = &v
	return s
}

// SetInputDataLocationS3 sets the InputDataLocationS3 field's value.
func (s *GetMLModelOutput) SetInputDataLocationS3(v string) *GetMLModelOutput {
	s.InputDataLocationS3 = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetMLModelOutput) SetLastUpdatedAt(v time.Time) *GetMLModelOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *GetMLModelOutput) SetLogUri(v string) *GetMLModelOutput {
	s.LogUri = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *GetMLModelOutput) SetMLModelId(v string) *GetMLModelOutput {
	s.MLModelId = &v
	return s
}

// SetMLModelType sets the MLModelType field's value.
func (s *GetMLModelOutput) SetMLModelType(v string) *GetMLModelOutput {
	s.MLModelType = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetMLModelOutput) SetMessage(v string) *GetMLModelOutput {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMLModelOutput) SetName(v string) *GetMLModelOutput {
	s.Name = &v
	return s
}

// SetRecipe sets the Recipe field's value.
func (s *GetMLModelOutput) SetRecipe(v string) *GetMLModelOutput {
	s.Recipe = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *GetMLModelOutput) SetSchema(v string) *GetMLModelOutput {
	s.Schema = &v
	return s
}

// SetScoreThreshold sets the ScoreThreshold field's value.
func (s *GetMLModelOutput) SetScoreThreshold(v float64) *GetMLModelOutput {
	s.ScoreThreshold = &v
	return s
}

// SetScoreThresholdLastUpdatedAt sets the ScoreThresholdLastUpdatedAt field's value.
func (s *GetMLModelOutput) SetScoreThresholdLastUpdatedAt(v time.Time) *GetMLModelOutput {
	s.ScoreThresholdLastUpdatedAt = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *GetMLModelOutput) SetSizeInBytes(v int64) *GetMLModelOutput {
	s.SizeInBytes = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetMLModelOutput) SetStartedAt(v time.Time) *GetMLModelOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMLModelOutput) SetStatus(v string) *GetMLModelOutput {
	s.Status = &v
	return s
}

// SetTrainingDataSourceId sets the TrainingDataSourceId field's value.
func (s *GetMLModelOutput) SetTrainingDataSourceId(v string) *GetMLModelOutput {
	s.TrainingDataSourceId = &v
	return s
}

// SetTrainingParameters sets the TrainingParameters field's value.
func (s *GetMLModelOutput) SetTrainingParameters(v map[string]*string) *GetMLModelOutput {
	s.TrainingParameters = v
	return s
}

// Represents the output of a GetMLModel operation.
//
// The content consists of the detailed metadata and the current status of the
// MLModel.
type MLModel struct {
	_ struct{} `type:"structure"`

	// The algorithm used to train the MLModel. The following algorithm is supported:
	//
	//    * SGD -- Stochastic gradient descent. The goal of SGD is to minimize the
	//    gradient of the loss function.
	Algorithm *string `type:"string" enum:"Algorithm"`

	// Long integer type that is a 64-bit signed number.
	ComputeTime *int64 `type:"long"`

	// The time that the MLModel was created. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account from which the MLModel was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIamUser *string `type:"string"`

	// The current endpoint of the MLModel.
	EndpointInfo *RealtimeEndpointInfo `type:"structure"`

	// A timestamp represented in epoch time.
	FinishedAt *time.Time `type:"timestamp"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the MLModel. The time is expressed in
	// epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The ID assigned to the MLModel at creation.
	MLModelId *string `min:"1" type:"string"`

	// Identifies the MLModel category. The following are the available types:
	//
	//    * REGRESSION - Produces a numeric result. For example, "What price should
	//    a house be listed at?"
	//    * BINARY - Produces one of two possible results. For example, "Is this
	//    a child-friendly web site?".
	//    * MULTICLASS - Produces one of several possible results. For example,
	//    "Is this a HIGH-, LOW-, or MEDIUM-risk trade?".
	MLModelType *string `type:"string" enum:"MLModelType"`

	// A description of the most recent details about accessing the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the MLModel.
	Name *string `type:"string"`

	ScoreThreshold *float64 `type:"float"`

	// The time of the most recent edit to the ScoreThreshold. The time is expressed
	// in epoch time.
	ScoreThresholdLastUpdatedAt *time.Time `type:"timestamp"`

	// Long integer type that is a 64-bit signed number.
	SizeInBytes *int64 `type:"long"`

	// A timestamp represented in epoch time.
	StartedAt *time.Time `type:"timestamp"`

	// The current status of an MLModel. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    create an MLModel.
	//    * INPROGRESS - The creation process is underway.
	//    * FAILED - The request to create an MLModel didn't run to completion.
	//    The model isn't usable.
	//    * COMPLETED - The creation process completed successfully.
	//    * DELETED - The MLModel is marked as deleted. It isn't usable.
	Status *string `type:"string" enum:"EntityStatus"`

	// The ID of the training DataSource. The CreateMLModel operation uses the TrainingDataSourceId.
	TrainingDataSourceId *string `min:"1" type:"string"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key-value pairs.
	//
	// The following is the current set of training parameters:
	//
	//    * sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending
	//    on the input data, the size of the model might affect its performance.
	//
	//  The value is an integer that ranges from 100000 to 2147483648. The default
	//    value is 33554432.
	//
	//    * sgd.maxPasses - The number of times that the training process traverses
	//    the observations to build the MLModel. The value is an integer that ranges
	//    from 1 to 10000. The default value is 10.
	//
	//    * sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling
	//    the data improves a model's ability to find the optimal solution for a
	//    variety of data types. The valid values are auto and none. The default
	//    value is none.
	//
	//    * sgd.l1RegularizationAmount - The coefficient regularization L1 norm,
	//    which controls overfitting the data by penalizing large coefficients.
	//    This parameter tends to drive coefficients to zero, resulting in sparse
	//    feature set. If you use this parameter, start by specifying a small value,
	//    such as 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is to
	//    not use L1 normalization. This parameter can't be used when L2 is specified.
	//    Use this parameter sparingly.
	//
	//    * sgd.l2RegularizationAmount - The coefficient regularization L2 norm,
	//    which controls overfitting the data by penalizing large coefficients.
	//    This tends to drive coefficients to small, nonzero values. If you use
	//    this parameter, start by specifying a small value, such as 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is to
	//    not use L2 normalization. This parameter can't be used when L1 is specified.
	//    Use this parameter sparingly.
	TrainingParameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s MLModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MLModel) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *MLModel) SetAlgorithm(v string) *MLModel {
	s.Algorithm = &v
	return s
}

// SetComputeTime sets the ComputeTime field's value.
func (s *MLModel) SetComputeTime(v int64) *MLModel {
	s.ComputeTime = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *MLModel) SetCreatedAt(v time.Time) *MLModel {
	s.CreatedAt = &v
	return s
}

// SetCreatedByIamUser sets the CreatedByIamUser field's value.
func (s *MLModel) SetCreatedByIamUser(v string) *MLModel {
	s.CreatedByIamUser = &v
	return s
}

// SetEndpointInfo sets the EndpointInfo field's value.
func (s *MLModel) SetEndpointInfo(v *RealtimeEndpointInfo) *MLModel {
	s.EndpointInfo = v
	return s
}

// SetFinishedAt sets the FinishedAt field's value.
func (s *MLModel) SetFinishedAt(v time.Time) *MLModel {
	s.FinishedAt = &v
	return s
}

// SetInputDataLocationS3 sets the InputDataLocationS3 field's value.
func (s *MLModel) SetInputDataLocationS3(v string) *MLModel {
	s.InputDataLocationS3 = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *MLModel) SetLastUpdatedAt(v time.Time) *MLModel {
	s.LastUpdatedAt = &v
	return s
}

// SetMLModelId sets the MLModelId field's value.
func (s *MLModel) SetMLModelId(v string) *MLModel {
	s.MLModelId = &v
	return s
}

// SetMLModelType sets the MLModelType field's value.
func (s *MLModel) SetMLModelType(v string) *MLModel {
	s.MLModelType = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *MLModel) SetMessage(v string) *MLModel {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *MLModel) SetName(v string) *MLModel {
	s.Name = &v
	return s
}

// SetScoreThreshold sets the ScoreThreshold field's value.
func (s *MLModel) SetScoreThreshold(v float64) *MLModel {
	s.ScoreThreshold = &v
	return s
}

// SetScoreThresholdLastUpdatedAt sets the ScoreThresholdLastUpdatedAt field's value.
func (s *MLModel) SetScoreThresholdLastUpdatedAt(v time.Time) *MLModel {
	s.ScoreThresholdLastUpdatedAt = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *MLModel) SetSizeInBytes(v int64) *MLModel {
	s.SizeInBytes = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *MLModel) SetStartedAt(v time.Time) *MLModel {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MLModel) SetStatus(v string) *MLModel {
	s.Status = &v
	return s
}

// SetTrainingDataSourceId sets the TrainingDataSourceId field's value.
func (s *MLModel) SetTrainingDataSourceId(v string) *MLModel {
	s.TrainingDataSourceId = &v
	return s
}

// SetTrainingParameters sets the TrainingParameters field's value.
func (s *MLModel) SetTrainingParameters(v map[string]*string) *MLModel {
	s.TrainingParameters = v
	return s
}

// Measurements of how well the MLModel performed on known observations. One
// of the following metrics is returned, based on the type of the MLModel:
//
//    * BinaryAUC: The binary MLModel uses the Area Under the Curve (AUC) technique
//    to measure performance.
//
//    * RegressionRMSE: The regression MLModel uses the Root Mean Square Error
//    (RMSE) technique to measure performance. RMSE measures the difference
//    between predicted and actual values for a single variable.
//
//    * MulticlassAvgFScore: The multiclass MLModel uses the F1 score technique
//    to measure performance.
//
// For more information about performance metrics, please see the Amazon Machine
// Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
type PerformanceMetrics struct {
	_ struct{} `type:"structure"`

	Properties map[string]*string `type:"map"`
}

// String returns the string representation
func (s PerformanceMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PerformanceMetrics) GoString() string {
	return s.String()
}

// SetProperties sets the Properties field's value.
func (s *PerformanceMetrics) SetProperties(v map[string]*string) *PerformanceMetrics {
	s.Properties = v
	return s
}

type PredictInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the MLModel.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`

	// PredictEndpoint is a required field
	PredictEndpoint *string `type:"string" required:"true"`

	// A map of variable name-value pairs that represent an observation.
	//
	// Record is a required field
	Record map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s PredictInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}
	if s.PredictEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictEndpoint"))
	}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *PredictInput) SetMLModelId(v string) *PredictInput {
	s.MLModelId = &v
	return s
}

// SetPredictEndpoint sets the PredictEndpoint field's value.
func (s *PredictInput) SetPredictEndpoint(v string) *PredictInput {
	s.PredictEndpoint = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *PredictInput) SetRecord(v map[string]*string) *PredictInput {
	s.Record = v
	return s
}

type PredictOutput struct {
	_ struct{} `type:"structure"`

	// The output from a Predict operation:
	//
	//    * Details - Contains the following attributes: DetailsAttributes.PREDICTIVE_MODEL_TYPE
	//    - REGRESSION | BINARY | MULTICLASSDetailsAttributes.ALGORITHM - SGD
	//
	//    * PredictedLabel - Present for either a BINARY or MULTICLASSMLModel request.
	//
	//
	//    * PredictedScores - Contains the raw classification score corresponding
	//    to each label.
	//
	//    * PredictedValue - Present for a REGRESSIONMLModel request.
	Prediction *Prediction `type:"structure"`
}

// String returns the string representation
func (s PredictOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictOutput) GoString() string {
	return s.String()
}

// SetPrediction sets the Prediction field's value.
func (s *PredictOutput) SetPrediction(v *Prediction) *PredictOutput {
	s.Prediction = v
	return s
}

// The output from a Predict operation:
//
//    * Details - Contains the following attributes: DetailsAttributes.PREDICTIVE_MODEL_TYPE
//    - REGRESSION | BINARY | MULTICLASSDetailsAttributes.ALGORITHM - SGD
//
//    * PredictedLabel - Present for either a BINARY or MULTICLASSMLModel request.
//
//
//    * PredictedScores - Contains the raw classification score corresponding
//    to each label.
//
//    * PredictedValue - Present for a REGRESSIONMLModel request.
type Prediction struct {
	_ struct{} `type:"structure"`

	// Provides any additional details regarding the prediction.
	Details map[string]*string `locationName:"details" type:"map"`

	// The prediction label for either a BINARY or MULTICLASSMLModel.
	PredictedLabel *string `locationName:"predictedLabel" min:"1" type:"string"`

	// Provides the raw classification score corresponding to each label.
	PredictedScores map[string]*float64 `locationName:"predictedScores" type:"map"`

	// The prediction value for REGRESSIONMLModel
	PredictedValue *float64 `locationName:"predictedValue" type:"float"`
}

// String returns the string representation
func (s Prediction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Prediction) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *Prediction) SetDetails(v map[string]*string) *Prediction {
	s.Details = v
	return s
}

// SetPredictedLabel sets the PredictedLabel field's value.
func (s *Prediction) SetPredictedLabel(v string) *Prediction {
	s.PredictedLabel = &v
	return s
}

// SetPredictedScores sets the PredictedScores field's value.
func (s *Prediction) SetPredictedScores(v map[string]*float64) *Prediction {
	s.PredictedScores = v
	return s
}

// SetPredictedValue sets the PredictedValue field's value.
func (s *Prediction) SetPredictedValue(v float64) *Prediction {
	s.PredictedValue = &v
	return s
}

// The data specification of an Amazon Relational Database Service (Amazon RDS)
// DataSource.
type RDSDataSpec struct {
	_ struct{} `type:"structure"`

	// A JSON string that represents the splitting and rearrangement processing
	// to be applied to a DataSource. If the DataRearrangement parameter is not
	// provided, all of the input data is used to create the Datasource.
	//
	// There are multiple parameters that control what data is used to create a
	// datasource:
	//
	//    * percentBegin
	//
	// Use percentBegin to indicate the beginning of the range of the data used
	//    to create the Datasource. If you do not include percentBegin and percentEnd,
	//    Amazon ML includes all of the data when creating the datasource.
	//
	//    * percentEnd
	//
	// Use percentEnd to indicate the end of the range of the data used to create
	//    the Datasource. If you do not include percentBegin and percentEnd, Amazon
	//    ML includes all of the data when creating the datasource.
	//
	//    * complement
	//
	// The complement parameter instructs Amazon ML to use the data that is not
	//    included in the range of percentBegin to percentEnd to create a datasource.
	//    The complement parameter is useful if you need to create complementary
	//    datasources for training and evaluation. To create a complementary datasource,
	//    use the same values for percentBegin and percentEnd, along with the complement
	//    parameter.
	//
	// For example, the following two datasources do not share any data, and can
	//    be used to train and evaluate a model. The first datasource has 25 percent
	//    of the data, and the second one has 75 percent of the data.
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":0, "percentEnd":25}}
	//
	// Datasource for training: {"splitting":{"percentBegin":0, "percentEnd":25,
	//    "complement":"true"}}
	//
	//    * strategy
	//
	// To change how Amazon ML splits the data for a datasource, use the strategy
	//    parameter.
	//
	// The default value for the strategy parameter is sequential, meaning that
	//    Amazon ML takes all of the data records between the percentBegin and percentEnd
	//    parameters for the datasource, in the order that the records appear in
	//    the input data.
	//
	// The following two DataRearrangement lines are examples of sequentially ordered
	//    training and evaluation datasources:
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"sequential"}}
	//
	// Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"sequential", "complement":"true"}}
	//
	// To randomly split the input data into the proportions indicated by the percentBegin
	//    and percentEnd parameters, set the strategy parameter to random and provide
	//    a string that is used as the seed value for the random data splitting
	//    (for example, you can use the S3 path to your data as the random seed
	//    string). If you choose the random split strategy, Amazon ML assigns each
	//    row of data a pseudo-random number between 0 and 100, and then selects
	//    the rows that have an assigned number between percentBegin and percentEnd.
	//    Pseudo-random numbers are assigned using both the input seed string value
	//    and the byte offset as a seed, so changing the data results in a different
	//    split. Any existing ordering is preserved. The random splitting strategy
	//    ensures that variables in the training and evaluation data are distributed
	//    similarly. It is useful in the cases where the input data may have an
	//    implicit sort order, which would otherwise result in training and evaluation
	//    datasources containing non-similar data records.
	//
	// The following two DataRearrangement lines are examples of non-sequentially
	//    ordered training and evaluation datasources:
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}
	//
	// Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}
	DataRearrangement *string `type:"string"`

	// A JSON string that represents the schema for an Amazon RDS DataSource. The
	// DataSchema defines the structure of the observation data in the data file(s)
	// referenced in the DataSource.
	//
	// A DataSchema is not required if you specify a DataSchemaUri
	//
	// Define your DataSchema as a series of key-value pairs. attributes and excludedVariableNames
	// have an array of key-value pairs for their value. Use the following format
	// to define your DataSchema.
	//
	// { "version": "1.0",
	//
	// "recordAnnotationFieldName": "F1",
	//
	// "recordWeightFieldName": "F2",
	//
	// "targetFieldName": "F3",
	//
	// "dataFormat": "CSV",
	//
	// "dataFileContainsHeader": true,
	//
	// "attributes": [
	//
	// { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType":
	// "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName":
	// "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL"
	// }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType":
	// "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE"
	// } ],
	//
	// "excludedVariableNames": [ "F6" ] }
	DataSchema *string `type:"string"`

	// The Amazon S3 location of the DataSchema.
	DataSchemaUri *string `type:"string"`

	// The AWS Identity and Access Management (IAM) credentials that are used connect
	// to the Amazon RDS database.
	//
	// DatabaseCredentials is a required field
	DatabaseCredentials *RDSDatabaseCredentials `type:"structure" required:"true"`

	// Describes the DatabaseName and InstanceIdentifier of an Amazon RDS database.
	//
	// DatabaseInformation is a required field
	DatabaseInformation *RDSDatabase `type:"structure" required:"true"`

	// The role (DataPipelineDefaultResourceRole) assumed by an Amazon Elastic Compute
	// Cloud (Amazon EC2) instance to carry out the copy operation from Amazon RDS
	// to an Amazon S3 task. For more information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	//
	// ResourceRole is a required field
	ResourceRole *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 location for staging Amazon RDS data. The data retrieved from
	// Amazon RDS using SelectSqlQuery is stored in this location.
	//
	// S3StagingLocation is a required field
	S3StagingLocation *string `type:"string" required:"true"`

	// The security group IDs to be used to access a VPC-based RDS DB instance.
	// Ensure that there are appropriate ingress rules set up to allow access to
	// the RDS DB instance. This attribute is used by Data Pipeline to carry out
	// the copy operation from Amazon RDS to an Amazon S3 task.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	// The query that is used to retrieve the observation data for the DataSource.
	//
	// SelectSqlQuery is a required field
	SelectSqlQuery *string `min:"1" type:"string" required:"true"`

	// The role (DataPipelineDefaultRole) assumed by AWS Data Pipeline service to
	// monitor the progress of the copy task from Amazon RDS to Amazon S3. For more
	// information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	//
	// ServiceRole is a required field
	ServiceRole *string `min:"1" type:"string" required:"true"`

	// The subnet ID to be used to access a VPC-based RDS DB instance. This attribute
	// is used by Data Pipeline to carry out the copy task from Amazon RDS to Amazon
	// S3.
	//
	// SubnetId is a required field
	SubnetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RDSDataSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSDataSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RDSDataSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RDSDataSpec"}
	if s.DatabaseCredentials == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseCredentials"))
	}
	if s.DatabaseInformation == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseInformation"))
	}
	if s.ResourceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceRole"))
	}
	if s.ResourceRole != nil && len(*s.ResourceRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceRole", 1))
	}
	if s.S3StagingLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("S3StagingLocation"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SelectSqlQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectSqlQuery"))
	}
	if s.SelectSqlQuery != nil && len(*s.SelectSqlQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectSqlQuery", 1))
	}
	if s.ServiceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRole"))
	}
	if s.ServiceRole != nil && len(*s.ServiceRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceRole", 1))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}
	if s.DatabaseCredentials != nil {
		if err := s.DatabaseCredentials.Validate(); err != nil {
			invalidParams.AddNested("DatabaseCredentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DatabaseInformation != nil {
		if err := s.DatabaseInformation.Validate(); err != nil {
			invalidParams.AddNested("DatabaseInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataRearrangement sets the DataRearrangement field's value.
func (s *RDSDataSpec) SetDataRearrangement(v string) *RDSDataSpec {
	s.DataRearrangement = &v
	return s
}

// SetDataSchema sets the DataSchema field's value.
func (s *RDSDataSpec) SetDataSchema(v string) *RDSDataSpec {
	s.DataSchema = &v
	return s
}

// SetDataSchemaUri sets the DataSchemaUri field's value.
func (s *RDSDataSpec) SetDataSchemaUri(v string) *RDSDataSpec {
	s.DataSchemaUri = &v
	return s
}

// SetDatabaseCredentials sets the DatabaseCredentials field's value.
func (s *RDSDataSpec) SetDatabaseCredentials(v *RDSDatabaseCredentials) *RDSDataSpec {
	s.DatabaseCredentials = v
	return s
}

// SetDatabaseInformation sets the DatabaseInformation field's value.
func (s *RDSDataSpec) SetDatabaseInformation(v *RDSDatabase) *RDSDataSpec {
	s.DatabaseInformation = v
	return s
}

// SetResourceRole sets the ResourceRole field's value.
func (s *RDSDataSpec) SetResourceRole(v string) *RDSDataSpec {
	s.ResourceRole = &v
	return s
}

// SetS3StagingLocation sets the S3StagingLocation field's value.
func (s *RDSDataSpec) SetS3StagingLocation(v string) *RDSDataSpec {
	s.S3StagingLocation = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *RDSDataSpec) SetSecurityGroupIds(v []*string) *RDSDataSpec {
	s.SecurityGroupIds = v
	return s
}

// SetSelectSqlQuery sets the SelectSqlQuery field's value.
func (s *RDSDataSpec) SetSelectSqlQuery(v string) *RDSDataSpec {
	s.SelectSqlQuery = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *RDSDataSpec) SetServiceRole(v string) *RDSDataSpec {
	s.ServiceRole = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *RDSDataSpec) SetSubnetId(v string) *RDSDataSpec {
	s.SubnetId = &v
	return s
}

// The database details of an Amazon RDS database.
type RDSDatabase struct {
	_ struct{} `type:"structure"`

	// The name of a database hosted on an RDS DB instance.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The ID of an RDS DB instance.
	//
	// InstanceIdentifier is a required field
	InstanceIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RDSDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSDatabase) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RDSDatabase) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RDSDatabase"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.InstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIdentifier"))
	}
	if s.InstanceIdentifier != nil && len(*s.InstanceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RDSDatabase) SetDatabaseName(v string) *RDSDatabase {
	s.DatabaseName = &v
	return s
}

// SetInstanceIdentifier sets the InstanceIdentifier field's value.
func (s *RDSDatabase) SetInstanceIdentifier(v string) *RDSDatabase {
	s.InstanceIdentifier = &v
	return s
}

// The database credentials to connect to a database on an RDS DB instance.
type RDSDatabaseCredentials struct {
	_ struct{} `type:"structure"`

	// The password to be used by Amazon ML to connect to a database on an RDS DB
	// instance. The password should have sufficient permissions to execute the
	// RDSSelectQuery query.
	//
	// Password is a required field
	Password *string `min:"8" type:"string" required:"true"`

	// The username to be used by Amazon ML to connect to database on an Amazon
	// RDS instance. The username should have sufficient permissions to execute
	// an RDSSelectSqlQuery query.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RDSDatabaseCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSDatabaseCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RDSDatabaseCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RDSDatabaseCredentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *RDSDatabaseCredentials) SetPassword(v string) *RDSDatabaseCredentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *RDSDatabaseCredentials) SetUsername(v string) *RDSDatabaseCredentials {
	s.Username = &v
	return s
}

// The datasource details that are specific to Amazon RDS.
type RDSMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Pipeline instance that is used to carry to copy data from
	// Amazon RDS to Amazon S3. You can use the ID to find details about the instance
	// in the Data Pipeline console.
	DataPipelineId *string `min:"1" type:"string"`

	// The database details required to connect to an Amazon RDS.
	Database *RDSDatabase `type:"structure"`

	// The username to be used by Amazon ML to connect to database on an Amazon
	// RDS instance. The username should have sufficient permissions to execute
	// an RDSSelectSqlQuery query.
	DatabaseUserName *string `min:"1" type:"string"`

	// The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance
	// to carry out the copy task from Amazon RDS to Amazon S3. For more information,
	// see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	ResourceRole *string `min:"1" type:"string"`

	// The SQL query that is supplied during CreateDataSourceFromRDS. Returns only
	// if Verbose is true in GetDataSourceInput.
	SelectSqlQuery *string `min:"1" type:"string"`

	// The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to
	// monitor the progress of the copy task from Amazon RDS to Amazon S3. For more
	// information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	ServiceRole *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RDSMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSMetadata) GoString() string {
	return s.String()
}

// SetDataPipelineId sets the DataPipelineId field's value.
func (s *RDSMetadata) SetDataPipelineId(v string) *RDSMetadata {
	s.DataPipelineId = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *RDSMetadata) SetDatabase(v *RDSDatabase) *RDSMetadata {
	s.Database = v
	return s
}

// SetDatabaseUserName sets the DatabaseUserName field's value.
func (s *RDSMetadata) SetDatabaseUserName(v string) *RDSMetadata {
	s.DatabaseUserName = &v
	return s
}

// SetResourceRole sets the ResourceRole field's value.
func (s *RDSMetadata) SetResourceRole(v string) *RDSMetadata {
	s.ResourceRole = &v
	return s
}

// SetSelectSqlQuery sets the SelectSqlQuery field's value.
func (s *RDSMetadata) SetSelectSqlQuery(v string) *RDSMetadata {
	s.SelectSqlQuery = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *RDSMetadata) SetServiceRole(v string) *RDSMetadata {
	s.ServiceRole = &v
	return s
}

// Describes the real-time endpoint information for an MLModel.
type RealtimeEndpointInfo struct {
	_ struct{} `type:"structure"`

	// The time that the request to create the real-time endpoint for the MLModel
	// was received. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp"`

	// The current status of the real-time endpoint for the MLModel. This element
	// can have one of the following values:
	//
	//    * NONE - Endpoint does not exist or was previously deleted.
	//    * READY - Endpoint is ready to be used for real-time predictions.
	//    * UPDATING - Updating/creating the endpoint.
	EndpointStatus *string `type:"string" enum:"RealtimeEndpointStatus"`

	// The URI that specifies where to send real-time prediction requests for the
	// MLModel.
	//
	// NoteThe application must wait until the real-time endpoint is ready before
	// using this URI.
	EndpointUrl *string `type:"string"`

	// The maximum processing rate for the real-time endpoint for MLModel, measured
	// in incoming requests per second.
	PeakRequestsPerSecond *int64 `type:"integer"`
}

// String returns the string representation
func (s RealtimeEndpointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RealtimeEndpointInfo) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RealtimeEndpointInfo) SetCreatedAt(v time.Time) *RealtimeEndpointInfo {
	s.CreatedAt = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *RealtimeEndpointInfo) SetEndpointStatus(v string) *RealtimeEndpointInfo {
	s.EndpointStatus = &v
	return s
}

// SetEndpointUrl sets the EndpointUrl field's value.
func (s *RealtimeEndpointInfo) SetEndpointUrl(v string) *RealtimeEndpointInfo {
	s.EndpointUrl = &v
	return s
}

// SetPeakRequestsPerSecond sets the PeakRequestsPerSecond field's value.
func (s *RealtimeEndpointInfo) SetPeakRequestsPerSecond(v int64) *RealtimeEndpointInfo {
	s.PeakRequestsPerSecond = &v
	return s
}

// Describes the data specification of an Amazon Redshift DataSource.
type RedshiftDataSpec struct {
	_ struct{} `type:"structure"`

	// A JSON string that represents the splitting and rearrangement processing
	// to be applied to a DataSource. If the DataRearrangement parameter is not
	// provided, all of the input data is used to create the Datasource.
	//
	// There are multiple parameters that control what data is used to create a
	// datasource:
	//
	//    * percentBegin
	//
	// Use percentBegin to indicate the beginning of the range of the data used
	//    to create the Datasource. If you do not include percentBegin and percentEnd,
	//    Amazon ML includes all of the data when creating the datasource.
	//
	//    * percentEnd
	//
	// Use percentEnd to indicate the end of the range of the data used to create
	//    the Datasource. If you do not include percentBegin and percentEnd, Amazon
	//    ML includes all of the data when creating the datasource.
	//
	//    * complement
	//
	// The complement parameter instructs Amazon ML to use the data that is not
	//    included in the range of percentBegin to percentEnd to create a datasource.
	//    The complement parameter is useful if you need to create complementary
	//    datasources for training and evaluation. To create a complementary datasource,
	//    use the same values for percentBegin and percentEnd, along with the complement
	//    parameter.
	//
	// For example, the following two datasources do not share any data, and can
	//    be used to train and evaluate a model. The first datasource has 25 percent
	//    of the data, and the second one has 75 percent of the data.
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":0, "percentEnd":25}}
	//
	// Datasource for training: {"splitting":{"percentBegin":0, "percentEnd":25,
	//    "complement":"true"}}
	//
	//    * strategy
	//
	// To change how Amazon ML splits the data for a datasource, use the strategy
	//    parameter.
	//
	// The default value for the strategy parameter is sequential, meaning that
	//    Amazon ML takes all of the data records between the percentBegin and percentEnd
	//    parameters for the datasource, in the order that the records appear in
	//    the input data.
	//
	// The following two DataRearrangement lines are examples of sequentially ordered
	//    training and evaluation datasources:
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"sequential"}}
	//
	// Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"sequential", "complement":"true"}}
	//
	// To randomly split the input data into the proportions indicated by the percentBegin
	//    and percentEnd parameters, set the strategy parameter to random and provide
	//    a string that is used as the seed value for the random data splitting
	//    (for example, you can use the S3 path to your data as the random seed
	//    string). If you choose the random split strategy, Amazon ML assigns each
	//    row of data a pseudo-random number between 0 and 100, and then selects
	//    the rows that have an assigned number between percentBegin and percentEnd.
	//    Pseudo-random numbers are assigned using both the input seed string value
	//    and the byte offset as a seed, so changing the data results in a different
	//    split. Any existing ordering is preserved. The random splitting strategy
	//    ensures that variables in the training and evaluation data are distributed
	//    similarly. It is useful in the cases where the input data may have an
	//    implicit sort order, which would otherwise result in training and evaluation
	//    datasources containing non-similar data records.
	//
	// The following two DataRearrangement lines are examples of non-sequentially
	//    ordered training and evaluation datasources:
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}
	//
	// Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}
	DataRearrangement *string `type:"string"`

	// A JSON string that represents the schema for an Amazon Redshift DataSource.
	// The DataSchema defines the structure of the observation data in the data
	// file(s) referenced in the DataSource.
	//
	// A DataSchema is not required if you specify a DataSchemaUri.
	//
	// Define your DataSchema as a series of key-value pairs. attributes and excludedVariableNames
	// have an array of key-value pairs for their value. Use the following format
	// to define your DataSchema.
	//
	// { "version": "1.0",
	//
	// "recordAnnotationFieldName": "F1",
	//
	// "recordWeightFieldName": "F2",
	//
	// "targetFieldName": "F3",
	//
	// "dataFormat": "CSV",
	//
	// "dataFileContainsHeader": true,
	//
	// "attributes": [
	//
	// { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType":
	// "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName":
	// "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL"
	// }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType":
	// "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE"
	// } ],
	//
	// "excludedVariableNames": [ "F6" ] }
	DataSchema *string `type:"string"`

	// Describes the schema location for an Amazon Redshift DataSource.
	DataSchemaUri *string `type:"string"`

	// Describes AWS Identity and Access Management (IAM) credentials that are used
	// connect to the Amazon Redshift database.
	//
	// DatabaseCredentials is a required field
	DatabaseCredentials *RedshiftDatabaseCredentials `type:"structure" required:"true"`

	// Describes the DatabaseName and ClusterIdentifier for an Amazon Redshift DataSource.
	//
	// DatabaseInformation is a required field
	DatabaseInformation *RedshiftDatabase `type:"structure" required:"true"`

	// Describes an Amazon S3 location to store the result set of the SelectSqlQuery
	// query.
	//
	// S3StagingLocation is a required field
	S3StagingLocation *string `type:"string" required:"true"`

	// Describes the SQL Query to execute on an Amazon Redshift database for an
	// Amazon Redshift DataSource.
	//
	// SelectSqlQuery is a required field
	SelectSqlQuery *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDataSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDataSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDataSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDataSpec"}
	if s.DatabaseCredentials == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseCredentials"))
	}
	if s.DatabaseInformation == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseInformation"))
	}
	if s.S3StagingLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("S3StagingLocation"))
	}
	if s.SelectSqlQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectSqlQuery"))
	}
	if s.SelectSqlQuery != nil && len(*s.SelectSqlQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectSqlQuery", 1))
	}
	if s.DatabaseCredentials != nil {
		if err := s.DatabaseCredentials.Validate(); err != nil {
			invalidParams.AddNested("DatabaseCredentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DatabaseInformation != nil {
		if err := s.DatabaseInformation.Validate(); err != nil {
			invalidParams.AddNested("DatabaseInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataRearrangement sets the DataRearrangement field's value.
func (s *RedshiftDataSpec) SetDataRearrangement(v string) *RedshiftDataSpec {
	s.DataRearrangement = &v
	return s
}

// SetDataSchema sets the DataSchema field's value.
func (s *RedshiftDataSpec) SetDataSchema(v string) *RedshiftDataSpec {
	s.DataSchema = &v
	return s
}

// SetDataSchemaUri sets the DataSchemaUri field's value.
func (s *RedshiftDataSpec) SetDataSchemaUri(v string) *RedshiftDataSpec {
	s.DataSchemaUri = &v
	return s
}

// SetDatabaseCredentials sets the DatabaseCredentials field's value.
func (s *RedshiftDataSpec) SetDatabaseCredentials(v *RedshiftDatabaseCredentials) *RedshiftDataSpec {
	s.DatabaseCredentials = v
	return s
}

// SetDatabaseInformation sets the DatabaseInformation field's value.
func (s *RedshiftDataSpec) SetDatabaseInformation(v *RedshiftDatabase) *RedshiftDataSpec {
	s.DatabaseInformation = v
	return s
}

// SetS3StagingLocation sets the S3StagingLocation field's value.
func (s *RedshiftDataSpec) SetS3StagingLocation(v string) *RedshiftDataSpec {
	s.S3StagingLocation = &v
	return s
}

// SetSelectSqlQuery sets the SelectSqlQuery field's value.
func (s *RedshiftDataSpec) SetSelectSqlQuery(v string) *RedshiftDataSpec {
	s.SelectSqlQuery = &v
	return s
}

// Describes the database details required to connect to an Amazon Redshift
// database.
type RedshiftDatabase struct {
	_ struct{} `type:"structure"`

	// The ID of an Amazon Redshift cluster.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `min:"1" type:"string" required:"true"`

	// The name of a database hosted on an Amazon Redshift cluster.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDatabase) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDatabase) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDatabase"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.ClusterIdentifier != nil && len(*s.ClusterIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterIdentifier", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RedshiftDatabase) SetClusterIdentifier(v string) *RedshiftDatabase {
	s.ClusterIdentifier = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RedshiftDatabase) SetDatabaseName(v string) *RedshiftDatabase {
	s.DatabaseName = &v
	return s
}

// Describes the database credentials for connecting to a database on an Amazon
// Redshift cluster.
type RedshiftDatabaseCredentials struct {
	_ struct{} `type:"structure"`

	// A password to be used by Amazon ML to connect to a database on an Amazon
	// Redshift cluster. The password should have sufficient permissions to execute
	// a RedshiftSelectSqlQuery query. The password should be valid for an Amazon
	// Redshift USER (http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
	//
	// Password is a required field
	Password *string `min:"8" type:"string" required:"true"`

	// A username to be used by Amazon Machine Learning (Amazon ML)to connect to
	// a database on an Amazon Redshift cluster. The username should have sufficient
	// permissions to execute the RedshiftSelectSqlQuery query. The username should
	// be valid for an Amazon Redshift USER (http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RedshiftDatabaseCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDatabaseCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDatabaseCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDatabaseCredentials"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *RedshiftDatabaseCredentials) SetPassword(v string) *RedshiftDatabaseCredentials {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDatabaseCredentials) SetUsername(v string) *RedshiftDatabaseCredentials {
	s.Username = &v
	return s
}

// Describes the DataSource details specific to Amazon Redshift.
type RedshiftMetadata struct {
	_ struct{} `type:"structure"`

	// A username to be used by Amazon Machine Learning (Amazon ML)to connect to
	// a database on an Amazon Redshift cluster. The username should have sufficient
	// permissions to execute the RedshiftSelectSqlQuery query. The username should
	// be valid for an Amazon Redshift USER (http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
	DatabaseUserName *string `min:"1" type:"string"`

	// Describes the database details required to connect to an Amazon Redshift
	// database.
	RedshiftDatabase *RedshiftDatabase `type:"structure"`

	// The SQL query that is specified during CreateDataSourceFromRedshift. Returns
	// only if Verbose is true in GetDataSourceInput.
	SelectSqlQuery *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RedshiftMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftMetadata) GoString() string {
	return s.String()
}

// SetDatabaseUserName sets the DatabaseUserName field's value.
func (s *RedshiftMetadata) SetDatabaseUserName(v string) *RedshiftMetadata {
	s.DatabaseUserName = &v
	return s
}

// SetRedshiftDatabase sets the RedshiftDatabase field's value.
func (s *RedshiftMetadata) SetRedshiftDatabase(v *RedshiftDatabase) *RedshiftMetadata {
	s.RedshiftDatabase = v
	return s
}

// SetSelectSqlQuery sets the SelectSqlQuery field's value.
func (s *RedshiftMetadata) SetSelectSqlQuery(v string) *RedshiftMetadata {
	s.SelectSqlQuery = &v
	return s
}

// Describes the data specification of a DataSource.
type S3DataSpec struct {
	_ struct{} `type:"structure"`

	// The location of the data file(s) used by a DataSource. The URI specifies
	// a data file or an Amazon Simple Storage Service (Amazon S3) directory or
	// bucket containing data files.
	//
	// DataLocationS3 is a required field
	DataLocationS3 *string `type:"string" required:"true"`

	// A JSON string that represents the splitting and rearrangement processing
	// to be applied to a DataSource. If the DataRearrangement parameter is not
	// provided, all of the input data is used to create the Datasource.
	//
	// There are multiple parameters that control what data is used to create a
	// datasource:
	//
	//    * percentBegin
	//
	// Use percentBegin to indicate the beginning of the range of the data used
	//    to create the Datasource. If you do not include percentBegin and percentEnd,
	//    Amazon ML includes all of the data when creating the datasource.
	//
	//    * percentEnd
	//
	// Use percentEnd to indicate the end of the range of the data used to create
	//    the Datasource. If you do not include percentBegin and percentEnd, Amazon
	//    ML includes all of the data when creating the datasource.
	//
	//    * complement
	//
	// The complement parameter instructs Amazon ML to use the data that is not
	//    included in the range of percentBegin to percentEnd to create a datasource.
	//    The complement parameter is useful if you need to create complementary
	//    datasources for training and evaluation. To create a complementary datasource,
	//    use the same values for percentBegin and percentEnd, along with the complement
	//    parameter.
	//
	// For example, the following two datasources do not share any data, and can
	//    be used to train and evaluate a model. The first datasource has 25 percent
	//    of the data, and the second one has 75 percent of the data.
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":0, "percentEnd":25}}
	//
	// Datasource for training: {"splitting":{"percentBegin":0, "percentEnd":25,
	//    "complement":"true"}}
	//
	//    * strategy
	//
	// To change how Amazon ML splits the data for a datasource, use the strategy
	//    parameter.
	//
	// The default value for the strategy parameter is sequential, meaning that
	//    Amazon ML takes all of the data records between the percentBegin and percentEnd
	//    parameters for the datasource, in the order that the records appear in
	//    the input data.
	//
	// The following two DataRearrangement lines are examples of sequentially ordered
	//    training and evaluation datasources:
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"sequential"}}
	//
	// Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"sequential", "complement":"true"}}
	//
	// To randomly split the input data into the proportions indicated by the percentBegin
	//    and percentEnd parameters, set the strategy parameter to random and provide
	//    a string that is used as the seed value for the random data splitting
	//    (for example, you can use the S3 path to your data as the random seed
	//    string). If you choose the random split strategy, Amazon ML assigns each
	//    row of data a pseudo-random number between 0 and 100, and then selects
	//    the rows that have an assigned number between percentBegin and percentEnd.
	//    Pseudo-random numbers are assigned using both the input seed string value
	//    and the byte offset as a seed, so changing the data results in a different
	//    split. Any existing ordering is preserved. The random splitting strategy
	//    ensures that variables in the training and evaluation data are distributed
	//    similarly. It is useful in the cases where the input data may have an
	//    implicit sort order, which would otherwise result in training and evaluation
	//    datasources containing non-similar data records.
	//
	// The following two DataRearrangement lines are examples of non-sequentially
	//    ordered training and evaluation datasources:
	//
	// Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}
	//
	// Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100,
	//    "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}
	DataRearrangement *string `type:"string"`

	// A JSON string that represents the schema for an Amazon S3 DataSource. The
	// DataSchema defines the structure of the observation data in the data file(s)
	// referenced in the DataSource.
	//
	// You must provide either the DataSchema or the DataSchemaLocationS3.
	//
	// Define your DataSchema as a series of key-value pairs. attributes and excludedVariableNames
	// have an array of key-value pairs for their value. Use the following format
	// to define your DataSchema.
	//
	// { "version": "1.0",
	//
	// "recordAnnotationFieldName": "F1",
	//
	// "recordWeightFieldName": "F2",
	//
	// "targetFieldName": "F3",
	//
	// "dataFormat": "CSV",
	//
	// "dataFileContainsHeader": true,
	//
	// "attributes": [
	//
	// { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType":
	// "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName":
	// "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL"
	// }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType":
	// "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE"
	// } ],
	//
	// "excludedVariableNames": [ "F6" ] }
	DataSchema *string `type:"string"`

	// Describes the schema location in Amazon S3. You must provide either the DataSchema
	// or the DataSchemaLocationS3.
	DataSchemaLocationS3 *string `type:"string"`
}

// String returns the string representation
func (s S3DataSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DataSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataSpec"}
	if s.DataLocationS3 == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLocationS3"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataLocationS3 sets the DataLocationS3 field's value.
func (s *S3DataSpec) SetDataLocationS3(v string) *S3DataSpec {
	s.DataLocationS3 = &v
	return s
}

// SetDataRearrangement sets the DataRearrangement field's value.
func (s *S3DataSpec) SetDataRearrangement(v string) *S3DataSpec {
	s.DataRearrangement = &v
	return s
}

// SetDataSchema sets the DataSchema field's value.
func (s *S3DataSpec) SetDataSchema(v string) *S3DataSpec {
	s.DataSchema = &v
	return s
}

// SetDataSchemaLocationS3 sets the DataSchemaLocationS3 field's value.
func (s *S3DataSpec) SetDataSchemaLocationS3(v string) *S3DataSpec {
	s.DataSchemaLocationS3 = &v
	return s
}

// A custom key-value pair associated with an ML object, such as an ML model.
type Tag struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the tag. Valid characters include Unicode letters,
	// digits, white space, _, ., /, =, +, -, %, and @.
	Key *string `min:"1" type:"string"`

	// An optional string, typically used to describe or define the tag. Valid characters
	// include Unicode letters, digits, white space, _, ., /, =, +, -, %, and @.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type UpdateBatchPredictionInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the BatchPrediction during creation.
	//
	// BatchPredictionId is a required field
	BatchPredictionId *string `min:"1" type:"string" required:"true"`

	// A new user-supplied name or description of the BatchPrediction.
	//
	// BatchPredictionName is a required field
	BatchPredictionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBatchPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBatchPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBatchPredictionInput"}
	if s.BatchPredictionId == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchPredictionId"))
	}
	if s.BatchPredictionId != nil && len(*s.BatchPredictionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BatchPredictionId", 1))
	}
	if s.BatchPredictionName == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchPredictionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *UpdateBatchPredictionInput) SetBatchPredictionId(v string) *UpdateBatchPredictionInput {
	s.BatchPredictionId = &v
	return s
}

// SetBatchPredictionName sets the BatchPredictionName field's value.
func (s *UpdateBatchPredictionInput) SetBatchPredictionName(v string) *UpdateBatchPredictionInput {
	s.BatchPredictionName = &v
	return s
}

// Represents the output of an UpdateBatchPrediction operation.
//
// You can see the updated content by using the GetBatchPrediction operation.
type UpdateBatchPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the BatchPrediction during creation. This value should
	// be identical to the value of the BatchPredictionId in the request.
	BatchPredictionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBatchPredictionOutput) GoString() string {
	return s.String()
}

// SetBatchPredictionId sets the BatchPredictionId field's value.
func (s *UpdateBatchPredictionOutput) SetBatchPredictionId(v string) *UpdateBatchPredictionOutput {
	s.BatchPredictionId = &v
	return s
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the DataSource during creation.
	//
	// DataSourceId is a required field
	DataSourceId *string `min:"1" type:"string" required:"true"`

	// A new user-supplied name or description of the DataSource that will replace
	// the current description.
	//
	// DataSourceName is a required field
	DataSourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.DataSourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceInput) SetDataSourceId(v string) *UpdateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceName sets the DataSourceName field's value.
func (s *UpdateDataSourceInput) SetDataSourceName(v string) *UpdateDataSourceInput {
	s.DataSourceName = &v
	return s
}

// Represents the output of an UpdateDataSource operation.
//
// You can see the updated content by using the GetBatchPrediction operation.
type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the DataSource during creation. This value should be identical
	// to the value of the DataSourceID in the request.
	DataSourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceOutput) SetDataSourceId(v string) *UpdateDataSourceOutput {
	s.DataSourceId = &v
	return s
}

type UpdateEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the Evaluation during creation.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`

	// A new user-supplied name or description of the Evaluation that will replace
	// the current content.
	//
	// EvaluationName is a required field
	EvaluationName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEvaluationInput"}
	if s.EvaluationId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluationId", 1))
	}
	if s.EvaluationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *UpdateEvaluationInput) SetEvaluationId(v string) *UpdateEvaluationInput {
	s.EvaluationId = &v
	return s
}

// SetEvaluationName sets the EvaluationName field's value.
func (s *UpdateEvaluationInput) SetEvaluationName(v string) *UpdateEvaluationInput {
	s.EvaluationName = &v
	return s
}

// Represents the output of an UpdateEvaluation operation.
//
// You can see the updated content by using the GetEvaluation operation.
type UpdateEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the Evaluation during creation. This value should be identical
	// to the value of the Evaluation in the request.
	EvaluationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEvaluationOutput) GoString() string {
	return s.String()
}

// SetEvaluationId sets the EvaluationId field's value.
func (s *UpdateEvaluationOutput) SetEvaluationId(v string) *UpdateEvaluationOutput {
	s.EvaluationId = &v
	return s
}

type UpdateMLModelInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the MLModel during creation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`

	// A user-supplied name or description of the MLModel.
	MLModelName *string `type:"string"`

	// The ScoreThreshold used in binary classification MLModel that marks the boundary
	// between a positive prediction and a negative prediction.
	//
	// Output values greater than or equal to the ScoreThreshold receive a positive
	// result from the MLModel, such as true. Output values less than the ScoreThreshold
	// receive a negative response from the MLModel, such as false.
	ScoreThreshold *float64 `type:"float"`
}

// String returns the string representation
func (s UpdateMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMLModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMLModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMLModelInput"}
	if s.MLModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMLModelId sets the MLModelId field's value.
func (s *UpdateMLModelInput) SetMLModelId(v string) *UpdateMLModelInput {
	s.MLModelId = &v
	return s
}

// SetMLModelName sets the MLModelName field's value.
func (s *UpdateMLModelInput) SetMLModelName(v string) *UpdateMLModelInput {
	s.MLModelName = &v
	return s
}

// SetScoreThreshold sets the ScoreThreshold field's value.
func (s *UpdateMLModelInput) SetScoreThreshold(v float64) *UpdateMLModelInput {
	s.ScoreThreshold = &v
	return s
}

// Represents the output of an UpdateMLModel operation.
//
// You can see the updated content by using the GetMLModel operation.
type UpdateMLModelOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the MLModel during creation. This value should be identical
	// to the value of the MLModelID in the request.
	MLModelId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMLModelOutput) GoString() string {
	return s.String()
}

// SetMLModelId sets the MLModelId field's value.
func (s *UpdateMLModelOutput) SetMLModelId(v string) *UpdateMLModelOutput {
	s.MLModelId = &v
	return s
}

// The function used to train an MLModel. Training choices supported by Amazon
// ML include the following:
//
//    * SGD - Stochastic Gradient Descent.
//    * RandomForest - Random forest of decision trees.
const (
	// AlgorithmSgd is a Algorithm enum value
	AlgorithmSgd = "sgd"
)

// A list of the variables to use in searching or filtering BatchPrediction.
//
//    * CreatedAt - Sets the search criteria to BatchPrediction creation date.
//
//    * Status - Sets the search criteria to BatchPrediction status.
//    * Name - Sets the search criteria to the contents of BatchPredictionName.
//
//    * IAMUser - Sets the search criteria to the user account that invoked
//    the BatchPrediction creation.
//    * MLModelId - Sets the search criteria to the MLModel used in the BatchPrediction.
//
//    * DataSourceId - Sets the search criteria to the DataSource used in the
//    BatchPrediction.
//    * DataURI - Sets the search criteria to the data file(s) used in the BatchPrediction.
//    The URL can identify either a file or an Amazon Simple Storage Service
//    (Amazon S3) bucket or directory.
const (
	// BatchPredictionFilterVariableCreatedAt is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableCreatedAt = "CreatedAt"

	// BatchPredictionFilterVariableLastUpdatedAt is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableLastUpdatedAt = "LastUpdatedAt"

	// BatchPredictionFilterVariableStatus is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableStatus = "Status"

	// BatchPredictionFilterVariableName is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableName = "Name"

	// BatchPredictionFilterVariableIamuser is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableIamuser = "IAMUser"

	// BatchPredictionFilterVariableMlmodelId is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableMlmodelId = "MLModelId"

	// BatchPredictionFilterVariableDataSourceId is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableDataSourceId = "DataSourceId"

	// BatchPredictionFilterVariableDataUri is a BatchPredictionFilterVariable enum value
	BatchPredictionFilterVariableDataUri = "DataURI"
)

// A list of the variables to use in searching or filtering DataSource.
//
//    * CreatedAt - Sets the search criteria to DataSource creation date.
//    * Status - Sets the search criteria to DataSource status.
//    * Name - Sets the search criteria to the contents of DataSourceName.
//    * DataUri - Sets the search criteria to the URI of data files used to
//    create the DataSource. The URI can identify either a file or an Amazon
//    Simple Storage Service (Amazon S3) bucket or directory.
//    * IAMUser - Sets the search criteria to the user account that invoked
//    the DataSource creation.
// NoteThe variable names should match the variable names in the DataSource.
const (
	// DataSourceFilterVariableCreatedAt is a DataSourceFilterVariable enum value
	DataSourceFilterVariableCreatedAt = "CreatedAt"

	// DataSourceFilterVariableLastUpdatedAt is a DataSourceFilterVariable enum value
	DataSourceFilterVariableLastUpdatedAt = "LastUpdatedAt"

	// DataSourceFilterVariableStatus is a DataSourceFilterVariable enum value
	DataSourceFilterVariableStatus = "Status"

	// DataSourceFilterVariableName is a DataSourceFilterVariable enum value
	DataSourceFilterVariableName = "Name"

	// DataSourceFilterVariableDataLocationS3 is a DataSourceFilterVariable enum value
	DataSourceFilterVariableDataLocationS3 = "DataLocationS3"

	// DataSourceFilterVariableIamuser is a DataSourceFilterVariable enum value
	DataSourceFilterVariableIamuser = "IAMUser"
)

// Contains the key values of DetailsMap: PredictiveModelType- Indicates the type of the MLModel. Algorithm- Indicates the algorithm that was used for the MLModel
const (
	// DetailsAttributesPredictiveModelType is a DetailsAttributes enum value
	DetailsAttributesPredictiveModelType = "PredictiveModelType"

	// DetailsAttributesAlgorithm is a DetailsAttributes enum value
	DetailsAttributesAlgorithm = "Algorithm"
)

// Object status with the following possible values:
//
//    * PENDING
//    * INPROGRESS
//    * FAILED
//    * COMPLETED
//    * DELETED
const (
	// EntityStatusPending is a EntityStatus enum value
	EntityStatusPending = "PENDING"

	// EntityStatusInprogress is a EntityStatus enum value
	EntityStatusInprogress = "INPROGRESS"

	// EntityStatusFailed is a EntityStatus enum value
	EntityStatusFailed = "FAILED"

	// EntityStatusCompleted is a EntityStatus enum value
	EntityStatusCompleted = "COMPLETED"

	// EntityStatusDeleted is a EntityStatus enum value
	EntityStatusDeleted = "DELETED"
)

// A list of the variables to use in searching or filtering Evaluation.
//
//    * CreatedAt - Sets the search criteria to Evaluation creation date.
//    * Status - Sets the search criteria to Evaluation status.
//    * Name - Sets the search criteria to the contents of EvaluationName.
//    * IAMUser - Sets the search criteria to the user account that invoked
//    an evaluation.
//    * MLModelId - Sets the search criteria to the Predictor that was evaluated.
//
//    * DataSourceId - Sets the search criteria to the DataSource used in evaluation.
//
//    * DataUri - Sets the search criteria to the data file(s) used in evaluation.
//    The URL can identify either a file or an Amazon Simple Storage Service
//    (Amazon S3) bucket or directory.
const (
	// EvaluationFilterVariableCreatedAt is a EvaluationFilterVariable enum value
	EvaluationFilterVariableCreatedAt = "CreatedAt"

	// EvaluationFilterVariableLastUpdatedAt is a EvaluationFilterVariable enum value
	EvaluationFilterVariableLastUpdatedAt = "LastUpdatedAt"

	// EvaluationFilterVariableStatus is a EvaluationFilterVariable enum value
	EvaluationFilterVariableStatus = "Status"

	// EvaluationFilterVariableName is a EvaluationFilterVariable enum value
	EvaluationFilterVariableName = "Name"

	// EvaluationFilterVariableIamuser is a EvaluationFilterVariable enum value
	EvaluationFilterVariableIamuser = "IAMUser"

	// EvaluationFilterVariableMlmodelId is a EvaluationFilterVariable enum value
	EvaluationFilterVariableMlmodelId = "MLModelId"

	// EvaluationFilterVariableDataSourceId is a EvaluationFilterVariable enum value
	EvaluationFilterVariableDataSourceId = "DataSourceId"

	// EvaluationFilterVariableDataUri is a EvaluationFilterVariable enum value
	EvaluationFilterVariableDataUri = "DataURI"
)

const (
	// MLModelFilterVariableCreatedAt is a MLModelFilterVariable enum value
	MLModelFilterVariableCreatedAt = "CreatedAt"

	// MLModelFilterVariableLastUpdatedAt is a MLModelFilterVariable enum value
	MLModelFilterVariableLastUpdatedAt = "LastUpdatedAt"

	// MLModelFilterVariableStatus is a MLModelFilterVariable enum value
	MLModelFilterVariableStatus = "Status"

	// MLModelFilterVariableName is a MLModelFilterVariable enum value
	MLModelFilterVariableName = "Name"

	// MLModelFilterVariableIamuser is a MLModelFilterVariable enum value
	MLModelFilterVariableIamuser = "IAMUser"

	// MLModelFilterVariableTrainingDataSourceId is a MLModelFilterVariable enum value
	MLModelFilterVariableTrainingDataSourceId = "TrainingDataSourceId"

	// MLModelFilterVariableRealtimeEndpointStatus is a MLModelFilterVariable enum value
	MLModelFilterVariableRealtimeEndpointStatus = "RealtimeEndpointStatus"

	// MLModelFilterVariableMlmodelType is a MLModelFilterVariable enum value
	MLModelFilterVariableMlmodelType = "MLModelType"

	// MLModelFilterVariableAlgorithm is a MLModelFilterVariable enum value
	MLModelFilterVariableAlgorithm = "Algorithm"

	// MLModelFilterVariableTrainingDataUri is a MLModelFilterVariable enum value
	MLModelFilterVariableTrainingDataUri = "TrainingDataURI"
)

const (
	// MLModelTypeRegression is a MLModelType enum value
	MLModelTypeRegression = "REGRESSION"

	// MLModelTypeBinary is a MLModelType enum value
	MLModelTypeBinary = "BINARY"

	// MLModelTypeMulticlass is a MLModelType enum value
	MLModelTypeMulticlass = "MULTICLASS"
)

const (
	// RealtimeEndpointStatusNone is a RealtimeEndpointStatus enum value
	RealtimeEndpointStatusNone = "NONE"

	// RealtimeEndpointStatusReady is a RealtimeEndpointStatus enum value
	RealtimeEndpointStatusReady = "READY"

	// RealtimeEndpointStatusUpdating is a RealtimeEndpointStatus enum value
	RealtimeEndpointStatusUpdating = "UPDATING"

	// RealtimeEndpointStatusFailed is a RealtimeEndpointStatus enum value
	RealtimeEndpointStatusFailed = "FAILED"
)

// The sort order specified in a listing condition. Possible values include
// the following:
//
//    * asc - Present the information in ascending order (from A-Z).
//    * dsc - Present the information in descending order (from Z-A).
const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "asc"

	// SortOrderDsc is a SortOrder enum value
	SortOrderDsc = "dsc"
)

const (
	// TaggableResourceTypeBatchPrediction is a TaggableResourceType enum value
	TaggableResourceTypeBatchPrediction = "BatchPrediction"

	// TaggableResourceTypeDataSource is a TaggableResourceType enum value
	TaggableResourceTypeDataSource = "DataSource"

	// TaggableResourceTypeEvaluation is a TaggableResourceType enum value
	TaggableResourceTypeEvaluation = "Evaluation"

	// TaggableResourceTypeMlmodel is a TaggableResourceType enum value
	TaggableResourceTypeMlmodel = "MLModel"
)
