package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ContrastSmartVerify invokes the cloudauth.ContrastSmartVerify API synchronously
func (client *Client) ContrastSmartVerify(request *ContrastSmartVerifyRequest) (response *ContrastSmartVerifyResponse, err error) {
	response = CreateContrastSmartVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// ContrastSmartVerifyWithChan invokes the cloudauth.ContrastSmartVerify API asynchronously
func (client *Client) ContrastSmartVerifyWithChan(request *ContrastSmartVerifyRequest) (<-chan *ContrastSmartVerifyResponse, <-chan error) {
	responseChan := make(chan *ContrastSmartVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ContrastSmartVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ContrastSmartVerifyWithCallback invokes the cloudauth.ContrastSmartVerify API asynchronously
func (client *Client) ContrastSmartVerifyWithCallback(request *ContrastSmartVerifyRequest, callback func(response *ContrastSmartVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ContrastSmartVerifyResponse
		var err error
		defer close(result)
		response, err = client.ContrastSmartVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ContrastSmartVerifyRequest is the request struct for api ContrastSmartVerify
type ContrastSmartVerifyRequest struct {
	*requests.RpcRequest
	FacePicFile   string           `position:"Body" name:"FacePicFile"`
	Ip            string           `position:"Body" name:"Ip"`
	CertName      string           `position:"Body" name:"CertName"`
	FacePicString string           `position:"Body" name:"FacePicString"`
	Mobile        string           `position:"Body" name:"Mobile"`
	UserId        string           `position:"Body" name:"UserId"`
	Mode          string           `position:"Body" name:"Mode"`
	CertNo        string           `position:"Body" name:"CertNo"`
	OuterOrderNo  string           `position:"Body" name:"OuterOrderNo"`
	FacePicUrl    string           `position:"Body" name:"FacePicUrl"`
	CertType      string           `position:"Body" name:"CertType"`
	SceneId       requests.Integer `position:"Body" name:"SceneId"`
}

// ContrastSmartVerifyResponse is the response struct for api ContrastSmartVerify
type ContrastSmartVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Message      string       `json:"Message" xml:"Message"`
	Code         string       `json:"Code" xml:"Code"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateContrastSmartVerifyRequest creates a request to invoke ContrastSmartVerify API
func CreateContrastSmartVerifyRequest() (request *ContrastSmartVerifyRequest) {
	request = &ContrastSmartVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2020-06-18", "ContrastSmartVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateContrastSmartVerifyResponse creates a response to parse from ContrastSmartVerify response
func CreateContrastSmartVerifyResponse() (response *ContrastSmartVerifyResponse) {
	response = &ContrastSmartVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
