package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ElementSmartVerify invokes the cloudauth.ElementSmartVerify API synchronously
func (client *Client) ElementSmartVerify(request *ElementSmartVerifyRequest) (response *ElementSmartVerifyResponse, err error) {
	response = CreateElementSmartVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// ElementSmartVerifyWithChan invokes the cloudauth.ElementSmartVerify API asynchronously
func (client *Client) ElementSmartVerifyWithChan(request *ElementSmartVerifyRequest) (<-chan *ElementSmartVerifyResponse, <-chan error) {
	responseChan := make(chan *ElementSmartVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ElementSmartVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ElementSmartVerifyWithCallback invokes the cloudauth.ElementSmartVerify API asynchronously
func (client *Client) ElementSmartVerifyWithCallback(request *ElementSmartVerifyRequest, callback func(response *ElementSmartVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ElementSmartVerifyResponse
		var err error
		defer close(result)
		response, err = client.ElementSmartVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ElementSmartVerifyRequest is the request struct for api ElementSmartVerify
type ElementSmartVerifyRequest struct {
	*requests.RpcRequest
	CertFile              string           `position:"Body" name:"CertFile"`
	CertNationalEmblemUrl string           `position:"Body" name:"CertNationalEmblemUrl"`
	CertName              string           `position:"Body" name:"CertName"`
	Mode                  string           `position:"Body" name:"Mode"`
	CertNo                string           `position:"Body" name:"CertNo"`
	OuterOrderNo          string           `position:"Body" name:"OuterOrderNo"`
	CertUrl               string           `position:"Body" name:"CertUrl"`
	CertType              string           `position:"Body" name:"CertType"`
	SceneId               requests.Integer `position:"Body" name:"SceneId"`
}

// ElementSmartVerifyResponse is the response struct for api ElementSmartVerify
type ElementSmartVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Message      string       `json:"Message" xml:"Message"`
	Code         string       `json:"Code" xml:"Code"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateElementSmartVerifyRequest creates a request to invoke ElementSmartVerify API
func CreateElementSmartVerifyRequest() (request *ElementSmartVerifyRequest) {
	request = &ElementSmartVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2020-06-18", "ElementSmartVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateElementSmartVerifyResponse creates a response to parse from ElementSmartVerify response
func CreateElementSmartVerifyResponse() (response *ElementSmartVerifyResponse) {
	response = &ElementSmartVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
