package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCompliance invokes the config.DescribeCompliance API synchronously
func (client *Client) DescribeCompliance(request *DescribeComplianceRequest) (response *DescribeComplianceResponse, err error) {
	response = CreateDescribeComplianceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComplianceWithChan invokes the config.DescribeCompliance API asynchronously
func (client *Client) DescribeComplianceWithChan(request *DescribeComplianceRequest) (<-chan *DescribeComplianceResponse, <-chan error) {
	responseChan := make(chan *DescribeComplianceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCompliance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComplianceWithCallback invokes the config.DescribeCompliance API asynchronously
func (client *Client) DescribeComplianceWithCallback(request *DescribeComplianceRequest, callback func(response *DescribeComplianceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComplianceResponse
		var err error
		defer close(result)
		response, err = client.DescribeCompliance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComplianceRequest is the request struct for api DescribeCompliance
type DescribeComplianceRequest struct {
	*requests.RpcRequest
	ConfigRuleId   string           `position:"Query" name:"ConfigRuleId"`
	ResourceId     string           `position:"Query" name:"ResourceId"`
	MultiAccount   requests.Boolean `position:"Query" name:"MultiAccount"`
	ResourceType   string           `position:"Query" name:"ResourceType"`
	ComplianceType string           `position:"Query" name:"ComplianceType"`
	MemberId       requests.Integer `position:"Query" name:"MemberId"`
}

// DescribeComplianceResponse is the response struct for api DescribeCompliance
type DescribeComplianceResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ComplianceResult ComplianceResult `json:"ComplianceResult" xml:"ComplianceResult"`
}

// CreateDescribeComplianceRequest creates a request to invoke DescribeCompliance API
func CreateDescribeComplianceRequest() (request *DescribeComplianceRequest) {
	request = &DescribeComplianceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "DescribeCompliance", "Config", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeComplianceResponse creates a response to parse from DescribeCompliance response
func CreateDescribeComplianceResponse() (response *DescribeComplianceResponse) {
	response = &DescribeComplianceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
