package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServerlessDBInstance invokes the dds.CreateServerlessDBInstance API synchronously
func (client *Client) CreateServerlessDBInstance(request *CreateServerlessDBInstanceRequest) (response *CreateServerlessDBInstanceResponse, err error) {
	response = CreateCreateServerlessDBInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServerlessDBInstanceWithChan invokes the dds.CreateServerlessDBInstance API asynchronously
func (client *Client) CreateServerlessDBInstanceWithChan(request *CreateServerlessDBInstanceRequest) (<-chan *CreateServerlessDBInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateServerlessDBInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServerlessDBInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServerlessDBInstanceWithCallback invokes the dds.CreateServerlessDBInstance API asynchronously
func (client *Client) CreateServerlessDBInstanceWithCallback(request *CreateServerlessDBInstanceRequest, callback func(response *CreateServerlessDBInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServerlessDBInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateServerlessDBInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServerlessDBInstanceRequest is the request struct for api CreateServerlessDBInstance
type CreateServerlessDBInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceStorage     requests.Integer `position:"Query" name:"DBInstanceStorage"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	PeriodPriceType       string           `position:"Query" name:"PeriodPriceType"`
	EngineVersion         string           `position:"Query" name:"EngineVersion"`
	NetworkType           string           `position:"Query" name:"NetworkType"`
	StorageEngine         string           `position:"Query" name:"StorageEngine"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken         string           `position:"Query" name:"SecurityToken"`
	Engine                string           `position:"Query" name:"Engine"`
	DBInstanceDescription string           `position:"Query" name:"DBInstanceDescription"`
	Period                requests.Integer `position:"Query" name:"Period"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	SecurityIPList        string           `position:"Query" name:"SecurityIPList"`
	VSwitchId             string           `position:"Query" name:"VSwitchId"`
	AccountPassword       string           `position:"Query" name:"AccountPassword"`
	AutoRenew             string           `position:"Query" name:"AutoRenew"`
	VpcId                 string           `position:"Query" name:"VpcId"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	ChargeType            string           `position:"Query" name:"ChargeType"`
}

// CreateServerlessDBInstanceResponse is the response struct for api CreateServerlessDBInstance
type CreateServerlessDBInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	OrderId      string `json:"OrderId" xml:"OrderId"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
}

// CreateCreateServerlessDBInstanceRequest creates a request to invoke CreateServerlessDBInstance API
func CreateCreateServerlessDBInstanceRequest() (request *CreateServerlessDBInstanceRequest) {
	request = &CreateServerlessDBInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "CreateServerlessDBInstance", "Dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateServerlessDBInstanceResponse creates a response to parse from CreateServerlessDBInstance response
func CreateCreateServerlessDBInstanceResponse() (response *CreateServerlessDBInstanceResponse) {
	response = &CreateServerlessDBInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
