package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConsumerChannel invokes the dts.CreateConsumerChannel API synchronously
func (client *Client) CreateConsumerChannel(request *CreateConsumerChannelRequest) (response *CreateConsumerChannelResponse, err error) {
	response = CreateCreateConsumerChannelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConsumerChannelWithChan invokes the dts.CreateConsumerChannel API asynchronously
func (client *Client) CreateConsumerChannelWithChan(request *CreateConsumerChannelRequest) (<-chan *CreateConsumerChannelResponse, <-chan error) {
	responseChan := make(chan *CreateConsumerChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConsumerChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConsumerChannelWithCallback invokes the dts.CreateConsumerChannel API asynchronously
func (client *Client) CreateConsumerChannelWithCallback(request *CreateConsumerChannelRequest, callback func(response *CreateConsumerChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConsumerChannelResponse
		var err error
		defer close(result)
		response, err = client.CreateConsumerChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConsumerChannelRequest is the request struct for api CreateConsumerChannel
type CreateConsumerChannelRequest struct {
	*requests.RpcRequest
	ConsumerGroupName     string `position:"Query" name:"ConsumerGroupName"`
	ConsumerGroupPassword string `position:"Query" name:"ConsumerGroupPassword"`
	ConsumerGroupUserName string `position:"Query" name:"ConsumerGroupUserName"`
	DtsJobId              string `position:"Query" name:"DtsJobId"`
	DtsInstanceId         string `position:"Query" name:"DtsInstanceId"`
}

// CreateConsumerChannelResponse is the response struct for api CreateConsumerChannel
type CreateConsumerChannelResponse struct {
	*responses.BaseResponse
	ErrCode         string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage      string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Success         string `json:"Success" xml:"Success"`
	ConsumerGroupID string `json:"ConsumerGroupID" xml:"ConsumerGroupID"`
	HttpStatusCode  string `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateConsumerChannelRequest creates a request to invoke CreateConsumerChannel API
func CreateCreateConsumerChannelRequest() (request *CreateConsumerChannelRequest) {
	request = &CreateConsumerChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "CreateConsumerChannel", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateConsumerChannelResponse creates a response to parse from CreateConsumerChannel response
func CreateCreateConsumerChannelResponse() (response *CreateConsumerChannelResponse) {
	response = &CreateConsumerChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
