package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindAxn invokes the dyplsapi.BindAxn API synchronously
func (client *Client) BindAxn(request *BindAxnRequest) (response *BindAxnResponse, err error) {
	response = CreateBindAxnResponse()
	err = client.DoAction(request, response)
	return
}

// BindAxnWithChan invokes the dyplsapi.BindAxn API asynchronously
func (client *Client) BindAxnWithChan(request *BindAxnRequest) (<-chan *BindAxnResponse, <-chan error) {
	responseChan := make(chan *BindAxnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindAxn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindAxnWithCallback invokes the dyplsapi.BindAxn API asynchronously
func (client *Client) BindAxnWithCallback(request *BindAxnRequest, callback func(response *BindAxnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindAxnResponse
		var err error
		defer close(result)
		response, err = client.BindAxn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindAxnRequest is the request struct for api BindAxn
type BindAxnRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CallDisplayType      requests.Integer `position:"Query" name:"CallDisplayType"`
	CallTimeout          requests.Integer `position:"Query" name:"CallTimeout"`
	PhoneNoX             string           `position:"Query" name:"PhoneNoX"`
	RingConfig           string           `position:"Query" name:"RingConfig"`
	ASRStatus            requests.Boolean `position:"Query" name:"ASRStatus"`
	PhoneNoB             string           `position:"Query" name:"PhoneNoB"`
	PhoneNoA             string           `position:"Query" name:"PhoneNoA"`
	ExpectCity           string           `position:"Query" name:"ExpectCity"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OutOrderId           string           `position:"Query" name:"OutOrderId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	Expiration           string           `position:"Query" name:"Expiration"`
	IsRecordingEnabled   requests.Boolean `position:"Query" name:"IsRecordingEnabled"`
	OutId                string           `position:"Query" name:"OutId"`
	NoType               string           `position:"Query" name:"NoType"`
	ASRModelId           string           `position:"Query" name:"ASRModelId"`
	CallRestrict         string           `position:"Query" name:"CallRestrict"`
}

// BindAxnResponse is the response struct for api BindAxn
type BindAxnResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Code          string        `json:"Code" xml:"Code"`
	Message       string        `json:"Message" xml:"Message"`
	SecretBindDTO SecretBindDTO `json:"SecretBindDTO" xml:"SecretBindDTO"`
}

// CreateBindAxnRequest creates a request to invoke BindAxn API
func CreateBindAxnRequest() (request *BindAxnRequest) {
	request = &BindAxnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "BindAxn", "", "")
	request.Method = requests.POST
	return
}

// CreateBindAxnResponse creates a response to parse from BindAxn response
func CreateBindAxnResponse() (response *BindAxnResponse) {
	response = &BindAxnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
