package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindAxnExtension invokes the dyplsapi.BindAxnExtension API synchronously
func (client *Client) BindAxnExtension(request *BindAxnExtensionRequest) (response *BindAxnExtensionResponse, err error) {
	response = CreateBindAxnExtensionResponse()
	err = client.DoAction(request, response)
	return
}

// BindAxnExtensionWithChan invokes the dyplsapi.BindAxnExtension API asynchronously
func (client *Client) BindAxnExtensionWithChan(request *BindAxnExtensionRequest) (<-chan *BindAxnExtensionResponse, <-chan error) {
	responseChan := make(chan *BindAxnExtensionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindAxnExtension(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindAxnExtensionWithCallback invokes the dyplsapi.BindAxnExtension API asynchronously
func (client *Client) BindAxnExtensionWithCallback(request *BindAxnExtensionRequest, callback func(response *BindAxnExtensionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindAxnExtensionResponse
		var err error
		defer close(result)
		response, err = client.BindAxnExtension(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindAxnExtensionRequest is the request struct for api BindAxnExtension
type BindAxnExtensionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Extension            string           `position:"Query" name:"Extension"`
	CallDisplayType      requests.Integer `position:"Query" name:"CallDisplayType"`
	PhoneNoX             string           `position:"Query" name:"PhoneNoX"`
	RingConfig           string           `position:"Query" name:"RingConfig"`
	ASRStatus            requests.Boolean `position:"Query" name:"ASRStatus"`
	PhoneNoB             string           `position:"Query" name:"PhoneNoB"`
	PhoneNoA             string           `position:"Query" name:"PhoneNoA"`
	ExpectCity           string           `position:"Query" name:"ExpectCity"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OutOrderId           string           `position:"Query" name:"OutOrderId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	Expiration           string           `position:"Query" name:"Expiration"`
	IsRecordingEnabled   requests.Boolean `position:"Query" name:"IsRecordingEnabled"`
	OutId                string           `position:"Query" name:"OutId"`
	ASRModelId           string           `position:"Query" name:"ASRModelId"`
	CallRestrict         string           `position:"Query" name:"CallRestrict"`
}

// BindAxnExtensionResponse is the response struct for api BindAxnExtension
type BindAxnExtensionResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Code          string        `json:"Code" xml:"Code"`
	Message       string        `json:"Message" xml:"Message"`
	SecretBindDTO SecretBindDTO `json:"SecretBindDTO" xml:"SecretBindDTO"`
}

// CreateBindAxnExtensionRequest creates a request to invoke BindAxnExtension API
func CreateBindAxnExtensionRequest() (request *BindAxnExtensionRequest) {
	request = &BindAxnExtensionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "BindAxnExtension", "", "")
	request.Method = requests.POST
	return
}

// CreateBindAxnExtensionResponse creates a response to parse from BindAxnExtension response
func CreateBindAxnExtensionResponse() (response *BindAxnExtensionResponse) {
	response = &BindAxnExtensionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
