package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSubscription invokes the dyplsapi.CreateSubscription API synchronously
func (client *Client) CreateSubscription(request *CreateSubscriptionRequest) (response *CreateSubscriptionResponse, err error) {
	response = CreateCreateSubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSubscriptionWithChan invokes the dyplsapi.CreateSubscription API asynchronously
func (client *Client) CreateSubscriptionWithChan(request *CreateSubscriptionRequest) (<-chan *CreateSubscriptionResponse, <-chan error) {
	responseChan := make(chan *CreateSubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSubscriptionWithCallback invokes the dyplsapi.CreateSubscription API asynchronously
func (client *Client) CreateSubscriptionWithCallback(request *CreateSubscriptionRequest, callback func(response *CreateSubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSubscriptionResponse
		var err error
		defer close(result)
		response, err = client.CreateSubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSubscriptionRequest is the request struct for api CreateSubscription
type CreateSubscriptionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	BindToken            string           `position:"Query" name:"BindToken"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PhoneNo              string           `position:"Query" name:"PhoneNo"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// CreateSubscriptionResponse is the response struct for api CreateSubscription
type CreateSubscriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateSubscriptionRequest creates a request to invoke CreateSubscription API
func CreateCreateSubscriptionRequest() (request *CreateSubscriptionRequest) {
	request = &CreateSubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "CreateSubscription", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSubscriptionResponse creates a response to parse from CreateSubscription response
func CreateCreateSubscriptionResponse() (response *CreateSubscriptionResponse) {
	response = &CreateSubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
