package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSubscriptionDetail invokes the dyplsapi.GetSubscriptionDetail API synchronously
func (client *Client) GetSubscriptionDetail(request *GetSubscriptionDetailRequest) (response *GetSubscriptionDetailResponse, err error) {
	response = CreateGetSubscriptionDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetSubscriptionDetailWithChan invokes the dyplsapi.GetSubscriptionDetail API asynchronously
func (client *Client) GetSubscriptionDetailWithChan(request *GetSubscriptionDetailRequest) (<-chan *GetSubscriptionDetailResponse, <-chan error) {
	responseChan := make(chan *GetSubscriptionDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSubscriptionDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSubscriptionDetailWithCallback invokes the dyplsapi.GetSubscriptionDetail API asynchronously
func (client *Client) GetSubscriptionDetailWithCallback(request *GetSubscriptionDetailRequest, callback func(response *GetSubscriptionDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSubscriptionDetailResponse
		var err error
		defer close(result)
		response, err = client.GetSubscriptionDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSubscriptionDetailRequest is the request struct for api GetSubscriptionDetail
type GetSubscriptionDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SubsId               requests.Integer `position:"Query" name:"SubsId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// GetSubscriptionDetailResponse is the response struct for api GetSubscriptionDetail
type GetSubscriptionDetailResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Code      string                      `json:"Code" xml:"Code"`
	Message   string                      `json:"Message" xml:"Message"`
	Data      DataInGetSubscriptionDetail `json:"Data" xml:"Data"`
}

// CreateGetSubscriptionDetailRequest creates a request to invoke GetSubscriptionDetail API
func CreateGetSubscriptionDetailRequest() (request *GetSubscriptionDetailRequest) {
	request = &GetSubscriptionDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "GetSubscriptionDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSubscriptionDetailResponse creates a response to parse from GetSubscriptionDetail response
func CreateGetSubscriptionDetailResponse() (response *GetSubscriptionDetailResponse) {
	response = &GetSubscriptionDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
