package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseSecretNo invokes the dyplsapi.ReleaseSecretNo API synchronously
func (client *Client) ReleaseSecretNo(request *ReleaseSecretNoRequest) (response *ReleaseSecretNoResponse, err error) {
	response = CreateReleaseSecretNoResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseSecretNoWithChan invokes the dyplsapi.ReleaseSecretNo API asynchronously
func (client *Client) ReleaseSecretNoWithChan(request *ReleaseSecretNoRequest) (<-chan *ReleaseSecretNoResponse, <-chan error) {
	responseChan := make(chan *ReleaseSecretNoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseSecretNo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseSecretNoWithCallback invokes the dyplsapi.ReleaseSecretNo API asynchronously
func (client *Client) ReleaseSecretNoWithCallback(request *ReleaseSecretNoRequest, callback func(response *ReleaseSecretNoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseSecretNoResponse
		var err error
		defer close(result)
		response, err = client.ReleaseSecretNo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseSecretNoRequest is the request struct for api ReleaseSecretNo
type ReleaseSecretNoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
}

// ReleaseSecretNoResponse is the response struct for api ReleaseSecretNo
type ReleaseSecretNoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateReleaseSecretNoRequest creates a request to invoke ReleaseSecretNo API
func CreateReleaseSecretNoRequest() (request *ReleaseSecretNoRequest) {
	request = &ReleaseSecretNoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "ReleaseSecretNo", "", "")
	request.Method = requests.POST
	return
}

// CreateReleaseSecretNoResponse creates a response to parse from ReleaseSecretNo response
func CreateReleaseSecretNoResponse() (response *ReleaseSecretNoResponse) {
	response = &ReleaseSecretNoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
