package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePhoneSwitch invokes the dyplsapi.UpdatePhoneSwitch API synchronously
func (client *Client) UpdatePhoneSwitch(request *UpdatePhoneSwitchRequest) (response *UpdatePhoneSwitchResponse, err error) {
	response = CreateUpdatePhoneSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePhoneSwitchWithChan invokes the dyplsapi.UpdatePhoneSwitch API asynchronously
func (client *Client) UpdatePhoneSwitchWithChan(request *UpdatePhoneSwitchRequest) (<-chan *UpdatePhoneSwitchResponse, <-chan error) {
	responseChan := make(chan *UpdatePhoneSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePhoneSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePhoneSwitchWithCallback invokes the dyplsapi.UpdatePhoneSwitch API asynchronously
func (client *Client) UpdatePhoneSwitchWithCallback(request *UpdatePhoneSwitchRequest, callback func(response *UpdatePhoneSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePhoneSwitchResponse
		var err error
		defer close(result)
		response, err = client.UpdatePhoneSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePhoneSwitchRequest is the request struct for api UpdatePhoneSwitch
type UpdatePhoneSwitchRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SwitchStatus         requests.Integer `position:"Query" name:"SwitchStatus"`
	SubsId               requests.Integer `position:"Query" name:"SubsId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// UpdatePhoneSwitchResponse is the response struct for api UpdatePhoneSwitch
type UpdatePhoneSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUpdatePhoneSwitchRequest creates a request to invoke UpdatePhoneSwitch API
func CreateUpdatePhoneSwitchRequest() (request *UpdatePhoneSwitchRequest) {
	request = &UpdatePhoneSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "UpdatePhoneSwitch", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdatePhoneSwitchResponse creates a response to parse from UpdatePhoneSwitch response
func CreateUpdatePhoneSwitchResponse() (response *UpdatePhoneSwitchResponse) {
	response = &UpdatePhoneSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
