package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDedicatedBlockStorageCluster invokes the ecs.CreateDedicatedBlockStorageCluster API synchronously
func (client *Client) CreateDedicatedBlockStorageCluster(request *CreateDedicatedBlockStorageClusterRequest) (response *CreateDedicatedBlockStorageClusterResponse, err error) {
	response = CreateCreateDedicatedBlockStorageClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDedicatedBlockStorageClusterWithChan invokes the ecs.CreateDedicatedBlockStorageCluster API asynchronously
func (client *Client) CreateDedicatedBlockStorageClusterWithChan(request *CreateDedicatedBlockStorageClusterRequest) (<-chan *CreateDedicatedBlockStorageClusterResponse, <-chan error) {
	responseChan := make(chan *CreateDedicatedBlockStorageClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDedicatedBlockStorageCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDedicatedBlockStorageClusterWithCallback invokes the ecs.CreateDedicatedBlockStorageCluster API asynchronously
func (client *Client) CreateDedicatedBlockStorageClusterWithCallback(request *CreateDedicatedBlockStorageClusterRequest, callback func(response *CreateDedicatedBlockStorageClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDedicatedBlockStorageClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateDedicatedBlockStorageCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDedicatedBlockStorageClusterRequest is the request struct for api CreateDedicatedBlockStorageCluster
type CreateDedicatedBlockStorageClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DedicatedBlockStorageClusterName string           `position:"Query" name:"DedicatedBlockStorageClusterName"`
	ClientToken                      string           `position:"Query" name:"ClientToken"`
	Description                      string           `position:"Query" name:"Description"`
	Capacity                         requests.Integer `position:"Query" name:"Capacity"`
	Period                           requests.Integer `position:"Query" name:"Period"`
	FromApp                          string           `position:"Query" name:"FromApp"`
	ResourceOwnerAccount             string           `position:"Query" name:"ResourceOwnerAccount"`
	PerformanceLevel                 string           `position:"Query" name:"PerformanceLevel"`
	OwnerAccount                     string           `position:"Query" name:"OwnerAccount"`
	OwnerId                          requests.Integer `position:"Query" name:"OwnerId"`
	PeriodUnit                       string           `position:"Query" name:"PeriodUnit"`
	ZoneId                           string           `position:"Query" name:"ZoneId"`
	Category                         string           `position:"Query" name:"Category"`
}

// CreateDedicatedBlockStorageClusterResponse is the response struct for api CreateDedicatedBlockStorageCluster
type CreateDedicatedBlockStorageClusterResponse struct {
	*responses.BaseResponse
	DedicatedBlockStorageClusterOrderId string `json:"DedicatedBlockStorageClusterOrderId" xml:"DedicatedBlockStorageClusterOrderId"`
	RequestId                           string `json:"RequestId" xml:"RequestId"`
	DedicatedBlockStorageClusterId      string `json:"DedicatedBlockStorageClusterId" xml:"DedicatedBlockStorageClusterId"`
}

// CreateCreateDedicatedBlockStorageClusterRequest creates a request to invoke CreateDedicatedBlockStorageCluster API
func CreateCreateDedicatedBlockStorageClusterRequest() (request *CreateDedicatedBlockStorageClusterRequest) {
	request = &CreateDedicatedBlockStorageClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateDedicatedBlockStorageCluster", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDedicatedBlockStorageClusterResponse creates a response to parse from CreateDedicatedBlockStorageCluster response
func CreateCreateDedicatedBlockStorageClusterResponse() (response *CreateDedicatedBlockStorageClusterResponse) {
	response = &CreateDedicatedBlockStorageClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
