package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartImagePipelineExecution invokes the ecs.StartImagePipelineExecution API synchronously
func (client *Client) StartImagePipelineExecution(request *StartImagePipelineExecutionRequest) (response *StartImagePipelineExecutionResponse, err error) {
	response = CreateStartImagePipelineExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// StartImagePipelineExecutionWithChan invokes the ecs.StartImagePipelineExecution API asynchronously
func (client *Client) StartImagePipelineExecutionWithChan(request *StartImagePipelineExecutionRequest) (<-chan *StartImagePipelineExecutionResponse, <-chan error) {
	responseChan := make(chan *StartImagePipelineExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartImagePipelineExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartImagePipelineExecutionWithCallback invokes the ecs.StartImagePipelineExecution API asynchronously
func (client *Client) StartImagePipelineExecutionWithCallback(request *StartImagePipelineExecutionRequest, callback func(response *StartImagePipelineExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartImagePipelineExecutionResponse
		var err error
		defer close(result)
		response, err = client.StartImagePipelineExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartImagePipelineExecutionRequest is the request struct for api StartImagePipelineExecution
type StartImagePipelineExecutionRequest struct {
	*requests.RpcRequest
	ImagePipelineId      string                                    `position:"Query" name:"ImagePipelineId"`
	ResourceOwnerId      requests.Integer                          `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string                                    `position:"Query" name:"ClientToken"`
	TemplateTag          *[]StartImagePipelineExecutionTemplateTag `position:"Query" name:"TemplateTag"  type:"Repeated"`
	ResourceOwnerAccount string                                    `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                    `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                          `position:"Query" name:"OwnerId"`
}

// StartImagePipelineExecutionTemplateTag is a repeated param struct in StartImagePipelineExecutionRequest
type StartImagePipelineExecutionTemplateTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// StartImagePipelineExecutionResponse is the response struct for api StartImagePipelineExecution
type StartImagePipelineExecutionResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ExecutionId string `json:"ExecutionId" xml:"ExecutionId"`
}

// CreateStartImagePipelineExecutionRequest creates a request to invoke StartImagePipelineExecution API
func CreateStartImagePipelineExecutionRequest() (request *StartImagePipelineExecutionRequest) {
	request = &StartImagePipelineExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "StartImagePipelineExecution", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartImagePipelineExecutionResponse creates a response to parse from StartImagePipelineExecution response
func CreateStartImagePipelineExecutionResponse() (response *StartImagePipelineExecutionResponse) {
	response = &StartImagePipelineExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
