package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddServiceTimeConfig invokes the edas.AddServiceTimeConfig API synchronously
func (client *Client) AddServiceTimeConfig(request *AddServiceTimeConfigRequest) (response *AddServiceTimeConfigResponse, err error) {
	response = CreateAddServiceTimeConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddServiceTimeConfigWithChan invokes the edas.AddServiceTimeConfig API asynchronously
func (client *Client) AddServiceTimeConfigWithChan(request *AddServiceTimeConfigRequest) (<-chan *AddServiceTimeConfigResponse, <-chan error) {
	responseChan := make(chan *AddServiceTimeConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddServiceTimeConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddServiceTimeConfigWithCallback invokes the edas.AddServiceTimeConfig API asynchronously
func (client *Client) AddServiceTimeConfigWithCallback(request *AddServiceTimeConfigRequest, callback func(response *AddServiceTimeConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddServiceTimeConfigResponse
		var err error
		defer close(result)
		response, err = client.AddServiceTimeConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddServiceTimeConfigRequest is the request struct for api AddServiceTimeConfig
type AddServiceTimeConfigRequest struct {
	*requests.RoaRequest
	Path            string `position:"Query" name:"Path"`
	ServiceType     string `position:"Query" name:"ServiceType"`
	ConsumerAppId   string `position:"Query" name:"ConsumerAppId"`
	AppId           string `position:"Query" name:"AppId"`
	ServiceVersion  string `position:"Query" name:"ServiceVersion"`
	Namespace       string `position:"Query" name:"Namespace"`
	ServiceName     string `position:"Query" name:"ServiceName"`
	Source          string `position:"Query" name:"Source"`
	Region          string `position:"Query" name:"Region"`
	ServiceGroup    string `position:"Query" name:"ServiceGroup"`
	ConsumerAppName string `position:"Query" name:"ConsumerAppName"`
	Timeout         string `position:"Query" name:"Timeout"`
}

// AddServiceTimeConfigResponse is the response struct for api AddServiceTimeConfig
type AddServiceTimeConfigResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddServiceTimeConfigRequest creates a request to invoke AddServiceTimeConfig API
func CreateAddServiceTimeConfigRequest() (request *AddServiceTimeConfigRequest) {
	request = &AddServiceTimeConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "AddServiceTimeConfig", "/pop/sp/api/timeout/add", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddServiceTimeConfigResponse creates a response to parse from AddServiceTimeConfig response
func CreateAddServiceTimeConfigResponse() (response *AddServiceTimeConfigResponse) {
	response = &AddServiceTimeConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
