package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSubAccountInfo invokes the edas.GetSubAccountInfo API synchronously
func (client *Client) GetSubAccountInfo(request *GetSubAccountInfoRequest) (response *GetSubAccountInfoResponse, err error) {
	response = CreateGetSubAccountInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetSubAccountInfoWithChan invokes the edas.GetSubAccountInfo API asynchronously
func (client *Client) GetSubAccountInfoWithChan(request *GetSubAccountInfoRequest) (<-chan *GetSubAccountInfoResponse, <-chan error) {
	responseChan := make(chan *GetSubAccountInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSubAccountInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSubAccountInfoWithCallback invokes the edas.GetSubAccountInfo API asynchronously
func (client *Client) GetSubAccountInfoWithCallback(request *GetSubAccountInfoRequest, callback func(response *GetSubAccountInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSubAccountInfoResponse
		var err error
		defer close(result)
		response, err = client.GetSubAccountInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSubAccountInfoRequest is the request struct for api GetSubAccountInfo
type GetSubAccountInfoRequest struct {
	*requests.RoaRequest
	TargetUserId string `position:"Query" name:"TargetUserId"`
}

// GetSubAccountInfoResponse is the response struct for api GetSubAccountInfo
type GetSubAccountInfoResponse struct {
	*responses.BaseResponse
	Code          int           `json:"Code" xml:"Code"`
	Message       string        `json:"Message" xml:"Message"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Authorization Authorization `json:"Authorization" xml:"Authorization"`
}

// CreateGetSubAccountInfoRequest creates a request to invoke GetSubAccountInfo API
func CreateGetSubAccountInfoRequest() (request *GetSubAccountInfoRequest) {
	request = &GetSubAccountInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetSubAccountInfo", "/pop/v5/account/sub_account_info", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSubAccountInfoResponse creates a response to parse from GetSubAccountInfo response
func CreateGetSubAccountInfoResponse() (response *GetSubAccountInfoResponse) {
	response = &GetSubAccountInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
