package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListK8sPvc invokes the edas.ListK8sPvc API synchronously
func (client *Client) ListK8sPvc(request *ListK8sPvcRequest) (response *ListK8sPvcResponse, err error) {
	response = CreateListK8sPvcResponse()
	err = client.DoAction(request, response)
	return
}

// ListK8sPvcWithChan invokes the edas.ListK8sPvc API asynchronously
func (client *Client) ListK8sPvcWithChan(request *ListK8sPvcRequest) (<-chan *ListK8sPvcResponse, <-chan error) {
	responseChan := make(chan *ListK8sPvcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListK8sPvc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListK8sPvcWithCallback invokes the edas.ListK8sPvc API asynchronously
func (client *Client) ListK8sPvcWithCallback(request *ListK8sPvcRequest, callback func(response *ListK8sPvcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListK8sPvcResponse
		var err error
		defer close(result)
		response, err = client.ListK8sPvc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListK8sPvcRequest is the request struct for api ListK8sPvc
type ListK8sPvcRequest struct {
	*requests.RoaRequest
	Namespace string `position:"Query" name:"Namespace"`
	ClusterId string `position:"Query" name:"ClusterId"`
}

// ListK8sPvcResponse is the response struct for api ListK8sPvc
type ListK8sPvcResponse struct {
	*responses.BaseResponse
	Code       int              `json:"Code" xml:"Code"`
	Message    string           `json:"Message" xml:"Message"`
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	K8sPvcList []K8sPvcListItem `json:"K8sPvcList" xml:"K8sPvcList"`
}

// CreateListK8sPvcRequest creates a request to invoke ListK8sPvc API
func CreateListK8sPvcRequest() (request *ListK8sPvcRequest) {
	request = &ListK8sPvcRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListK8sPvc", "/pop/v5/k8s/acs/k8s_pvc", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListK8sPvcResponse creates a response to parse from ListK8sPvc response
func CreateListK8sPvcResponse() (response *ListK8sPvcResponse) {
	response = &ListK8sPvcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
