package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMasterSpec invokes the foas.ModifyMasterSpec API synchronously
// api document: https://help.aliyun.com/api/foas/modifymasterspec.html
func (client *Client) ModifyMasterSpec(request *ModifyMasterSpecRequest) (response *ModifyMasterSpecResponse, err error) {
	response = CreateModifyMasterSpecResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMasterSpecWithChan invokes the foas.ModifyMasterSpec API asynchronously
// api document: https://help.aliyun.com/api/foas/modifymasterspec.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyMasterSpecWithChan(request *ModifyMasterSpecRequest) (<-chan *ModifyMasterSpecResponse, <-chan error) {
	responseChan := make(chan *ModifyMasterSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMasterSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMasterSpecWithCallback invokes the foas.ModifyMasterSpec API asynchronously
// api document: https://help.aliyun.com/api/foas/modifymasterspec.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyMasterSpecWithCallback(request *ModifyMasterSpecRequest, callback func(response *ModifyMasterSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMasterSpecResponse
		var err error
		defer close(result)
		response, err = client.ModifyMasterSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMasterSpecRequest is the request struct for api ModifyMasterSpec
type ModifyMasterSpecRequest struct {
	*requests.RoaRequest
	ClusterId         string `position:"Path" name:"clusterId"`
	MasterTargetModel string `position:"Body" name:"masterTargetModel"`
}

// ModifyMasterSpecResponse is the response struct for api ModifyMasterSpec
type ModifyMasterSpecResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyMasterSpecRequest creates a request to invoke ModifyMasterSpec API
func CreateModifyMasterSpecRequest() (request *ModifyMasterSpecRequest) {
	request = &ModifyMasterSpecRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ModifyMasterSpec", "/api/v2/clusters/[clusterId]/specification", "foas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateModifyMasterSpecResponse creates a response to parse from ModifyMasterSpec response
func CreateModifyMasterSpecResponse() (response *ModifyMasterSpecResponse) {
	response = &ModifyMasterSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
