package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBizTypeTextLib invokes the green.DescribeBizTypeTextLib API synchronously
func (client *Client) DescribeBizTypeTextLib(request *DescribeBizTypeTextLibRequest) (response *DescribeBizTypeTextLibResponse, err error) {
	response = CreateDescribeBizTypeTextLibResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBizTypeTextLibWithChan invokes the green.DescribeBizTypeTextLib API asynchronously
func (client *Client) DescribeBizTypeTextLibWithChan(request *DescribeBizTypeTextLibRequest) (<-chan *DescribeBizTypeTextLibResponse, <-chan error) {
	responseChan := make(chan *DescribeBizTypeTextLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBizTypeTextLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBizTypeTextLibWithCallback invokes the green.DescribeBizTypeTextLib API asynchronously
func (client *Client) DescribeBizTypeTextLibWithCallback(request *DescribeBizTypeTextLibRequest, callback func(response *DescribeBizTypeTextLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBizTypeTextLibResponse
		var err error
		defer close(result)
		response, err = client.DescribeBizTypeTextLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBizTypeTextLibRequest is the request struct for api DescribeBizTypeTextLib
type DescribeBizTypeTextLibRequest struct {
	*requests.RpcRequest
	ResourceType string `position:"Query" name:"ResourceType"`
	Scene        string `position:"Query" name:"Scene"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	BizTypeName  string `position:"Query" name:"BizTypeName"`
}

// DescribeBizTypeTextLibResponse is the response struct for api DescribeBizTypeTextLib
type DescribeBizTypeTextLibResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Black     Black  `json:"Black" xml:"Black"`
	Review    Review `json:"Review" xml:"Review"`
	Ignore    Ignore `json:"Ignore" xml:"Ignore"`
	White     White  `json:"White" xml:"White"`
}

// CreateDescribeBizTypeTextLibRequest creates a request to invoke DescribeBizTypeTextLib API
func CreateDescribeBizTypeTextLibRequest() (request *DescribeBizTypeTextLibRequest) {
	request = &DescribeBizTypeTextLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeBizTypeTextLib", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBizTypeTextLibResponse creates a response to parse from DescribeBizTypeTextLib response
func CreateDescribeBizTypeTextLibResponse() (response *DescribeBizTypeTextLibResponse) {
	response = &DescribeBizTypeTextLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
