package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebsiteScanResultDetail invokes the green.DescribeWebsiteScanResultDetail API synchronously
func (client *Client) DescribeWebsiteScanResultDetail(request *DescribeWebsiteScanResultDetailRequest) (response *DescribeWebsiteScanResultDetailResponse, err error) {
	response = CreateDescribeWebsiteScanResultDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebsiteScanResultDetailWithChan invokes the green.DescribeWebsiteScanResultDetail API asynchronously
func (client *Client) DescribeWebsiteScanResultDetailWithChan(request *DescribeWebsiteScanResultDetailRequest) (<-chan *DescribeWebsiteScanResultDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeWebsiteScanResultDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebsiteScanResultDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebsiteScanResultDetailWithCallback invokes the green.DescribeWebsiteScanResultDetail API asynchronously
func (client *Client) DescribeWebsiteScanResultDetailWithCallback(request *DescribeWebsiteScanResultDetailRequest, callback func(response *DescribeWebsiteScanResultDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebsiteScanResultDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebsiteScanResultDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebsiteScanResultDetailRequest is the request struct for api DescribeWebsiteScanResultDetail
type DescribeWebsiteScanResultDetailRequest struct {
	*requests.RpcRequest
	ResourceType string           `position:"Query" name:"ResourceType"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	Id           requests.Integer `position:"Query" name:"Id"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribeWebsiteScanResultDetailResponse is the response struct for api DescribeWebsiteScanResultDetail
type DescribeWebsiteScanResultDetailResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	Baseline         string            `json:"Baseline" xml:"Baseline"`
	Content          string            `json:"Content" xml:"Content"`
	TamperedSource   string            `json:"TamperedSource" xml:"TamperedSource"`
	ResourceType     string            `json:"ResourceType" xml:"ResourceType"`
	HitKeywords      []string          `json:"HitKeywords" xml:"HitKeywords"`
	ImageScanResults []ImageScanResult `json:"ImageScanResults" xml:"ImageScanResults"`
}

// CreateDescribeWebsiteScanResultDetailRequest creates a request to invoke DescribeWebsiteScanResultDetail API
func CreateDescribeWebsiteScanResultDetailRequest() (request *DescribeWebsiteScanResultDetailRequest) {
	request = &DescribeWebsiteScanResultDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeWebsiteScanResultDetail", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWebsiteScanResultDetailResponse creates a response to parse from DescribeWebsiteScanResultDetail response
func CreateDescribeWebsiteScanResultDetailResponse() (response *DescribeWebsiteScanResultDetailResponse) {
	response = &DescribeWebsiteScanResultDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
