package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWebsiteInstanceStatus invokes the green.UpdateWebsiteInstanceStatus API synchronously
func (client *Client) UpdateWebsiteInstanceStatus(request *UpdateWebsiteInstanceStatusRequest) (response *UpdateWebsiteInstanceStatusResponse, err error) {
	response = CreateUpdateWebsiteInstanceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWebsiteInstanceStatusWithChan invokes the green.UpdateWebsiteInstanceStatus API asynchronously
func (client *Client) UpdateWebsiteInstanceStatusWithChan(request *UpdateWebsiteInstanceStatusRequest) (<-chan *UpdateWebsiteInstanceStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateWebsiteInstanceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWebsiteInstanceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWebsiteInstanceStatusWithCallback invokes the green.UpdateWebsiteInstanceStatus API asynchronously
func (client *Client) UpdateWebsiteInstanceStatusWithCallback(request *UpdateWebsiteInstanceStatusRequest, callback func(response *UpdateWebsiteInstanceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWebsiteInstanceStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateWebsiteInstanceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWebsiteInstanceStatusRequest is the request struct for api UpdateWebsiteInstanceStatus
type UpdateWebsiteInstanceStatusRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
	Status     string `position:"Query" name:"Status"`
}

// UpdateWebsiteInstanceStatusResponse is the response struct for api UpdateWebsiteInstanceStatus
type UpdateWebsiteInstanceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateWebsiteInstanceStatusRequest creates a request to invoke UpdateWebsiteInstanceStatus API
func CreateUpdateWebsiteInstanceStatusRequest() (request *UpdateWebsiteInstanceStatusRequest) {
	request = &UpdateWebsiteInstanceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateWebsiteInstanceStatus", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateWebsiteInstanceStatusResponse creates a response to parse from UpdateWebsiteInstanceStatus response
func CreateUpdateWebsiteInstanceStatusResponse() (response *UpdateWebsiteInstanceStatusResponse) {
	response = &UpdateWebsiteInstanceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
