package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceAsyncManualScan invokes the green.VoiceAsyncManualScan API synchronously
func (client *Client) VoiceAsyncManualScan(request *VoiceAsyncManualScanRequest) (response *VoiceAsyncManualScanResponse, err error) {
	response = CreateVoiceAsyncManualScanResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceAsyncManualScanWithChan invokes the green.VoiceAsyncManualScan API asynchronously
func (client *Client) VoiceAsyncManualScanWithChan(request *VoiceAsyncManualScanRequest) (<-chan *VoiceAsyncManualScanResponse, <-chan error) {
	responseChan := make(chan *VoiceAsyncManualScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceAsyncManualScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceAsyncManualScanWithCallback invokes the green.VoiceAsyncManualScan API asynchronously
func (client *Client) VoiceAsyncManualScanWithCallback(request *VoiceAsyncManualScanRequest, callback func(response *VoiceAsyncManualScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceAsyncManualScanResponse
		var err error
		defer close(result)
		response, err = client.VoiceAsyncManualScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceAsyncManualScanRequest is the request struct for api VoiceAsyncManualScan
type VoiceAsyncManualScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceAsyncManualScanResponse is the response struct for api VoiceAsyncManualScan
type VoiceAsyncManualScanResponse struct {
	*responses.BaseResponse
}

// CreateVoiceAsyncManualScanRequest creates a request to invoke VoiceAsyncManualScan API
func CreateVoiceAsyncManualScanRequest() (request *VoiceAsyncManualScanRequest) {
	request = &VoiceAsyncManualScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceAsyncManualScan", "/green/voice/manual/asyncScan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVoiceAsyncManualScanResponse creates a response to parse from VoiceAsyncManualScan response
func CreateVoiceAsyncManualScanResponse() (response *VoiceAsyncManualScanResponse) {
	response = &VoiceAsyncManualScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
