package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CompareImageFaces invokes the imm.CompareImageFaces API synchronously
func (client *Client) CompareImageFaces(request *CompareImageFacesRequest) (response *CompareImageFacesResponse, err error) {
	response = CreateCompareImageFacesResponse()
	err = client.DoAction(request, response)
	return
}

// CompareImageFacesWithChan invokes the imm.CompareImageFaces API asynchronously
func (client *Client) CompareImageFacesWithChan(request *CompareImageFacesRequest) (<-chan *CompareImageFacesResponse, <-chan error) {
	responseChan := make(chan *CompareImageFacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CompareImageFaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CompareImageFacesWithCallback invokes the imm.CompareImageFaces API asynchronously
func (client *Client) CompareImageFacesWithCallback(request *CompareImageFacesRequest, callback func(response *CompareImageFacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CompareImageFacesResponse
		var err error
		defer close(result)
		response, err = client.CompareImageFaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CompareImageFacesRequest is the request struct for api CompareImageFaces
type CompareImageFacesRequest struct {
	*requests.RpcRequest
	Project   string `position:"Query" name:"Project"`
	FaceIdA   string `position:"Query" name:"FaceIdA"`
	FaceIdB   string `position:"Query" name:"FaceIdB"`
	ImageUriB string `position:"Query" name:"ImageUriB"`
	ImageUriA string `position:"Query" name:"ImageUriA"`
	SetId     string `position:"Query" name:"SetId"`
}

// CompareImageFacesResponse is the response struct for api CompareImageFaces
type CompareImageFacesResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	SetId      string  `json:"SetId" xml:"SetId"`
	Similarity float64 `json:"Similarity" xml:"Similarity"`
	FaceA      FaceA   `json:"FaceA" xml:"FaceA"`
	FaceB      FaceB   `json:"FaceB" xml:"FaceB"`
}

// CreateCompareImageFacesRequest creates a request to invoke CompareImageFaces API
func CreateCompareImageFacesRequest() (request *CompareImageFacesRequest) {
	request = &CompareImageFacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "CompareImageFaces", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCompareImageFacesResponse creates a response to parse from CompareImageFaces response
func CreateCompareImageFacesResponse() (response *CompareImageFacesResponse) {
	response = &CompareImageFacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
