package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestSpeech invokes the iot.TestSpeech API synchronously
func (client *Client) TestSpeech(request *TestSpeechRequest) (response *TestSpeechResponse, err error) {
	response = CreateTestSpeechResponse()
	err = client.DoAction(request, response)
	return
}

// TestSpeechWithChan invokes the iot.TestSpeech API asynchronously
func (client *Client) TestSpeechWithChan(request *TestSpeechRequest) (<-chan *TestSpeechResponse, <-chan error) {
	responseChan := make(chan *TestSpeechResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestSpeech(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestSpeechWithCallback invokes the iot.TestSpeech API asynchronously
func (client *Client) TestSpeechWithCallback(request *TestSpeechRequest, callback func(response *TestSpeechResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestSpeechResponse
		var err error
		defer close(result)
		response, err = client.TestSpeech(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestSpeechRequest is the request struct for api TestSpeech
type TestSpeechRequest struct {
	*requests.RpcRequest
	Voice         string           `position:"Body" name:"Voice"`
	ProjectCode   string           `position:"Body" name:"ProjectCode"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	Text          string           `position:"Body" name:"Text"`
	SpeechType    string           `position:"Body" name:"SpeechType"`
	Volume        requests.Integer `position:"Body" name:"Volume"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	SpeechRate    requests.Integer `position:"Body" name:"SpeechRate"`
}

// TestSpeechResponse is the response struct for api TestSpeech
type TestSpeechResponse struct {
	*responses.BaseResponse
	RequestId    string           `json:"RequestId" xml:"RequestId"`
	Success      bool             `json:"Success" xml:"Success"`
	Code         string           `json:"Code" xml:"Code"`
	ErrorMessage string           `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInTestSpeech `json:"Data" xml:"Data"`
}

// CreateTestSpeechRequest creates a request to invoke TestSpeech API
func CreateTestSpeechRequest() (request *TestSpeechRequest) {
	request = &TestSpeechRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "TestSpeech", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTestSpeechResponse creates a response to parse from TestSpeech response
func CreateTestSpeechResponse() (response *TestSpeechResponse) {
	response = &TestSpeechResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
