package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySmarttagJob invokes the mts.QuerySmarttagJob API synchronously
func (client *Client) QuerySmarttagJob(request *QuerySmarttagJobRequest) (response *QuerySmarttagJobResponse, err error) {
	response = CreateQuerySmarttagJobResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySmarttagJobWithChan invokes the mts.QuerySmarttagJob API asynchronously
func (client *Client) QuerySmarttagJobWithChan(request *QuerySmarttagJobRequest) (<-chan *QuerySmarttagJobResponse, <-chan error) {
	responseChan := make(chan *QuerySmarttagJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySmarttagJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySmarttagJobWithCallback invokes the mts.QuerySmarttagJob API asynchronously
func (client *Client) QuerySmarttagJobWithCallback(request *QuerySmarttagJobRequest, callback func(response *QuerySmarttagJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySmarttagJobResponse
		var err error
		defer close(result)
		response, err = client.QuerySmarttagJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySmarttagJobRequest is the request struct for api QuerySmarttagJob
type QuerySmarttagJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobId                string           `position:"Query" name:"JobId"`
}

// QuerySmarttagJobResponse is the response struct for api QuerySmarttagJob
type QuerySmarttagJobResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	JobStatus string                    `json:"JobStatus" xml:"JobStatus"`
	UserData  string                    `json:"UserData" xml:"UserData"`
	Results   ResultsInQuerySmarttagJob `json:"Results" xml:"Results"`
}

// CreateQuerySmarttagJobRequest creates a request to invoke QuerySmarttagJob API
func CreateQuerySmarttagJobRequest() (request *QuerySmarttagJobRequest) {
	request = &QuerySmarttagJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QuerySmarttagJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySmarttagJobResponse creates a response to parse from QuerySmarttagJob response
func CreateQuerySmarttagJobResponse() (response *QuerySmarttagJobResponse) {
	response = &QuerySmarttagJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
