package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterCustomFace invokes the mts.RegisterCustomFace API synchronously
func (client *Client) RegisterCustomFace(request *RegisterCustomFaceRequest) (response *RegisterCustomFaceResponse, err error) {
	response = CreateRegisterCustomFaceResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterCustomFaceWithChan invokes the mts.RegisterCustomFace API asynchronously
func (client *Client) RegisterCustomFaceWithChan(request *RegisterCustomFaceRequest) (<-chan *RegisterCustomFaceResponse, <-chan error) {
	responseChan := make(chan *RegisterCustomFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterCustomFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterCustomFaceWithCallback invokes the mts.RegisterCustomFace API asynchronously
func (client *Client) RegisterCustomFaceWithCallback(request *RegisterCustomFaceRequest, callback func(response *RegisterCustomFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterCustomFaceResponse
		var err error
		defer close(result)
		response, err = client.RegisterCustomFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterCustomFaceRequest is the request struct for api RegisterCustomFace
type RegisterCustomFaceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PersonId             string           `position:"Query" name:"PersonId"`
	CategoryId           string           `position:"Query" name:"CategoryId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ImageUrl             string           `position:"Query" name:"ImageUrl"`
}

// RegisterCustomFaceResponse is the response struct for api RegisterCustomFace
type RegisterCustomFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	FaceId    string `json:"FaceId" xml:"FaceId"`
}

// CreateRegisterCustomFaceRequest creates a request to invoke RegisterCustomFace API
func CreateRegisterCustomFaceRequest() (request *RegisterCustomFaceRequest) {
	request = &RegisterCustomFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "RegisterCustomFace", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRegisterCustomFaceResponse creates a response to parse from RegisterCustomFace response
func CreateRegisterCustomFaceResponse() (response *RegisterCustomFaceResponse) {
	response = &RegisterCustomFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
