package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchMediaWorkflow invokes the mts.SearchMediaWorkflow API synchronously
func (client *Client) SearchMediaWorkflow(request *SearchMediaWorkflowRequest) (response *SearchMediaWorkflowResponse, err error) {
	response = CreateSearchMediaWorkflowResponse()
	err = client.DoAction(request, response)
	return
}

// SearchMediaWorkflowWithChan invokes the mts.SearchMediaWorkflow API asynchronously
func (client *Client) SearchMediaWorkflowWithChan(request *SearchMediaWorkflowRequest) (<-chan *SearchMediaWorkflowResponse, <-chan error) {
	responseChan := make(chan *SearchMediaWorkflowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchMediaWorkflow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchMediaWorkflowWithCallback invokes the mts.SearchMediaWorkflow API asynchronously
func (client *Client) SearchMediaWorkflowWithCallback(request *SearchMediaWorkflowRequest, callback func(response *SearchMediaWorkflowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchMediaWorkflowResponse
		var err error
		defer close(result)
		response, err = client.SearchMediaWorkflow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchMediaWorkflowRequest is the request struct for api SearchMediaWorkflow
type SearchMediaWorkflowRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	StateList            string           `position:"Query" name:"StateList"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SearchMediaWorkflowResponse is the response struct for api SearchMediaWorkflow
type SearchMediaWorkflowResponse struct {
	*responses.BaseResponse
	RequestId         string                                 `json:"RequestId" xml:"RequestId"`
	TotalCount        int64                                  `json:"TotalCount" xml:"TotalCount"`
	PageNumber        int64                                  `json:"PageNumber" xml:"PageNumber"`
	PageSize          int64                                  `json:"PageSize" xml:"PageSize"`
	MediaWorkflowList MediaWorkflowListInSearchMediaWorkflow `json:"MediaWorkflowList" xml:"MediaWorkflowList"`
}

// CreateSearchMediaWorkflowRequest creates a request to invoke SearchMediaWorkflow API
func CreateSearchMediaWorkflowRequest() (request *SearchMediaWorkflowRequest) {
	request = &SearchMediaWorkflowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SearchMediaWorkflow", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchMediaWorkflowResponse creates a response to parse from SearchMediaWorkflow response
func CreateSearchMediaWorkflowResponse() (response *SearchMediaWorkflowResponse) {
	response = &SearchMediaWorkflowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
