package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitEditingJobs invokes the mts.SubmitEditingJobs API synchronously
func (client *Client) SubmitEditingJobs(request *SubmitEditingJobsRequest) (response *SubmitEditingJobsResponse, err error) {
	response = CreateSubmitEditingJobsResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitEditingJobsWithChan invokes the mts.SubmitEditingJobs API asynchronously
func (client *Client) SubmitEditingJobsWithChan(request *SubmitEditingJobsRequest) (<-chan *SubmitEditingJobsResponse, <-chan error) {
	responseChan := make(chan *SubmitEditingJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitEditingJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitEditingJobsWithCallback invokes the mts.SubmitEditingJobs API asynchronously
func (client *Client) SubmitEditingJobsWithCallback(request *SubmitEditingJobsRequest, callback func(response *SubmitEditingJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitEditingJobsResponse
		var err error
		defer close(result)
		response, err = client.SubmitEditingJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitEditingJobsRequest is the request struct for api SubmitEditingJobs
type SubmitEditingJobsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OutputLocation       string           `position:"Query" name:"OutputLocation"`
	EditingInputs        string           `position:"Query" name:"EditingInputs"`
	EditingJobOutputs    string           `position:"Query" name:"EditingJobOutputs"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	OutputBucket         string           `position:"Query" name:"OutputBucket"`
}

// SubmitEditingJobsResponse is the response struct for api SubmitEditingJobs
type SubmitEditingJobsResponse struct {
	*responses.BaseResponse
	RequestId     string                           `json:"RequestId" xml:"RequestId"`
	JobResultList JobResultListInSubmitEditingJobs `json:"JobResultList" xml:"JobResultList"`
}

// CreateSubmitEditingJobsRequest creates a request to invoke SubmitEditingJobs API
func CreateSubmitEditingJobsRequest() (request *SubmitEditingJobsRequest) {
	request = &SubmitEditingJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitEditingJobs", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitEditingJobsResponse creates a response to parse from SubmitEditingJobs response
func CreateSubmitEditingJobsResponse() (response *SubmitEditingJobsResponse) {
	response = &SubmitEditingJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
