package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWarningConfig invokes the qualitycheck.CreateWarningConfig API synchronously
func (client *Client) CreateWarningConfig(request *CreateWarningConfigRequest) (response *CreateWarningConfigResponse, err error) {
	response = CreateCreateWarningConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWarningConfigWithChan invokes the qualitycheck.CreateWarningConfig API asynchronously
func (client *Client) CreateWarningConfigWithChan(request *CreateWarningConfigRequest) (<-chan *CreateWarningConfigResponse, <-chan error) {
	responseChan := make(chan *CreateWarningConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWarningConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWarningConfigWithCallback invokes the qualitycheck.CreateWarningConfig API asynchronously
func (client *Client) CreateWarningConfigWithCallback(request *CreateWarningConfigRequest, callback func(response *CreateWarningConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWarningConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateWarningConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWarningConfigRequest is the request struct for api CreateWarningConfig
type CreateWarningConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// CreateWarningConfigResponse is the response struct for api CreateWarningConfig
type CreateWarningConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateWarningConfigRequest creates a request to invoke CreateWarningConfig API
func CreateCreateWarningConfigRequest() (request *CreateWarningConfigRequest) {
	request = &CreateWarningConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "CreateWarningConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateWarningConfigResponse creates a response to parse from CreateWarningConfig response
func CreateCreateWarningConfigResponse() (response *CreateWarningConfigResponse) {
	response = &CreateWarningConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
