package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcScale invokes the rtc.DescribeRtcScale API synchronously
func (client *Client) DescribeRtcScale(request *DescribeRtcScaleRequest) (response *DescribeRtcScaleResponse, err error) {
	response = CreateDescribeRtcScaleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcScaleWithChan invokes the rtc.DescribeRtcScale API asynchronously
func (client *Client) DescribeRtcScaleWithChan(request *DescribeRtcScaleRequest) (<-chan *DescribeRtcScaleResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcScaleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcScale(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcScaleWithCallback invokes the rtc.DescribeRtcScale API asynchronously
func (client *Client) DescribeRtcScaleWithCallback(request *DescribeRtcScaleRequest, callback func(response *DescribeRtcScaleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcScaleResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcScale(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcScaleRequest is the request struct for api DescribeRtcScale
type DescribeRtcScaleRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	AppId     string           `position:"Query" name:"AppId"`
}

// DescribeRtcScaleResponse is the response struct for api DescribeRtcScale
type DescribeRtcScaleResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Scale     []ScaleItem `json:"Scale" xml:"Scale"`
}

// CreateDescribeRtcScaleRequest creates a request to invoke DescribeRtcScale API
func CreateDescribeRtcScaleRequest() (request *DescribeRtcScaleRequest) {
	request = &DescribeRtcScaleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcScale", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcScaleResponse creates a response to parse from DescribeRtcScale response
func CreateDescribeRtcScaleResponse() (response *DescribeRtcScaleResponse) {
	response = &DescribeRtcScaleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
