package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWatermark invokes the vod.DeleteWatermark API synchronously
func (client *Client) DeleteWatermark(request *DeleteWatermarkRequest) (response *DeleteWatermarkResponse, err error) {
	response = CreateDeleteWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWatermarkWithChan invokes the vod.DeleteWatermark API asynchronously
func (client *Client) DeleteWatermarkWithChan(request *DeleteWatermarkRequest) (<-chan *DeleteWatermarkResponse, <-chan error) {
	responseChan := make(chan *DeleteWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWatermarkWithCallback invokes the vod.DeleteWatermark API asynchronously
func (client *Client) DeleteWatermarkWithCallback(request *DeleteWatermarkRequest, callback func(response *DeleteWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWatermarkResponse
		var err error
		defer close(result)
		response, err = client.DeleteWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWatermarkRequest is the request struct for api DeleteWatermark
type DeleteWatermarkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	WatermarkId          string           `position:"Query" name:"WatermarkId"`
}

// DeleteWatermarkResponse is the response struct for api DeleteWatermark
type DeleteWatermarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteWatermarkRequest creates a request to invoke DeleteWatermark API
func CreateDeleteWatermarkRequest() (request *DeleteWatermarkRequest) {
	request = &DeleteWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DeleteWatermark", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteWatermarkResponse creates a response to parse from DeleteWatermark response
func CreateDeleteWatermarkResponse() (response *DeleteWatermarkResponse) {
	response = &DeleteWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
