package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMediaDNALibs invokes the vod.ListMediaDNALibs API synchronously
func (client *Client) ListMediaDNALibs(request *ListMediaDNALibsRequest) (response *ListMediaDNALibsResponse, err error) {
	response = CreateListMediaDNALibsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMediaDNALibsWithChan invokes the vod.ListMediaDNALibs API asynchronously
func (client *Client) ListMediaDNALibsWithChan(request *ListMediaDNALibsRequest) (<-chan *ListMediaDNALibsResponse, <-chan error) {
	responseChan := make(chan *ListMediaDNALibsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMediaDNALibs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMediaDNALibsWithCallback invokes the vod.ListMediaDNALibs API asynchronously
func (client *Client) ListMediaDNALibsWithCallback(request *ListMediaDNALibsRequest, callback func(response *ListMediaDNALibsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMediaDNALibsResponse
		var err error
		defer close(result)
		response, err = client.ListMediaDNALibs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMediaDNALibsRequest is the request struct for api ListMediaDNALibs
type ListMediaDNALibsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	LibRegion            string `position:"Query" name:"LibRegion"`
}

// ListMediaDNALibsResponse is the response struct for api ListMediaDNALibs
type ListMediaDNALibsResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	AIDNALibInfoList AIDNALibInfoList `json:"AIDNALibInfoList" xml:"AIDNALibInfoList"`
}

// CreateListMediaDNALibsRequest creates a request to invoke ListMediaDNALibs API
func CreateListMediaDNALibsRequest() (request *ListMediaDNALibsRequest) {
	request = &ListMediaDNALibsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListMediaDNALibs", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMediaDNALibsResponse creates a response to parse from ListMediaDNALibs response
func CreateListMediaDNALibsResponse() (response *ListMediaDNALibsResponse) {
	response = &ListMediaDNALibsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
