package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitTranscodeJobs invokes the vod.SubmitTranscodeJobs API synchronously
func (client *Client) SubmitTranscodeJobs(request *SubmitTranscodeJobsRequest) (response *SubmitTranscodeJobsResponse, err error) {
	response = CreateSubmitTranscodeJobsResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitTranscodeJobsWithChan invokes the vod.SubmitTranscodeJobs API asynchronously
func (client *Client) SubmitTranscodeJobsWithChan(request *SubmitTranscodeJobsRequest) (<-chan *SubmitTranscodeJobsResponse, <-chan error) {
	responseChan := make(chan *SubmitTranscodeJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitTranscodeJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitTranscodeJobsWithCallback invokes the vod.SubmitTranscodeJobs API asynchronously
func (client *Client) SubmitTranscodeJobsWithCallback(request *SubmitTranscodeJobsRequest, callback func(response *SubmitTranscodeJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitTranscodeJobsResponse
		var err error
		defer close(result)
		response, err = client.SubmitTranscodeJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitTranscodeJobsRequest is the request struct for api SubmitTranscodeJobs
type SubmitTranscodeJobsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	VideoId              string           `position:"Query" name:"VideoId"`
	OverrideParams       string           `position:"Query" name:"OverrideParams"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Priority             string           `position:"Query" name:"Priority"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	TemplateGroupId      string           `position:"Query" name:"TemplateGroupId"`
	FileUrl              string           `position:"Query" name:"FileUrl"`
	EncryptConfig        string           `position:"Query" name:"EncryptConfig"`
}

// SubmitTranscodeJobsResponse is the response struct for api SubmitTranscodeJobs
type SubmitTranscodeJobsResponse struct {
	*responses.BaseResponse
	RequestId       string        `json:"RequestId" xml:"RequestId"`
	TranscodeTaskId string        `json:"TranscodeTaskId" xml:"TranscodeTaskId"`
	TranscodeJobs   TranscodeJobs `json:"TranscodeJobs" xml:"TranscodeJobs"`
}

// CreateSubmitTranscodeJobsRequest creates a request to invoke SubmitTranscodeJobs API
func CreateSubmitTranscodeJobsRequest() (request *SubmitTranscodeJobsRequest) {
	request = &SubmitTranscodeJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SubmitTranscodeJobs", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitTranscodeJobsResponse creates a response to parse from SubmitTranscodeJobs response
func CreateSubmitTranscodeJobsResponse() (response *SubmitTranscodeJobsResponse) {
	response = &SubmitTranscodeJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
