package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchBindParentPlatformDevices invokes the vs.BatchBindParentPlatformDevices API synchronously
func (client *Client) BatchBindParentPlatformDevices(request *BatchBindParentPlatformDevicesRequest) (response *BatchBindParentPlatformDevicesResponse, err error) {
	response = CreateBatchBindParentPlatformDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchBindParentPlatformDevicesWithChan invokes the vs.BatchBindParentPlatformDevices API asynchronously
func (client *Client) BatchBindParentPlatformDevicesWithChan(request *BatchBindParentPlatformDevicesRequest) (<-chan *BatchBindParentPlatformDevicesResponse, <-chan error) {
	responseChan := make(chan *BatchBindParentPlatformDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchBindParentPlatformDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchBindParentPlatformDevicesWithCallback invokes the vs.BatchBindParentPlatformDevices API asynchronously
func (client *Client) BatchBindParentPlatformDevicesWithCallback(request *BatchBindParentPlatformDevicesRequest, callback func(response *BatchBindParentPlatformDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchBindParentPlatformDevicesResponse
		var err error
		defer close(result)
		response, err = client.BatchBindParentPlatformDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchBindParentPlatformDevicesRequest is the request struct for api BatchBindParentPlatformDevices
type BatchBindParentPlatformDevicesRequest struct {
	*requests.RpcRequest
	ParentPlatformId string           `position:"Query" name:"ParentPlatformId"`
	ShowLog          string           `position:"Query" name:"ShowLog"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId         string           `position:"Query" name:"DeviceId"`
}

// BatchBindParentPlatformDevicesResponse is the response struct for api BatchBindParentPlatformDevices
type BatchBindParentPlatformDevicesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchBindParentPlatformDevicesRequest creates a request to invoke BatchBindParentPlatformDevices API
func CreateBatchBindParentPlatformDevicesRequest() (request *BatchBindParentPlatformDevicesRequest) {
	request = &BatchBindParentPlatformDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchBindParentPlatformDevices", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchBindParentPlatformDevicesResponse creates a response to parse from BatchBindParentPlatformDevices response
func CreateBatchBindParentPlatformDevicesResponse() (response *BatchBindParentPlatformDevicesResponse) {
	response = &BatchBindParentPlatformDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
