package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStopStreams invokes the vs.BatchStopStreams API synchronously
func (client *Client) BatchStopStreams(request *BatchStopStreamsRequest) (response *BatchStopStreamsResponse, err error) {
	response = CreateBatchStopStreamsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStopStreamsWithChan invokes the vs.BatchStopStreams API asynchronously
func (client *Client) BatchStopStreamsWithChan(request *BatchStopStreamsRequest) (<-chan *BatchStopStreamsResponse, <-chan error) {
	responseChan := make(chan *BatchStopStreamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStopStreams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStopStreamsWithCallback invokes the vs.BatchStopStreams API asynchronously
func (client *Client) BatchStopStreamsWithCallback(request *BatchStopStreamsRequest, callback func(response *BatchStopStreamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStopStreamsResponse
		var err error
		defer close(result)
		response, err = client.BatchStopStreams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStopStreamsRequest is the request struct for api BatchStopStreams
type BatchStopStreamsRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	Id        string           `position:"Query" name:"Id"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// BatchStopStreamsResponse is the response struct for api BatchStopStreams
type BatchStopStreamsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchStopStreamsRequest creates a request to invoke BatchStopStreams API
func CreateBatchStopStreamsRequest() (request *BatchStopStreamsRequest) {
	request = &BatchStopStreamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchStopStreams", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchStopStreamsResponse creates a response to parse from BatchStopStreams response
func CreateBatchStopStreamsResponse() (response *BatchStopStreamsResponse) {
	response = &BatchStopStreamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
