package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetVsDomainCertificate invokes the vs.SetVsDomainCertificate API synchronously
func (client *Client) SetVsDomainCertificate(request *SetVsDomainCertificateRequest) (response *SetVsDomainCertificateResponse, err error) {
	response = CreateSetVsDomainCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SetVsDomainCertificateWithChan invokes the vs.SetVsDomainCertificate API asynchronously
func (client *Client) SetVsDomainCertificateWithChan(request *SetVsDomainCertificateRequest) (<-chan *SetVsDomainCertificateResponse, <-chan error) {
	responseChan := make(chan *SetVsDomainCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetVsDomainCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetVsDomainCertificateWithCallback invokes the vs.SetVsDomainCertificate API asynchronously
func (client *Client) SetVsDomainCertificateWithCallback(request *SetVsDomainCertificateRequest, callback func(response *SetVsDomainCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetVsDomainCertificateResponse
		var err error
		defer close(result)
		response, err = client.SetVsDomainCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetVsDomainCertificateRequest is the request struct for api SetVsDomainCertificate
type SetVsDomainCertificateRequest struct {
	*requests.RpcRequest
	SSLProtocol string           `position:"Query" name:"SSLProtocol"`
	CertType    string           `position:"Query" name:"CertType"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	SSLPri      string           `position:"Query" name:"SSLPri"`
	ForceSet    string           `position:"Query" name:"ForceSet"`
	CertName    string           `position:"Query" name:"CertName"`
	DomainName  string           `position:"Query" name:"DomainName"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	SSLPub      string           `position:"Query" name:"SSLPub"`
	Region      string           `position:"Query" name:"Region"`
}

// SetVsDomainCertificateResponse is the response struct for api SetVsDomainCertificate
type SetVsDomainCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetVsDomainCertificateRequest creates a request to invoke SetVsDomainCertificate API
func CreateSetVsDomainCertificateRequest() (request *SetVsDomainCertificateRequest) {
	request = &SetVsDomainCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "SetVsDomainCertificate", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetVsDomainCertificateResponse creates a response to parse from SetVsDomainCertificate response
func CreateSetVsDomainCertificateResponse() (response *SetVsDomainCertificateResponse) {
	response = &SetVsDomainCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
