package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartTransferStream invokes the vs.StartTransferStream API synchronously
func (client *Client) StartTransferStream(request *StartTransferStreamRequest) (response *StartTransferStreamResponse, err error) {
	response = CreateStartTransferStreamResponse()
	err = client.DoAction(request, response)
	return
}

// StartTransferStreamWithChan invokes the vs.StartTransferStream API asynchronously
func (client *Client) StartTransferStreamWithChan(request *StartTransferStreamRequest) (<-chan *StartTransferStreamResponse, <-chan error) {
	responseChan := make(chan *StartTransferStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartTransferStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartTransferStreamWithCallback invokes the vs.StartTransferStream API asynchronously
func (client *Client) StartTransferStreamWithCallback(request *StartTransferStreamRequest, callback func(response *StartTransferStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartTransferStreamResponse
		var err error
		defer close(result)
		response, err = client.StartTransferStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartTransferStreamRequest is the request struct for api StartTransferStream
type StartTransferStreamRequest struct {
	*requests.RpcRequest
	Id        string           `position:"Query" name:"Id"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	Transcode string           `position:"Query" name:"Transcode"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	Url       string           `position:"Query" name:"Url"`
}

// StartTransferStreamResponse is the response struct for api StartTransferStream
type StartTransferStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartTransferStreamRequest creates a request to invoke StartTransferStream API
func CreateStartTransferStreamRequest() (request *StartTransferStreamRequest) {
	request = &StartTransferStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "StartTransferStream", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartTransferStreamResponse creates a response to parse from StartTransferStream response
func CreateStartTransferStreamResponse() (response *StartTransferStreamResponse) {
	response = &StartTransferStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
