package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindDirectory invokes the vs.UnbindDirectory API synchronously
func (client *Client) UnbindDirectory(request *UnbindDirectoryRequest) (response *UnbindDirectoryResponse, err error) {
	response = CreateUnbindDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindDirectoryWithChan invokes the vs.UnbindDirectory API asynchronously
func (client *Client) UnbindDirectoryWithChan(request *UnbindDirectoryRequest) (<-chan *UnbindDirectoryResponse, <-chan error) {
	responseChan := make(chan *UnbindDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindDirectoryWithCallback invokes the vs.UnbindDirectory API asynchronously
func (client *Client) UnbindDirectoryWithCallback(request *UnbindDirectoryRequest, callback func(response *UnbindDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindDirectoryResponse
		var err error
		defer close(result)
		response, err = client.UnbindDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindDirectoryRequest is the request struct for api UnbindDirectory
type UnbindDirectoryRequest struct {
	*requests.RpcRequest
	DirectoryId string           `position:"Query" name:"DirectoryId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId    string           `position:"Query" name:"DeviceId"`
}

// UnbindDirectoryResponse is the response struct for api UnbindDirectory
type UnbindDirectoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindDirectoryRequest creates a request to invoke UnbindDirectory API
func CreateUnbindDirectoryRequest() (request *UnbindDirectoryRequest) {
	request = &UnbindDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UnbindDirectory", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnbindDirectoryResponse creates a response to parse from UnbindDirectory response
func CreateUnbindDirectoryResponse() (response *UnbindDirectoryResponse) {
	response = &UnbindDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
