/*
 * GPL HEADER START
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License version 2 for more details (a copy is included
 * in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License
 * version 2 along with this program; If not, see
 * http://www.gnu.org/licenses/gpl-2.0.html
 *
 * GPL HEADER END
 */
/*
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 * Use is subject to license terms.
 *
 * Copyright (c) 2011, 2016, Intel Corporation.
 */
/*
 * This file is part of Lustre, http://www.lustre.org/
 * Lustre is a trademark of Sun Microsystems, Inc.
 */

#define DEBUG_SUBSYSTEM S_RPC

#ifdef CONFIG_FS_POSIX_ACL
# include <linux/fs.h>
# include <linux/posix_acl_xattr.h>
#endif /* CONFIG_FS_POSIX_ACL */

#include <obd_support.h>
#include <obd_class.h>
#include <lustre_net.h>
#include <lustre/lustre_lfsck_user.h>
#include <lustre_disk.h>
void lustre_assert_wire_constants(void)
{
	 /* Wire protocol assertions generated by 'wirecheck'
	  * (make -C lustre/utils newwiretest)
	  * running on Linux centss05 2.6.32.431.29.2.el6_lustre #1 SMP Tue Sep 23 16:06:38 CDT 2014 x
	  * with gcc version 4.4.7 20120313 (Red Hat 4.4.7-4) (GCC)  */


	/* Constants... */
	LASSERTF(PTL_RPC_MSG_REQUEST == 4711, "found %lld\n",
		 (long long)PTL_RPC_MSG_REQUEST);
	LASSERTF(PTL_RPC_MSG_ERR == 4712, "found %lld\n",
		 (long long)PTL_RPC_MSG_ERR);
	LASSERTF(PTL_RPC_MSG_REPLY == 4713, "found %lld\n",
		 (long long)PTL_RPC_MSG_REPLY);
	LASSERTF(MDS_DIR_END_OFF == 0xfffffffffffffffeULL, "found 0x%.16llxULL\n",
		 MDS_DIR_END_OFF);
	LASSERTF(DEAD_HANDLE_MAGIC == 0xdeadbeefcafebabeULL, "found 0x%.16llxULL\n",
		 DEAD_HANDLE_MAGIC);
	CLASSERT(MTI_NAME_MAXLEN == 64);
	LASSERTF(OST_REPLY == 0, "found %lld\n",
		 (long long)OST_REPLY);
	LASSERTF(OST_GETATTR == 1, "found %lld\n",
		 (long long)OST_GETATTR);
	LASSERTF(OST_SETATTR == 2, "found %lld\n",
		 (long long)OST_SETATTR);
	LASSERTF(OST_READ == 3, "found %lld\n",
		 (long long)OST_READ);
	LASSERTF(OST_WRITE == 4, "found %lld\n",
		 (long long)OST_WRITE);
	LASSERTF(OST_CREATE == 5, "found %lld\n",
		 (long long)OST_CREATE);
	LASSERTF(OST_DESTROY == 6, "found %lld\n",
		 (long long)OST_DESTROY);
	LASSERTF(OST_GET_INFO == 7, "found %lld\n",
		 (long long)OST_GET_INFO);
	LASSERTF(OST_CONNECT == 8, "found %lld\n",
		 (long long)OST_CONNECT);
	LASSERTF(OST_DISCONNECT == 9, "found %lld\n",
		 (long long)OST_DISCONNECT);
	LASSERTF(OST_PUNCH == 10, "found %lld\n",
		 (long long)OST_PUNCH);
	LASSERTF(OST_OPEN == 11, "found %lld\n",
		 (long long)OST_OPEN);
	LASSERTF(OST_CLOSE == 12, "found %lld\n",
		 (long long)OST_CLOSE);
	LASSERTF(OST_STATFS == 13, "found %lld\n",
		 (long long)OST_STATFS);
	LASSERTF(OST_SYNC == 16, "found %lld\n",
		 (long long)OST_SYNC);
	LASSERTF(OST_SET_INFO == 17, "found %lld\n",
		 (long long)OST_SET_INFO);
	LASSERTF(OST_QUOTACHECK == 18, "found %lld\n",
		 (long long)OST_QUOTACHECK);
	LASSERTF(OST_QUOTACTL == 19, "found %lld\n",
		 (long long)OST_QUOTACTL);
	LASSERTF(OST_QUOTA_ADJUST_QUNIT == 20, "found %lld\n",
		 (long long)OST_QUOTA_ADJUST_QUNIT);
	LASSERTF(OST_LADVISE == 21, "found %lld\n",
		 (long long)OST_LADVISE);
	LASSERTF(OST_LAST_OPC == 22, "found %lld\n",
		 (long long)OST_LAST_OPC);
	LASSERTF(OBD_OBJECT_EOF == 0xffffffffffffffffULL, "found 0x%.16llxULL\n",
		 OBD_OBJECT_EOF);
	LASSERTF(OST_MIN_PRECREATE == 32, "found %lld\n",
		 (long long)OST_MIN_PRECREATE);
	LASSERTF(OST_MAX_PRECREATE == 20000, "found %lld\n",
		 (long long)OST_MAX_PRECREATE);
	LASSERTF(OST_LVB_ERR_INIT == 0xffbadbad80000000ULL, "found 0x%.16llxULL\n",
		 OST_LVB_ERR_INIT);
	LASSERTF(OST_LVB_ERR_MASK == 0xffbadbad00000000ULL, "found 0x%.16llxULL\n",
		 OST_LVB_ERR_MASK);
	LASSERTF(MDS_FIRST_OPC == 33, "found %lld\n",
		 (long long)MDS_FIRST_OPC);
	LASSERTF(MDS_GETATTR == 33, "found %lld\n",
		 (long long)MDS_GETATTR);
	LASSERTF(MDS_GETATTR_NAME == 34, "found %lld\n",
		 (long long)MDS_GETATTR_NAME);
	LASSERTF(MDS_CLOSE == 35, "found %lld\n",
		 (long long)MDS_CLOSE);
	LASSERTF(MDS_REINT == 36, "found %lld\n",
		 (long long)MDS_REINT);
	LASSERTF(MDS_READPAGE == 37, "found %lld\n",
		 (long long)MDS_READPAGE);
	LASSERTF(MDS_CONNECT == 38, "found %lld\n",
		 (long long)MDS_CONNECT);
	LASSERTF(MDS_DISCONNECT == 39, "found %lld\n",
		 (long long)MDS_DISCONNECT);
	LASSERTF(MDS_GET_ROOT == 40, "found %lld\n",
		 (long long)MDS_GET_ROOT);
	LASSERTF(MDS_STATFS == 41, "found %lld\n",
		 (long long)MDS_STATFS);
	LASSERTF(MDS_PIN == 42, "found %lld\n",
		 (long long)MDS_PIN);
	LASSERTF(MDS_UNPIN == 43, "found %lld\n",
		 (long long)MDS_UNPIN);
	LASSERTF(MDS_SYNC == 44, "found %lld\n",
		 (long long)MDS_SYNC);
	LASSERTF(MDS_DONE_WRITING == 45, "found %lld\n",
		 (long long)MDS_DONE_WRITING);
	LASSERTF(MDS_SET_INFO == 46, "found %lld\n",
		 (long long)MDS_SET_INFO);
	LASSERTF(MDS_QUOTACHECK == 47, "found %lld\n",
		 (long long)MDS_QUOTACHECK);
	LASSERTF(MDS_QUOTACTL == 48, "found %lld\n",
		 (long long)MDS_QUOTACTL);
	LASSERTF(MDS_GETXATTR == 49, "found %lld\n",
		 (long long)MDS_GETXATTR);
	LASSERTF(MDS_SETXATTR == 50, "found %lld\n",
		 (long long)MDS_SETXATTR);
	LASSERTF(MDS_WRITEPAGE == 51, "found %lld\n",
		 (long long)MDS_WRITEPAGE);
	LASSERTF(MDS_IS_SUBDIR == 52, "found %lld\n",
		 (long long)MDS_IS_SUBDIR);
	LASSERTF(MDS_GET_INFO == 53, "found %lld\n",
		 (long long)MDS_GET_INFO);
	LASSERTF(MDS_HSM_STATE_GET == 54, "found %lld\n",
		 (long long)MDS_HSM_STATE_GET);
	LASSERTF(MDS_HSM_STATE_SET == 55, "found %lld\n",
		 (long long)MDS_HSM_STATE_SET);
	LASSERTF(MDS_HSM_ACTION == 56, "found %lld\n",
		 (long long)MDS_HSM_ACTION);
	LASSERTF(MDS_HSM_PROGRESS == 57, "found %lld\n",
		 (long long)MDS_HSM_PROGRESS);
	LASSERTF(MDS_HSM_REQUEST == 58, "found %lld\n",
		 (long long)MDS_HSM_REQUEST);
	LASSERTF(MDS_HSM_CT_REGISTER == 59, "found %lld\n",
		 (long long)MDS_HSM_CT_REGISTER);
	LASSERTF(MDS_HSM_CT_UNREGISTER == 60, "found %lld\n",
		 (long long)MDS_HSM_CT_UNREGISTER);
	LASSERTF(MDS_SWAP_LAYOUTS == 61, "found %lld\n",
		 (long long)MDS_SWAP_LAYOUTS);
	LASSERTF(MDS_LAST_OPC == 62, "found %lld\n",
		 (long long)MDS_LAST_OPC);
	LASSERTF(REINT_SETATTR == 1, "found %lld\n",
		 (long long)REINT_SETATTR);
	LASSERTF(REINT_CREATE == 2, "found %lld\n",
		 (long long)REINT_CREATE);
	LASSERTF(REINT_LINK == 3, "found %lld\n",
		 (long long)REINT_LINK);
	LASSERTF(REINT_UNLINK == 4, "found %lld\n",
		 (long long)REINT_UNLINK);
	LASSERTF(REINT_RENAME == 5, "found %lld\n",
		 (long long)REINT_RENAME);
	LASSERTF(REINT_OPEN == 6, "found %lld\n",
		 (long long)REINT_OPEN);
	LASSERTF(REINT_SETXATTR == 7, "found %lld\n",
		 (long long)REINT_SETXATTR);
	LASSERTF(REINT_RMENTRY == 8, "found %lld\n",
		 (long long)REINT_RMENTRY);
	LASSERTF(REINT_MIGRATE == 9, "found %lld\n",
		 (long long)REINT_MIGRATE);
	LASSERTF(REINT_MAX == 10, "found %lld\n",
		 (long long)REINT_MAX);
	LASSERTF(DISP_IT_EXECD == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)DISP_IT_EXECD);
	LASSERTF(DISP_LOOKUP_EXECD == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)DISP_LOOKUP_EXECD);
	LASSERTF(DISP_LOOKUP_NEG == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)DISP_LOOKUP_NEG);
	LASSERTF(DISP_LOOKUP_POS == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)DISP_LOOKUP_POS);
	LASSERTF(DISP_OPEN_CREATE == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)DISP_OPEN_CREATE);
	LASSERTF(DISP_OPEN_OPEN == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)DISP_OPEN_OPEN);
	LASSERTF(DISP_ENQ_COMPLETE == 0x00400000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_ENQ_COMPLETE);
	LASSERTF(DISP_ENQ_OPEN_REF == 0x00800000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_ENQ_OPEN_REF);
	LASSERTF(DISP_ENQ_CREATE_REF == 0x01000000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_ENQ_CREATE_REF);
	LASSERTF(DISP_OPEN_LOCK == 0x02000000UL, "found 0x%.8xUL\n",
		(unsigned)DISP_OPEN_LOCK);
	LASSERTF(MDS_STATUS_CONN == 1, "found %lld\n",
		 (long long)MDS_STATUS_CONN);
	LASSERTF(MDS_STATUS_LOV == 2, "found %lld\n",
		 (long long)MDS_STATUS_LOV);
	LASSERTF(MDS_ATTR_MODE == 0x0000000000000001ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_MODE);
	LASSERTF(MDS_ATTR_UID == 0x0000000000000002ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_UID);
	LASSERTF(MDS_ATTR_GID == 0x0000000000000004ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_GID);
	LASSERTF(MDS_ATTR_SIZE == 0x0000000000000008ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_SIZE);
	LASSERTF(MDS_ATTR_ATIME == 0x0000000000000010ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_ATIME);
	LASSERTF(MDS_ATTR_MTIME == 0x0000000000000020ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_MTIME);
	LASSERTF(MDS_ATTR_CTIME == 0x0000000000000040ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_CTIME);
	LASSERTF(MDS_ATTR_ATIME_SET == 0x0000000000000080ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_ATIME_SET);
	LASSERTF(MDS_ATTR_MTIME_SET == 0x0000000000000100ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_MTIME_SET);
	LASSERTF(MDS_ATTR_FORCE == 0x0000000000000200ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_FORCE);
	LASSERTF(MDS_ATTR_ATTR_FLAG == 0x0000000000000400ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_ATTR_FLAG);
	LASSERTF(MDS_ATTR_KILL_SUID == 0x0000000000000800ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_KILL_SUID);
	LASSERTF(MDS_ATTR_KILL_SGID == 0x0000000000001000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_KILL_SGID);
	LASSERTF(MDS_ATTR_CTIME_SET == 0x0000000000002000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_CTIME_SET);
	LASSERTF(MDS_ATTR_FROM_OPEN == 0x0000000000004000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_FROM_OPEN);
	LASSERTF(MDS_ATTR_BLOCKS == 0x0000000000008000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_BLOCKS);

	LASSERTF(MDS_ATTR_PROJID == 0x0000000000010000ULL, "found 0x%.16llxULL\n",
			(long long)MDS_ATTR_PROJID);
	LASSERTF(FLD_QUERY == 900, "found %lld\n",
		 (long long)FLD_QUERY);
	LASSERTF(FLD_READ == 901, "found %lld\n",
		 (long long)FLD_READ);
	LASSERTF(FLD_FIRST_OPC == 900, "found %lld\n",
		 (long long)FLD_FIRST_OPC);
	LASSERTF(FLD_LAST_OPC == 902, "found %lld\n",
		 (long long)FLD_LAST_OPC);
	LASSERTF(SEQ_QUERY == 700, "found %lld\n",
		 (long long)SEQ_QUERY);
	LASSERTF(SEQ_FIRST_OPC == 700, "found %lld\n",
		 (long long)SEQ_FIRST_OPC);
	LASSERTF(SEQ_LAST_OPC == 701, "found %lld\n",
		 (long long)SEQ_LAST_OPC);
	LASSERTF(LFSCK_NOTIFY == 1101, "found %lld\n",
		 (long long)LFSCK_NOTIFY);
	LASSERTF(LFSCK_QUERY == 1102, "found %lld\n",
		 (long long)LFSCK_QUERY);
	LASSERTF(LFSCK_FIRST_OPC == 1101, "found %lld\n",
		 (long long)LFSCK_FIRST_OPC);
	LASSERTF(LFSCK_LAST_OPC == 1103, "found %lld\n",
		 (long long)LFSCK_LAST_OPC);
	LASSERTF(SEQ_ALLOC_SUPER == 0, "found %lld\n",
		 (long long)SEQ_ALLOC_SUPER);
	LASSERTF(SEQ_ALLOC_META == 1, "found %lld\n",
		 (long long)SEQ_ALLOC_META);
	LASSERTF(LDLM_ENQUEUE == 101, "found %lld\n",
		 (long long)LDLM_ENQUEUE);
	LASSERTF(LDLM_CONVERT == 102, "found %lld\n",
		 (long long)LDLM_CONVERT);
	LASSERTF(LDLM_CANCEL == 103, "found %lld\n",
		 (long long)LDLM_CANCEL);
	LASSERTF(LDLM_BL_CALLBACK == 104, "found %lld\n",
		 (long long)LDLM_BL_CALLBACK);
	LASSERTF(LDLM_CP_CALLBACK == 105, "found %lld\n",
		 (long long)LDLM_CP_CALLBACK);
	LASSERTF(LDLM_GL_CALLBACK == 106, "found %lld\n",
		 (long long)LDLM_GL_CALLBACK);
	LASSERTF(LDLM_SET_INFO == 107, "found %lld\n",
		 (long long)LDLM_SET_INFO);
	LASSERTF(LDLM_LAST_OPC == 108, "found %lld\n",
		 (long long)LDLM_LAST_OPC);
	LASSERTF(LCK_MINMODE == 0, "found %lld\n",
		 (long long)LCK_MINMODE);
	LASSERTF(LCK_EX == 1, "found %lld\n",
		 (long long)LCK_EX);
	LASSERTF(LCK_PW == 2, "found %lld\n",
		 (long long)LCK_PW);
	LASSERTF(LCK_PR == 4, "found %lld\n",
		 (long long)LCK_PR);
	LASSERTF(LCK_CW == 8, "found %lld\n",
		 (long long)LCK_CW);
	LASSERTF(LCK_CR == 16, "found %lld\n",
		 (long long)LCK_CR);
	LASSERTF(LCK_NL == 32, "found %lld\n",
		 (long long)LCK_NL);
	LASSERTF(LCK_GROUP == 64, "found %lld\n",
		 (long long)LCK_GROUP);
	LASSERTF(LCK_COS == 128, "found %lld\n",
		 (long long)LCK_COS);
	LASSERTF(LCK_MAXMODE == 129, "found %lld\n",
		 (long long)LCK_MAXMODE);
	LASSERTF(LCK_MODE_NUM == 8, "found %lld\n",
		 (long long)LCK_MODE_NUM);
	CLASSERT(LDLM_PLAIN == 10);
	CLASSERT(LDLM_EXTENT == 11);
	CLASSERT(LDLM_FLOCK == 12);
	CLASSERT(LDLM_IBITS == 13);
	CLASSERT(LDLM_MAX_TYPE == 14);
	CLASSERT(LUSTRE_RES_ID_SEQ_OFF == 0);
	CLASSERT(LUSTRE_RES_ID_VER_OID_OFF == 1);
	LASSERTF(OUT_UPDATE == 1000, "found %lld\n",
		 (long long)OUT_UPDATE);
	LASSERTF(OUT_UPDATE_LAST_OPC == 1001, "found %lld\n",
		 (long long)OUT_UPDATE_LAST_OPC);
	CLASSERT(LUSTRE_RES_ID_QUOTA_SEQ_OFF == 2);
	CLASSERT(LUSTRE_RES_ID_QUOTA_VER_OID_OFF == 3);
	CLASSERT(LUSTRE_RES_ID_HSH_OFF == 3);
	CLASSERT(LQUOTA_TYPE_USR == 0);
	CLASSERT(LQUOTA_TYPE_GRP == 1);
	CLASSERT(LQUOTA_RES_MD == 1);
	CLASSERT(LQUOTA_RES_DT == 2);
	LASSERTF(OBD_PING == 400, "found %lld\n",
		 (long long)OBD_PING);
	LASSERTF(OBD_LOG_CANCEL == 401, "found %lld\n",
		 (long long)OBD_LOG_CANCEL);
	LASSERTF(OBD_QC_CALLBACK == 402, "found %lld\n",
		 (long long)OBD_QC_CALLBACK);
	LASSERTF(OBD_IDX_READ == 403, "found %lld\n",
		 (long long)OBD_IDX_READ);
	LASSERTF(OBD_LAST_OPC == 404, "found %lld\n",
		 (long long)OBD_LAST_OPC);
	LASSERTF(QUOTA_DQACQ == 601, "found %lld\n",
		 (long long)QUOTA_DQACQ);
	LASSERTF(QUOTA_DQREL == 602, "found %lld\n",
		 (long long)QUOTA_DQREL);
	LASSERTF(QUOTA_LAST_OPC == 603, "found %lld\n",
		 (long long)QUOTA_LAST_OPC);
	LASSERTF(MGS_CONNECT == 250, "found %lld\n",
		 (long long)MGS_CONNECT);
	LASSERTF(MGS_DISCONNECT == 251, "found %lld\n",
		 (long long)MGS_DISCONNECT);
	LASSERTF(MGS_EXCEPTION == 252, "found %lld\n",
		 (long long)MGS_EXCEPTION);
	LASSERTF(MGS_TARGET_REG == 253, "found %lld\n",
		 (long long)MGS_TARGET_REG);
	LASSERTF(MGS_TARGET_DEL == 254, "found %lld\n",
		 (long long)MGS_TARGET_DEL);
	LASSERTF(MGS_SET_INFO == 255, "found %lld\n",
		 (long long)MGS_SET_INFO);
	LASSERTF(MGS_LAST_OPC == 257, "found %lld\n",
		 (long long)MGS_LAST_OPC);
	LASSERTF(SEC_CTX_INIT == 801, "found %lld\n",
		 (long long)SEC_CTX_INIT);
	LASSERTF(SEC_CTX_INIT_CONT == 802, "found %lld\n",
		 (long long)SEC_CTX_INIT_CONT);
	LASSERTF(SEC_CTX_FINI == 803, "found %lld\n",
		 (long long)SEC_CTX_FINI);
	LASSERTF(SEC_LAST_OPC == 804, "found %lld\n",
		 (long long)SEC_LAST_OPC);
	/* Sizes and Offsets */

	/* Checks for struct obd_uuid */
	LASSERTF((int)sizeof(struct obd_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct obd_uuid));

	/* Checks for struct lu_seq_range */
	LASSERTF((int)sizeof(struct lu_seq_range) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lu_seq_range));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_start));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_start));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_end));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_end));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_index) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_index));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_index));
	LASSERTF((int)offsetof(struct lu_seq_range, lsr_flags) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lu_seq_range, lsr_flags));
	LASSERTF((int)sizeof(((struct lu_seq_range *)0)->lsr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_seq_range *)0)->lsr_flags));
	LASSERTF(LU_SEQ_RANGE_MDT == 0, "found %lld\n",
		 (long long)LU_SEQ_RANGE_MDT);
	LASSERTF(LU_SEQ_RANGE_OST == 1, "found %lld\n",
		 (long long)LU_SEQ_RANGE_OST);

	/* Checks for struct lustre_mdt_attrs */
	LASSERTF((int)sizeof(struct lustre_mdt_attrs) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_mdt_attrs));
	LASSERTF((int)offsetof(struct lustre_mdt_attrs, lma_compat) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_mdt_attrs, lma_compat));
	LASSERTF((int)sizeof(((struct lustre_mdt_attrs *)0)->lma_compat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_mdt_attrs *)0)->lma_compat));
	LASSERTF((int)offsetof(struct lustre_mdt_attrs, lma_incompat) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_mdt_attrs, lma_incompat));
	LASSERTF((int)sizeof(((struct lustre_mdt_attrs *)0)->lma_incompat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_mdt_attrs *)0)->lma_incompat));
	LASSERTF((int)offsetof(struct lustre_mdt_attrs, lma_self_fid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_mdt_attrs, lma_self_fid));
	LASSERTF((int)sizeof(((struct lustre_mdt_attrs *)0)->lma_self_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_mdt_attrs *)0)->lma_self_fid));
	LASSERTF(LMAC_HSM == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_HSM);
	LASSERTF(LMAC_NOT_IN_OI == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_NOT_IN_OI);
	LASSERTF(LMAC_FID_ON_OST == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_FID_ON_OST);
	LASSERTF(LMAC_STRIPE_INFO == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_STRIPE_INFO);
	LASSERTF(LMAC_COMP_INFO == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)LMAC_COMP_INFO);
	LASSERTF(LMAI_RELEASED == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LMAI_RELEASED);
	LASSERTF(LMAI_AGENT == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LMAI_AGENT);
	LASSERTF(LMAI_REMOTE_PARENT == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LMAI_REMOTE_PARENT);
	LASSERTF(LMAI_STRIPED == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)LMAI_STRIPED);
	LASSERTF(LMAI_ORPHAN == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)LMAI_ORPHAN);

	/* Checks for struct lustre_ost_attrs */
	LASSERTF((int)sizeof(struct lustre_ost_attrs) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_ost_attrs));
	LASSERTF((int)offsetof(struct lustre_ost_attrs, loa_lma) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_ost_attrs, loa_lma));
	LASSERTF((int)sizeof(((struct lustre_ost_attrs *)0)->loa_lma) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_ost_attrs *)0)->loa_lma));
	LASSERTF((int)offsetof(struct lustre_ost_attrs, loa_parent_fid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_ost_attrs, loa_parent_fid));
	LASSERTF((int)sizeof(((struct lustre_ost_attrs *)0)->loa_parent_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_ost_attrs *)0)->loa_parent_fid));
	LASSERTF((int)offsetof(struct lustre_ost_attrs, loa_stripe_size) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_ost_attrs, loa_stripe_size));
	LASSERTF((int)sizeof(((struct lustre_ost_attrs *)0)->loa_stripe_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_ost_attrs *)0)->loa_stripe_size));
	LASSERTF((int)offsetof(struct lustre_ost_attrs, loa_comp_id) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_ost_attrs, loa_comp_id));
	LASSERTF((int)sizeof(((struct lustre_ost_attrs *)0)->loa_comp_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_ost_attrs *)0)->loa_comp_id));
	LASSERTF((int)offsetof(struct lustre_ost_attrs, loa_comp_start) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_ost_attrs, loa_comp_start));
	LASSERTF((int)sizeof(((struct lustre_ost_attrs *)0)->loa_comp_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_ost_attrs *)0)->loa_comp_start));
	LASSERTF((int)offsetof(struct lustre_ost_attrs, loa_comp_end) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_ost_attrs, loa_comp_end));
	LASSERTF((int)sizeof(((struct lustre_ost_attrs *)0)->loa_comp_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_ost_attrs *)0)->loa_comp_end));
	LASSERTF(OUT_CREATE == 1, "found %lld\n",
		 (long long)OUT_CREATE);
	LASSERTF(OUT_DESTROY == 2, "found %lld\n",
		 (long long)OUT_DESTROY);
	LASSERTF(OUT_REF_ADD == 3, "found %lld\n",
		 (long long)OUT_REF_ADD);
	LASSERTF(OUT_REF_DEL == 4, "found %lld\n",
		 (long long)OUT_REF_DEL);
	LASSERTF(OUT_ATTR_SET == 5, "found %lld\n",
		 (long long)OUT_ATTR_SET);
	LASSERTF(OUT_ATTR_GET == 6, "found %lld\n",
		 (long long)OUT_ATTR_GET);
	LASSERTF(OUT_XATTR_SET == 7, "found %lld\n",
		 (long long)OUT_XATTR_SET);
	LASSERTF(OUT_XATTR_GET == 8, "found %lld\n",
		 (long long)OUT_XATTR_GET);
	LASSERTF(OUT_INDEX_LOOKUP == 9, "found %lld\n",
		 (long long)OUT_INDEX_LOOKUP);
	LASSERTF(OUT_INDEX_LOOKUP == 9, "found %lld\n",
		 (long long)OUT_INDEX_LOOKUP);
	LASSERTF(OUT_INDEX_INSERT == 10, "found %lld\n",
		 (long long)OUT_INDEX_INSERT);
	LASSERTF(OUT_INDEX_DELETE == 11, "found %lld\n",
		 (long long)OUT_INDEX_DELETE);
	LASSERTF(OUT_WRITE == 12, "found %lld\n",
		 (long long)OUT_WRITE);
	LASSERTF(OUT_XATTR_DEL == 13, "found %lld\n",
		 (long long)OUT_XATTR_DEL);
	LASSERTF(OUT_PUNCH == 14, "found %lld\n",
		 (long long)OUT_PUNCH);
	LASSERTF(OUT_READ == 15, "found %lld\n",
		 (long long)OUT_READ);

	/* Checks for struct hsm_attrs */
	LASSERTF((int)sizeof(struct hsm_attrs) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_attrs));
	LASSERTF((int)offsetof(struct hsm_attrs, hsm_compat) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_attrs, hsm_compat));
	LASSERTF((int)sizeof(((struct hsm_attrs *)0)->hsm_compat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_attrs *)0)->hsm_compat));
	LASSERTF((int)offsetof(struct hsm_attrs, hsm_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_attrs, hsm_flags));
	LASSERTF((int)sizeof(((struct hsm_attrs *)0)->hsm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_attrs *)0)->hsm_flags));
	LASSERTF((int)offsetof(struct hsm_attrs, hsm_arch_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_attrs, hsm_arch_id));
	LASSERTF((int)sizeof(((struct hsm_attrs *)0)->hsm_arch_id) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_attrs *)0)->hsm_arch_id));
	LASSERTF((int)offsetof(struct hsm_attrs, hsm_arch_ver) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_attrs, hsm_arch_ver));
	LASSERTF((int)sizeof(((struct hsm_attrs *)0)->hsm_arch_ver) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_attrs *)0)->hsm_arch_ver));

	/* Checks for struct ost_id */
	LASSERTF((int)sizeof(struct ost_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct ost_id));
	LASSERTF((int)offsetof(struct ost_id, oi) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_id, oi));
	LASSERTF((int)sizeof(((struct ost_id *)0)->oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_id *)0)->oi));
	LASSERTF(LUSTRE_FID_INIT_OID == 1, "found %lld\n",
		 (long long)LUSTRE_FID_INIT_OID);
	LASSERTF(FID_SEQ_OST_MDT0 == 0, "found %lld\n",
		 (long long)FID_SEQ_OST_MDT0);
	LASSERTF(FID_SEQ_LLOG == 1, "found %lld\n",
		 (long long)FID_SEQ_LLOG);
	LASSERTF(FID_SEQ_ECHO == 2, "found %lld\n",
		 (long long)FID_SEQ_ECHO);
	LASSERTF(FID_SEQ_UNUSED_START == 3, "found %lld\n",
		 (long long)FID_SEQ_UNUSED_START);
	LASSERTF(FID_SEQ_UNUSED_END == 9, "found %lld\n",
		 (long long)FID_SEQ_UNUSED_END);
	LASSERTF(FID_SEQ_RSVD == 11, "found %lld\n",
		 (long long)FID_SEQ_RSVD);
	LASSERTF(FID_SEQ_IGIF == 12, "found %lld\n",
		 (long long)FID_SEQ_IGIF);
	LASSERTF(FID_SEQ_IGIF_MAX == 0x00000000ffffffffULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_IGIF_MAX);
	LASSERTF(FID_SEQ_IDIF == 0x0000000100000000ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_IDIF);
	LASSERTF(FID_SEQ_IDIF_MAX == 0x00000001ffffffffULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_IDIF_MAX);
	LASSERTF(FID_SEQ_START == 0x0000000200000000ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_START);
	LASSERTF(FID_SEQ_LOCAL_FILE == 0x0000000200000001ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_LOCAL_FILE);
	LASSERTF(FID_SEQ_DOT_LUSTRE == 0x0000000200000002ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_DOT_LUSTRE);
	LASSERTF(FID_SEQ_SPECIAL == 0x0000000200000004ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_SPECIAL);
	LASSERTF(FID_SEQ_QUOTA == 0x0000000200000005ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_QUOTA);
	LASSERTF(FID_SEQ_QUOTA_GLB == 0x0000000200000006ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_QUOTA_GLB);
	LASSERTF(FID_SEQ_ROOT == 0x0000000200000007ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_ROOT);
	LASSERTF(FID_SEQ_LAYOUT_RBTREE == 0x0000000200000008ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_LAYOUT_RBTREE);
	LASSERTF(FID_SEQ_UPDATE_LOG == 0x0000000200000009ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_UPDATE_LOG);
	LASSERTF(FID_SEQ_UPDATE_LOG_DIR == 0x000000020000000aULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_UPDATE_LOG_DIR);
	LASSERTF(FID_SEQ_NORMAL == 0x0000000200000400ULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_NORMAL);
	LASSERTF(FID_SEQ_LOV_DEFAULT == 0xffffffffffffffffULL, "found 0x%.16llxULL\n",
			(long long)FID_SEQ_LOV_DEFAULT);
	LASSERTF(FID_OID_SPECIAL_BFL == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)FID_OID_SPECIAL_BFL);
	LASSERTF(FID_OID_DOT_LUSTRE == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)FID_OID_DOT_LUSTRE);
	LASSERTF(FID_OID_DOT_LUSTRE_OBF == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)FID_OID_DOT_LUSTRE_OBF);

	/* Checks for struct lu_dirent */
	LASSERTF((int)sizeof(struct lu_dirent) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lu_dirent));
	LASSERTF((int)offsetof(struct lu_dirent, lde_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_fid));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_fid));
	LASSERTF((int)offsetof(struct lu_dirent, lde_hash) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_hash));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_hash) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_hash));
	LASSERTF((int)offsetof(struct lu_dirent, lde_reclen) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_reclen));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_reclen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_reclen));
	LASSERTF((int)offsetof(struct lu_dirent, lde_namelen) == 26, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_namelen));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_namelen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_namelen));
	LASSERTF((int)offsetof(struct lu_dirent, lde_attrs) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_attrs));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_attrs) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_attrs));
	LASSERTF((int)offsetof(struct lu_dirent, lde_name[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirent, lde_name[0]));
	LASSERTF((int)sizeof(((struct lu_dirent *)0)->lde_name[0]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirent *)0)->lde_name[0]));
	LASSERTF(LUDA_FID == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LUDA_FID);
	LASSERTF(LUDA_TYPE == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LUDA_TYPE);
	LASSERTF(LUDA_64BITHASH == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LUDA_64BITHASH);

	/* Checks for struct luda_type */
	LASSERTF((int)sizeof(struct luda_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(struct luda_type));
	LASSERTF((int)offsetof(struct luda_type, lt_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct luda_type, lt_type));
	LASSERTF((int)sizeof(((struct luda_type *)0)->lt_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct luda_type *)0)->lt_type));

	/* Checks for struct lu_dirpage */
	LASSERTF((int)sizeof(struct lu_dirpage) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lu_dirpage));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_hash_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_hash_start));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_hash_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_hash_start));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_hash_end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_hash_end));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_hash_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_hash_end));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_flags));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_flags));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_pad0) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_pad0));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_pad0) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_pad0));
	LASSERTF((int)offsetof(struct lu_dirpage, ldp_entries[0]) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lu_dirpage, ldp_entries[0]));
	LASSERTF((int)sizeof(((struct lu_dirpage *)0)->ldp_entries[0]) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_dirpage *)0)->ldp_entries[0]));
	LASSERTF(LDF_EMPTY == 1, "found %lld\n",
		 (long long)LDF_EMPTY);
	LASSERTF(LDF_COLLIDE == 2, "found %lld\n",
		 (long long)LDF_COLLIDE);
	LASSERTF(LU_PAGE_SIZE == 4096, "found %lld\n",
		 (long long)LU_PAGE_SIZE);
	/* Checks for union lu_page */
	LASSERTF((int)sizeof(union lu_page) == 4096, "found %lld\n",
		 (long long)(int)sizeof(union lu_page));

	/* Checks for struct lustre_handle */
	LASSERTF((int)sizeof(struct lustre_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_handle));
	LASSERTF((int)offsetof(struct lustre_handle, cookie) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_handle, cookie));
	LASSERTF((int)sizeof(((struct lustre_handle *)0)->cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_handle *)0)->cookie));

	/* Checks for struct lustre_msg_v2 */
	LASSERTF((int)sizeof(struct lustre_msg_v2) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_msg_v2));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_bufcount) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_bufcount));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_bufcount) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_bufcount));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_secflvr) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_secflvr));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_secflvr) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_secflvr));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_magic) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_magic));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_magic));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_repsize) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_repsize));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_repsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_repsize));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_cksum) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_cksum));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_cksum) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_cksum));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_flags) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_flags));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_flags));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_padding_2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_padding_2));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_2));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_padding_3) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_padding_3));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_padding_3));
	LASSERTF((int)offsetof(struct lustre_msg_v2, lm_buflens[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_msg_v2, lm_buflens[0]));
	LASSERTF((int)sizeof(((struct lustre_msg_v2 *)0)->lm_buflens[0]) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_msg_v2 *)0)->lm_buflens[0]));
	LASSERTF(LUSTRE_MSG_MAGIC_V2 == 0x0BD00BD3, "found 0x%.8x\n",
		LUSTRE_MSG_MAGIC_V2);
	LASSERTF(LUSTRE_MSG_MAGIC_V2_SWABBED == 0xD30BD00B, "found 0x%.8x\n",
		LUSTRE_MSG_MAGIC_V2_SWABBED);

	/* Checks for struct ptlrpc_body */
	LASSERTF((int)sizeof(struct ptlrpc_body_v3) == 184, "found %lld\n",
		 (long long)(int)sizeof(struct ptlrpc_body_v3));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_handle) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_handle));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_type) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_type));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_version) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_version));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_opc) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_opc));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_status) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_status));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_xid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_last_xid));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_tag) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_tag));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_tag) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_tag));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding0) == 34, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_padding0));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding0) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding0));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_padding1));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding1));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_committed) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_last_committed));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_transno) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_transno));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_flags) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_op_flags) == 60, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_op_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_timeout) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_timeout));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_service_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_service_time));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_limit) == 76, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_limit));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_slv) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_slv));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv));
	CLASSERT(PTLRPC_NUM_VERSIONS == 4);
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_pre_versions) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_pre_versions));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_mbits) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_mbits));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_mbits) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_mbits));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding64_0) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_padding64_0));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_0) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_0));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding64_1) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_padding64_1));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_1));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding64_2) == 144, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_padding64_2));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_2));
	CLASSERT(LUSTRE_JOBID_SIZE == 32);
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_jobid) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct ptlrpc_body_v3, pb_jobid));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_jobid) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_jobid));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_handle) == (int)offsetof(struct ptlrpc_body_v2, pb_handle), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_handle), (int)offsetof(struct ptlrpc_body_v2, pb_handle));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_handle), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_handle), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_handle));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_type) == (int)offsetof(struct ptlrpc_body_v2, pb_type), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_type), (int)offsetof(struct ptlrpc_body_v2, pb_type));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_type), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_type), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_type));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_version) == (int)offsetof(struct ptlrpc_body_v2, pb_version), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_version), (int)offsetof(struct ptlrpc_body_v2, pb_version));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_version), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_version), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_version));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_opc) == (int)offsetof(struct ptlrpc_body_v2, pb_opc), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_opc), (int)offsetof(struct ptlrpc_body_v2, pb_opc));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_opc), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_opc), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_opc));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_status) == (int)offsetof(struct ptlrpc_body_v2, pb_status), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_status), (int)offsetof(struct ptlrpc_body_v2, pb_status));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_status), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_status), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_status));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_xid) == (int)offsetof(struct ptlrpc_body_v2, pb_last_xid), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_last_xid), (int)offsetof(struct ptlrpc_body_v2, pb_last_xid));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_xid), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_xid), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_xid));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_tag) == (int)offsetof(struct ptlrpc_body_v2, pb_tag), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_tag), (int)offsetof(struct ptlrpc_body_v2, pb_tag));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_tag) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_tag), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_tag), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_tag));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding0) == (int)offsetof(struct ptlrpc_body_v2, pb_padding0), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_padding0), (int)offsetof(struct ptlrpc_body_v2, pb_padding0));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding0) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding0), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding0), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding0));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding1) == (int)offsetof(struct ptlrpc_body_v2, pb_padding1), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_padding1), (int)offsetof(struct ptlrpc_body_v2, pb_padding1));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding1) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding1), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding1), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding1));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_last_committed) == (int)offsetof(struct ptlrpc_body_v2, pb_last_committed), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_last_committed), (int)offsetof(struct ptlrpc_body_v2, pb_last_committed));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_committed), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_last_committed), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_last_committed));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_transno) == (int)offsetof(struct ptlrpc_body_v2, pb_transno), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_transno), (int)offsetof(struct ptlrpc_body_v2, pb_transno));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_transno), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_transno), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_transno));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_flags) == (int)offsetof(struct ptlrpc_body_v2, pb_flags), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_flags), (int)offsetof(struct ptlrpc_body_v2, pb_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_flags), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_flags), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_op_flags) == (int)offsetof(struct ptlrpc_body_v2, pb_op_flags), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_op_flags), (int)offsetof(struct ptlrpc_body_v2, pb_op_flags));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_op_flags), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_op_flags), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_op_flags));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt) == (int)offsetof(struct ptlrpc_body_v2, pb_conn_cnt), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_conn_cnt), (int)offsetof(struct ptlrpc_body_v2, pb_conn_cnt));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_conn_cnt), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_conn_cnt), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_conn_cnt));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_timeout) == (int)offsetof(struct ptlrpc_body_v2, pb_timeout), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_timeout), (int)offsetof(struct ptlrpc_body_v2, pb_timeout));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_timeout), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_timeout), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_timeout));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_service_time) == (int)offsetof(struct ptlrpc_body_v2, pb_service_time), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_service_time), (int)offsetof(struct ptlrpc_body_v2, pb_service_time));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_service_time), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_service_time), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_service_time));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_limit) == (int)offsetof(struct ptlrpc_body_v2, pb_limit), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_limit), (int)offsetof(struct ptlrpc_body_v2, pb_limit));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_limit), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_limit), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_limit));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_slv) == (int)offsetof(struct ptlrpc_body_v2, pb_slv), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_slv), (int)offsetof(struct ptlrpc_body_v2, pb_slv));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_slv), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_slv), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_slv));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_pre_versions) == (int)offsetof(struct ptlrpc_body_v2, pb_pre_versions), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_pre_versions), (int)offsetof(struct ptlrpc_body_v2, pb_pre_versions));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_pre_versions), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_pre_versions), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_pre_versions));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_mbits) == (int)offsetof(struct ptlrpc_body_v2, pb_mbits), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_mbits), (int)offsetof(struct ptlrpc_body_v2, pb_mbits));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_mbits) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_mbits), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_mbits), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_mbits));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding64_0) == (int)offsetof(struct ptlrpc_body_v2, pb_padding64_0), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_padding64_0), (int)offsetof(struct ptlrpc_body_v2, pb_padding64_0));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_0) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding64_0), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_0), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding64_0));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding64_1) == (int)offsetof(struct ptlrpc_body_v2, pb_padding64_1), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_padding64_1), (int)offsetof(struct ptlrpc_body_v2, pb_padding64_1));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_1) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding64_1), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_1), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding64_1));
	LASSERTF((int)offsetof(struct ptlrpc_body_v3, pb_padding64_2) == (int)offsetof(struct ptlrpc_body_v2, pb_padding64_2), "%d != %d\n",
		 (int)offsetof(struct ptlrpc_body_v3, pb_padding64_2), (int)offsetof(struct ptlrpc_body_v2, pb_padding64_2));
	LASSERTF((int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_2) == (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding64_2), "%d != %d\n",
		 (int)sizeof(((struct ptlrpc_body_v3 *)0)->pb_padding64_2), (int)sizeof(((struct ptlrpc_body_v2 *)0)->pb_padding64_2));
	LASSERTF(MSG_PTLRPC_BODY_OFF == 0, "found %lld\n",
		 (long long)MSG_PTLRPC_BODY_OFF);
	LASSERTF(REQ_REC_OFF == 1, "found %lld\n",
		 (long long)REQ_REC_OFF);
	LASSERTF(REPLY_REC_OFF == 1, "found %lld\n",
		 (long long)REPLY_REC_OFF);
	LASSERTF(DLM_LOCKREQ_OFF == 1, "found %lld\n",
		 (long long)DLM_LOCKREQ_OFF);
	LASSERTF(DLM_REQ_REC_OFF == 2, "found %lld\n",
		 (long long)DLM_REQ_REC_OFF);
	LASSERTF(DLM_INTENT_IT_OFF == 2, "found %lld\n",
		 (long long)DLM_INTENT_IT_OFF);
	LASSERTF(DLM_INTENT_REC_OFF == 3, "found %lld\n",
		 (long long)DLM_INTENT_REC_OFF);
	LASSERTF(DLM_LOCKREPLY_OFF == 1, "found %lld\n",
		 (long long)DLM_LOCKREPLY_OFF);
	LASSERTF(DLM_REPLY_REC_OFF == 2, "found %lld\n",
		 (long long)DLM_REPLY_REC_OFF);
	LASSERTF(MSG_PTLRPC_HEADER_OFF == 31, "found %lld\n",
		 (long long)MSG_PTLRPC_HEADER_OFF);
	LASSERTF(PTLRPC_MSG_VERSION == 0x00000003, "found 0x%.8x\n",
		PTLRPC_MSG_VERSION);
	LASSERTF(LUSTRE_VERSION_MASK == 0xffff0000, "found 0x%.8x\n",
		LUSTRE_VERSION_MASK);
	LASSERTF(LUSTRE_OBD_VERSION == 0x00010000, "found 0x%.8x\n",
		LUSTRE_OBD_VERSION);
	LASSERTF(LUSTRE_MDS_VERSION == 0x00020000, "found 0x%.8x\n",
		LUSTRE_MDS_VERSION);
	LASSERTF(LUSTRE_OST_VERSION == 0x00030000, "found 0x%.8x\n",
		LUSTRE_OST_VERSION);
	LASSERTF(LUSTRE_DLM_VERSION == 0x00040000, "found 0x%.8x\n",
		LUSTRE_DLM_VERSION);
	LASSERTF(LUSTRE_LOG_VERSION == 0x00050000, "found 0x%.8x\n",
		LUSTRE_LOG_VERSION);
	LASSERTF(LUSTRE_MGS_VERSION == 0x00060000, "found 0x%.8x\n",
		LUSTRE_MGS_VERSION);
	LASSERTF(MSGHDR_AT_SUPPORT == 1, "found %lld\n",
		 (long long)MSGHDR_AT_SUPPORT);
	LASSERTF(MSGHDR_CKSUM_INCOMPAT18 == 2, "found %lld\n",
		 (long long)MSGHDR_CKSUM_INCOMPAT18);
	LASSERTF(MSG_OP_FLAG_MASK == 0xffff0000UL, "found 0x%.8xUL\n",
		(unsigned)MSG_OP_FLAG_MASK);
	LASSERTF(MSG_OP_FLAG_SHIFT == 16, "found %lld\n",
		 (long long)MSG_OP_FLAG_SHIFT);
	LASSERTF(MSG_GEN_FLAG_MASK == 0x0000ffffUL, "found 0x%.8xUL\n",
		(unsigned)MSG_GEN_FLAG_MASK);
	LASSERTF(MSG_LAST_REPLAY == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)MSG_LAST_REPLAY);
	LASSERTF(MSG_RESENT == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)MSG_RESENT);
	LASSERTF(MSG_REPLAY == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)MSG_REPLAY);
	LASSERTF(MSG_DELAY_REPLAY == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)MSG_DELAY_REPLAY);
	LASSERTF(MSG_VERSION_REPLAY == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)MSG_VERSION_REPLAY);
	LASSERTF(MSG_REQ_REPLAY_DONE == 0x00000040UL, "found 0x%.8xUL\n",
		(unsigned)MSG_REQ_REPLAY_DONE);
	LASSERTF(MSG_LOCK_REPLAY_DONE == 0x00000080UL, "found 0x%.8xUL\n",
		(unsigned)MSG_LOCK_REPLAY_DONE);
	LASSERTF(MSG_CONNECT_RECOVERING == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_RECOVERING);
	LASSERTF(MSG_CONNECT_RECONNECT == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_RECONNECT);
	LASSERTF(MSG_CONNECT_REPLAYABLE == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_REPLAYABLE);
	LASSERTF(MSG_CONNECT_LIBCLIENT == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_LIBCLIENT);
	LASSERTF(MSG_CONNECT_INITIAL == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_INITIAL);
	LASSERTF(MSG_CONNECT_ASYNC == 0x00000040UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_ASYNC);
	LASSERTF(MSG_CONNECT_NEXT_VER == 0x00000080UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_NEXT_VER);
	LASSERTF(MSG_CONNECT_TRANSNO == 0x00000100UL, "found 0x%.8xUL\n",
		(unsigned)MSG_CONNECT_TRANSNO);

	/* Checks for struct obd_connect_data */
	LASSERTF((int)sizeof(struct obd_connect_data) == 192, "found %lld\n",
		 (long long)(int)sizeof(struct obd_connect_data));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_connect_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_connect_flags));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_version) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_version));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_version));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_index) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_index));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_index));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_brw_size) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_brw_size));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_brw_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_brw_size));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_ibits_known) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_ibits_known));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_ibits_known) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_ibits_known));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant_blkbits) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant_blkbits));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant_blkbits) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant_blkbits));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant_inobits) == 33, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant_inobits));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant_inobits) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant_inobits));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant_tax_kb) == 34, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant_tax_kb));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant_tax_kb) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant_tax_kb));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_grant_max_blks) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_grant_max_blks));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_grant_max_blks) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_grant_max_blks));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_transno) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_transno));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_transno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_transno));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_group) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_group));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_group) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_group));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_cksum_types) == 52, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_cksum_types));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_cksum_types) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_cksum_types));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_max_easize) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_max_easize));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_max_easize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_max_easize));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_instance) == 60, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_instance));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_instance) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_instance));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_maxbytes) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_maxbytes));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_maxbytes) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_maxbytes));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_maxmodrpcs) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_maxmodrpcs));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_maxmodrpcs) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_maxmodrpcs));
	LASSERTF((int)offsetof(struct obd_connect_data, padding0) == 74, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding0));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding0) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding0));
	LASSERTF((int)offsetof(struct obd_connect_data, padding1) == 76, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding1));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding1));
	LASSERTF((int)offsetof(struct obd_connect_data, ocd_connect_flags2) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, ocd_connect_flags2));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->ocd_connect_flags2));
	LASSERTF((int)offsetof(struct obd_connect_data, padding3) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding3));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding3));
	LASSERTF((int)offsetof(struct obd_connect_data, padding4) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding4));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding4));
	LASSERTF((int)offsetof(struct obd_connect_data, padding5) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding5));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding5));
	LASSERTF((int)offsetof(struct obd_connect_data, padding6) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding6));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding6));
	LASSERTF((int)offsetof(struct obd_connect_data, padding7) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding7));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding7) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding7));
	LASSERTF((int)offsetof(struct obd_connect_data, padding8) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding8));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding8) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding8));
	LASSERTF((int)offsetof(struct obd_connect_data, padding9) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, padding9));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->padding9) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->padding9));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingA) == 144, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingA));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingA) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingA));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingB) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingB));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingB) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingB));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingC) == 160, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingC));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingC) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingC));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingD) == 168, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingD));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingD) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingD));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingE) == 176, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingE));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingE) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingE));
	LASSERTF((int)offsetof(struct obd_connect_data, paddingF) == 184, "found %lld\n",
		 (long long)(int)offsetof(struct obd_connect_data, paddingF));
	LASSERTF((int)sizeof(((struct obd_connect_data *)0)->paddingF) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_connect_data *)0)->paddingF));
	LASSERTF(OBD_CONNECT_RDONLY == 0x1ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_RDONLY);
	LASSERTF(OBD_CONNECT_INDEX == 0x2ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_INDEX);
	LASSERTF(OBD_CONNECT_MDS == 0x4ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MDS);
	LASSERTF(OBD_CONNECT_GRANT == 0x8ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_GRANT);
	LASSERTF(OBD_CONNECT_SRVLOCK == 0x10ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SRVLOCK);
	LASSERTF(OBD_CONNECT_VERSION == 0x20ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_VERSION);
	LASSERTF(OBD_CONNECT_REQPORTAL == 0x40ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_REQPORTAL);
	LASSERTF(OBD_CONNECT_ACL == 0x80ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_ACL);
	LASSERTF(OBD_CONNECT_XATTR == 0x100ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_XATTR);
	LASSERTF(OBD_CONNECT_LARGE_ACL == 0x200ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LARGE_ACL);
	LASSERTF(OBD_CONNECT_TRUNCLOCK == 0x400ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_TRUNCLOCK);
	LASSERTF(OBD_CONNECT_TRANSNO == 0x800ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_TRANSNO);
	LASSERTF(OBD_CONNECT_IBITS == 0x1000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_IBITS);
	LASSERTF(OBD_CONNECT_BARRIER == 0x2000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_BARRIER);
	LASSERTF(OBD_CONNECT_ATTRFID == 0x4000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_ATTRFID);
	LASSERTF(OBD_CONNECT_NODEVOH == 0x8000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_NODEVOH);
	LASSERTF(OBD_CONNECT_RMT_CLIENT == 0x10000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_RMT_CLIENT);
	LASSERTF(OBD_CONNECT_RMT_CLIENT_FORCE == 0x20000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_RMT_CLIENT_FORCE);
	LASSERTF(OBD_CONNECT_BRW_SIZE == 0x40000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_BRW_SIZE);
	LASSERTF(OBD_CONNECT_QUOTA64 == 0x80000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_QUOTA64);
	LASSERTF(OBD_CONNECT_MDS_CAPA == 0x100000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MDS_CAPA);
	LASSERTF(OBD_CONNECT_OSS_CAPA == 0x200000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_OSS_CAPA);
	LASSERTF(OBD_CONNECT_CANCELSET == 0x400000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CANCELSET);
	LASSERTF(OBD_CONNECT_SOM == 0x800000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SOM);
	LASSERTF(OBD_CONNECT_AT == 0x1000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_AT);
	LASSERTF(OBD_CONNECT_LRU_RESIZE == 0x2000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LRU_RESIZE);
	LASSERTF(OBD_CONNECT_MDS_MDS == 0x4000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MDS_MDS);
	LASSERTF(OBD_CONNECT_REAL == 0x8000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_REAL);
	LASSERTF(OBD_CONNECT_CHANGE_QS == 0x10000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CHANGE_QS);
	LASSERTF(OBD_CONNECT_CKSUM == 0x20000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_CKSUM);
	LASSERTF(OBD_CONNECT_FID == 0x40000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FID);
	LASSERTF(OBD_CONNECT_VBR == 0x80000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_VBR);
	LASSERTF(OBD_CONNECT_LOV_V3 == 0x100000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LOV_V3);
	LASSERTF(OBD_CONNECT_GRANT_SHRINK == 0x200000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_GRANT_SHRINK);
	LASSERTF(OBD_CONNECT_SKIP_ORPHAN == 0x400000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SKIP_ORPHAN);
	LASSERTF(OBD_CONNECT_MAX_EASIZE == 0x800000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MAX_EASIZE);
	LASSERTF(OBD_CONNECT_FULL20 == 0x1000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FULL20);
	LASSERTF(OBD_CONNECT_LAYOUTLOCK == 0x2000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LAYOUTLOCK);
	LASSERTF(OBD_CONNECT_64BITHASH == 0x4000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_64BITHASH);
	LASSERTF(OBD_CONNECT_MAXBYTES == 0x8000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MAXBYTES);
	LASSERTF(OBD_CONNECT_IMP_RECOV == 0x10000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_IMP_RECOV);
	LASSERTF(OBD_CONNECT_JOBSTATS == 0x20000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_JOBSTATS);
	LASSERTF(OBD_CONNECT_UMASK == 0x40000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_UMASK);
	LASSERTF(OBD_CONNECT_EINPROGRESS == 0x80000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_EINPROGRESS);
	LASSERTF(OBD_CONNECT_GRANT_PARAM == 0x100000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_GRANT_PARAM);
	LASSERTF(OBD_CONNECT_FLOCK_OWNER == 0x200000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FLOCK_OWNER);
	LASSERTF(OBD_CONNECT_LVB_TYPE == 0x400000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LVB_TYPE);
	LASSERTF(OBD_CONNECT_NANOSEC_TIME == 0x800000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_NANOSEC_TIME);
	LASSERTF(OBD_CONNECT_LIGHTWEIGHT == 0x1000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LIGHTWEIGHT);
	LASSERTF(OBD_CONNECT_SHORTIO == 0x2000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SHORTIO);
	LASSERTF(OBD_CONNECT_PINGLESS == 0x4000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_PINGLESS);
	LASSERTF(OBD_CONNECT_FLOCK_DEAD == 0x8000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FLOCK_DEAD);
	LASSERTF(OBD_CONNECT_OPEN_BY_FID == 0x20000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_OPEN_BY_FID);
	LASSERTF(OBD_CONNECT_LFSCK == 0x40000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LFSCK);
	LASSERTF(OBD_CONNECT_UNLINK_CLOSE == 0x100000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_UNLINK_CLOSE);
	LASSERTF(OBD_CONNECT_MULTIMODRPCS == 0x200000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_MULTIMODRPCS);
	LASSERTF(OBD_CONNECT_DIR_STRIPE == 0x400000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_DIR_STRIPE);
	LASSERTF(OBD_CONNECT_SUBTREE == 0x800000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_SUBTREE);
	LASSERTF(OBD_CONNECT_LOCK_AHEAD == 0x1000000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_LOCK_AHEAD);
	LASSERTF(OBD_CONNECT_BULK_MBITS == 0x2000000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_BULK_MBITS);
	LASSERTF(OBD_CONNECT_OBDOPACK == 0x4000000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_OBDOPACK);
	LASSERTF(OBD_CONNECT_FLAGS2 == 0x8000000000000000ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT_FLAGS2);
	LASSERTF(OBD_CONNECT2_FILE_SECCTX == 0x1ULL, "found 0x%.16llxULL\n",
		 OBD_CONNECT2_FILE_SECCTX);
	LASSERTF(OBD_CKSUM_CRC32 == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)OBD_CKSUM_CRC32);
	LASSERTF(OBD_CKSUM_ADLER == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)OBD_CKSUM_ADLER);
	LASSERTF(OBD_CKSUM_CRC32C == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)OBD_CKSUM_CRC32C);

	/* Checks for struct ost_layout */
	LASSERTF((int)sizeof(struct ost_layout) == 28, "found %lld\n",
		 (long long)(int)sizeof(struct ost_layout));
	LASSERTF((int)offsetof(struct ost_layout, ol_stripe_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_layout, ol_stripe_size));
	LASSERTF((int)sizeof(((struct ost_layout *)0)->ol_stripe_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_layout *)0)->ol_stripe_size));
	LASSERTF((int)offsetof(struct ost_layout, ol_stripe_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ost_layout, ol_stripe_count));
	LASSERTF((int)sizeof(((struct ost_layout *)0)->ol_stripe_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_layout *)0)->ol_stripe_count));
	LASSERTF((int)offsetof(struct ost_layout, ol_comp_start) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ost_layout, ol_comp_start));
	LASSERTF((int)sizeof(((struct ost_layout *)0)->ol_comp_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_layout *)0)->ol_comp_start));
	LASSERTF((int)offsetof(struct ost_layout, ol_comp_end) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ost_layout, ol_comp_end));
	LASSERTF((int)sizeof(((struct ost_layout *)0)->ol_comp_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_layout *)0)->ol_comp_end));
	LASSERTF((int)offsetof(struct ost_layout, ol_comp_id) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ost_layout, ol_comp_id));
	LASSERTF((int)sizeof(((struct ost_layout *)0)->ol_comp_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_layout *)0)->ol_comp_id));

	/* Checks for struct obdo */
	LASSERTF((int)sizeof(struct obdo) == 208, "found %lld\n",
		 (long long)(int)sizeof(struct obdo));
	LASSERTF((int)offsetof(struct obdo, o_valid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_valid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_valid));
	LASSERTF((int)offsetof(struct obdo, o_oi) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_oi));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_oi));
	LASSERTF((int)offsetof(struct obdo, o_parent_seq) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_parent_seq));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_parent_seq) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_parent_seq));
	LASSERTF((int)offsetof(struct obdo, o_size) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_size));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_size));
	LASSERTF((int)offsetof(struct obdo, o_mtime) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_mtime));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_mtime));
	LASSERTF((int)offsetof(struct obdo, o_atime) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_atime));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_atime));
	LASSERTF((int)offsetof(struct obdo, o_ctime) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_ctime));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_ctime));
	LASSERTF((int)offsetof(struct obdo, o_blocks) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_blocks));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_blocks));
	LASSERTF((int)offsetof(struct obdo, o_grant) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_grant));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_grant) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_grant));
	LASSERTF((int)offsetof(struct obdo, o_blksize) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_blksize));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_blksize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_blksize));
	LASSERTF((int)offsetof(struct obdo, o_mode) == 84, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_mode));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_mode));
	LASSERTF((int)offsetof(struct obdo, o_uid) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_uid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_uid));
	LASSERTF((int)offsetof(struct obdo, o_gid) == 92, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_gid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_gid));
	LASSERTF((int)offsetof(struct obdo, o_flags) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_flags));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_flags));
	LASSERTF((int)offsetof(struct obdo, o_nlink) == 100, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_nlink));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_nlink) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_nlink));
	LASSERTF((int)offsetof(struct obdo, o_parent_oid) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_parent_oid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_parent_oid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_parent_oid));
	LASSERTF((int)offsetof(struct obdo, o_misc) == 108, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_misc));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_misc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_misc));
	LASSERTF((int)offsetof(struct obdo, o_ioepoch) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_ioepoch));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_ioepoch) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_ioepoch));
	LASSERTF((int)offsetof(struct obdo, o_stripe_idx) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_stripe_idx));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_stripe_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_stripe_idx));
	LASSERTF((int)offsetof(struct obdo, o_parent_ver) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_parent_ver));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_parent_ver) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_parent_ver));
	LASSERTF((int)offsetof(struct obdo, o_handle) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_handle));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_handle));
	LASSERTF((int)offsetof(struct obdo, o_layout) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_layout));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_layout) == 28, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_layout));
	LASSERTF((int)offsetof(struct obdo, o_padding_3) == 164, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_3));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_3));
	LASSERTF((int)offsetof(struct obdo, o_uid_h) == 168, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_uid_h));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_uid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_uid_h));
	LASSERTF((int)offsetof(struct obdo, o_gid_h) == 172, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_gid_h));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_gid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_gid_h));
	LASSERTF((int)offsetof(struct obdo, o_data_version) == 176, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_data_version));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_data_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_data_version));
	LASSERTF((int)offsetof(struct obdo, o_projid) == 184, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_projid));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_projid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_projid));
	LASSERTF((int)offsetof(struct obdo, o_padding_4) == 188, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_4));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_4));
	LASSERTF((int)offsetof(struct obdo, o_padding_5) == 192, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_5));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_5));
	LASSERTF((int)offsetof(struct obdo, o_padding_6) == 200, "found %lld\n",
		 (long long)(int)offsetof(struct obdo, o_padding_6));
	LASSERTF((int)sizeof(((struct obdo *)0)->o_padding_6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obdo *)0)->o_padding_6));
	LASSERTF(OBD_MD_FLID == (0x00000001ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLID);
	LASSERTF(OBD_MD_FLATIME == (0x00000002ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLATIME);
	LASSERTF(OBD_MD_FLMTIME == (0x00000004ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMTIME);
	LASSERTF(OBD_MD_FLCTIME == (0x00000008ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCTIME);
	LASSERTF(OBD_MD_FLSIZE == (0x00000010ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLSIZE);
	LASSERTF(OBD_MD_FLBLOCKS == (0x00000020ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLBLOCKS);
	LASSERTF(OBD_MD_FLBLKSZ == (0x00000040ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLBLKSZ);
	LASSERTF(OBD_MD_FLMODE == (0x00000080ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMODE);
	LASSERTF(OBD_MD_FLTYPE == (0x00000100ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLTYPE);
	LASSERTF(OBD_MD_FLUID == (0x00000200ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLUID);
	LASSERTF(OBD_MD_FLGID == (0x00000400ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGID);
	LASSERTF(OBD_MD_FLFLAGS == (0x00000800ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLFLAGS);
	LASSERTF(OBD_MD_FLNLINK == (0x00002000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLNLINK);
	LASSERTF(OBD_MD_FLGENER == (0x00004000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGENER);
	LASSERTF(OBD_MD_FLRDEV == (0x00010000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLRDEV);
	LASSERTF(OBD_MD_FLEASIZE == (0x00020000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLEASIZE);
	LASSERTF(OBD_MD_LINKNAME == (0x00040000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_LINKNAME);
	LASSERTF(OBD_MD_FLHANDLE == (0x00080000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLHANDLE);
	LASSERTF(OBD_MD_FLCKSUM == (0x00100000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCKSUM);
	LASSERTF(OBD_MD_FLQOS == (0x00200000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLQOS);
	LASSERTF(OBD_MD_FLGROUP == (0x01000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGROUP);
	LASSERTF(OBD_MD_FLFID == (0x02000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLFID);
	LASSERTF(OBD_MD_FLEPOCH == (0x04000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLEPOCH);
	LASSERTF(OBD_MD_FLGRANT == (0x08000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGRANT);
	LASSERTF(OBD_MD_FLDIREA == (0x10000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLDIREA);
	LASSERTF(OBD_MD_FLUSRQUOTA == (0x20000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLUSRQUOTA);
	LASSERTF(OBD_MD_FLGRPQUOTA == (0x40000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGRPQUOTA);
	LASSERTF(OBD_MD_FLMODEASIZE == (0x80000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMODEASIZE);
	LASSERTF(OBD_MD_MDS == (0x0000000100000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_MDS);
	LASSERTF(OBD_MD_REINT == (0x0000000200000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_REINT);
	LASSERTF(OBD_MD_MEA == (0x0000000400000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_MEA);
	LASSERTF(OBD_MD_TSTATE == (0x0000000800000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_TSTATE);
	LASSERTF(OBD_MD_FLXATTR == (0x0000001000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLXATTR);
	LASSERTF(OBD_MD_FLXATTRLS == (0x0000002000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLXATTRLS);
	LASSERTF(OBD_MD_FLXATTRRM == (0x0000004000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLXATTRRM);
	LASSERTF(OBD_MD_FLACL == (0x0000008000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLACL);
	LASSERTF(OBD_MD_FLMDSCAPA == (0x0000020000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLMDSCAPA);
	LASSERTF(OBD_MD_FLOSSCAPA == (0x0000040000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLOSSCAPA);
	LASSERTF(OBD_MD_FLCKSPLIT == (0x0000080000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCKSPLIT);
	LASSERTF(OBD_MD_FLCROSSREF == (0x0000100000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLCROSSREF);
	LASSERTF(OBD_MD_FLGETATTRLOCK == (0x0000200000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLGETATTRLOCK);
	LASSERTF(OBD_MD_FLDATAVERSION == (0x0010000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLDATAVERSION);
	LASSERTF(OBD_MD_CLOSE_INTENT_EXECED == (0x0020000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_CLOSE_INTENT_EXECED);
	LASSERTF(OBD_MD_DEFAULT_MEA == (0x0040000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_DEFAULT_MEA);
	LASSERTF(OBD_MD_FLOSTLAYOUT == (0x0080000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLOSTLAYOUT);

	LASSERTF(OBD_MD_FLPROJID == (0x0100000000000000ULL), "found 0x%.16llxULL\n",
		 OBD_MD_FLPROJID);
	CLASSERT(OBD_FL_INLINEDATA == 0x00000001);
	CLASSERT(OBD_FL_OBDMDEXISTS == 0x00000002);
	CLASSERT(OBD_FL_DELORPHAN == 0x00000004);
	CLASSERT(OBD_FL_NORPC == 0x00000008);
	CLASSERT(OBD_FL_IDONLY == 0x00000010);
	CLASSERT(OBD_FL_RECREATE_OBJS == 0x00000020);
	CLASSERT(OBD_FL_DEBUG_CHECK == 0x00000040);
	CLASSERT(OBD_FL_NO_USRQUOTA == 0x00000100);
	CLASSERT(OBD_FL_NO_GRPQUOTA == 0x00000200);
	CLASSERT(OBD_FL_CREATE_CROW == 0x00000400);
	CLASSERT(OBD_FL_SRVLOCK == 0x00000800);
	CLASSERT(OBD_FL_CKSUM_CRC32 == 0x00001000);
	CLASSERT(OBD_FL_CKSUM_ADLER == 0x00002000);
	CLASSERT(OBD_FL_CKSUM_CRC32C == 0x00004000);
	CLASSERT(OBD_FL_CKSUM_RSVD2 == 0x00008000);
	CLASSERT(OBD_FL_CKSUM_RSVD3 == 0x00010000);
	CLASSERT(OBD_FL_SHRINK_GRANT == 0x00020000);
	CLASSERT(OBD_FL_MMAP == 0x00040000);
	CLASSERT(OBD_FL_RECOV_RESEND == 0x00080000);
	CLASSERT(OBD_FL_NOSPC_BLK == 0x00100000);
	CLASSERT(OBD_FL_FLUSH == 0x00200000);
	CLASSERT(OBD_FL_SHORT_IO == 0x00400000);

	/* Checks for struct lov_ost_data_v1 */
	LASSERTF((int)sizeof(struct lov_ost_data_v1) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct lov_ost_data_v1));
	LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_oi) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_oi));
	LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_oi));
	LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_gen) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_gen));
	LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_gen));
	LASSERTF((int)offsetof(struct lov_ost_data_v1, l_ost_idx) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lov_ost_data_v1, l_ost_idx));
	LASSERTF((int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_ost_data_v1 *)0)->l_ost_idx));

	/* Checks for struct lov_mds_md_v1 */
	LASSERTF((int)sizeof(struct lov_mds_md_v1) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lov_mds_md_v1));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_magic));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_magic));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_pattern));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_pattern));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_oi) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_oi));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_oi));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_stripe_size) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_stripe_size));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_size));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_stripe_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_stripe_count));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_stripe_count));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_layout_gen) == 30, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_layout_gen));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_layout_gen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_layout_gen));
	LASSERTF((int)offsetof(struct lov_mds_md_v1, lmm_objects[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v1, lmm_objects[0]));
	LASSERTF((int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_objects[0]) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v1 *)0)->lmm_objects[0]));
	CLASSERT(LOV_MAGIC_V1 == (0x0BD10000 | 0x0BD0));

	/* Checks for struct lov_mds_md_v3 */
	LASSERTF((int)sizeof(struct lov_mds_md_v3) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct lov_mds_md_v3));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_magic));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_magic));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_pattern));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pattern));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_oi) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_oi));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_oi));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_stripe_size) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_stripe_size));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_size));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_stripe_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_stripe_count));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_stripe_count));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_layout_gen) == 30, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_layout_gen));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_layout_gen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_layout_gen));
	CLASSERT(LOV_MAXPOOLNAME == 15);
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_pool_name[15 + 1]) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_pool_name[15 + 1]));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pool_name[15 + 1]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_pool_name[15 + 1]));
	LASSERTF((int)offsetof(struct lov_mds_md_v3, lmm_objects[0]) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lov_mds_md_v3, lmm_objects[0]));
	LASSERTF((int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_objects[0]) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_mds_md_v3 *)0)->lmm_objects[0]));
	CLASSERT(LOV_MAGIC_V3 == (0x0BD30000 | 0x0BD0));
	LASSERTF(LOV_PATTERN_RAID0 == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_RAID0);
	LASSERTF(LOV_PATTERN_RAID1 == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_RAID1);
	LASSERTF(LOV_PATTERN_FIRST == 0x00000100UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_FIRST);
	LASSERTF(LOV_PATTERN_CMOBD == 0x00000200UL, "found 0x%.8xUL\n",
		(unsigned)LOV_PATTERN_CMOBD);

	/* Checks for struct lov_comp_md_entry_v1 */
	LASSERTF((int)sizeof(struct lov_comp_md_entry_v1) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct lov_comp_md_entry_v1));
	LASSERTF((int)offsetof(struct lov_comp_md_entry_v1, lcme_id) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_entry_v1, lcme_id));
	LASSERTF((int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_id));
	LASSERTF((int)offsetof(struct lov_comp_md_entry_v1, lcme_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_entry_v1, lcme_flags));
	LASSERTF((int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_flags));
	LASSERTF((int)offsetof(struct lov_comp_md_entry_v1, lcme_extent) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_entry_v1, lcme_extent));
	LASSERTF((int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_extent));
	LASSERTF((int)offsetof(struct lov_comp_md_entry_v1, lcme_offset) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_entry_v1, lcme_offset));
	LASSERTF((int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_offset) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_offset));
	LASSERTF((int)offsetof(struct lov_comp_md_entry_v1, lcme_size) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_entry_v1, lcme_size));
	LASSERTF((int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_size));
	LASSERTF((int)offsetof(struct lov_comp_md_entry_v1, lcme_padding) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_entry_v1, lcme_padding));
	LASSERTF((int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_padding) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_entry_v1 *)0)->lcme_padding));
	LASSERTF(LCME_FL_INIT == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)LCME_FL_INIT);

	/* Checks for struct lov_comp_md_v1 */
	LASSERTF((int)sizeof(struct lov_comp_md_v1) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lov_comp_md_v1));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_magic));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_magic));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_size) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_size));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_size));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_layout_gen) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_layout_gen));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_layout_gen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_layout_gen));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_flags) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_flags));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_flags));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_entry_count) == 14, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_entry_count));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_entry_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_entry_count));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_padding1) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_padding1));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_padding1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_padding1));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_padding2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_padding2));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_padding2));
	LASSERTF((int)offsetof(struct lov_comp_md_v1, lcm_entries[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lov_comp_md_v1, lcm_entries[0]));
	LASSERTF((int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_entries[0]) == 48, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_comp_md_v1 *)0)->lcm_entries[0]));
	CLASSERT(LOV_MAGIC_COMP_V1 == (0x0BD60000 | 0x0BD0));

	/* Checks for struct lmv_mds_md_v1 */
	LASSERTF((int)sizeof(struct lmv_mds_md_v1) == 56, "found %lld\n",
		 (long long)(int)sizeof(struct lmv_mds_md_v1));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_magic));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_magic));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_stripe_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_stripe_count));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_stripe_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_stripe_count));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_master_mdt_index) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_master_mdt_index));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_master_mdt_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_master_mdt_index));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_hash_type) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_hash_type));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_hash_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_hash_type));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_layout_version) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_layout_version));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_layout_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_layout_version));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_padding1) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_padding1));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_padding1));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_padding2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_padding2));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_padding2));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_padding3) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_padding3));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_padding3));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_pool_name[15]) == 55, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_pool_name[15]));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_pool_name[15]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_pool_name[15]));
	LASSERTF((int)offsetof(struct lmv_mds_md_v1, lmv_stripe_fids[0]) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_mds_md_v1, lmv_stripe_fids[0]));
	LASSERTF((int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_stripe_fids[0]) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_mds_md_v1 *)0)->lmv_stripe_fids[0]));
	CLASSERT(LMV_MAGIC_V1 == 0x0CD20CD0);
	CLASSERT(LMV_MAGIC_STRIPE == 0x0CD40CD0);
	CLASSERT(LMV_HASH_TYPE_MASK == 0x0000ffff);
	CLASSERT(LMV_HASH_FLAG_MIGRATION == 0x80000000);
	CLASSERT(LMV_HASH_FLAG_DEAD == 0x40000000);
	CLASSERT(LMV_HASH_FLAG_BAD_TYPE == 0x20000000);
	CLASSERT(LMV_HASH_FLAG_LOST_LMV == 0x10000000);

	/* Checks for struct obd_statfs */
	LASSERTF((int)sizeof(struct obd_statfs) == 144, "found %lld\n",
		 (long long)(int)sizeof(struct obd_statfs));
	LASSERTF((int)offsetof(struct obd_statfs, os_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_type));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_type) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_type));
	LASSERTF((int)offsetof(struct obd_statfs, os_blocks) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_blocks));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_blocks));
	LASSERTF((int)offsetof(struct obd_statfs, os_bfree) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_bfree));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bfree) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bfree));
	LASSERTF((int)offsetof(struct obd_statfs, os_bavail) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_bavail));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bavail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bavail));
	LASSERTF((int)offsetof(struct obd_statfs, os_ffree) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_ffree));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_ffree) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_ffree));
	LASSERTF((int)offsetof(struct obd_statfs, os_fsid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_fsid));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_fsid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_fsid));
	LASSERTF((int)offsetof(struct obd_statfs, os_bsize) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_bsize));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_bsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_bsize));
	LASSERTF((int)offsetof(struct obd_statfs, os_namelen) == 92, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_namelen));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_namelen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_namelen));
	LASSERTF((int)offsetof(struct obd_statfs, os_state) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_state));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_state) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_state));
	LASSERTF((int)offsetof(struct obd_statfs, os_fprecreated) == 108, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_fprecreated));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_fprecreated) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_fprecreated));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare2) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare2));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare2));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare3) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare3));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare3));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare4) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare4));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare4));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare5) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare5));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare5));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare6) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare6));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare6));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare7) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare7));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare7));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare8) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare8));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare8));
	LASSERTF((int)offsetof(struct obd_statfs, os_spare9) == 140, "found %lld\n",
		 (long long)(int)offsetof(struct obd_statfs, os_spare9));
	LASSERTF((int)sizeof(((struct obd_statfs *)0)->os_spare9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_statfs *)0)->os_spare9));

	/* Checks for struct obd_ioobj */
	LASSERTF((int)sizeof(struct obd_ioobj) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct obd_ioobj));
	LASSERTF((int)offsetof(struct obd_ioobj, ioo_oid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_ioobj, ioo_oid));
	LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_oid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_oid));
	LASSERTF((int)offsetof(struct obd_ioobj, ioo_max_brw) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_ioobj, ioo_max_brw));
	LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_max_brw) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_max_brw));
	LASSERTF((int)offsetof(struct obd_ioobj, ioo_bufcnt) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct obd_ioobj, ioo_bufcnt));
	LASSERTF((int)sizeof(((struct obd_ioobj *)0)->ioo_bufcnt) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_ioobj *)0)->ioo_bufcnt));
	LASSERTF(IOOBJ_MAX_BRW_BITS == 16, "found %lld\n",
		 (long long)IOOBJ_MAX_BRW_BITS);

	/* Checks for union lquota_id */
	LASSERTF((int)sizeof(union lquota_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(union lquota_id));

	LASSERTF(QUOTABLOCK_BITS == 10, "found %lld\n",
		 (long long)QUOTABLOCK_BITS);
	LASSERTF(QUOTABLOCK_SIZE == 1024, "found %lld\n",
		 (long long)QUOTABLOCK_SIZE);

	/* Checks for struct obd_quotactl */
	LASSERTF((int)sizeof(struct obd_quotactl) == 112, "found %lld\n",
		 (long long)(int)sizeof(struct obd_quotactl));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_cmd) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_cmd));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_cmd) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_cmd));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_type) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_type));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_type));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_id));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_id));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_stat) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_stat));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_stat) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_stat));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_dqinfo) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_dqinfo));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_dqinfo) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_dqinfo));
	LASSERTF((int)offsetof(struct obd_quotactl, qc_dqblk) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_quotactl, qc_dqblk));
	LASSERTF((int)sizeof(((struct obd_quotactl *)0)->qc_dqblk) == 72, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_quotactl *)0)->qc_dqblk));

	/* Checks for struct obd_dqinfo */
	LASSERTF((int)sizeof(struct obd_dqinfo) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct obd_dqinfo));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_bgrace) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_bgrace));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_bgrace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_bgrace));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_igrace) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_igrace));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_igrace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_igrace));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_flags));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_flags));
	LASSERTF((int)offsetof(struct obd_dqinfo, dqi_valid) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqinfo, dqi_valid));
	LASSERTF((int)sizeof(((struct obd_dqinfo *)0)->dqi_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqinfo *)0)->dqi_valid));

	/* Checks for struct obd_dqblk */
	LASSERTF((int)sizeof(struct obd_dqblk) == 72, "found %lld\n",
		 (long long)(int)sizeof(struct obd_dqblk));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_bhardlimit) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_bhardlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_bhardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_bhardlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_bsoftlimit) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_bsoftlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_bsoftlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_bsoftlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_curspace) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_curspace));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_curspace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_curspace));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_ihardlimit) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_ihardlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_ihardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_ihardlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_isoftlimit) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_isoftlimit));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_isoftlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_isoftlimit));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_curinodes) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_curinodes));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_curinodes) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_curinodes));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_btime) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_btime));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_btime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_btime));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_itime) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_itime));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_itime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_itime));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_valid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_valid));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_valid));
	LASSERTF((int)offsetof(struct obd_dqblk, dqb_padding) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct obd_dqblk, dqb_padding));
	LASSERTF((int)sizeof(((struct obd_dqblk *)0)->dqb_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct obd_dqblk *)0)->dqb_padding));
	LASSERTF(Q_QUOTACHECK == 0x800100, "found 0x%.8x\n",
		Q_QUOTACHECK);
	LASSERTF(Q_INITQUOTA == 0x800101, "found 0x%.8x\n",
		Q_INITQUOTA);
	LASSERTF(Q_GETOINFO == 0x800102, "found 0x%.8x\n",
		Q_GETOINFO);
	LASSERTF(Q_GETOQUOTA == 0x800103, "found 0x%.8x\n",
		Q_GETOQUOTA);
	LASSERTF(Q_FINVALIDATE == 0x800104, "found 0x%.8x\n",
		Q_FINVALIDATE);

	/* Checks for struct lquota_acct_rec */
	LASSERTF((int)sizeof(struct lquota_acct_rec) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct lquota_acct_rec));
	LASSERTF((int)offsetof(struct lquota_acct_rec, bspace) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_acct_rec, bspace));
	LASSERTF((int)sizeof(((struct lquota_acct_rec *)0)->bspace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_acct_rec *)0)->bspace));
	LASSERTF((int)offsetof(struct lquota_acct_rec, ispace) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_acct_rec, ispace));
	LASSERTF((int)sizeof(((struct lquota_acct_rec *)0)->ispace) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_acct_rec *)0)->ispace));

	/* Checks for struct lquota_glb_rec */
	LASSERTF((int)sizeof(struct lquota_glb_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lquota_glb_rec));
	LASSERTF((int)offsetof(struct lquota_glb_rec, qbr_hardlimit) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_glb_rec, qbr_hardlimit));
	LASSERTF((int)sizeof(((struct lquota_glb_rec *)0)->qbr_hardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_glb_rec *)0)->qbr_hardlimit));
	LASSERTF((int)offsetof(struct lquota_glb_rec, qbr_softlimit) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_glb_rec, qbr_softlimit));
	LASSERTF((int)sizeof(((struct lquota_glb_rec *)0)->qbr_softlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_glb_rec *)0)->qbr_softlimit));
	LASSERTF((int)offsetof(struct lquota_glb_rec, qbr_time) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_glb_rec, qbr_time));
	LASSERTF((int)sizeof(((struct lquota_glb_rec *)0)->qbr_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_glb_rec *)0)->qbr_time));
	LASSERTF((int)offsetof(struct lquota_glb_rec, qbr_granted) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_glb_rec, qbr_granted));
	LASSERTF((int)sizeof(((struct lquota_glb_rec *)0)->qbr_granted) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_glb_rec *)0)->qbr_granted));

	/* Checks for struct lquota_slv_rec */
	LASSERTF((int)sizeof(struct lquota_slv_rec) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct lquota_slv_rec));
	LASSERTF((int)offsetof(struct lquota_slv_rec, qsr_granted) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_slv_rec, qsr_granted));
	LASSERTF((int)sizeof(((struct lquota_slv_rec *)0)->qsr_granted) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_slv_rec *)0)->qsr_granted));

	/* Checks for struct idx_info */
	LASSERTF((int)sizeof(struct idx_info) == 80, "found %lld\n",
		 (long long)(int)sizeof(struct idx_info));
	LASSERTF((int)offsetof(struct idx_info, ii_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_magic));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_magic));
	LASSERTF((int)offsetof(struct idx_info, ii_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_flags));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_flags));
	LASSERTF((int)offsetof(struct idx_info, ii_count) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_count));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_count));
	LASSERTF((int)offsetof(struct idx_info, ii_pad0) == 10, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_pad0));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_pad0) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_pad0));
	LASSERTF((int)offsetof(struct idx_info, ii_attrs) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_attrs));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_attrs) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_attrs));
	LASSERTF((int)offsetof(struct idx_info, ii_fid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_fid));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_fid));
	LASSERTF((int)offsetof(struct idx_info, ii_version) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_version));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_version));
	LASSERTF((int)offsetof(struct idx_info, ii_hash_start) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_hash_start));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_hash_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_hash_start));
	LASSERTF((int)offsetof(struct idx_info, ii_hash_end) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_hash_end));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_hash_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_hash_end));
	LASSERTF((int)offsetof(struct idx_info, ii_keysize) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_keysize));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_keysize) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_keysize));
	LASSERTF((int)offsetof(struct idx_info, ii_recsize) == 58, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_recsize));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_recsize) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_recsize));
	LASSERTF((int)offsetof(struct idx_info, ii_pad1) == 60, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_pad1));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_pad1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_pad1));
	LASSERTF((int)offsetof(struct idx_info, ii_pad2) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_pad2));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_pad2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_pad2));
	LASSERTF((int)offsetof(struct idx_info, ii_pad3) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct idx_info, ii_pad3));
	LASSERTF((int)sizeof(((struct idx_info *)0)->ii_pad3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct idx_info *)0)->ii_pad3));
	CLASSERT(IDX_INFO_MAGIC == 0x3D37CC37);

	/* Checks for struct lu_idxpage */
	LASSERTF((int)sizeof(struct lu_idxpage) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct lu_idxpage));
	LASSERTF((int)offsetof(struct lu_idxpage, lip_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_idxpage, lip_magic));
	LASSERTF((int)sizeof(((struct lu_idxpage *)0)->lip_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_idxpage *)0)->lip_magic));
	LASSERTF((int)offsetof(struct lu_idxpage, lip_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lu_idxpage, lip_flags));
	LASSERTF((int)sizeof(((struct lu_idxpage *)0)->lip_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_idxpage *)0)->lip_flags));
	LASSERTF((int)offsetof(struct lu_idxpage, lip_nr) == 6, "found %lld\n",
		 (long long)(int)offsetof(struct lu_idxpage, lip_nr));
	LASSERTF((int)sizeof(((struct lu_idxpage *)0)->lip_nr) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_idxpage *)0)->lip_nr));
	LASSERTF((int)offsetof(struct lu_idxpage, lip_pad0) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lu_idxpage, lip_pad0));
	LASSERTF((int)sizeof(((struct lu_idxpage *)0)->lip_pad0) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_idxpage *)0)->lip_pad0));
	CLASSERT(LIP_MAGIC == 0x8A6D6B6C);
	LASSERTF(LIP_HDR_SIZE == 16, "found %lld\n",
		 (long long)LIP_HDR_SIZE);
	LASSERTF(II_FL_NOHASH == 1, "found %lld\n",
		 (long long)II_FL_NOHASH);
	LASSERTF(II_FL_VARKEY == 2, "found %lld\n",
		 (long long)II_FL_VARKEY);
	LASSERTF(II_FL_VARREC == 4, "found %lld\n",
		 (long long)II_FL_VARREC);
	LASSERTF(II_FL_NONUNQ == 8, "found %lld\n",
		 (long long)II_FL_NONUNQ);

	/* Checks for struct niobuf_remote */
	LASSERTF((int)sizeof(struct niobuf_remote) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct niobuf_remote));
	LASSERTF((int)offsetof(struct niobuf_remote, rnb_offset) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct niobuf_remote, rnb_offset));
	LASSERTF((int)sizeof(((struct niobuf_remote *)0)->rnb_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct niobuf_remote *)0)->rnb_offset));
	LASSERTF((int)offsetof(struct niobuf_remote, rnb_len) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct niobuf_remote, rnb_len));
	LASSERTF((int)sizeof(((struct niobuf_remote *)0)->rnb_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct niobuf_remote *)0)->rnb_len));
	LASSERTF((int)offsetof(struct niobuf_remote, rnb_flags) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct niobuf_remote, rnb_flags));
	LASSERTF((int)sizeof(((struct niobuf_remote *)0)->rnb_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct niobuf_remote *)0)->rnb_flags));
	LASSERTF(OBD_BRW_READ == 0x01, "found 0x%.8x\n",
		OBD_BRW_READ);
	LASSERTF(OBD_BRW_WRITE == 0x02, "found 0x%.8x\n",
		OBD_BRW_WRITE);
	LASSERTF(OBD_BRW_SYNC == 0x08, "found 0x%.8x\n",
		OBD_BRW_SYNC);
	LASSERTF(OBD_BRW_CHECK == 0x10, "found 0x%.8x\n",
		OBD_BRW_CHECK);
	LASSERTF(OBD_BRW_FROM_GRANT == 0x20, "found 0x%.8x\n",
		OBD_BRW_FROM_GRANT);
	LASSERTF(OBD_BRW_GRANTED == 0x40, "found 0x%.8x\n",
		OBD_BRW_GRANTED);
	LASSERTF(OBD_BRW_NOCACHE == 0x80, "found 0x%.8x\n",
		OBD_BRW_NOCACHE);
	LASSERTF(OBD_BRW_NOQUOTA == 0x100, "found 0x%.8x\n",
		OBD_BRW_NOQUOTA);
	LASSERTF(OBD_BRW_SRVLOCK == 0x200, "found 0x%.8x\n",
		OBD_BRW_SRVLOCK);
	LASSERTF(OBD_BRW_ASYNC == 0x400, "found 0x%.8x\n",
		OBD_BRW_ASYNC);
	LASSERTF(OBD_BRW_MEMALLOC == 0x800, "found 0x%.8x\n",
		OBD_BRW_MEMALLOC);
	LASSERTF(OBD_BRW_OVER_USRQUOTA == 0x1000, "found 0x%.8x\n",
		OBD_BRW_OVER_USRQUOTA);
	LASSERTF(OBD_BRW_OVER_GRPQUOTA == 0x2000, "found 0x%.8x\n",
		OBD_BRW_OVER_GRPQUOTA);
	LASSERTF(OBD_BRW_SOFT_SYNC == 0x4000, "found 0x%.8x\n",
		OBD_BRW_SOFT_SYNC);

	/* Checks for struct ost_body */
	LASSERTF((int)sizeof(struct ost_body) == 208, "found %lld\n",
		 (long long)(int)sizeof(struct ost_body));
	LASSERTF((int)offsetof(struct ost_body, oa) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_body, oa));
	LASSERTF((int)sizeof(((struct ost_body *)0)->oa) == 208, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_body *)0)->oa));

	/* Checks for struct ll_fid */
	LASSERTF((int)sizeof(struct ll_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct ll_fid));
	LASSERTF((int)offsetof(struct ll_fid, id) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fid, id));
	LASSERTF((int)sizeof(((struct ll_fid *)0)->id) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fid *)0)->id));
	LASSERTF((int)offsetof(struct ll_fid, generation) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fid, generation));
	LASSERTF((int)sizeof(((struct ll_fid *)0)->generation) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fid *)0)->generation));
	LASSERTF((int)offsetof(struct ll_fid, f_type) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fid, f_type));
	LASSERTF((int)sizeof(((struct ll_fid *)0)->f_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fid *)0)->f_type));

	/* Checks for struct mdt_body */
	LASSERTF((int)sizeof(struct mdt_body) == 216, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_body));
	LASSERTF((int)offsetof(struct mdt_body, mbo_fid1) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_fid1));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_fid1));
	LASSERTF((int)offsetof(struct mdt_body, mbo_fid2) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_fid2));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_fid2));
	LASSERTF((int)offsetof(struct mdt_body, mbo_handle) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_handle));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_handle));
	LASSERTF((int)offsetof(struct mdt_body, mbo_valid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_valid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_valid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_size) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_size));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_size));
	LASSERTF((int)offsetof(struct mdt_body, mbo_mtime) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_mtime));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_mtime));
	LASSERTF((int)offsetof(struct mdt_body, mbo_atime) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_atime));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_atime));
	LASSERTF((int)offsetof(struct mdt_body, mbo_ctime) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_ctime));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_ctime));
	LASSERTF((int)offsetof(struct mdt_body, mbo_blocks) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_blocks));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_blocks));
	LASSERTF((int)offsetof(struct mdt_body, mbo_t_state) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_t_state));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_t_state) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_t_state));
	LASSERTF((int)offsetof(struct mdt_body, mbo_fsuid) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_fsuid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_fsuid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_fsgid) == 108, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_fsgid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_fsgid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_capability) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_capability));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_capability) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_capability));
	LASSERTF((int)offsetof(struct mdt_body, mbo_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_mode));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_mode));
	LASSERTF((int)offsetof(struct mdt_body, mbo_uid) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_uid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_uid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_gid) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_gid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_gid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_flags) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_flags));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_flags));
	LASSERTF((int)offsetof(struct mdt_body, mbo_rdev) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_rdev));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_rdev) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_rdev));
	LASSERTF((int)offsetof(struct mdt_body, mbo_nlink) == 136, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_nlink));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_nlink) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_nlink));
	LASSERTF((int)offsetof(struct mdt_body, mbo_unused2) == 140, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_unused2));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_unused2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_unused2));
	LASSERTF((int)offsetof(struct mdt_body, mbo_suppgid) == 144, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_suppgid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_suppgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_suppgid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_eadatasize) == 148, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_eadatasize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_eadatasize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_eadatasize));
	LASSERTF((int)offsetof(struct mdt_body, mbo_aclsize) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_aclsize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_aclsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_aclsize));
	LASSERTF((int)offsetof(struct mdt_body, mbo_max_mdsize) == 156, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_max_mdsize));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_max_mdsize) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_max_mdsize));
	LASSERTF((int)offsetof(struct mdt_body, mbo_unused3) == 160, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_unused3));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_unused3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_unused3));
	LASSERTF((int)offsetof(struct mdt_body, mbo_uid_h) == 164, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_uid_h));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_uid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_uid_h));
	LASSERTF((int)offsetof(struct mdt_body, mbo_gid_h) == 168, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_gid_h));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_gid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_gid_h));
	LASSERTF((int)offsetof(struct mdt_body, mbo_projid) == 172, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_projid));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_projid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_projid));
	LASSERTF((int)offsetof(struct mdt_body, mbo_padding_6) == 176, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_padding_6));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_padding_6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_padding_6));
	LASSERTF((int)offsetof(struct mdt_body, mbo_padding_7) == 184, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_padding_7));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_padding_7) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_padding_7));
	LASSERTF((int)offsetof(struct mdt_body, mbo_padding_8) == 192, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_padding_8));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_padding_8) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_padding_8));
	LASSERTF((int)offsetof(struct mdt_body, mbo_padding_9) == 200, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_padding_9));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_padding_9) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_padding_9));
	LASSERTF((int)offsetof(struct mdt_body, mbo_padding_10) == 208, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_body, mbo_padding_10));
	LASSERTF((int)sizeof(((struct mdt_body *)0)->mbo_padding_10) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_body *)0)->mbo_padding_10));
	LASSERTF(MDS_FMODE_CLOSED == 000000000000UL, "found 0%.11oUL\n",
		MDS_FMODE_CLOSED);
	LASSERTF(MDS_FMODE_EXEC == 000000000004UL, "found 0%.11oUL\n",
		MDS_FMODE_EXEC);
	LASSERTF(MDS_OPEN_CREATED == 000000000010UL, "found 0%.11oUL\n",
		MDS_OPEN_CREATED);
	LASSERTF(MDS_OPEN_CROSS == 000000000020UL, "found 0%.11oUL\n",
		MDS_OPEN_CROSS);
	LASSERTF(MDS_OPEN_CREAT == 000000000100UL, "found 0%.11oUL\n",
		MDS_OPEN_CREAT);
	LASSERTF(MDS_OPEN_EXCL == 000000000200UL, "found 0%.11oUL\n",
		MDS_OPEN_EXCL);
	LASSERTF(MDS_OPEN_TRUNC == 000000001000UL, "found 0%.11oUL\n",
		MDS_OPEN_TRUNC);
	LASSERTF(MDS_OPEN_APPEND == 000000002000UL, "found 0%.11oUL\n",
		MDS_OPEN_APPEND);
	LASSERTF(MDS_OPEN_SYNC == 000000010000UL, "found 0%.11oUL\n",
		MDS_OPEN_SYNC);
	LASSERTF(MDS_OPEN_DIRECTORY == 000000200000UL, "found 0%.11oUL\n",
		MDS_OPEN_DIRECTORY);
	LASSERTF(MDS_OPEN_BY_FID == 000040000000UL, "found 0%.11oUL\n",
		MDS_OPEN_BY_FID);
	LASSERTF(MDS_OPEN_DELAY_CREATE == 000100000000UL, "found 0%.11oUL\n",
		MDS_OPEN_DELAY_CREATE);
	LASSERTF(MDS_OPEN_OWNEROVERRIDE == 000200000000UL, "found 0%.11oUL\n",
		MDS_OPEN_OWNEROVERRIDE);
	LASSERTF(MDS_OPEN_JOIN_FILE == 000400000000UL, "found 0%.11oUL\n",
		MDS_OPEN_JOIN_FILE);
	LASSERTF(MDS_OPEN_LOCK == 004000000000UL, "found 0%.11oUL\n",
		MDS_OPEN_LOCK);
	LASSERTF(MDS_OPEN_HAS_EA == 010000000000UL, "found 0%.11oUL\n",
		MDS_OPEN_HAS_EA);
	LASSERTF(MDS_OPEN_HAS_OBJS == 020000000000UL, "found 0%.11oUL\n",
		MDS_OPEN_HAS_OBJS);
	LASSERTF(MDS_OPEN_NORESTORE == 00000000000100000000000ULL, "found 0%.22lloULL\n",
			(long long)MDS_OPEN_NORESTORE);
	LASSERTF(MDS_OPEN_NEWSTRIPE == 00000000000200000000000ULL, "found 0%.22lloULL\n",
			(long long)MDS_OPEN_NEWSTRIPE);
	LASSERTF(MDS_OPEN_VOLATILE == 00000000000400000000000ULL, "found 0%.22lloULL\n",
			(long long)MDS_OPEN_VOLATILE);
	LASSERTF(LUSTRE_SYNC_FL == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_SYNC_FL);
	LASSERTF(LUSTRE_IMMUTABLE_FL == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_IMMUTABLE_FL);
	LASSERTF(LUSTRE_APPEND_FL == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_APPEND_FL);
	LASSERTF(LUSTRE_NODUMP_FL == 0x00000040UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_NODUMP_FL);
	LASSERTF(LUSTRE_NOATIME_FL == 0x00000080UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_NOATIME_FL);
	LASSERTF(LUSTRE_INDEX_FL == 0x00001000UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_INDEX_FL);
	LASSERTF(LUSTRE_ORPHAN_FL == 0x00002000UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_ORPHAN_FL);
	LASSERTF(LUSTRE_DIRSYNC_FL == 0x00010000UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_DIRSYNC_FL);
	LASSERTF(LUSTRE_TOPDIR_FL == 0x00020000UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_TOPDIR_FL);
	LASSERTF(LUSTRE_DIRECTIO_FL == 0x00100000UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_DIRECTIO_FL);
	LASSERTF(LUSTRE_INLINE_DATA_FL == 0x10000000UL, "found 0x%.8xUL\n",
		(unsigned)LUSTRE_INLINE_DATA_FL);
	LASSERTF(MDS_INODELOCK_LOOKUP == 0x000001, "found 0x%.8x\n",
		MDS_INODELOCK_LOOKUP);
	LASSERTF(MDS_INODELOCK_UPDATE == 0x000002, "found 0x%.8x\n",
		MDS_INODELOCK_UPDATE);
	LASSERTF(MDS_INODELOCK_OPEN == 0x000004, "found 0x%.8x\n",
		MDS_INODELOCK_OPEN);
	LASSERTF(MDS_INODELOCK_LAYOUT == 0x000008, "found 0x%.8x\n",
		MDS_INODELOCK_LAYOUT);

	/* Checks for struct mdt_ioepoch */
	LASSERTF((int)sizeof(struct mdt_ioepoch) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_ioepoch));
	LASSERTF((int)offsetof(struct mdt_ioepoch, mio_handle) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, mio_handle));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->mio_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->mio_handle));
	LASSERTF((int)offsetof(struct mdt_ioepoch, mio_unused1) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, mio_unused1));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->mio_unused1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->mio_unused1));
	LASSERTF((int)offsetof(struct mdt_ioepoch, mio_unused2) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, mio_unused2));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->mio_unused2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->mio_unused2));
	LASSERTF((int)offsetof(struct mdt_ioepoch, mio_padding) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_ioepoch, mio_padding));
	LASSERTF((int)sizeof(((struct mdt_ioepoch *)0)->mio_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_ioepoch *)0)->mio_padding));

	/* Checks for struct mdt_rec_setattr */
	LASSERTF((int)sizeof(struct mdt_rec_setattr) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_setattr));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_cap));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_suppgid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_suppgid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_suppgid_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_suppgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_suppgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_1) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_1_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_1_h));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_fid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_fid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_fid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_valid) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_valid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_valid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_uid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_uid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_uid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_gid) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_gid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_gid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_size) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_size));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_size));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_blocks) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_blocks));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_blocks));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_mtime) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_mtime));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_mtime));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_atime) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_atime));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_atime));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_ctime) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_ctime));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_ctime));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_attr_flags) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_attr_flags));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_attr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_attr_flags));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_mode));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_bias) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_bias));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_projid) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_projid));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_projid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_projid));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_4) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_setattr, sa_padding_5) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setattr, sa_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setattr *)0)->sa_padding_5));

	/* Checks for struct mdt_rec_create */
	LASSERTF((int)sizeof(struct mdt_rec_create) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_create));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_cap));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_old_handle) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_old_handle));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_old_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_old_handle));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_time) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_time));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_time));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_rdev) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_rdev));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_rdev) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_rdev));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_ioepoch) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_ioepoch));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_ioepoch) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_ioepoch));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_padding_1) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_mode) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_mode));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_bias) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_bias));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_flags_l) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_flags_l));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_flags_l) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_flags_l));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_flags_h) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_flags_h));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_flags_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_flags_h));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_umask) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_umask));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_umask) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_umask));
	LASSERTF((int)offsetof(struct mdt_rec_create, cr_padding_4) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_create, cr_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_create *)0)->cr_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_create *)0)->cr_padding_4));

	/* Checks for struct mdt_rec_link */
	LASSERTF((int)sizeof(struct mdt_rec_link) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_link));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_cap));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_time));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_time));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_1) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_2) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_3) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_4) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_bias));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_5) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_6) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_7) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_8) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_8));
	LASSERTF((int)offsetof(struct mdt_rec_link, lk_padding_9) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_link, lk_padding_9));
	LASSERTF((int)sizeof(((struct mdt_rec_link *)0)->lk_padding_9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_link *)0)->lk_padding_9));

	/* Checks for struct mdt_rec_unlink */
	LASSERTF((int)sizeof(struct mdt_rec_unlink) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_unlink));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_cap));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_time));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_time));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_2) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_3) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_4) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_5) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_bias));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_mode));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_6) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_7) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_8) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_8));
	LASSERTF((int)offsetof(struct mdt_rec_unlink, ul_padding_9) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_unlink, ul_padding_9));
	LASSERTF((int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_unlink *)0)->ul_padding_9));

	/* Checks for struct mdt_rec_rename */
	LASSERTF((int)sizeof(struct mdt_rec_rename) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_rename));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_cap));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_time) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_time));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_time));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_1) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_2) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_3) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_4) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_4));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_bias));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_mode));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_5) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_5) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_6) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_6) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_7) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_7) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_rename, rn_padding_8) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_rename, rn_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_rename *)0)->rn_padding_8));

	/* Checks for struct mdt_rec_setxattr */
	LASSERTF((int)sizeof(struct mdt_rec_setxattr) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_setxattr));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_cap));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_fid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_fid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_fid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_1) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_1));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_1));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_2) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_2));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_2));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_3) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_3));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_3));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_valid) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_valid));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_valid));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_time) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_time));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_time));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_5) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_5));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_5));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_6) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_6));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_6));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_7) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_7));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_7) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_7));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_size) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_size));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_size));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_flags) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_flags));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_flags));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_8) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_8));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_8) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_8));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_9) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_9));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_9) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_9));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_10) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_10));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_10) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_10));
	LASSERTF((int)offsetof(struct mdt_rec_setxattr, sx_padding_11) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_setxattr, sx_padding_11));
	LASSERTF((int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_11) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_setxattr *)0)->sx_padding_11));

	/* Checks for struct mdt_rec_reint */
	LASSERTF((int)sizeof(struct mdt_rec_reint) == 136, "found %lld\n",
		 (long long)(int)sizeof(struct mdt_rec_reint));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_opcode) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_opcode));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_opcode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_opcode));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_cap) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_cap));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_cap) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_cap));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsuid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsuid));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsuid_h) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsuid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsuid_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsgid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsgid));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fsgid_h) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fsgid_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fsgid_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid1));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid1_h) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid1_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid1_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid2));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_suppgid2_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_suppgid2_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_suppgid2_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fid1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fid1));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fid1) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fid1));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_fid2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_fid2));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_fid2));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_mtime) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_mtime));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_mtime));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_atime) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_atime));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_atime));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_ctime) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_ctime));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_ctime));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_size) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_size));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_size));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_blocks) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_blocks));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_blocks));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_bias) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_bias));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_bias) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_bias));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_mode) == 116, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_mode));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_mode));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_flags) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_flags));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_flags));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_flags_h) == 124, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_flags_h));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_flags_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_flags_h));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_umask) == 128, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_umask));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_umask) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_umask));
	LASSERTF((int)offsetof(struct mdt_rec_reint, rr_padding_4) == 132, "found %lld\n",
		 (long long)(int)offsetof(struct mdt_rec_reint, rr_padding_4));
	LASSERTF((int)sizeof(((struct mdt_rec_reint *)0)->rr_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mdt_rec_reint *)0)->rr_padding_4));

	/* Checks for struct lmv_desc */
	LASSERTF((int)sizeof(struct lmv_desc) == 88, "found %lld\n",
		 (long long)(int)sizeof(struct lmv_desc));
	LASSERTF((int)offsetof(struct lmv_desc, ld_tgt_count) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_tgt_count));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_tgt_count));
	LASSERTF((int)offsetof(struct lmv_desc, ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_active_tgt_count));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_active_tgt_count));
	LASSERTF((int)offsetof(struct lmv_desc, ld_default_stripe_count) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_default_stripe_count));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_default_stripe_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_default_stripe_count));
	LASSERTF((int)offsetof(struct lmv_desc, ld_pattern) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_pattern));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_pattern));
	LASSERTF((int)offsetof(struct lmv_desc, ld_default_hash_size) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_default_hash_size));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_default_hash_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_default_hash_size));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_1) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_1));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_1));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_2) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_2));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_2));
	LASSERTF((int)offsetof(struct lmv_desc, ld_qos_maxage) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_qos_maxage));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_qos_maxage) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_qos_maxage));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_3) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_3));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_3));
	LASSERTF((int)offsetof(struct lmv_desc, ld_padding_4) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_padding_4));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_padding_4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_padding_4));
	LASSERTF((int)offsetof(struct lmv_desc, ld_uuid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lmv_desc, ld_uuid));
	LASSERTF((int)sizeof(((struct lmv_desc *)0)->ld_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct lmv_desc *)0)->ld_uuid));

	/* Checks for struct lov_desc */
	LASSERTF((int)sizeof(struct lov_desc) == 88, "found %lld\n",
		 (long long)(int)sizeof(struct lov_desc));
	LASSERTF((int)offsetof(struct lov_desc, ld_tgt_count) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_tgt_count));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_tgt_count));
	LASSERTF((int)offsetof(struct lov_desc, ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_active_tgt_count));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_active_tgt_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_active_tgt_count));
	LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_count) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_count));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_count));
	LASSERTF((int)offsetof(struct lov_desc, ld_pattern) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_pattern));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_pattern) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_pattern));
	LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_size) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_size));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_size));
	LASSERTF((int)offsetof(struct lov_desc, ld_default_stripe_offset) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_default_stripe_offset));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_default_stripe_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_default_stripe_offset));
	LASSERTF((int)offsetof(struct lov_desc, ld_padding_0) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_padding_0));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_0) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_0));
	LASSERTF((int)offsetof(struct lov_desc, ld_qos_maxage) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_qos_maxage));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_qos_maxage) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_qos_maxage));
	LASSERTF((int)offsetof(struct lov_desc, ld_padding_1) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_padding_1));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_1));
	LASSERTF((int)offsetof(struct lov_desc, ld_padding_2) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_padding_2));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_padding_2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_padding_2));
	LASSERTF((int)offsetof(struct lov_desc, ld_uuid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lov_desc, ld_uuid));
	LASSERTF((int)sizeof(((struct lov_desc *)0)->ld_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct lov_desc *)0)->ld_uuid));
	CLASSERT(LOV_DESC_MAGIC == 0xB0CCDE5C);

	/* Checks for struct ldlm_res_id */
	LASSERTF((int)sizeof(struct ldlm_res_id) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_res_id));
	CLASSERT(RES_NAME_SIZE == 4);
	LASSERTF((int)offsetof(struct ldlm_res_id, name[4]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_res_id, name[4]));
	LASSERTF((int)sizeof(((struct ldlm_res_id *)0)->name[4]) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_res_id *)0)->name[4]));

	/* Checks for struct ldlm_extent */
	LASSERTF((int)sizeof(struct ldlm_extent) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_extent));
	LASSERTF((int)offsetof(struct ldlm_extent, start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_extent, start));
	LASSERTF((int)sizeof(((struct ldlm_extent *)0)->start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_extent *)0)->start));
	LASSERTF((int)offsetof(struct ldlm_extent, end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_extent, end));
	LASSERTF((int)sizeof(((struct ldlm_extent *)0)->end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_extent *)0)->end));
	LASSERTF((int)offsetof(struct ldlm_extent, gid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_extent, gid));
	LASSERTF((int)sizeof(((struct ldlm_extent *)0)->gid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_extent *)0)->gid));

	/* Checks for struct ldlm_inodebits */
	LASSERTF((int)sizeof(struct ldlm_inodebits) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_inodebits));
	LASSERTF((int)offsetof(struct ldlm_inodebits, bits) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_inodebits, bits));
	LASSERTF((int)sizeof(((struct ldlm_inodebits *)0)->bits) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_inodebits *)0)->bits));

	/* Checks for struct ldlm_flock_wire */
	LASSERTF((int)sizeof(struct ldlm_flock_wire) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_flock_wire));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_start));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_start));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_end) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_end));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_end));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_owner) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_owner));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_owner) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_owner));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_padding) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_padding));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_padding));
	LASSERTF((int)offsetof(struct ldlm_flock_wire, lfw_pid) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_flock_wire, lfw_pid));
	LASSERTF((int)sizeof(((struct ldlm_flock_wire *)0)->lfw_pid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_flock_wire *)0)->lfw_pid));

	/* Checks for struct ldlm_intent */
	LASSERTF((int)sizeof(struct ldlm_intent) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_intent));
	LASSERTF((int)offsetof(struct ldlm_intent, opc) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_intent, opc));
	LASSERTF((int)sizeof(((struct ldlm_intent *)0)->opc) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_intent *)0)->opc));
	LASSERTF(IT_OPEN == 1, "found %lld\n",
		 (long long)IT_OPEN);
	LASSERTF(IT_CREAT == 2, "found %lld\n",
		 (long long)IT_CREAT);
	LASSERTF(IT_READDIR == 4, "found %lld\n",
		 (long long)IT_READDIR);
	LASSERTF(IT_GETATTR == 8, "found %lld\n",
		 (long long)IT_GETATTR);
	LASSERTF(IT_LOOKUP == 16, "found %lld\n",
		 (long long)IT_LOOKUP);
	LASSERTF(IT_UNLINK == 32, "found %lld\n",
		 (long long)IT_UNLINK);
	LASSERTF(IT_TRUNC == 64, "found %lld\n",
		 (long long)IT_TRUNC);
	LASSERTF(IT_GETXATTR == 128, "found %lld\n",
		 (long long)IT_GETXATTR);
	LASSERTF(IT_EXEC == 256, "found %lld\n",
		 (long long)IT_EXEC);
	LASSERTF(IT_PIN == 512, "found %lld\n",
		 (long long)IT_PIN);
	LASSERTF(IT_LAYOUT == 1024, "found %lld\n",
		 (long long)IT_LAYOUT);
	LASSERTF(IT_QUOTA_DQACQ == 2048, "found %lld\n",
		 (long long)IT_QUOTA_DQACQ);
	LASSERTF(IT_QUOTA_CONN == 4096, "found %lld\n",
		 (long long)IT_QUOTA_CONN);
	LASSERTF(IT_SETXATTR == 8192, "found %lld\n",
		 (long long)IT_SETXATTR);

	/* Checks for struct ldlm_resource_desc */
	LASSERTF((int)sizeof(struct ldlm_resource_desc) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_resource_desc));
	LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_resource_desc, lr_type));
	LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_type));
	LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_pad) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_resource_desc, lr_pad));
	LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_pad) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_pad));
	LASSERTF((int)offsetof(struct ldlm_resource_desc, lr_name) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_resource_desc, lr_name));
	LASSERTF((int)sizeof(((struct ldlm_resource_desc *)0)->lr_name) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_resource_desc *)0)->lr_name));

	/* Checks for struct ldlm_lock_desc */
	LASSERTF((int)sizeof(struct ldlm_lock_desc) == 80, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_lock_desc));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_resource) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_resource));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_resource) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_resource));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_req_mode) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_req_mode));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_req_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_req_mode));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_granted_mode) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_granted_mode));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_granted_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_granted_mode));
	LASSERTF((int)offsetof(struct ldlm_lock_desc, l_policy_data) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_lock_desc, l_policy_data));
	LASSERTF((int)sizeof(((struct ldlm_lock_desc *)0)->l_policy_data) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_lock_desc *)0)->l_policy_data));

	/* Checks for struct ldlm_request */
	LASSERTF((int)sizeof(struct ldlm_request) == 104, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_request));
	LASSERTF((int)offsetof(struct ldlm_request, lock_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_flags));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_flags));
	LASSERTF((int)offsetof(struct ldlm_request, lock_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_count));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_count));
	LASSERTF((int)offsetof(struct ldlm_request, lock_desc) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_desc));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_desc) == 80, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_desc));
	LASSERTF((int)offsetof(struct ldlm_request, lock_handle) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_request, lock_handle));
	LASSERTF((int)sizeof(((struct ldlm_request *)0)->lock_handle) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_request *)0)->lock_handle));

	/* Checks for struct ldlm_reply */
	LASSERTF((int)sizeof(struct ldlm_reply) == 112, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_reply));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_flags));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_flags));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_padding) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_padding));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_padding));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_desc) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_desc));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_desc) == 80, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_desc));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_handle) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_handle));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_handle) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_handle));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_policy_res1) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_policy_res1));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_policy_res1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_policy_res1));
	LASSERTF((int)offsetof(struct ldlm_reply, lock_policy_res2) == 104, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_reply, lock_policy_res2));
	LASSERTF((int)sizeof(((struct ldlm_reply *)0)->lock_policy_res2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_reply *)0)->lock_policy_res2));

	/* Checks for struct ost_lvb_v1 */
	LASSERTF((int)sizeof(struct ost_lvb_v1) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct ost_lvb_v1));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_size));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_size));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_mtime));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_mtime));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_atime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_atime));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_atime));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_ctime) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_ctime));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_ctime));
	LASSERTF((int)offsetof(struct ost_lvb_v1, lvb_blocks) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb_v1, lvb_blocks));
	LASSERTF((int)sizeof(((struct ost_lvb_v1 *)0)->lvb_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb_v1 *)0)->lvb_blocks));

	/* Checks for struct ost_lvb */
	LASSERTF((int)sizeof(struct ost_lvb) == 56, "found %lld\n",
		 (long long)(int)sizeof(struct ost_lvb));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_size));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_size));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_mtime));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_mtime));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_atime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_atime));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_atime));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_ctime) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_ctime));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_ctime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_ctime));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_blocks) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_blocks));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_blocks) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_blocks));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_mtime_ns) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_mtime_ns));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_mtime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_mtime_ns));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_atime_ns) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_atime_ns));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_atime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_atime_ns));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_ctime_ns) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_ctime_ns));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_ctime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_ctime_ns));
	LASSERTF((int)offsetof(struct ost_lvb, lvb_padding) == 52, "found %lld\n",
		 (long long)(int)offsetof(struct ost_lvb, lvb_padding));
	LASSERTF((int)sizeof(((struct ost_lvb *)0)->lvb_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ost_lvb *)0)->lvb_padding));

	/* Checks for struct lquota_lvb */
	LASSERTF((int)sizeof(struct lquota_lvb) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct lquota_lvb));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_flags) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_flags));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_flags));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_id_may_rel) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_id_may_rel));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_id_may_rel) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_id_may_rel));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_id_rel) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_id_rel));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_id_rel) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_id_rel));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_id_qunit) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_id_qunit));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_id_qunit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_id_qunit));
	LASSERTF((int)offsetof(struct lquota_lvb, lvb_pad1) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lquota_lvb, lvb_pad1));
	LASSERTF((int)sizeof(((struct lquota_lvb *)0)->lvb_pad1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lquota_lvb *)0)->lvb_pad1));
	LASSERTF(LQUOTA_FL_EDQUOT == 1, "found %lld\n",
		 (long long)LQUOTA_FL_EDQUOT);

	/* Checks for struct ldlm_gl_lquota_desc */
	LASSERTF((int)sizeof(struct ldlm_gl_lquota_desc) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_gl_lquota_desc));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_id) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_id));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_id));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_flags));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_flags));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_ver) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_ver));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_ver) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_ver));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_hardlimit) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_hardlimit));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_hardlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_hardlimit));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_softlimit) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_softlimit));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_softlimit) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_softlimit));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_time) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_time));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_time));
	LASSERTF((int)offsetof(struct ldlm_gl_lquota_desc, gl_pad2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_lquota_desc, gl_pad2));
	LASSERTF((int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_pad2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_lquota_desc *)0)->gl_pad2));

	/* Checks for struct ldlm_gl_barrier_desc */
	LASSERTF((int)sizeof(struct ldlm_gl_barrier_desc) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct ldlm_gl_barrier_desc));
	LASSERTF((int)offsetof(struct ldlm_gl_barrier_desc, lgbd_status) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_barrier_desc, lgbd_status));
	LASSERTF((int)sizeof(((struct ldlm_gl_barrier_desc *)0)->lgbd_status) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_barrier_desc *)0)->lgbd_status));
	LASSERTF((int)offsetof(struct ldlm_gl_barrier_desc, lgbd_timeout) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_barrier_desc, lgbd_timeout));
	LASSERTF((int)sizeof(((struct ldlm_gl_barrier_desc *)0)->lgbd_timeout) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_barrier_desc *)0)->lgbd_timeout));
	LASSERTF((int)offsetof(struct ldlm_gl_barrier_desc, lgbd_padding) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ldlm_gl_barrier_desc, lgbd_padding));
	LASSERTF((int)sizeof(((struct ldlm_gl_barrier_desc *)0)->lgbd_padding) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ldlm_gl_barrier_desc *)0)->lgbd_padding));

	/* Checks for struct barrier_lvb */
	LASSERTF((int)sizeof(struct barrier_lvb) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct barrier_lvb));
	LASSERTF((int)offsetof(struct barrier_lvb, lvb_status) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct barrier_lvb, lvb_status));
	LASSERTF((int)sizeof(((struct barrier_lvb *)0)->lvb_status) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct barrier_lvb *)0)->lvb_status));
	LASSERTF((int)offsetof(struct barrier_lvb, lvb_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct barrier_lvb, lvb_index));
	LASSERTF((int)sizeof(((struct barrier_lvb *)0)->lvb_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct barrier_lvb *)0)->lvb_index));
	LASSERTF((int)offsetof(struct barrier_lvb, lvb_padding) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct barrier_lvb, lvb_padding));
	LASSERTF((int)sizeof(((struct barrier_lvb *)0)->lvb_padding) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct barrier_lvb *)0)->lvb_padding));

	/* Checks for struct mgs_send_param */
	LASSERTF((int)sizeof(struct mgs_send_param) == 1024, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_send_param));
	CLASSERT(MGS_PARAM_MAXLEN == 1024);
	LASSERTF((int)offsetof(struct mgs_send_param, mgs_param[1024]) == 1024, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_send_param, mgs_param[1024]));
	LASSERTF((int)sizeof(((struct mgs_send_param *)0)->mgs_param[1024]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_send_param *)0)->mgs_param[1024]));

	/* Checks for struct cfg_marker */
	LASSERTF((int)sizeof(struct cfg_marker) == 160, "found %lld\n",
		 (long long)(int)sizeof(struct cfg_marker));
	LASSERTF((int)offsetof(struct cfg_marker, cm_step) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_step));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_step) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_step));
	LASSERTF((int)offsetof(struct cfg_marker, cm_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_flags));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_flags));
	LASSERTF((int)offsetof(struct cfg_marker, cm_vers) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_vers));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_vers) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_vers));
	LASSERTF((int)offsetof(struct cfg_marker, cm_padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_padding));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_padding));
	LASSERTF((int)offsetof(struct cfg_marker, cm_createtime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_createtime));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_createtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_createtime));
	LASSERTF((int)offsetof(struct cfg_marker, cm_canceltime) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_canceltime));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_canceltime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_canceltime));
	LASSERTF((int)offsetof(struct cfg_marker, cm_tgtname) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_tgtname));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_tgtname) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_tgtname));
	LASSERTF((int)offsetof(struct cfg_marker, cm_comment) == 96, "found %lld\n",
		 (long long)(int)offsetof(struct cfg_marker, cm_comment));
	LASSERTF((int)sizeof(((struct cfg_marker *)0)->cm_comment) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct cfg_marker *)0)->cm_comment));

	/* Checks for struct llog_logid */
	LASSERTF((int)sizeof(struct llog_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(struct llog_logid));
	LASSERTF((int)offsetof(struct llog_logid, lgl_oi) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid, lgl_oi));
	LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_oi));
	LASSERTF((int)offsetof(struct llog_logid, lgl_ogen) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid, lgl_ogen));
	LASSERTF((int)sizeof(((struct llog_logid *)0)->lgl_ogen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid *)0)->lgl_ogen));
	CLASSERT(OST_SZ_REC == 274730752);
	CLASSERT(MDS_UNLINK_REC == 274801668);
	CLASSERT(MDS_UNLINK64_REC == 275325956);
	CLASSERT(MDS_SETATTR64_REC == 275325953);
	CLASSERT(OBD_CFG_REC == 274857984);
	CLASSERT(LLOG_GEN_REC == 274989056);
	CLASSERT(CHANGELOG_REC == 275120128);
	CLASSERT(CHANGELOG_USER_REC == 275185664);
	CLASSERT(LLOG_HDR_MAGIC == 275010873);
	CLASSERT(LLOG_LOGID_MAGIC == 275010875);

	/* Checks for struct llog_catid */
	LASSERTF((int)sizeof(struct llog_catid) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct llog_catid));
	LASSERTF((int)offsetof(struct llog_catid, lci_logid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_logid));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_logid));
	LASSERTF((int)offsetof(struct llog_catid, lci_padding1) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_padding1));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding1));
	LASSERTF((int)offsetof(struct llog_catid, lci_padding2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_padding2));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding2));
	LASSERTF((int)offsetof(struct llog_catid, lci_padding3) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_catid, lci_padding3));
	LASSERTF((int)sizeof(((struct llog_catid *)0)->lci_padding3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_catid *)0)->lci_padding3));

	/* Checks for struct llog_rec_hdr */
	LASSERTF((int)sizeof(struct llog_rec_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct llog_rec_hdr));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_len));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_len));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_index));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_index));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_type) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_type));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_type));
	LASSERTF((int)offsetof(struct llog_rec_hdr, lrh_id) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_hdr, lrh_id));
	LASSERTF((int)sizeof(((struct llog_rec_hdr *)0)->lrh_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_hdr *)0)->lrh_id));

	/* Checks for struct llog_rec_tail */
	LASSERTF((int)sizeof(struct llog_rec_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct llog_rec_tail));
	LASSERTF((int)offsetof(struct llog_rec_tail, lrt_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_tail, lrt_len));
	LASSERTF((int)sizeof(((struct llog_rec_tail *)0)->lrt_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_tail *)0)->lrt_len));
	LASSERTF((int)offsetof(struct llog_rec_tail, lrt_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct llog_rec_tail, lrt_index));
	LASSERTF((int)sizeof(((struct llog_rec_tail *)0)->lrt_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_rec_tail *)0)->lrt_index));

	/* Checks for struct llog_logid_rec */
	LASSERTF((int)sizeof(struct llog_logid_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_logid_rec));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_hdr));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_hdr));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_id) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_id));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_id) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_id));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_padding1));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_padding1));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_padding2) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_padding2));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_padding2));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_padding3) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_padding3));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_padding3));
	LASSERTF((int)offsetof(struct llog_logid_rec, lid_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_logid_rec, lid_tail));
	LASSERTF((int)sizeof(((struct llog_logid_rec *)0)->lid_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_logid_rec *)0)->lid_tail));

	/* Checks for struct llog_unlink_rec */
	LASSERTF((int)sizeof(struct llog_unlink_rec) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct llog_unlink_rec));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_hdr));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_hdr));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_oid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_oid));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_oid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_oid));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_oseq) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_oseq));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_oseq) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_oseq));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_count));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_count));
	LASSERTF((int)offsetof(struct llog_unlink_rec, lur_tail) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink_rec, lur_tail));
	LASSERTF((int)sizeof(((struct llog_unlink_rec *)0)->lur_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink_rec *)0)->lur_tail));
	/* Checks for struct llog_unlink64_rec */
	LASSERTF((int)sizeof(struct llog_unlink64_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_unlink64_rec));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_hdr));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_hdr));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_fid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_fid));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_fid));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_count) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_count));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_count));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_tail));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_tail));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_padding1));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding1));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_padding2) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_padding2));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding2));
	LASSERTF((int)offsetof(struct llog_unlink64_rec, lur_padding3) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_unlink64_rec, lur_padding3));
	LASSERTF((int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_unlink64_rec *)0)->lur_padding3));

	/* Checks for struct llog_setattr64_rec */
	LASSERTF((int)sizeof(struct llog_setattr64_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_setattr64_rec));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_hdr));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_hdr));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_oi) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_oi));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_oi) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_oi));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_uid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_uid));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_uid_h) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_uid_h));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_uid_h));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_gid) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_gid));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_gid_h) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_gid_h));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid_h) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_gid_h));
	LASSERTF((int)offsetof(struct llog_setattr64_rec, lsr_valid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec, lsr_valid));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec *)0)->lsr_valid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec *)0)->lsr_valid));
	LASSERTF((int)offsetof(struct llog_setattr64_rec_v2, lsr_projid) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec_v2, lsr_projid));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec_v2 *)0)->lsr_projid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec_v2 *)0)->lsr_projid));
	LASSERTF((int)offsetof(struct llog_setattr64_rec_v2, lsr_tail) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct llog_setattr64_rec_v2, lsr_tail));
	LASSERTF((int)sizeof(((struct llog_setattr64_rec_v2 *)0)->lsr_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_setattr64_rec_v2 *)0)->lsr_tail));

	/* Checks for struct llog_size_change_rec */
	LASSERTF((int)sizeof(struct llog_size_change_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_size_change_rec));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_hdr));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_hdr));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_fid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_fid));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_fid));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_ioepoch) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_ioepoch));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_ioepoch) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_ioepoch));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_padding1) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_padding1));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding1));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_padding2) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_padding2));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding2));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_padding3) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_padding3));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_padding3));
	LASSERTF((int)offsetof(struct llog_size_change_rec, lsc_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_size_change_rec, lsc_tail));
	LASSERTF((int)sizeof(((struct llog_size_change_rec *)0)->lsc_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_size_change_rec *)0)->lsc_tail));

	/* Checks for struct changelog_rec */
	LASSERTF((int)sizeof(struct changelog_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_rec));
	LASSERTF((int)offsetof(struct changelog_rec, cr_namelen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_namelen));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_namelen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_namelen));
	LASSERTF((int)offsetof(struct changelog_rec, cr_flags) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_flags));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_flags));
	LASSERTF((int)offsetof(struct changelog_rec, cr_type) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_type));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_type) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_type));
	LASSERTF((int)offsetof(struct changelog_rec, cr_index) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_index));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_index) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_index));
	LASSERTF((int)offsetof(struct changelog_rec, cr_prev) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_prev));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_prev) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_prev));
	LASSERTF((int)offsetof(struct changelog_rec, cr_time) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_time));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_time) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_time));
	LASSERTF((int)offsetof(struct changelog_rec, cr_tfid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_tfid));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_tfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_tfid));
	LASSERTF((int)offsetof(struct changelog_rec, cr_pfid) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_rec, cr_pfid));
	LASSERTF((int)sizeof(((struct changelog_rec *)0)->cr_pfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_rec *)0)->cr_pfid));

	/* Checks for struct changelog_ext_rename */
	LASSERTF((int)sizeof(struct changelog_ext_rename) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_ext_rename));
	LASSERTF((int)offsetof(struct changelog_ext_rename, cr_sfid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rename, cr_sfid));
	LASSERTF((int)sizeof(((struct changelog_ext_rename *)0)->cr_sfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rename *)0)->cr_sfid));
	LASSERTF((int)offsetof(struct changelog_ext_rename, cr_spfid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_rename, cr_spfid));
	LASSERTF((int)sizeof(((struct changelog_ext_rename *)0)->cr_spfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_rename *)0)->cr_spfid));

	/* Checks for struct changelog_ext_jobid */
	LASSERTF((int)sizeof(struct changelog_ext_jobid) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_ext_jobid));
	LASSERTF((int)offsetof(struct changelog_ext_jobid, cr_jobid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_ext_jobid, cr_jobid));
	LASSERTF((int)sizeof(((struct changelog_ext_jobid *)0)->cr_jobid) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_ext_jobid *)0)->cr_jobid));

	/* Checks for struct changelog_setinfo */
	LASSERTF((int)sizeof(struct changelog_setinfo) == 12, "found %lld\n",
		 (long long)(int)sizeof(struct changelog_setinfo));
	LASSERTF((int)offsetof(struct changelog_setinfo, cs_recno) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_setinfo, cs_recno));
	LASSERTF((int)sizeof(((struct changelog_setinfo *)0)->cs_recno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_setinfo *)0)->cs_recno));
	LASSERTF((int)offsetof(struct changelog_setinfo, cs_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct changelog_setinfo, cs_id));
	LASSERTF((int)sizeof(((struct changelog_setinfo *)0)->cs_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct changelog_setinfo *)0)->cs_id));

	/* Checks for struct llog_changelog_rec */
	LASSERTF((int)sizeof(struct llog_changelog_rec) == 88, "found %lld\n",
		 (long long)(int)sizeof(struct llog_changelog_rec));
	LASSERTF((int)offsetof(struct llog_changelog_rec, cr_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_rec, cr_hdr));
	LASSERTF((int)sizeof(((struct llog_changelog_rec *)0)->cr_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_rec *)0)->cr_hdr));
	LASSERTF((int)offsetof(struct llog_changelog_rec, cr) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_rec, cr));
	LASSERTF((int)sizeof(((struct llog_changelog_rec *)0)->cr) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_rec *)0)->cr));
	LASSERTF((int)offsetof(struct llog_changelog_rec, cr_do_not_use) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_rec, cr_do_not_use));
	LASSERTF((int)sizeof(((struct llog_changelog_rec *)0)->cr_do_not_use) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_rec *)0)->cr_do_not_use));

	/* Checks for struct llog_changelog_user_rec */
	LASSERTF((int)sizeof(struct llog_changelog_user_rec) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct llog_changelog_user_rec));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_hdr));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_hdr));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_id) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_id));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_id));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_padding) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_padding));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_padding));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_endrec) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_endrec));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_endrec) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_endrec));
	LASSERTF((int)offsetof(struct llog_changelog_user_rec, cur_tail) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_changelog_user_rec, cur_tail));
	LASSERTF((int)sizeof(((struct llog_changelog_user_rec *)0)->cur_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_changelog_user_rec *)0)->cur_tail));

	/* Checks for struct llog_gen */
	LASSERTF((int)sizeof(struct llog_gen) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct llog_gen));
	LASSERTF((int)offsetof(struct llog_gen, mnt_cnt) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen, mnt_cnt));
	LASSERTF((int)sizeof(((struct llog_gen *)0)->mnt_cnt) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen *)0)->mnt_cnt));
	LASSERTF((int)offsetof(struct llog_gen, conn_cnt) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen, conn_cnt));
	LASSERTF((int)sizeof(((struct llog_gen *)0)->conn_cnt) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen *)0)->conn_cnt));

	/* Checks for struct llog_gen_rec */
	LASSERTF((int)sizeof(struct llog_gen_rec) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct llog_gen_rec));
	LASSERTF((int)offsetof(struct llog_gen_rec, lgr_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen_rec, lgr_hdr));
	LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_hdr));
	LASSERTF((int)offsetof(struct llog_gen_rec, lgr_gen) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen_rec, lgr_gen));
	LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_gen) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_gen));
	LASSERTF((int)offsetof(struct llog_gen_rec, lgr_tail) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct llog_gen_rec, lgr_tail));
	LASSERTF((int)sizeof(((struct llog_gen_rec *)0)->lgr_tail) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_gen_rec *)0)->lgr_tail));

	/* Checks for struct llog_log_hdr */
	LASSERTF((int)sizeof(struct llog_log_hdr) == 8192, "found %lld\n",
		 (long long)(int)sizeof(struct llog_log_hdr));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_hdr));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_hdr));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_timestamp) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_timestamp));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_timestamp) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_timestamp));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_count) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_count));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_count));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_bitmap_offset) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_bitmap_offset));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap_offset) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_bitmap_offset));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_size) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_size));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_size));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_flags) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_flags));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_flags));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_cat_idx) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_cat_idx));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_cat_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_cat_idx));
	LASSERTF((int)offsetof(struct llog_log_hdr, llh_tgtuuid) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct llog_log_hdr, llh_tgtuuid));
	LASSERTF((int)sizeof(((struct llog_log_hdr *)0)->llh_tgtuuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_log_hdr *)0)->llh_tgtuuid));

	/* Checks for struct llogd_body */
	LASSERTF((int)sizeof(struct llogd_body) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct llogd_body));
	LASSERTF((int)offsetof(struct llogd_body, lgd_logid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_logid));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_logid));
	LASSERTF((int)offsetof(struct llogd_body, lgd_ctxt_idx) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_ctxt_idx));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_ctxt_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_ctxt_idx));
	LASSERTF((int)offsetof(struct llogd_body, lgd_llh_flags) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_llh_flags));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_llh_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_llh_flags));
	LASSERTF((int)offsetof(struct llogd_body, lgd_index) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_index));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_index));
	LASSERTF((int)offsetof(struct llogd_body, lgd_saved_index) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_saved_index));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_saved_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_saved_index));
	LASSERTF((int)offsetof(struct llogd_body, lgd_len) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_len));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_len));
	LASSERTF((int)offsetof(struct llogd_body, lgd_cur_offset) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_body, lgd_cur_offset));
	LASSERTF((int)sizeof(((struct llogd_body *)0)->lgd_cur_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_body *)0)->lgd_cur_offset));
	CLASSERT(LLOG_ORIGIN_HANDLE_CREATE == 501);
	CLASSERT(LLOG_ORIGIN_HANDLE_NEXT_BLOCK == 502);
	CLASSERT(LLOG_ORIGIN_HANDLE_READ_HEADER == 503);
	CLASSERT(LLOG_ORIGIN_HANDLE_WRITE_REC == 504);
	CLASSERT(LLOG_ORIGIN_HANDLE_CLOSE == 505);
	CLASSERT(LLOG_ORIGIN_CONNECT == 506);
	CLASSERT(LLOG_CATINFO == 507);
	CLASSERT(LLOG_ORIGIN_HANDLE_PREV_BLOCK == 508);
	CLASSERT(LLOG_ORIGIN_HANDLE_DESTROY == 509);
	CLASSERT(LLOG_FIRST_OPC == 501);
	CLASSERT(LLOG_LAST_OPC == 510);
	CLASSERT(LLOG_CONFIG_ORIG_CTXT == 0);
	CLASSERT(LLOG_CONFIG_REPL_CTXT == 1);
	CLASSERT(LLOG_MDS_OST_ORIG_CTXT == 2);
	CLASSERT(LLOG_MDS_OST_REPL_CTXT == 3);
	CLASSERT(LLOG_SIZE_ORIG_CTXT == 4);
	CLASSERT(LLOG_SIZE_REPL_CTXT == 5);
	CLASSERT(LLOG_TEST_ORIG_CTXT == 8);
	CLASSERT(LLOG_TEST_REPL_CTXT == 9);
	CLASSERT(LLOG_CHANGELOG_ORIG_CTXT == 12);
	CLASSERT(LLOG_CHANGELOG_REPL_CTXT == 13);
	CLASSERT(LLOG_CHANGELOG_USER_ORIG_CTXT == 14);
	CLASSERT(LLOG_AGENT_ORIG_CTXT == 15);
	CLASSERT(LLOG_UPDATELOG_ORIG_CTXT == 16);
	CLASSERT(LLOG_UPDATELOG_REPL_CTXT == 17);
	CLASSERT(LLOG_MAX_CTXTS == 18);

	/* Checks for struct llogd_conn_body */
	LASSERTF((int)sizeof(struct llogd_conn_body) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct llogd_conn_body));
	LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_gen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_conn_body, lgdc_gen));
	LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_gen) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_gen));
	LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_logid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_conn_body, lgdc_logid));
	LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_logid) == 20, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_logid));
	LASSERTF((int)offsetof(struct llogd_conn_body, lgdc_ctxt_idx) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct llogd_conn_body, lgdc_ctxt_idx));
	LASSERTF((int)sizeof(((struct llogd_conn_body *)0)->lgdc_ctxt_idx) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct llogd_conn_body *)0)->lgdc_ctxt_idx));

	/* Checks for struct ll_fiemap_info_key */
	LASSERTF((int)sizeof(struct ll_fiemap_info_key) == 248, "found %lld\n",
		 (long long)(int)sizeof(struct ll_fiemap_info_key));
	LASSERTF((int)offsetof(struct ll_fiemap_info_key, lfik_name[8]) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_info_key, lfik_name[8]));
	LASSERTF((int)sizeof(((struct ll_fiemap_info_key *)0)->lfik_name[8]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_info_key *)0)->lfik_name[8]));
	LASSERTF((int)offsetof(struct ll_fiemap_info_key, lfik_oa) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_info_key, lfik_oa));
	LASSERTF((int)sizeof(((struct ll_fiemap_info_key *)0)->lfik_oa) == 208, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_info_key *)0)->lfik_oa));
	LASSERTF((int)offsetof(struct ll_fiemap_info_key, lfik_fiemap) == 216, "found %lld\n",
		 (long long)(int)offsetof(struct ll_fiemap_info_key, lfik_fiemap));
	LASSERTF((int)sizeof(((struct ll_fiemap_info_key *)0)->lfik_fiemap) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct ll_fiemap_info_key *)0)->lfik_fiemap));

	/* Checks for struct quota_body */
	LASSERTF((int)sizeof(struct quota_body) == 112, "found %lld\n",
		 (long long)(int)sizeof(struct quota_body));
	LASSERTF((int)offsetof(struct quota_body, qb_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_fid));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_fid));
	LASSERTF((int)offsetof(struct quota_body, qb_id) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_id));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_id) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_id));
	LASSERTF((int)offsetof(struct quota_body, qb_flags) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_flags));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_flags));
	LASSERTF((int)offsetof(struct quota_body, qb_padding) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_padding));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_padding));
	LASSERTF((int)offsetof(struct quota_body, qb_count) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_count));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_count) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_count));
	LASSERTF((int)offsetof(struct quota_body, qb_usage) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_usage));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_usage) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_usage));
	LASSERTF((int)offsetof(struct quota_body, qb_slv_ver) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_slv_ver));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_slv_ver) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_slv_ver));
	LASSERTF((int)offsetof(struct quota_body, qb_lockh) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_lockh));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_lockh) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_lockh));
	LASSERTF((int)offsetof(struct quota_body, qb_glb_lockh) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_glb_lockh));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_glb_lockh) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_glb_lockh));
	LASSERTF((int)offsetof(struct quota_body, qb_padding1[4]) == 112, "found %lld\n",
		 (long long)(int)offsetof(struct quota_body, qb_padding1[4]));
	LASSERTF((int)sizeof(((struct quota_body *)0)->qb_padding1[4]) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct quota_body *)0)->qb_padding1[4]));

	/* Checks for struct mgs_target_info */
	LASSERTF((int)sizeof(struct mgs_target_info) == 4544, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_target_info));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_lustre_ver) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_lustre_ver));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_lustre_ver) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_lustre_ver));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_stripe_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_stripe_index));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_stripe_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_stripe_index));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_config_ver) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_config_ver));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_config_ver) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_config_ver));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_flags) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_flags));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_flags));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_nid_count) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_nid_count));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_nid_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_nid_count));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_instance) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_instance));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_instance) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_instance));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_fsname) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_fsname));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_fsname) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_fsname));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_svname) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_svname));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_svname) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_svname));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_uuid) == 152, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_uuid));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_uuid) == 40, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_uuid));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_nids) == 192, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_nids));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_nids) == 256, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_nids));
	LASSERTF((int)offsetof(struct mgs_target_info, mti_params) == 448, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_target_info, mti_params));
	LASSERTF((int)sizeof(((struct mgs_target_info *)0)->mti_params) == 4096, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_target_info *)0)->mti_params));

	/* Checks for struct mgs_nidtbl_entry */
	LASSERTF((int)sizeof(struct mgs_nidtbl_entry) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_nidtbl_entry));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_version));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_version));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_instance) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_instance));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_instance) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_instance));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_index) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_index));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_index));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_length) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_length));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_length) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_length));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_type) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_type));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_type) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_type));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_nid_type) == 21, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_nid_type));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_nid_type) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_nid_type));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_nid_size) == 22, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_nid_size));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_nid_size) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_nid_size));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, mne_nid_count) == 23, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, mne_nid_count));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_nid_count) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->mne_nid_count));
	LASSERTF((int)offsetof(struct mgs_nidtbl_entry, u.nids[0]) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_nidtbl_entry, u.nids[0]));
	LASSERTF((int)sizeof(((struct mgs_nidtbl_entry *)0)->u.nids[0]) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_nidtbl_entry *)0)->u.nids[0]));

	/* Checks for struct mgs_config_body */
	LASSERTF((int)sizeof(struct mgs_config_body) == 80, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_config_body));
	LASSERTF((int)offsetof(struct mgs_config_body, mcb_name) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_body, mcb_name));
	LASSERTF((int)sizeof(((struct mgs_config_body *)0)->mcb_name) == 64, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_body *)0)->mcb_name));
	LASSERTF((int)offsetof(struct mgs_config_body, mcb_offset) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_body, mcb_offset));
	LASSERTF((int)sizeof(((struct mgs_config_body *)0)->mcb_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_body *)0)->mcb_offset));
	LASSERTF((int)offsetof(struct mgs_config_body, mcb_type) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_body, mcb_type));
	LASSERTF((int)sizeof(((struct mgs_config_body *)0)->mcb_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_body *)0)->mcb_type));
	LASSERTF((int)offsetof(struct mgs_config_body, mcb_nm_cur_pass) == 74, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_body, mcb_nm_cur_pass));
	LASSERTF((int)sizeof(((struct mgs_config_body *)0)->mcb_nm_cur_pass) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_body *)0)->mcb_nm_cur_pass));
	LASSERTF((int)offsetof(struct mgs_config_body, mcb_bits) == 75, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_body, mcb_bits));
	LASSERTF((int)sizeof(((struct mgs_config_body *)0)->mcb_bits) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_body *)0)->mcb_bits));
	LASSERTF((int)offsetof(struct mgs_config_body, mcb_units) == 76, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_body, mcb_units));
	LASSERTF((int)sizeof(((struct mgs_config_body *)0)->mcb_units) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_body *)0)->mcb_units));
	CLASSERT(CONFIG_T_CONFIG == 0);
	CLASSERT(CONFIG_T_SPTLRPC == 1);
	CLASSERT(CONFIG_T_RECOVER == 2);
	CLASSERT(CONFIG_T_PARAMS == 3);
	CLASSERT(CONFIG_T_NODEMAP == 4);
	CLASSERT(CONFIG_T_BARRIER == 5);

	/* Checks for struct mgs_config_res */
	LASSERTF((int)sizeof(struct mgs_config_res) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct mgs_config_res));
	LASSERTF((int)offsetof(struct mgs_config_res, mcr_offset) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_res, mcr_offset));
	LASSERTF((int)sizeof(((struct mgs_config_res *)0)->mcr_offset) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_res *)0)->mcr_offset));
	LASSERTF((int)offsetof(struct mgs_config_res, mcr_size) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct mgs_config_res, mcr_size));
	LASSERTF((int)sizeof(((struct mgs_config_res *)0)->mcr_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct mgs_config_res *)0)->mcr_size));

	/* Checks for struct lustre_capa */
	LASSERTF((int)sizeof(struct lustre_capa) == 120, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_capa));
	LASSERTF((int)offsetof(struct lustre_capa, lc_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_fid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_fid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_opc) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_opc));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_opc) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_opc));
	LASSERTF((int)offsetof(struct lustre_capa, lc_uid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_uid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_uid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_uid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_gid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_gid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_gid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_gid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_flags));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_flags));
	LASSERTF((int)offsetof(struct lustre_capa, lc_keyid) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_keyid));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_keyid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_keyid));
	LASSERTF((int)offsetof(struct lustre_capa, lc_timeout) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_timeout));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_timeout) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_timeout));
	LASSERTF((int)offsetof(struct lustre_capa, lc_expiry) == 52, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_expiry));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_expiry) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_expiry));
	CLASSERT(CAPA_HMAC_MAX_LEN == 64);
	LASSERTF((int)offsetof(struct lustre_capa, lc_hmac[64]) == 120, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa, lc_hmac[64]));
	LASSERTF((int)sizeof(((struct lustre_capa *)0)->lc_hmac[64]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa *)0)->lc_hmac[64]));

	/* Checks for struct lustre_capa_key */
	LASSERTF((int)sizeof(struct lustre_capa_key) == 72, "found %lld\n",
		 (long long)(int)sizeof(struct lustre_capa_key));
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_seq) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_seq));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_seq) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_seq));
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_keyid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_keyid));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_keyid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_keyid));
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_padding));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_padding));
	CLASSERT(CAPA_HMAC_KEY_MAX_LEN == 56);
	LASSERTF((int)offsetof(struct lustre_capa_key, lk_key[56]) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct lustre_capa_key, lk_key[56]));
	LASSERTF((int)sizeof(((struct lustre_capa_key *)0)->lk_key[56]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct lustre_capa_key *)0)->lk_key[56]));

	/* Checks for struct getinfo_fid2path */
	LASSERTF((int)sizeof(struct getinfo_fid2path) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct getinfo_fid2path));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_fid));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_fid));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_recno) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_recno));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_recno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_recno));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_linkno) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_linkno));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_linkno) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_linkno));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_pathlen) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_pathlen));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_pathlen) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_pathlen));
	LASSERTF((int)offsetof(struct getinfo_fid2path, gf_u.gf_path[0]) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct getinfo_fid2path, gf_u.gf_path[0]));
	LASSERTF((int)sizeof(((struct getinfo_fid2path *)0)->gf_u.gf_path[0]) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct getinfo_fid2path *)0)->gf_u.gf_path[0]));

	/* Checks for struct fiemap */
	LASSERTF((int)sizeof(struct fiemap) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct fiemap));
	LASSERTF((int)offsetof(struct fiemap, fm_start) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_start));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_start));
	LASSERTF((int)offsetof(struct fiemap, fm_length) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_length));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_length) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_length));
	LASSERTF((int)offsetof(struct fiemap, fm_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_flags));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_flags));
	LASSERTF((int)offsetof(struct fiemap, fm_mapped_extents) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_mapped_extents));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_mapped_extents) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_mapped_extents));
	LASSERTF((int)offsetof(struct fiemap, fm_extent_count) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_extent_count));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_extent_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_extent_count));
	LASSERTF((int)offsetof(struct fiemap, fm_reserved) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_reserved));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_reserved) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_reserved));
	LASSERTF((int)offsetof(struct fiemap, fm_extents) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap, fm_extents));
	LASSERTF((int)sizeof(((struct fiemap *)0)->fm_extents) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap *)0)->fm_extents));
	CLASSERT(FIEMAP_FLAG_SYNC == 0x00000001);
	CLASSERT(FIEMAP_FLAG_XATTR == 0x00000002);
	CLASSERT(FIEMAP_FLAG_DEVICE_ORDER == 0x40000000);

	/* Checks for struct fiemap_extent */
	LASSERTF((int)sizeof(struct fiemap_extent) == 56, "found %lld\n",
		 (long long)(int)sizeof(struct fiemap_extent));
	LASSERTF((int)offsetof(struct fiemap_extent, fe_logical) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap_extent, fe_logical));
	LASSERTF((int)sizeof(((struct fiemap_extent *)0)->fe_logical) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap_extent *)0)->fe_logical));
	LASSERTF((int)offsetof(struct fiemap_extent, fe_physical) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap_extent, fe_physical));
	LASSERTF((int)sizeof(((struct fiemap_extent *)0)->fe_physical) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap_extent *)0)->fe_physical));
	LASSERTF((int)offsetof(struct fiemap_extent, fe_length) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap_extent, fe_length));
	LASSERTF((int)sizeof(((struct fiemap_extent *)0)->fe_length) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap_extent *)0)->fe_length));
	LASSERTF((int)offsetof(struct fiemap_extent, fe_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap_extent, fe_flags));
	LASSERTF((int)sizeof(((struct fiemap_extent *)0)->fe_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap_extent *)0)->fe_flags));
	LASSERTF((int)offsetof(struct fiemap_extent, fe_reserved[0]) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct fiemap_extent, fe_reserved[0]));
	LASSERTF((int)sizeof(((struct fiemap_extent *)0)->fe_reserved[0]) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct fiemap_extent *)0)->fe_reserved[0]));
	CLASSERT(FIEMAP_EXTENT_LAST == 0x00000001);
	CLASSERT(FIEMAP_EXTENT_UNKNOWN == 0x00000002);
	CLASSERT(FIEMAP_EXTENT_DELALLOC == 0x00000004);
	CLASSERT(FIEMAP_EXTENT_ENCODED == 0x00000008);
	CLASSERT(FIEMAP_EXTENT_DATA_ENCRYPTED == 0x00000080);
	CLASSERT(FIEMAP_EXTENT_NOT_ALIGNED == 0x00000100);
	CLASSERT(FIEMAP_EXTENT_DATA_INLINE == 0x00000200);
	CLASSERT(FIEMAP_EXTENT_DATA_TAIL == 0x00000400);
	CLASSERT(FIEMAP_EXTENT_UNWRITTEN == 0x00000800);
	CLASSERT(FIEMAP_EXTENT_MERGED == 0x00001000);
	CLASSERT(FIEMAP_EXTENT_NO_DIRECT == 0x40000000);
	CLASSERT(FIEMAP_EXTENT_NET == 0x80000000);

#ifdef CONFIG_FS_POSIX_ACL
	/* Checks for type posix_acl_xattr_entry */
	LASSERTF((int)sizeof(posix_acl_xattr_entry) == 8, "found %lld\n",
		 (long long)(int)sizeof(posix_acl_xattr_entry));
	LASSERTF((int)offsetof(posix_acl_xattr_entry, e_tag) == 0, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_entry, e_tag));
	LASSERTF((int)sizeof(((posix_acl_xattr_entry *)0)->e_tag) == 2, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_entry *)0)->e_tag));
	LASSERTF((int)offsetof(posix_acl_xattr_entry, e_perm) == 2, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_entry, e_perm));
	LASSERTF((int)sizeof(((posix_acl_xattr_entry *)0)->e_perm) == 2, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_entry *)0)->e_perm));
	LASSERTF((int)offsetof(posix_acl_xattr_entry, e_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_entry, e_id));
	LASSERTF((int)sizeof(((posix_acl_xattr_entry *)0)->e_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_entry *)0)->e_id));
#endif /* CONFIG_FS_POSIX_ACL */

#ifdef CONFIG_FS_POSIX_ACL
	/* Checks for type posix_acl_xattr_header */
	LASSERTF((int)sizeof(posix_acl_xattr_header) == 4, "found %lld\n",
		 (long long)(int)sizeof(posix_acl_xattr_header));
	LASSERTF((int)offsetof(posix_acl_xattr_header, a_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_header, a_version));
	LASSERTF((int)sizeof(((posix_acl_xattr_header *)0)->a_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_header *)0)->a_version));
#ifndef HAVE_STRUCT_POSIX_ACL_XATTR
	LASSERTF((int)offsetof(posix_acl_xattr_header, a_entries) == 4, "found %lld\n",
		 (long long)(int)offsetof(posix_acl_xattr_header, a_entries));
	LASSERTF((int)sizeof(((posix_acl_xattr_header *)0)->a_entries) == 0, "found %lld\n",
		 (long long)(int)sizeof(((posix_acl_xattr_header *)0)->a_entries));
#endif /* HAVE_STRUCT_POSIX_ACL_XATTR */
#endif /* CONFIG_FS_POSIX_ACL */

	/* Checks for struct link_ea_header */
	LASSERTF((int)sizeof(struct link_ea_header) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct link_ea_header));
	LASSERTF((int)offsetof(struct link_ea_header, leh_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_magic));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_magic));
	LASSERTF((int)offsetof(struct link_ea_header, leh_reccount) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_reccount));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_reccount) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_reccount));
	LASSERTF((int)offsetof(struct link_ea_header, leh_len) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_len));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_len) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_len));
	LASSERTF((int)offsetof(struct link_ea_header, leh_overflow_time) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_overflow_time));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_overflow_time) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_overflow_time));
	LASSERTF((int)offsetof(struct link_ea_header, leh_padding) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_header, leh_padding));
	LASSERTF((int)sizeof(((struct link_ea_header *)0)->leh_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_header *)0)->leh_padding));
	CLASSERT(LINK_EA_MAGIC == 0x11EAF1DFUL);

	/* Checks for struct link_ea_entry */
	LASSERTF((int)sizeof(struct link_ea_entry) == 18, "found %lld\n",
		 (long long)(int)sizeof(struct link_ea_entry));
	LASSERTF((int)offsetof(struct link_ea_entry, lee_reclen) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_entry, lee_reclen));
	LASSERTF((int)sizeof(((struct link_ea_entry *)0)->lee_reclen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_entry *)0)->lee_reclen));
	LASSERTF((int)offsetof(struct link_ea_entry, lee_parent_fid) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_entry, lee_parent_fid));
	LASSERTF((int)sizeof(((struct link_ea_entry *)0)->lee_parent_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_entry *)0)->lee_parent_fid));
	LASSERTF((int)offsetof(struct link_ea_entry, lee_name) == 18, "found %lld\n",
		 (long long)(int)offsetof(struct link_ea_entry, lee_name));
	LASSERTF((int)sizeof(((struct link_ea_entry *)0)->lee_name) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct link_ea_entry *)0)->lee_name));

	/* Checks for struct layout_intent */
	LASSERTF((int)sizeof(struct layout_intent) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct layout_intent));
	LASSERTF((int)offsetof(struct layout_intent, li_opc) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_opc));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_opc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_opc));
	LASSERTF((int)offsetof(struct layout_intent, li_flags) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_flags));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_flags));
	LASSERTF((int)offsetof(struct layout_intent, li_start) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_start));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_start));
	LASSERTF((int)offsetof(struct layout_intent, li_end) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct layout_intent, li_end));
	LASSERTF((int)sizeof(((struct layout_intent *)0)->li_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct layout_intent *)0)->li_end));
	LASSERTF(LAYOUT_INTENT_ACCESS == 0, "found %lld\n",
		 (long long)LAYOUT_INTENT_ACCESS);
	LASSERTF(LAYOUT_INTENT_READ == 1, "found %lld\n",
		 (long long)LAYOUT_INTENT_READ);
	LASSERTF(LAYOUT_INTENT_WRITE == 2, "found %lld\n",
		 (long long)LAYOUT_INTENT_WRITE);
	LASSERTF(LAYOUT_INTENT_GLIMPSE == 3, "found %lld\n",
		 (long long)LAYOUT_INTENT_GLIMPSE);
	LASSERTF(LAYOUT_INTENT_TRUNC == 4, "found %lld\n",
		 (long long)LAYOUT_INTENT_TRUNC);
	LASSERTF(LAYOUT_INTENT_RELEASE == 5, "found %lld\n",
		 (long long)LAYOUT_INTENT_RELEASE);
	LASSERTF(LAYOUT_INTENT_RESTORE == 6, "found %lld\n",
		 (long long)LAYOUT_INTENT_RESTORE);

	/* Checks for struct hsm_action_item */
	LASSERTF((int)sizeof(struct hsm_action_item) == 72, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_action_item));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_len));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_len));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_action) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_action));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_action));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_fid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_fid));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_fid));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_dfid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_dfid));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_dfid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_dfid));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_extent) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_extent));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_extent));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_cookie) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_cookie));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_cookie));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_gid) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_gid));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_gid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_gid));
	LASSERTF((int)offsetof(struct hsm_action_item, hai_data) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_item, hai_data));
	LASSERTF((int)sizeof(((struct hsm_action_item *)0)->hai_data) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_item *)0)->hai_data));

	/* Checks for struct hsm_action_list */
	LASSERTF((int)sizeof(struct hsm_action_list) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_action_list));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_version));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_version) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_version));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_count));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_count));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_compound_id) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_compound_id));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_compound_id) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_compound_id));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_flags));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_flags));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_archive_id) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_archive_id));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_archive_id));
	LASSERTF((int)offsetof(struct hsm_action_list, padding1) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, padding1));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->padding1));
	LASSERTF((int)offsetof(struct hsm_action_list, hal_fsname) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_action_list, hal_fsname));
	LASSERTF((int)sizeof(((struct hsm_action_list *)0)->hal_fsname) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_action_list *)0)->hal_fsname));

	/* Checks for struct hsm_progress */
	LASSERTF((int)sizeof(struct hsm_progress) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_progress));
	LASSERTF((int)offsetof(struct hsm_progress, hp_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_fid));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_fid));
	LASSERTF((int)offsetof(struct hsm_progress, hp_cookie) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_cookie));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_cookie));
	LASSERTF((int)offsetof(struct hsm_progress, hp_extent) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_extent));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_extent));
	LASSERTF((int)offsetof(struct hsm_progress, hp_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_flags));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_flags));
	LASSERTF((int)offsetof(struct hsm_progress, hp_errval) == 42, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, hp_errval));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->hp_errval) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->hp_errval));
	LASSERTF((int)offsetof(struct hsm_progress, padding) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress, padding));
	LASSERTF((int)sizeof(((struct hsm_progress *)0)->padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress *)0)->padding));
	LASSERTF(HP_FLAG_COMPLETED == 0x01, "found 0x%.8x\n",
		HP_FLAG_COMPLETED);
	LASSERTF(HP_FLAG_RETRY == 0x02, "found 0x%.8x\n",
		HP_FLAG_RETRY);

	LASSERTF((int)offsetof(struct hsm_copy, hc_data_version) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_data_version));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_data_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_data_version));
	LASSERTF((int)offsetof(struct hsm_copy, hc_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_flags));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_flags));
	LASSERTF((int)offsetof(struct hsm_copy, hc_errval) == 10, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_errval));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_errval) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_errval));
	LASSERTF((int)offsetof(struct hsm_copy, padding) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, padding));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->padding));
	LASSERTF((int)offsetof(struct hsm_copy, hc_hai) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_copy, hc_hai));
	LASSERTF((int)sizeof(((struct hsm_copy *)0)->hc_hai) == 72, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_copy *)0)->hc_hai));

	/* Checks for struct hsm_progress_kernel */
	LASSERTF((int)sizeof(struct hsm_progress_kernel) == 64, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_progress_kernel));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_fid));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_fid));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_cookie) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_cookie));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_cookie) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_cookie));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_extent) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_extent));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_extent));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_flags) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_flags));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_flags) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_flags));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_errval) == 42, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_errval));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_errval) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_errval));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_padding1) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_padding1));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding1));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_data_version) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_data_version));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_data_version) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_data_version));
	LASSERTF((int)offsetof(struct hsm_progress_kernel, hpk_padding2) == 56, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_progress_kernel, hpk_padding2));
	LASSERTF((int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_progress_kernel *)0)->hpk_padding2));

	/* Checks for struct hsm_user_item */
	LASSERTF((int)sizeof(struct hsm_user_item) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_item));
	LASSERTF((int)offsetof(struct hsm_user_item, hui_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_item, hui_fid));
	LASSERTF((int)sizeof(((struct hsm_user_item *)0)->hui_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_item *)0)->hui_fid));
	LASSERTF((int)offsetof(struct hsm_user_item, hui_extent) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_item, hui_extent));
	LASSERTF((int)sizeof(((struct hsm_user_item *)0)->hui_extent) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_item *)0)->hui_extent));

	/* Checks for struct hsm_user_state */
	LASSERTF((int)sizeof(struct hsm_user_state) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_state));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_states) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_states));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_states) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_states));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_archive_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_archive_id));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_archive_id));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_in_progress_state) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_in_progress_state));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_state) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_state));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_in_progress_action) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_in_progress_action));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_action));
	LASSERTF((int)offsetof(struct hsm_user_state, hus_in_progress_location) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_state, hus_in_progress_location));
	LASSERTF((int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_location) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_state *)0)->hus_in_progress_location));

	/* Checks for struct hsm_state_set */
	LASSERTF((int)sizeof(struct hsm_state_set) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_state_set));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_valid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_valid));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_valid));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_archive_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_archive_id));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_archive_id));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_setmask) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_setmask));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_setmask) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_setmask));
	LASSERTF((int)offsetof(struct hsm_state_set, hss_clearmask) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_state_set, hss_clearmask));
	LASSERTF((int)sizeof(((struct hsm_state_set *)0)->hss_clearmask) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_state_set *)0)->hss_clearmask));

	/* Checks for struct hsm_current_action */
	LASSERTF((int)sizeof(struct hsm_current_action) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_current_action));
	LASSERTF((int)offsetof(struct hsm_current_action, hca_state) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_current_action, hca_state));
	LASSERTF((int)sizeof(((struct hsm_current_action *)0)->hca_state) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_current_action *)0)->hca_state));
	LASSERTF((int)offsetof(struct hsm_current_action, hca_action) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_current_action, hca_action));
	LASSERTF((int)sizeof(((struct hsm_current_action *)0)->hca_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_current_action *)0)->hca_action));
	LASSERTF((int)offsetof(struct hsm_current_action, hca_location) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_current_action, hca_location));
	LASSERTF((int)sizeof(((struct hsm_current_action *)0)->hca_location) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_current_action *)0)->hca_location));

	/* Checks for struct hsm_request */
	LASSERTF((int)sizeof(struct hsm_request) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_request));
	LASSERTF((int)offsetof(struct hsm_request, hr_action) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_action));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_action) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_action));
	LASSERTF((int)offsetof(struct hsm_request, hr_archive_id) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_archive_id));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_archive_id));
	LASSERTF((int)offsetof(struct hsm_request, hr_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_flags));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_flags));
	LASSERTF((int)offsetof(struct hsm_request, hr_itemcount) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_itemcount));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_itemcount) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_itemcount));
	LASSERTF((int)offsetof(struct hsm_request, hr_data_len) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_request, hr_data_len));
	LASSERTF((int)sizeof(((struct hsm_request *)0)->hr_data_len) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_request *)0)->hr_data_len));
	LASSERTF(HSM_FORCE_ACTION == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)HSM_FORCE_ACTION);
	LASSERTF(HSM_GHOST_COPY == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)HSM_GHOST_COPY);

	/* Checks for struct hsm_user_request */
	LASSERTF((int)sizeof(struct hsm_user_request) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_request));
	LASSERTF((int)offsetof(struct hsm_user_request, hur_request) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_request, hur_request));
	LASSERTF((int)sizeof(((struct hsm_user_request *)0)->hur_request) == 24, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_request *)0)->hur_request));
	LASSERTF((int)offsetof(struct hsm_user_request, hur_user_item) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_request, hur_user_item));
	LASSERTF((int)sizeof(((struct hsm_user_request *)0)->hur_user_item) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_request *)0)->hur_user_item));

	/* Checks for struct hsm_user_import */
	LASSERTF((int)sizeof(struct hsm_user_import) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct hsm_user_import));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_size));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_size) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_size));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_uid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_uid));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_uid));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_gid) == 36, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_gid));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_gid));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_mode) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_mode));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_mode) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_mode));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_atime) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_atime));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_atime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_atime));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_atime_ns) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_atime_ns));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_atime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_atime_ns));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_mtime) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_mtime));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_mtime) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_mtime));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_mtime_ns) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_mtime_ns));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_mtime_ns) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_mtime_ns));
	LASSERTF((int)offsetof(struct hsm_user_import, hui_archive_id) == 44, "found %lld\n",
		 (long long)(int)offsetof(struct hsm_user_import, hui_archive_id));
	LASSERTF((int)sizeof(((struct hsm_user_import *)0)->hui_archive_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct hsm_user_import *)0)->hui_archive_id));

	/* Checks for struct object_update_param */
	LASSERTF((int)sizeof(struct object_update_param) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct object_update_param));
	LASSERTF((int)offsetof(struct object_update_param, oup_len) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_param, oup_len));
	LASSERTF((int)sizeof(((struct object_update_param *)0)->oup_len) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_param *)0)->oup_len));
	LASSERTF((int)offsetof(struct object_update_param, oup_padding) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_param, oup_padding));
	LASSERTF((int)sizeof(((struct object_update_param *)0)->oup_padding) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_param *)0)->oup_padding));
	LASSERTF((int)offsetof(struct object_update_param, oup_padding2) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_param, oup_padding2));
	LASSERTF((int)sizeof(((struct object_update_param *)0)->oup_padding2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_param *)0)->oup_padding2));
	LASSERTF((int)offsetof(struct object_update_param, oup_buf) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_param, oup_buf));
	LASSERTF((int)sizeof(((struct object_update_param *)0)->oup_buf) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_param *)0)->oup_buf));

	/* Checks for struct object_update */
	LASSERTF((int)sizeof(struct object_update) == 40, "found %lld\n",
		 (long long)(int)sizeof(struct object_update));
	LASSERTF((int)offsetof(struct object_update, ou_type) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_type));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_type));
	LASSERTF((int)offsetof(struct object_update, ou_params_count) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_params_count));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_params_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_params_count));
	LASSERTF((int)offsetof(struct object_update, ou_result_size) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_result_size));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_result_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_result_size));
	LASSERTF((int)offsetof(struct object_update, ou_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_flags));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_flags));
	LASSERTF((int)offsetof(struct object_update, ou_padding1) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_padding1));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_padding1));
	LASSERTF((int)offsetof(struct object_update, ou_batchid) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_batchid));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_batchid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_batchid));
	LASSERTF((int)offsetof(struct object_update, ou_fid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_fid));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_fid));
	LASSERTF((int)offsetof(struct object_update, ou_params) == 40, "found %lld\n",
		 (long long)(int)offsetof(struct object_update, ou_params));
	LASSERTF((int)sizeof(((struct object_update *)0)->ou_params) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update *)0)->ou_params));

	/* Checks for struct object_update_request */
	LASSERTF((int)sizeof(struct object_update_request) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct object_update_request));
	LASSERTF((int)offsetof(struct object_update_request, ourq_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_request, ourq_magic));
	LASSERTF((int)sizeof(((struct object_update_request *)0)->ourq_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_request *)0)->ourq_magic));
	LASSERTF((int)offsetof(struct object_update_request, ourq_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_request, ourq_count));
	LASSERTF((int)sizeof(((struct object_update_request *)0)->ourq_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_request *)0)->ourq_count));
	LASSERTF((int)offsetof(struct object_update_request, ourq_padding) == 6, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_request, ourq_padding));
	LASSERTF((int)sizeof(((struct object_update_request *)0)->ourq_padding) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_request *)0)->ourq_padding));
	LASSERTF((int)offsetof(struct object_update_request, ourq_updates) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_request, ourq_updates));
	LASSERTF((int)sizeof(((struct object_update_request *)0)->ourq_updates) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_request *)0)->ourq_updates));

	/* Checks for struct object_update_result */
	LASSERTF((int)sizeof(struct object_update_result) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct object_update_result));
	LASSERTF((int)offsetof(struct object_update_result, our_rc) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_result, our_rc));
	LASSERTF((int)sizeof(((struct object_update_result *)0)->our_rc) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_result *)0)->our_rc));
	LASSERTF((int)offsetof(struct object_update_result, our_datalen) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_result, our_datalen));
	LASSERTF((int)sizeof(((struct object_update_result *)0)->our_datalen) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_result *)0)->our_datalen));
	LASSERTF((int)offsetof(struct object_update_result, our_padding) == 6, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_result, our_padding));
	LASSERTF((int)sizeof(((struct object_update_result *)0)->our_padding) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_result *)0)->our_padding));
	LASSERTF((int)offsetof(struct object_update_result, our_data) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_result, our_data));
	LASSERTF((int)sizeof(((struct object_update_result *)0)->our_data) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_result *)0)->our_data));

	/* Checks for struct object_update_reply */
	LASSERTF((int)sizeof(struct object_update_reply) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct object_update_reply));
	LASSERTF((int)offsetof(struct object_update_reply, ourp_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_reply, ourp_magic));
	LASSERTF((int)sizeof(((struct object_update_reply *)0)->ourp_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_reply *)0)->ourp_magic));
	LASSERTF((int)offsetof(struct object_update_reply, ourp_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_reply, ourp_count));
	LASSERTF((int)sizeof(((struct object_update_reply *)0)->ourp_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_reply *)0)->ourp_count));
	LASSERTF((int)offsetof(struct object_update_reply, ourp_padding) == 6, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_reply, ourp_padding));
	LASSERTF((int)sizeof(((struct object_update_reply *)0)->ourp_padding) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_reply *)0)->ourp_padding));
	LASSERTF((int)offsetof(struct object_update_reply, ourp_lens) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct object_update_reply, ourp_lens));
	LASSERTF((int)sizeof(((struct object_update_reply *)0)->ourp_lens) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct object_update_reply *)0)->ourp_lens));

	/* Checks for struct out_update_header */
	LASSERTF((int)sizeof(struct out_update_header) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct out_update_header));
	LASSERTF((int)offsetof(struct out_update_header, ouh_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_header, ouh_magic));
	LASSERTF((int)sizeof(((struct out_update_header *)0)->ouh_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_header *)0)->ouh_magic));
	LASSERTF((int)offsetof(struct out_update_header, ouh_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_header, ouh_count));
	LASSERTF((int)sizeof(((struct out_update_header *)0)->ouh_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_header *)0)->ouh_count));
	LASSERTF((int)offsetof(struct out_update_header, ouh_inline_length) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_header, ouh_inline_length));
	LASSERTF((int)sizeof(((struct out_update_header *)0)->ouh_inline_length) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_header *)0)->ouh_inline_length));
	LASSERTF((int)offsetof(struct out_update_header, ouh_reply_size) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_header, ouh_reply_size));
	LASSERTF((int)sizeof(((struct out_update_header *)0)->ouh_reply_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_header *)0)->ouh_reply_size));
	LASSERTF((int)offsetof(struct out_update_header, ouh_inline_data) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_header, ouh_inline_data));
	LASSERTF((int)sizeof(((struct out_update_header *)0)->ouh_inline_data) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_header *)0)->ouh_inline_data));

	/* Checks for struct out_update_buffer */
	LASSERTF((int)sizeof(struct out_update_buffer) == 8, "found %lld\n",
		 (long long)(int)sizeof(struct out_update_buffer));
	LASSERTF((int)offsetof(struct out_update_buffer, oub_size) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_buffer, oub_size));
	LASSERTF((int)sizeof(((struct out_update_buffer *)0)->oub_size) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_buffer *)0)->oub_size));
	LASSERTF((int)offsetof(struct out_update_buffer, oub_padding) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct out_update_buffer, oub_padding));
	LASSERTF((int)sizeof(((struct out_update_buffer *)0)->oub_padding) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct out_update_buffer *)0)->oub_padding));

	/* Checks for struct nodemap_cluster_rec */
	LASSERTF((int)sizeof(struct nodemap_cluster_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct nodemap_cluster_rec));
	LASSERTF((int)offsetof(struct nodemap_cluster_rec, ncr_name) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_cluster_rec, ncr_name));
	LASSERTF((int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_name) == 17, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_name));
	LASSERTF((int)offsetof(struct nodemap_cluster_rec, ncr_flags) == 17, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_cluster_rec, ncr_flags));
	LASSERTF((int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_flags) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_flags));
	LASSERTF((int)offsetof(struct nodemap_cluster_rec, ncr_padding1) == 18, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_cluster_rec, ncr_padding1));
	LASSERTF((int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_padding1) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_padding1));
	LASSERTF((int)offsetof(struct nodemap_cluster_rec, ncr_padding2) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_cluster_rec, ncr_padding2));
	LASSERTF((int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_padding2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_padding2));
	LASSERTF((int)offsetof(struct nodemap_cluster_rec, ncr_squash_uid) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_cluster_rec, ncr_squash_uid));
	LASSERTF((int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_squash_uid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_squash_uid));
	LASSERTF((int)offsetof(struct nodemap_cluster_rec, ncr_squash_gid) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_cluster_rec, ncr_squash_gid));
	LASSERTF((int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_squash_gid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_cluster_rec *)0)->ncr_squash_gid));

	/* Checks for struct nodemap_range_rec */
	LASSERTF((int)sizeof(struct nodemap_range_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct nodemap_range_rec));
	LASSERTF((int)offsetof(struct nodemap_range_rec, nrr_start_nid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_range_rec, nrr_start_nid));
	LASSERTF((int)sizeof(((struct nodemap_range_rec *)0)->nrr_start_nid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_range_rec *)0)->nrr_start_nid));
	LASSERTF((int)offsetof(struct nodemap_range_rec, nrr_end_nid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_range_rec, nrr_end_nid));
	LASSERTF((int)sizeof(((struct nodemap_range_rec *)0)->nrr_end_nid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_range_rec *)0)->nrr_end_nid));
	LASSERTF((int)offsetof(struct nodemap_range_rec, nrr_padding1) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_range_rec, nrr_padding1));
	LASSERTF((int)sizeof(((struct nodemap_range_rec *)0)->nrr_padding1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_range_rec *)0)->nrr_padding1));
	LASSERTF((int)offsetof(struct nodemap_range_rec, nrr_padding2) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_range_rec, nrr_padding2));
	LASSERTF((int)sizeof(((struct nodemap_range_rec *)0)->nrr_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_range_rec *)0)->nrr_padding2));

	/* Checks for struct nodemap_id_rec */
	LASSERTF((int)sizeof(struct nodemap_id_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct nodemap_id_rec));
	LASSERTF((int)offsetof(struct nodemap_id_rec, nir_id_fs) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_id_rec, nir_id_fs));
	LASSERTF((int)sizeof(((struct nodemap_id_rec *)0)->nir_id_fs) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_id_rec *)0)->nir_id_fs));
	LASSERTF((int)offsetof(struct nodemap_id_rec, nir_padding1) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_id_rec, nir_padding1));
	LASSERTF((int)sizeof(((struct nodemap_id_rec *)0)->nir_padding1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_id_rec *)0)->nir_padding1));
	LASSERTF((int)offsetof(struct nodemap_id_rec, nir_padding2) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_id_rec, nir_padding2));
	LASSERTF((int)sizeof(((struct nodemap_id_rec *)0)->nir_padding2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_id_rec *)0)->nir_padding2));
	LASSERTF((int)offsetof(struct nodemap_id_rec, nir_padding3) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_id_rec, nir_padding3));
	LASSERTF((int)sizeof(((struct nodemap_id_rec *)0)->nir_padding3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_id_rec *)0)->nir_padding3));
	LASSERTF((int)offsetof(struct nodemap_id_rec, nir_padding4) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_id_rec, nir_padding4));
	LASSERTF((int)sizeof(((struct nodemap_id_rec *)0)->nir_padding4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_id_rec *)0)->nir_padding4));

	/* Checks for struct nodemap_global_rec */
	LASSERTF((int)sizeof(struct nodemap_global_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct nodemap_global_rec));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_is_active) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_is_active));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_is_active) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_is_active));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_padding1) == 1, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_padding1));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding1) == 1, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding1));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_padding2) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_padding2));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding2) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding2));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_padding3) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_padding3));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding3));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_padding4) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_padding4));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding4) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding4));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_padding5) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_padding5));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding5) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding5));
	LASSERTF((int)offsetof(struct nodemap_global_rec, ngr_padding6) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct nodemap_global_rec, ngr_padding6));
	LASSERTF((int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding6) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct nodemap_global_rec *)0)->ngr_padding6));

	/* Checks for union nodemap_rec */
	LASSERTF((int)sizeof(union nodemap_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(union nodemap_rec));

	/* Checks for struct lfsck_request */
	LASSERTF((int)sizeof(struct lfsck_request) == 96, "found %lld\n",
		 (long long)(int)sizeof(struct lfsck_request));
	LASSERTF((int)offsetof(struct lfsck_request, lr_event) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_event));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_event) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_event));
	LASSERTF((int)offsetof(struct lfsck_request, lr_index) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_index));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_index));
	LASSERTF((int)offsetof(struct lfsck_request, lr_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_flags));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_flags));
	LASSERTF((int)offsetof(struct lfsck_request, lr_valid) == 12, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_valid));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_valid) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_valid));
	LASSERTF((int)offsetof(struct lfsck_request, lr_speed) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_speed));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_speed) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_speed));
	LASSERTF((int)offsetof(struct lfsck_request, lr_version) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_version));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_version) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_version));
	LASSERTF((int)offsetof(struct lfsck_request, lr_active) == 22, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_active));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_active) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_active));
	LASSERTF((int)offsetof(struct lfsck_request, lr_param) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_param));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_param) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_param));
	LASSERTF((int)offsetof(struct lfsck_request, lr_async_windows) == 26, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_async_windows));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_async_windows) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_async_windows));
	LASSERTF((int)offsetof(struct lfsck_request, lr_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_flags));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_flags));
	LASSERTF((int)offsetof(struct lfsck_request, lr_fid) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_fid));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_fid));
	LASSERTF((int)offsetof(struct lfsck_request, lr_fid2) == 48, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_fid2));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_fid2) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_fid2));
	LASSERTF((int)offsetof(struct lfsck_request, lr_comp_id) == 64, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_comp_id));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_comp_id) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_comp_id));
	LASSERTF((int)offsetof(struct lfsck_request, lr_padding_0) == 68, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_padding_0));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_padding_0) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_padding_0));
	LASSERTF((int)offsetof(struct lfsck_request, lr_padding_1) == 72, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_padding_1));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_padding_1) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_padding_1));
	LASSERTF((int)offsetof(struct lfsck_request, lr_padding_2) == 80, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_padding_2));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_padding_2) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_padding_2));
	LASSERTF((int)offsetof(struct lfsck_request, lr_padding_3) == 88, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_request, lr_padding_3));
	LASSERTF((int)sizeof(((struct lfsck_request *)0)->lr_padding_3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_request *)0)->lr_padding_3));
	LASSERTF(LFSCK_TYPE_SCRUB == 0x00000000UL, "found 0x%.8xUL\n",
		(unsigned)LFSCK_TYPE_SCRUB);
	LASSERTF(LFSCK_TYPE_LAYOUT == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LFSCK_TYPE_LAYOUT);
	LASSERTF(LFSCK_TYPE_NAMESPACE == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LFSCK_TYPE_NAMESPACE);
	LASSERTF(LE_LASTID_REBUILDING == 1, "found %lld\n",
		 (long long)LE_LASTID_REBUILDING);
	LASSERTF(LE_LASTID_REBUILT == 2, "found %lld\n",
		 (long long)LE_LASTID_REBUILT);
	LASSERTF(LE_PHASE1_DONE == 3, "found %lld\n",
		 (long long)LE_PHASE1_DONE);
	LASSERTF(LE_PHASE2_DONE == 4, "found %lld\n",
		 (long long)LE_PHASE2_DONE);
	LASSERTF(LE_START == 5, "found %lld\n",
		 (long long)LE_START);
	LASSERTF(LE_STOP == 6, "found %lld\n",
		 (long long)LE_STOP);
	LASSERTF(LE_QUERY == 7, "found %lld\n",
		 (long long)LE_QUERY);
	LASSERTF(LE_PEER_EXIT == 9, "found %lld\n",
		 (long long)LE_PEER_EXIT);
	LASSERTF(LE_CONDITIONAL_DESTROY == 10, "found %lld\n",
		 (long long)LE_CONDITIONAL_DESTROY);
	LASSERTF(LE_PAIRS_VERIFY == 11, "found %lld\n",
		 (long long)LE_PAIRS_VERIFY);
	LASSERTF(LE_SET_LMV_MASTER == 15, "found %lld\n",
		 (long long)LE_SET_LMV_MASTER);
	LASSERTF(LE_SET_LMV_SLAVE == 16, "found %lld\n",
		 (long long)LE_SET_LMV_SLAVE);
	LASSERTF(LEF_TO_OST == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LEF_TO_OST);
	LASSERTF(LEF_FROM_OST == 0x00000002UL, "found 0x%.8xUL\n",
		(unsigned)LEF_FROM_OST);
	LASSERTF(LEF_SET_LMV_HASH == 0x00000004UL, "found 0x%.8xUL\n",
		(unsigned)LEF_SET_LMV_HASH);
	LASSERTF(LEF_SET_LMV_ALL == 0x00000008UL, "found 0x%.8xUL\n",
		(unsigned)LEF_SET_LMV_ALL);
	LASSERTF(LEF_RECHECK_NAME_HASH == 0x00000010UL, "found 0x%.8xUL\n",
		(unsigned)LEF_RECHECK_NAME_HASH);
	LASSERTF(LEF_QUERY_ALL == 0x00000020UL, "found 0x%.8xUL\n",
		(unsigned)LEF_QUERY_ALL);

	/* Checks for struct lfsck_reply */
	LASSERTF((int)sizeof(struct lfsck_reply) == 16, "found %lld\n",
		 (long long)(int)sizeof(struct lfsck_reply));
	LASSERTF((int)offsetof(struct lfsck_reply, lr_status) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_reply, lr_status));
	LASSERTF((int)sizeof(((struct lfsck_reply *)0)->lr_status) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_reply *)0)->lr_status));
	LASSERTF((int)offsetof(struct lfsck_reply, lr_padding_1) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_reply, lr_padding_1));
	LASSERTF((int)sizeof(((struct lfsck_reply *)0)->lr_padding_1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_reply *)0)->lr_padding_1));
	LASSERTF((int)offsetof(struct lfsck_reply, lr_repaired) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lfsck_reply, lr_repaired));
	LASSERTF((int)sizeof(((struct lfsck_reply *)0)->lr_repaired) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lfsck_reply *)0)->lr_repaired));

	/* Checks for struct update_params */
	LASSERTF((int)sizeof(struct update_params) == 0, "found %lld\n",
		 (long long)(int)sizeof(struct update_params));
	LASSERTF((int)offsetof(struct update_params, up_params) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct update_params, up_params));
	LASSERTF((int)sizeof(((struct update_params *)0)->up_params) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct update_params *)0)->up_params));

	/* Checks for struct update_op */
	LASSERTF((int)sizeof(struct update_op) == 24, "found %lld\n",
		 (long long)(int)sizeof(struct update_op));
	LASSERTF((int)offsetof(struct update_op, uop_fid) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct update_op, uop_fid));
	LASSERTF((int)sizeof(((struct update_op *)0)->uop_fid) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct update_op *)0)->uop_fid));
	LASSERTF((int)offsetof(struct update_op, uop_type) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct update_op, uop_type));
	LASSERTF((int)sizeof(((struct update_op *)0)->uop_type) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct update_op *)0)->uop_type));
	LASSERTF((int)offsetof(struct update_op, uop_param_count) == 18, "found %lld\n",
		 (long long)(int)offsetof(struct update_op, uop_param_count));
	LASSERTF((int)sizeof(((struct update_op *)0)->uop_param_count) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct update_op *)0)->uop_param_count));
	LASSERTF((int)offsetof(struct update_op, uop_params_off) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct update_op, uop_params_off));
	LASSERTF((int)sizeof(((struct update_op *)0)->uop_params_off) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct update_op *)0)->uop_params_off));

	/* Checks for struct update_ops */
	LASSERTF((int)sizeof(struct update_ops) == 0, "found %lld\n",
		 (long long)(int)sizeof(struct update_ops));
	LASSERTF((int)offsetof(struct update_ops, uops_op) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct update_ops, uops_op));
	LASSERTF((int)sizeof(((struct update_ops *)0)->uops_op) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct update_ops *)0)->uops_op));

	/* Checks for struct update_records */
	LASSERTF((int)sizeof(struct update_records) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct update_records));
	LASSERTF((int)offsetof(struct update_records, ur_master_transno) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct update_records, ur_master_transno));
	LASSERTF((int)sizeof(((struct update_records *)0)->ur_master_transno) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct update_records *)0)->ur_master_transno));
	LASSERTF((int)offsetof(struct update_records, ur_batchid) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct update_records, ur_batchid));
	LASSERTF((int)sizeof(((struct update_records *)0)->ur_batchid) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct update_records *)0)->ur_batchid));
	LASSERTF((int)offsetof(struct update_records, ur_flags) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct update_records, ur_flags));
	LASSERTF((int)sizeof(((struct update_records *)0)->ur_flags) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct update_records *)0)->ur_flags));
	LASSERTF((int)offsetof(struct update_records, ur_index) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct update_records, ur_index));
	LASSERTF((int)sizeof(((struct update_records *)0)->ur_index) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct update_records *)0)->ur_index));
	LASSERTF((int)offsetof(struct update_records, ur_update_count) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct update_records, ur_update_count));
	LASSERTF((int)sizeof(((struct update_records *)0)->ur_update_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct update_records *)0)->ur_update_count));
	LASSERTF((int)offsetof(struct update_records, ur_param_count) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct update_records, ur_param_count));
	LASSERTF((int)sizeof(((struct update_records *)0)->ur_param_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct update_records *)0)->ur_param_count));
	LASSERTF(UPDATE_RECORD_CONTINUE == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)UPDATE_RECORD_CONTINUE);

	/* Checks for struct llog_update_record */
	LASSERTF((int)sizeof(struct llog_update_record) == 48, "found %lld\n",
		 (long long)(int)sizeof(struct llog_update_record));
	LASSERTF((int)offsetof(struct llog_update_record, lur_hdr) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct llog_update_record, lur_hdr));
	LASSERTF((int)sizeof(((struct llog_update_record *)0)->lur_hdr) == 16, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_update_record *)0)->lur_hdr));
	LASSERTF((int)offsetof(struct llog_update_record, lur_update_rec) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct llog_update_record, lur_update_rec));
	LASSERTF((int)sizeof(((struct llog_update_record *)0)->lur_update_rec) == 32, "found %lld\n",
		 (long long)(int)sizeof(((struct llog_update_record *)0)->lur_update_rec));

	/* Checks for struct lu_ladvise */
	LASSERTF((int)sizeof(struct lu_ladvise) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct lu_ladvise));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_advice) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_advice));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_advice) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_advice));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_value1) == 2, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_value1));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_value1) == 2, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_value1));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_value2) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_value2));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_value2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_value2));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_start) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_start));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_start) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_start));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_end) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_end));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_end) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_end));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_value3) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_value3));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_value3) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_value3));
	LASSERTF((int)offsetof(struct lu_ladvise, lla_value4) == 28, "found %lld\n",
		 (long long)(int)offsetof(struct lu_ladvise, lla_value4));
	LASSERTF((int)sizeof(((struct lu_ladvise *)0)->lla_value4) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct lu_ladvise *)0)->lla_value4));
	LASSERTF(LU_LADVISE_WILLREAD == 1, "found %lld\n",
		 (long long)LU_LADVISE_WILLREAD);
	LASSERTF(LU_LADVISE_DONTNEED == 2, "found %lld\n",
		 (long long)LU_LADVISE_DONTNEED);

	/* Checks for struct ladvise_hdr */
	LASSERTF(LADVISE_MAGIC == 0x1ADF1CE0, "found 0x%.8x\n",
		 LADVISE_MAGIC);
	LASSERTF((int)sizeof(struct ladvise_hdr) == 32, "found %lld\n",
		 (long long)(int)sizeof(struct ladvise_hdr));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_magic) == 0, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_magic));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_magic) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_magic));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_count) == 4, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_count));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_count) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_count));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_flags) == 8, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_flags));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_flags) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_flags));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_value1) == 16, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_value1));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_value1) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_value1));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_value2) == 20, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_value2));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_value2) == 4, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_value2));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_value3) == 24, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_value3));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_value3) == 8, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_value3));
	LASSERTF((int)offsetof(struct ladvise_hdr, lah_advise) == 32, "found %lld\n",
		 (long long)(int)offsetof(struct ladvise_hdr, lah_advise));
	LASSERTF((int)sizeof(((struct ladvise_hdr *)0)->lah_advise) == 0, "found %lld\n",
		 (long long)(int)sizeof(((struct ladvise_hdr *)0)->lah_advise));
	LASSERTF(LF_ASYNC == 0x00000001UL, "found 0x%.8xUL\n",
		(unsigned)LF_ASYNC);
}
