#!/bin/bash
LOG=$1
CONF=/etc/cpfs/cpfs-options.conf

now=`date`
echo "=== $now ===" >> ${LOG}

#
# do nothing if config doesn't exist
#
if [ -f ${CONF} ]; then
    . ${CONF}
else
    echo "skip cpfs pre stop config because $CONF not exists" >> ${LOG}
    exit
fi

. /etc/cpfs/utils.sh
RETVAL=0
[ "$CONFIG_OPENCACHE" == true ] && { echo "Running config opencache"; run_config /etc/cpfs/config-opencache.sh stop ${LOG}; RETVAL=$?; }
[ $RETVAL -ne 0 ] && exit $RETVAL

exit 0
