# lustre.spec

# Declare rpmbuild --with/--without parameters
%bcond_without servers
%bcond_without ldiskfs
%bcond_with zfs
%bcond_without lustre_tests
%bcond_without lustre_utils
%bcond_without lustre_iokit
%bcond_without lustre_modules
%bcond_with lnet_dlc
%bcond_with snmp
%bcond_without manpages
%bcond_without shared
%bcond_without static
%bcond_with    systemd
%bcond_without cpfs_utils

%if %{without servers}
    # --without servers overrides --with {ldiskfs|zfs}
    # so undefine the internal variables set by bcond_*
    %undefine with_ldiskfs
    %undefine with_zfs
%else
    %undefine with_cpfs_utils
%endif

%{!?version: %global version 2.10.8}
%{!?kver:    %global kver    %(uname -r)}
%{!?kdir:    %global kdir    /lib/modules/%{kver}/source}
%{!?kobjdir: %global kobjdir %(if [ "%{kdir}" = "/lib/modules/%{kver}/source" ]; then echo "/lib/modules/%{kver}/build"; else echo "%{kdir}"; fi)}

# as an alternative to this implementation we could simply "make -C $kdir kernelversion"
%{!?kversion: %global kversion %(files="include/generated/utsrelease.h include/linux/utsrelease.h include/linux/version.h"; for f in $files; do if test -r %{kobjdir}/$f && grep UTS_RELEASE %{kobjdir}/$f >/dev/null; then sed -ne '/^#define UTS_RELEASE/s/.*"\\(.*\\)"$/\\1/p' %{kobjdir}/$f; break; fi; done)}

# We set this because kernel_module_package has its own method of identifying
# which kernel to build against, and it is unlikely that its decision will
# match with Lustre's method of selecting which kernel to build against.
# By setting this variable, we override kernel_module_package's kernel
# selection with our selection.
%{!?kernel_version: %global kernel_version %kversion}

# in order to get kernel symset and/or kernel module dependencies into
# the RPM, in order to support weak-modules, the internal dependency gen-
# erator needs to be disabled
# this is done with (reduce the double % down to a single %):
#
# %%global _use_internal_dependency_generator 0
#
# on SLES10, /usr/lib/rpm/macros already sets this, so no harm in also
# defining it here (until Suse changes their mind)
#
# on RHEL5, however, we do need to explicitly disable the internal dep-
# endency generator and allow the external one be used
# but since RedHat's kABI is only a subset of the total kernel ABI, it
# doesn't include all of the symbols we (or OFED for that matter) need
# until RedHat includes all of the symbols we need in their symsets we
# cannot support weak-modules
# we did e-mail the maintainer of all of this stuff @redhat but got no
# response from them
#%%global _use_internal_dependency_generator 0

# Set the package name prefix
%if %{undefined lustre_name}
    %if %{with servers}
        %global lustre_name lustre
    %else
        %global lustre_name cpfs-client
    %endif
%endif

%if %{undefined kmoddir}
    %if %{defined kernel_module_package_moddir}
        %global kmoddir %{kernel_module_package_moddir}
    %else
        %if %{defined suse_kernel_module_package}
            %global kmoddir updates
        %else
            %global kmoddir extra
        %endif
    %endif
%endif

%global modules_fs_path /lib/modules/%{kversion}/%{kmoddir}

%if %{_vendor}=="redhat" || %{_vendor}=="fedora"
	%global requires_kmod_name kmod-%{lustre_name}
	%if %{with lustre_tests}
		%global requires_kmod_tests_name kmod-%{lustre_name}-tests
	%endif
	%global requires_kmod_version %{version}
%else	#for Suse
	%global requires_kmod_name %{lustre_name}-kmp
	%if %{with lustre_tests}
		%global requires_kmod_tests_name %{lustre_name}-tests-kmp
	%endif
	%define krequires %(echo %{kversion} | sed -e 's/\.x86_64$//' -e 's/\.i[3456]86$//' -e 's/-smp$//' -e 's/-bigsmp$//' -e 's/[-.]ppc64$//' -e 's/\.aarch64$//' -e 's/-default$//')
	%if 0%{?suse_version} >= 1200
		%global requires_kmod_version %{version}_k%(echo %{krequires} | sed -r 'y/-/_/; s/^(2\.6\.[0-9]+)_/\\1.0_/;')
	%else
		%global requires_kmod_version %{version}_%(echo %{krequires} | sed -r 'y/-/_/; s/^(2\.6\.[0-9]+)_/\\1.0_/;')
	%endif
%endif

# RHEL >= 7 comes with systemd
%if 0%{?rhel} >= 7
%define with_systemd 1
%endif

# Fedora >= 15 comes with systemd, but only >= 18 has
# the proper macros
%if 0%{?fedora} >= 18
%define with_systemd 1
%endif

# opensuse >= 12.1 comes with systemd, but only >= 13.1
# has the proper macros
%if 0%{?suse_version} >= 1310
%define with_systemd 1
%endif

%define buildid 202

Summary: Cloud Parallel File System
Name: %{lustre_name}
Version: %{version}
Release: %{buildid}%{?dist}
License: GPL
Group: System Environment/Kernel
Source: lustre-%{version}.tar.gz
Source1: kmp-lustre.preamble
Source2: kmp-lustre.files
Source3: kmp-lustre-osd-ldiskfs.preamble
Source4: kmp-lustre-osd-ldiskfs.files
Source5: kmp-lustre-osd-zfs.preamble
Source6: kmp-lustre-osd-zfs.files
Source7: kmp-lustre-tests.files
URL: https://www.aliyun.com/
BuildRoot: %{_tmppath}/lustre-%{version}-root
%if %{with servers} || %{with lustre_modules}
Requires: %{requires_kmod_name} = %{requires_kmod_version}
%endif
BuildRequires: libtool
%if %{with servers}
Requires: lustre-osd
Requires: lustre-osd-mount
Obsoletes: lustre-client < %{version}
Provides: lustre-client = %{version}-%{release}
%endif
%if %{with cpfs_utils}
Requires: cpfs-client-dkms
%endif
# GSS requires this: BuildRequires: pkgconfig, libgssapi-devel >= 0.10
%if %{_vendor}=="redhat" || %{_vendor}=="fedora"
#suse don't support selinux
BuildRequires: libselinux-devel
Requires: libselinux
%endif
%if %{with lustre_modules}
BuildRequires: %kernel_module_package_buildreqs
%if %{_vendor}=="redhat"
BuildRequires: redhat-rpm-config
%endif
%endif

%if %{with systemd}
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd
BuildRequires: systemd
%endif

%description
Userspace tools and files for CPFS(cloud parallel file system).

%if %{with lustre_modules}
%if 0%{?rhel} == 7
# until we have achieved full kABI compatibility we need to
# restrict the kernel range that can be used to the kernel
# version from the RHEL minor release
# this is supposed to be done for kmods automatically but
# RHBZ#1467319 seems to be getting in the way
# this is true for el7.0 through el7.4
%define preamble %{expand:%(
TMPFILE=`mktemp`
cat %{SOURCE1} > $TMPFILE
kver=%{kver}
linuxversion=${kver%%%%-*}
linuxrelease=${kver##*-}
kabiminor=${linuxrelease%%%%.*}
echo "Requires:       kernel < $linuxversion-$((kabiminor+1)), kernel >= $linuxversion-$((kabiminor))" >> $TMPFILE
echo $TMPFILE
)}
%else
%define preamble %{SOURCE1}
%endif
%kernel_module_package -n %{name} -p %preamble -f %SOURCE2 default

%if %{with ldiskfs}
%kernel_module_package -n %{name}-osd-ldiskfs -p %SOURCE3 -f %SOURCE4 default
%if %{with lustre_utils}
%package osd-ldiskfs-mount
Summary: osd-ldiskfs-mount contains mount's ldiskfs specific dso.
Provides: lustre-osd-mount = %{version}-%{fullrelease}
Group: System Environment/Kernel

%description osd-ldiskfs-mount
LDISKFS hooks for mount/mkfs into a dynamic library.

%endif	# with lustre_utils
%endif	# with ldiskfs

%if %{with zfs}
%kernel_module_package -n %{name}-osd-zfs -p %SOURCE5 -f %SOURCE6 default
%if %{with lustre_utils}
%package osd-zfs-mount
Summary: osd-zfs-mount contains mount's zfs specific dso.
Provides: lustre-osd-mount = %{version}-%{fullrelease}
Group: System Environment/Kernel

%description osd-zfs-mount
ZFS hooks for mount/mkfs into a dynamic library.

%endif	# with lustre_utils
%endif	# with zfs

%endif # with lustre_modules

%if %{with servers}
%package resource-agents
Summary: HA Resuable Cluster Resource Scripts for Lustre
Group: System Environment/Base
Requires: lustre
Requires: resource-agents

%description resource-agents
A set of scripts to operate Lustre resources in a High Availablity
environment for both Pacemaker and rgmanager.
%endif

%if %{with lustre_tests}
%package tests
Summary: Lustre testing framework
Group: System Environment/Kernel
Provides: %{name}-tests = %{version}
%if %{with lustre_iokit}
Requires: %{name} = %{version}, lustre-iokit
%else
Requires: %{name} = %{version}
%endif
Requires: %{requires_kmod_name} = %{requires_kmod_version}
Requires: %{requires_kmod_tests_name} = %{requires_kmod_version}
Requires: attr, rsync, perl, lsof, /usr/bin/getconf

%description tests
This package contains a set of test binaries and scripts that are intended
to be used by the Lustre testing framework.

%if %{with lustre_modules}
%kernel_module_package -n %{name}-tests -f %SOURCE7 default
%endif
%endif

%if %{with lustre_iokit}
%package -n lustre-iokit
Summary: The Lustre IO-Kit is a collection of benchmark tools for a cluster with the Lustre file system.
Group: Applications/System
Requires: python > 2.2, sg3_utils

%description -n lustre-iokit
This package includes five tools:
sgpdd-survey:
A test of the 'bare metal' performance, bypassing as much of the kernel as we can. Uses the sgp_dd utility.

obdfilter-survey
This survey can be run in 3 modes to test disk I/O including the filesystem,
network I/O, and disk I/O via the network.  The script does sequential I/O
with varying numbers of threads and objects (files) by using lctl::test_brw
to drive the echo_client connected to local or remote obdfilter instances,
or remote obdecho instances.

ost-survey
This survey tests the client-to-disk performance of individual OSTs, and
ranks then for comparison.

stats-collect
This script will collect IO stats on a defined set of nodes.

ior-survey:
A script to run the IOR benchmark. The latest version can be downloaded from
http://www.llnl.gov/asci/purple/benchmarks/limited/ior/

mds-survey:
This survey tests the local metadata performance using the echo_client to drive
the MDD layer to perform operations. It is run with multiple threads (to
simulate MDT service threads) locally on the MDS node, and does not need Lustre
clients in order to run
%endif

%if 0%{?suse_version}
%debug_package
%endif
%prep
%setup -qn lustre-%{version}
ln lustre/ChangeLog ChangeLog-lustre
ln lnet/ChangeLog ChangeLog-lnet

%build
# Set an explicit path to our Linux tree, if we can.
cd $RPM_BUILD_DIR/lustre-%{version}
# override %optflags so that the vendor's overzealous flags don't create
# build failures
%define optflags -g -O2 -Werror

CONFIGURE_ARGS="%{?configure_args}"
if [ -n "$CONFIGURE_ARGS" ]; then
	# make sure %%kdir and %%kobjdir are not in the configure arguments
	CONFIGURE_ARGS=$(echo $CONFIGURE_ARGS | sed -e 's/"\?--with-linux=[^ ][^ ]* \?//')
	CONFIGURE_ARGS=$(echo $CONFIGURE_ARGS | sed -e 's/"\?--with-linux-obj=[^ ][^ ]* \?//')
	# remove --with-kmp-moddir from configure arguments,
	# it will be set --with-kmp-moddir=%%kmoddir
	CONFIGURE_ARGS=$(echo $CONFIGURE_ARGS | sed -e 's/"\?--with-kmp-moddir=[^ ][^ ]* \?//')
fi

# we need to eval "configure" because $CONFIGURE_ARGS could have a quoted
# string in it which we don't want word splitted by the shell
# also remove (build|host|target) options because they will be specified
# inside $CONFIGURE_ARGS
# kmod tools/scripts require %{name} directory with kernel modules
%define eval_configure %(echo '%configure' | sed -e 's#\./configure#eval ./configure#' -e 's/--\\(build\\|host\\|target\\)=[^ ][^ ]* //g')

%eval_configure $CONFIGURE_ARGS \
	%{?with_lustre_tests:--enable-tests}%{!?with_lustre_tests:--disable-tests} \
	%{?with_lustre_utils:--enable-utils}%{!?with_lustre_utils:--disable-utils} \
	%{?with_lustre_modules:--enable-modules}%{!?with_lustre_modules:--disable-modules} \
	%{!?with_shared:--disable-shared} \
	%{!?with_static:--disable-static} \
	%{!?with_lustre_iokit:--disable-iokit} \
	%{!?with_ldiskfs:--disable-ldiskfs} \
	%{!?with_servers:--disable-server} \
	%{!?with_zfs:--without-zfs} \
	%{!?with_lnet_dlc:--disable-dlc} \
	%{!?with_snmp:--disable-snmp} \
	%{!?with_manpages:--disable-manpages} \
	%{!?with_systemd:--with-systemdsystemunitdir=no} \
	%{!?with_cpfs_utils:--disable-cpfsutils} \
	%{?with_systemd:--with-systemdsystemunitdir=%{_unitdir}} \
	--with-linux=%{kdir} \
	--with-linux-obj=%{kobjdir} \
	--with-kmp-moddir=%{kmoddir}/%{name}

make %{?_smp_mflags} -s %{?make_args}

%install
make install DESTDIR=$RPM_BUILD_ROOT

# RHEL's kernel_module_path macro expects that all the modules
# in a kmod package will be in modules_fs_path/<sub packagename>
# but Lustre installs all of the modules in a single pass into
# a shared location.  Since this is a restriction imposed by
# RHEL, we handle this here in the spec file rather than in
# Lustre's build system.  This is not expected to bother SLES's
# kernel_module_path macro.
basemodpath=$RPM_BUILD_ROOT%{modules_fs_path}/%{lustre_name}
%if %{with ldiskfs}
mkdir -p $basemodpath-osd-ldiskfs/fs
mv $basemodpath/fs/osd_ldiskfs.ko $basemodpath-osd-ldiskfs/fs/osd_ldiskfs.ko
mv $basemodpath/fs/ldiskfs.ko $basemodpath-osd-ldiskfs/fs/ldiskfs.ko
%endif
%if %{with zfs}
mkdir -p $basemodpath-osd-zfs/fs
mv $basemodpath/fs/osd_zfs.ko $basemodpath-osd-zfs/fs/osd_zfs.ko
%endif
%if %{with lustre_tests}
mkdir -p $basemodpath-tests/fs
mv $basemodpath/fs/llog_test.ko $basemodpath-tests/fs/llog_test.ko
mkdir -p $RPM_BUILD_ROOT%{_libdir}/lustre/tests/kernel/
mv $basemodpath/fs/kinode.ko $RPM_BUILD_ROOT%{_libdir}/lustre/tests/kernel/
%endif

:> lustre.files

%if %{with servers} && %{with lustre_utils}
# The .ha_v2 extension identifies the heartbeat resource agent as using
# legacy syntax. Install a compatibility symlink to avoid conflicts when
# newer-style agents are added.
ln -s Lustre.ha_v2 $RPM_BUILD_ROOT%{_sysconfdir}/ha.d/resource.d/Lustre
echo '%{_sysconfdir}/ha.d/resource.d/Lustre.ha_v2' >>lustre.files
echo '%{_sysconfdir}/ha.d/resource.d/Lustre' >>lustre.files
%endif

# systemd is on redhat, fedora, and suse
%if %{with systemd}
echo '%{_unitdir}/lnet.service' >>lustre.files
%endif

%if %{_vendor}=="redhat"
# The following scripts are Red Hat specific
%if %{with servers}
echo '%{_sysconfdir}/sysconfig/lustre' >>lustre.files
echo '%{_sysconfdir}/sysconfig/lsvcgss' >>lustre.files
echo '%{_sysconfdir}/init.d/lustre' >>lustre.files
%endif

%if %{without systemd}
echo '%{_sysconfdir}/init.d/lnet' >>lustre.files
%endif

%if %{with servers}
echo '%{_sysconfdir}/init.d/lsvcgss' >>lustre.files
%endif
%endif

%if %{with servers}
mkdir -p $RPM_BUILD_ROOT%{_prefix}/lib/ocf/resource.d/lustre/
install -m 0755 contrib/scripts/pacemaker/* $RPM_BUILD_ROOT%{_prefix}/lib/ocf/resource.d/lustre/
%endif

# fc18 needs 'x' permission for library files
find $RPM_BUILD_ROOT -name \*.so -type f -exec chmod +x {} \;

%if %{with lnet_dlc}
rm -f $RPM_BUILD_ROOT%{_libdir}/liblnetconfig.la
%if %{with static}
echo '%attr(-, root, root) %{_libdir}/liblnetconfig.a' >>lustre.files
%endif
%if %{with shared}
echo '%attr(-, root, root) %{_libdir}/liblnetconfig.so' >>lustre.files
echo '%attr(-, root, root) %{_libdir}/liblnetconfig.so.*' >>lustre.files
%endif
%endif

%if %{with ldiskfs}
echo '%{_libdir}/libiam.a' >>lustre.files
%endif

%if %{with snmp}
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/lustre/snmp
echo '%{_libdir}/lustre/snmp' >>lustre.files
%endif

%if %{with lustre_utils}
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/lustre
if [ -d $RPM_BUILD_ROOT%{_libdir}/lustre ] ; then
	find $RPM_BUILD_ROOT%{_libdir}/lustre -name \*.la -type f -exec rm -f {} \;
fi
%endif

%if %{with lustre_modules}
# mark modules executable for find-debuginfo.sh
find $RPM_BUILD_ROOT/lib/modules -name \*.ko -type f -exec chmod u+x {} \;
%endif

%if %{with lustre_tests}
:> lustre-tests.files
echo '%{_libdir}/lustre/tests/*' >>lustre-tests.files
echo '%{_bindir}/mcreate' >>lustre-tests.files
echo '%{_bindir}/munlink' >>lustre-tests.files
echo '%{_sbindir}/wirecheck' >>lustre-tests.files
echo '%{_sbindir}/wiretest' >>lustre-tests.files
%endif

%if %{with cpfs_utils}
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/cpfs
install -D -m644 cpfs/dist/etc/*.conf $RPM_BUILD_ROOT/%{_sysconfdir}/cpfs/
install -D -m644 cpfs/dist/etc/modprobe.d/lustre.conf $RPM_BUILD_ROOT/%{_sysconfdir}/modprobe.d/lustre.conf
install -D cpfs/dist/etc/*.sh $RPM_BUILD_ROOT/%{_sysconfdir}/cpfs/
install -D cpfs/dist/etc/init.d/cpfs-client.init $RPM_BUILD_ROOT/%{_initrddir}/cpfs-client

mkdir -p $RPM_BUILD_ROOT/opt/cpfs/log
touch $RPM_BUILD_ROOT/opt/cpfs/log/post-start.log
touch $RPM_BUILD_ROOT/opt/cpfs/log/post-stop.log
touch $RPM_BUILD_ROOT/opt/cpfs/log/pre-stop.log

install -D -m644 cpfs/dist/systemd/cpfs-client.service \
    ${RPM_BUILD_ROOT}/%{_unitdir}/cpfs-client.service

echo '%{_sysconfdir}/cpfs/*.conf' >>lustre.files
echo '%{_sysconfdir}/cpfs/*.sh' >>lustre.files
echo '%{_initrddir}/cpfs-client' >>lustre.files
echo '/opt/cpfs/log/*' >>lustre.files
echo '%{_unitdir}/cpfs-client.service' >>lustre.files
%endif

%files -f lustre.files
%defattr(-,root,root)
%{_sbindir}/*
%if %{with lustre_tests}
%exclude %{_sbindir}/wirecheck
%exclude %{_sbindir}/wiretest
%endif
%if %{with zfs}
%exclude %{_sbindir}/zfsobj2fid
%endif
%if %{with lustre_utils}
%if %{with servers}
%{_libexecdir}/lustre/lc_common
%{_libexecdir}/lustre/haconfig
%{_bindir}/lustre_req_history
%endif

%{_bindir}/llobdstat
%{_bindir}/llstat
%{_bindir}/plot-llstat

%{_bindir}/lfs
%{_bindir}/lfs_migrate
/sbin/mount.lustre
%{_libdir}/libptlctl.a
%{_libdir}/libcfsutil.a
%{_libdir}/liblustreapi.a
%{_libdir}/liblustreapi.so
%if %{with manpages}
%{_mandir}/man?/*
%endif
%{_datadir}/lustre
%{_includedir}/lustre
%endif
%{_sysconfdir}/udev/rules.d/99-lustre.rules
%if %{with servers}
%{_sysconfdir}/udev/rules.d/99-lustre-server.rules
%{_sysconfdir}/init.d/lsvcgss
%endif
%config(noreplace) %{_sysconfdir}/ldev.conf
%if %{with lnet_dlc}
%config(noreplace) %{_sysconfdir}/lnet.conf
%endif
%config(noreplace) %{_sysconfdir}/modprobe.d/ko2iblnd.conf
%if %{with lustre_utils}
%config(noreplace) %{_sysconfdir}/lnet_routes.conf
%endif
%if %{with cpfs_utils}
%config(noreplace) %{_sysconfdir}/cpfs/*.conf
%config(noreplace) %{_sysconfdir}/modprobe.d/lustre.conf
%endif

%if %{with lustre_modules}

%if %{with ldiskfs}
%if %{with lustre_utils}
%files osd-ldiskfs-mount
%defattr(-,root,root)
%{_libdir}/lustre/mount_osd_ldiskfs.so
%endif
%endif

%if %{with zfs}
%if %{with lustre_utils}
%files osd-zfs-mount
%defattr(-,root,root)
%{_libdir}/lustre/mount_osd_zfs.so
%endif
%endif

%endif # with lustre_modules

%if %{with servers}
%files resource-agents
%defattr(0755,root,root)
%{_prefix}/lib/ocf/resource.d/lustre/
%endif

%if %{with lustre_tests}
%files tests -f lustre-tests.files
%defattr(-,root,root)
%endif

%if %{with lustre_iokit}
%files -n lustre-iokit
%defattr(-, root, root)
%{_bindir}/iokit-config
%{_bindir}/iokit-gather-stats
%{_bindir}/iokit-libecho
%{_bindir}/iokit-lstats
%{_bindir}/iokit-parse-ior
%{_bindir}/iokit-plot-obdfilter
%{_bindir}/iokit-plot-ost
%{_bindir}/iokit-plot-sgpdd
%{_bindir}/ior-survey
%{_bindir}/mds-survey
%{_bindir}/obdfilter-survey
%{_bindir}/ost-survey
%{_bindir}/sgpdd-survey
%doc lustre-iokit/ior-survey/README.ior-survey
%doc lustre-iokit/mds-survey/README.mds-survey
%doc lustre-iokit/obdfilter-survey/README.obdfilter-survey
%doc lustre-iokit/ost-survey/README.ost-survey
%doc lustre-iokit/sgpdd-survey/README.sgpdd-survey
%doc lustre-iokit/stats-collect/README.iokit-lstats
%endif

%post
%if %{with systemd}
%systemd_post lnet.service
%endif

%if %{with cpfs_utils}
if [ "$1" = 1 ]
then
    output=$(systemctl is-system-running 2> /dev/null)
    if [ "$?" == 127 ]
    then
        chkconfig cpfs-client on
    elif [ "$?" == 0 ] || ( [ "$output" != "offline" ] && [ "$output" != "unknown" ] )
    then
        systemctl enable cpfs-client.service
    else
        chkconfig cpfs-client on
    fi
fi
%endif

%preun
%if %{with cpfs_utils}
if [ "$1" = 0 ]
then
    output=$(systemctl is-system-running 2> /dev/null)
    if [ "$?" == 127 ]
    then
        chkconfig cpfs-client off
    elif [ "$?" == 0 ] || ( [ "$output" != "offline" ] && [ "$output" != "unknown" ] )
    then
        systemctl disable cpfs-client.service
    else
        chkconfig cpfs-client off
    fi
fi
%endif

%if %{with systemd}
%systemd_preun lnet.service
%endif

%postun
%if %{with systemd}
%systemd_postun_with_restart lnet.service
%if %{with cpfs_utils}
%systemd_postun_with_restart cpfs-client.service
%endif
%endif

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf %{_tmppath}/kmp
