package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainLatestBlocks invokes the baas.DescribeAntChainLatestBlocks API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchainlatestblocks.html
func (client *Client) DescribeAntChainLatestBlocks(request *DescribeAntChainLatestBlocksRequest) (response *DescribeAntChainLatestBlocksResponse, err error) {
	response = CreateDescribeAntChainLatestBlocksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainLatestBlocksWithChan invokes the baas.DescribeAntChainLatestBlocks API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainlatestblocks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainLatestBlocksWithChan(request *DescribeAntChainLatestBlocksRequest) (<-chan *DescribeAntChainLatestBlocksResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainLatestBlocksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainLatestBlocks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainLatestBlocksWithCallback invokes the baas.DescribeAntChainLatestBlocks API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainlatestblocks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainLatestBlocksWithCallback(request *DescribeAntChainLatestBlocksRequest, callback func(response *DescribeAntChainLatestBlocksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainLatestBlocksResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainLatestBlocks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainLatestBlocksRequest is the request struct for api DescribeAntChainLatestBlocks
type DescribeAntChainLatestBlocksRequest struct {
	*requests.RpcRequest
	AntChainId string `position:"Body" name:"AntChainId"`
}

// DescribeAntChainLatestBlocksResponse is the response struct for api DescribeAntChainLatestBlocks
type DescribeAntChainLatestBlocksResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Result    []map[string]interface{} `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainLatestBlocksRequest creates a request to invoke DescribeAntChainLatestBlocks API
func CreateDescribeAntChainLatestBlocksRequest() (request *DescribeAntChainLatestBlocksRequest) {
	request = &DescribeAntChainLatestBlocksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainLatestBlocks", "baas", "openAPI")
	return
}

// CreateDescribeAntChainLatestBlocksResponse creates a response to parse from DescribeAntChainLatestBlocks response
func CreateDescribeAntChainLatestBlocksResponse() (response *DescribeAntChainLatestBlocksResponse) {
	response = &DescribeAntChainLatestBlocksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
