package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricOrganizationPeers invokes the baas.DescribeFabricOrganizationPeers API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationpeers.html
func (client *Client) DescribeFabricOrganizationPeers(request *DescribeFabricOrganizationPeersRequest) (response *DescribeFabricOrganizationPeersResponse, err error) {
	response = CreateDescribeFabricOrganizationPeersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricOrganizationPeersWithChan invokes the baas.DescribeFabricOrganizationPeers API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationpeers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationPeersWithChan(request *DescribeFabricOrganizationPeersRequest) (<-chan *DescribeFabricOrganizationPeersResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricOrganizationPeersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricOrganizationPeers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricOrganizationPeersWithCallback invokes the baas.DescribeFabricOrganizationPeers API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationpeers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationPeersWithCallback(request *DescribeFabricOrganizationPeersRequest, callback func(response *DescribeFabricOrganizationPeersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricOrganizationPeersResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricOrganizationPeers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricOrganizationPeersRequest is the request struct for api DescribeFabricOrganizationPeers
type DescribeFabricOrganizationPeersRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeFabricOrganizationPeersResponse is the response struct for api DescribeFabricOrganizationPeers
type DescribeFabricOrganizationPeersResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeFabricOrganizationPeersRequest creates a request to invoke DescribeFabricOrganizationPeers API
func CreateDescribeFabricOrganizationPeersRequest() (request *DescribeFabricOrganizationPeersRequest) {
	request = &DescribeFabricOrganizationPeersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricOrganizationPeers", "baas", "openAPI")
	return
}

// CreateDescribeFabricOrganizationPeersResponse creates a response to parse from DescribeFabricOrganizationPeers response
func CreateDescribeFabricOrganizationPeersResponse() (response *DescribeFabricOrganizationPeersResponse) {
	response = &DescribeFabricOrganizationPeersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
