package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBookkeepingIntention invokes the companyreg.CreateBookkeepingIntention API synchronously
func (client *Client) CreateBookkeepingIntention(request *CreateBookkeepingIntentionRequest) (response *CreateBookkeepingIntentionResponse, err error) {
	response = CreateCreateBookkeepingIntentionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBookkeepingIntentionWithChan invokes the companyreg.CreateBookkeepingIntention API asynchronously
func (client *Client) CreateBookkeepingIntentionWithChan(request *CreateBookkeepingIntentionRequest) (<-chan *CreateBookkeepingIntentionResponse, <-chan error) {
	responseChan := make(chan *CreateBookkeepingIntentionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBookkeepingIntention(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBookkeepingIntentionWithCallback invokes the companyreg.CreateBookkeepingIntention API asynchronously
func (client *Client) CreateBookkeepingIntentionWithCallback(request *CreateBookkeepingIntentionRequest, callback func(response *CreateBookkeepingIntentionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBookkeepingIntentionResponse
		var err error
		defer close(result)
		response, err = client.CreateBookkeepingIntention(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBookkeepingIntentionRequest is the request struct for api CreateBookkeepingIntention
type CreateBookkeepingIntentionRequest struct {
	*requests.RpcRequest
	Area        string `position:"Query" name:"Area"`
	Mobile      string `position:"Query" name:"Mobile"`
	Channel     string `position:"Query" name:"Channel"`
	Description string `position:"Query" name:"Description"`
	Token       string `position:"Query" name:"Token"`
	VerifyCode  string `position:"Query" name:"VerifyCode"`
	UserName    string `position:"Query" name:"UserName"`
}

// CreateBookkeepingIntentionResponse is the response struct for api CreateBookkeepingIntention
type CreateBookkeepingIntentionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateBookkeepingIntentionRequest creates a request to invoke CreateBookkeepingIntention API
func CreateCreateBookkeepingIntentionRequest() (request *CreateBookkeepingIntentionRequest) {
	request = &CreateBookkeepingIntentionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "CreateBookkeepingIntention", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateBookkeepingIntentionResponse creates a response to parse from CreateBookkeepingIntention response
func CreateCreateBookkeepingIntentionResponse() (response *CreateBookkeepingIntentionResponse) {
	response = &CreateBookkeepingIntentionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
