package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEcuByRegion invokes the edas.ListEcuByRegion API synchronously
func (client *Client) ListEcuByRegion(request *ListEcuByRegionRequest) (response *ListEcuByRegionResponse, err error) {
	response = CreateListEcuByRegionResponse()
	err = client.DoAction(request, response)
	return
}

// ListEcuByRegionWithChan invokes the edas.ListEcuByRegion API asynchronously
func (client *Client) ListEcuByRegionWithChan(request *ListEcuByRegionRequest) (<-chan *ListEcuByRegionResponse, <-chan error) {
	responseChan := make(chan *ListEcuByRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEcuByRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEcuByRegionWithCallback invokes the edas.ListEcuByRegion API asynchronously
func (client *Client) ListEcuByRegionWithCallback(request *ListEcuByRegionRequest, callback func(response *ListEcuByRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEcuByRegionResponse
		var err error
		defer close(result)
		response, err = client.ListEcuByRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEcuByRegionRequest is the request struct for api ListEcuByRegion
type ListEcuByRegionRequest struct {
	*requests.RoaRequest
	Act             string `position:"Query" name:"Act"`
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
}

// ListEcuByRegionResponse is the response struct for api ListEcuByRegion
type ListEcuByRegionResponse struct {
	*responses.BaseResponse
	Code          int                            `json:"Code" xml:"Code"`
	Message       string                         `json:"Message" xml:"Message"`
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	EcuEntityList EcuEntityListInListEcuByRegion `json:"EcuEntityList" xml:"EcuEntityList"`
}

// CreateListEcuByRegionRequest creates a request to invoke ListEcuByRegion API
func CreateListEcuByRegionRequest() (request *ListEcuByRegionRequest) {
	request = &ListEcuByRegionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListEcuByRegion", "/pop/v5/resource/ecu_list", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListEcuByRegionResponse creates a response to parse from ListEcuByRegion response
func CreateListEcuByRegionResponse() (response *ListEcuByRegionResponse) {
	response = &ListEcuByRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
