package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRole invokes the edas.ListRole API synchronously
func (client *Client) ListRole(request *ListRoleRequest) (response *ListRoleResponse, err error) {
	response = CreateListRoleResponse()
	err = client.DoAction(request, response)
	return
}

// ListRoleWithChan invokes the edas.ListRole API asynchronously
func (client *Client) ListRoleWithChan(request *ListRoleRequest) (<-chan *ListRoleResponse, <-chan error) {
	responseChan := make(chan *ListRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRoleWithCallback invokes the edas.ListRole API asynchronously
func (client *Client) ListRoleWithCallback(request *ListRoleRequest, callback func(response *ListRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRoleResponse
		var err error
		defer close(result)
		response, err = client.ListRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRoleRequest is the request struct for api ListRole
type ListRoleRequest struct {
	*requests.RoaRequest
}

// ListRoleResponse is the response struct for api ListRole
type ListRoleResponse struct {
	*responses.BaseResponse
	Code      int      `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	RoleList  RoleList `json:"RoleList" xml:"RoleList"`
}

// CreateListRoleRequest creates a request to invoke ListRole API
func CreateListRoleRequest() (request *ListRoleRequest) {
	request = &ListRoleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListRole", "/pop/v5/account/role_list", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRoleResponse creates a response to parse from ListRole response
func CreateListRoleResponse() (response *ListRoleResponse) {
	response = &ListRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
